/*
    mKEYBR.C - minimum keyboard handler for international keyboards

    ******* RESIDENT PART **********

    requires only ~500-600 byte of precious memory to do what it does.

    for details, please see readme.txt


    Copyright (C) 2002 by tom.ehlert@ginko.de
*/

#include <dos.h>

#define RESIDENT
#include "mKeyb.h"

#ifdef REDUCED
    #define NO_DECIDINGSBUMS
    #define NO_REPLACESCAN
    #define NO_ALTGREY
#endif




/** 'normal' data **********************************/
unsigned char usebiosonly_flag = 0xff;
unsigned char debug_scancode = 0;

unsigned char nibble_length[] = {
/*0*/   2+0,
/*1*/   2+3,
/*2*/   2+1,
/*3*/   2+1+3,
/*4*/   2+1,    /* replace */
/*5*/   2+1,    /* replace */
/*6*/   2+1,    /* replace */
/*7*/   2+1,    /* replace */
    };


/* verify correct definition */
struct verifyNibbleTableSize {
    char x[ sizeof(nibble_length) == ALLSIZEFLAGS+1 ? 1 : -1]; };


/** normal data end, ONE last member - the scan code translation table

//
// scan code translation table
// this also marks the end of our resident data
//
//
// the format for each entry is
//
// [0] scancode to search
// [1] different shift states handled (SHIFT,CTRL,ALTGREY,...)
//     also implies table entry size
// [2..n]  keycode to send into BIOS buffer
//
*/

#ifdef COMBI
uint  RESIDENT currentCombi           = IGNORE;
uchar RESIDENT currentCombiScancode   = 0;
uint  RESIDENT ResidentCombiTables[5] = {0};
#endif

#ifdef HANLDEE0  /* currently disabled */
uint  RESIDENT ResidentE0table          = 0;
#endif
uchar RESIDENT DecimalDingsBums = 0;    /* grey , or . */


unsigned char RESIDENT ResidentScancodetable[1] = {0};  /* MUST BE LAST DATA MEMBER */


/** data end **********************************/



/* use BIOS INT16/05 to enter keystroke into key buffer */

#ifdef __TURBOC__
    #define GENERATE_KEYSTROKE(scancode,keycode)    \
        _CL = keycode;                              \
        _CH = scancode ;                            \
        _AH = 5;                                    \
        __int__(0x16);
#else
    #define GENERATE_KEYSTROKE(scancode,keycode)    \
        _asm mov cl, byte ptr keycode;              \
        _asm mov ch, byte ptr scancode;             \
        _asm mov ah,5                               \
        _asm int 0x16;
#endif


int cint15_handler(unsigned char scancode)
{
    uchar  RESIDENT *tbl;
    ushort BIOSstate;

    BIOSstate     = *(short far *)MK_FP(0x40,0x17);

    debug_scancode = scancode;              /* very nice for debugging   */
                                            /* hit ESC - and we are gone */


    if (BIOSstate & 0x08 && BIOSstate & 0x04)   /* Ctrl+Alt+F1/F2 */
        {
        if (scancode == 0x3b || scancode == 0x3c)
            {
            usebiosonly_flag = 0x3b - scancode; /* 0x00 or 0xff */
            return 0;
            }
        }

    if (usebiosonly_flag == 0)
        return scancode;


                            /*
                            ** E0 scancode handling
                            **      don't handle ANYTHING, if E0 was pressed
                            */
    if (*(char far *)MK_FP(0x40,0x96) & 0x02) /* last code was E0 hidden code */
        {
        return scancode;
        }

#ifndef NO_DECIDINGSBUMS
                            /* explicit handling of numeric '.' */

    if (        scancode == 0x53 &&
                DecimalDingsBums &&
                BIOSstate & 0x20)   /* NUMLOCK pressed */
            {
                            /* the grey . is particular ugly */
            GENERATE_KEYSTROKE(scancode,DecimalDingsBums);
            return 0;
            }
#endif /* NO_DECIDINGSBUMS */

                                    /* CAPS handling:
                                       logical shift state = CapsPressed ^ ShiftPressed */
    if (BIOSstate & 3)
        BIOSstate ^= 0x40;


#ifdef COMBI
                                    /* all that swedish, spanish stuff ;-)
                                       these keys are generated
                                       by 2 character combinations
                                    */
    if (currentCombi != IGNORE)
        {
                                    /* key release - handled by BIOS*/
        if (scancode & 0x80)
            return scancode;

        if (scancode == 0x2a  ||    /* left  shift - handled by BIOS*/
            scancode == 0x36)       /* right shift - handled by BIOS*/
            {
            return scancode;
            }


        tbl = (uchar*)ResidentCombiTables[currentCombi - COMBI1];
        currentCombi = IGNORE;

        for ( ; tbl[0] != 0; tbl += 3)
            {
            if (tbl[0] == scancode)
                {                                /* these character all use CAPS */
                GENERATE_KEYSTROKE(scancode, BIOSstate & 0x40 ? tbl[2] : tbl[1]);

                return 0;
                }
            }
        /* not found ? then the last entry before holds the character to generate */

        GENERATE_KEYSTROKE(scancode, BIOSstate & 0x43 ? tbl[-3+2] : tbl[-3+1]);

        /* and fall through to generate the key */
        }
#endif




                            /*
                                'conventional' keyboard mappings
                                search our table and locate the scancode
                            */


    for (   tbl = ResidentScancodetable;
                tbl[0] != scancode;
                tbl += nibble_length[tbl[1] & ALLSIZEFLAGS]
            )
        {
                            /* end of table --> not found -->
                                let the BIOS do it's work
                            */
        if (tbl[0] == 0)
            return scancode;
        }

    tbl++;
                        /* now tbl points to entry in scancodetable */


#ifndef NO_REPLACESCAN

                                    /* simple scancode exchange */
    if (tbl[0] & REPLACESCAN)
        return tbl[1];

#endif /* NO_REPLACESCAN */
                                    /* we found the table entry for the scancode
                                       match the shiftstate in the table against
                                       the current shift state
                                    */


                                    /* now advance tbl in a way, that it
                                       finally points to the key to be generated
                                    */
#ifndef NO_ALTGREY

    if (tbl[0] & ALTGREY &&                     /* has ALTGREY definition */
        *(char far *)MK_FP(0x40,0x96) & 0x08)   /* and right ALT pressed */
        {
        if (tbl[0] & NORMAL)
            {
            tbl += 1+3;
            goto simulateKeyPress;
            }
        else
            {
            tbl += 1;
            goto simulateKeyPress;
            }
        }

#endif  /* NO_ALTGREY */


    if (BIOSstate & 0x08)           /* any ALT pressed */
        {
        return scancode;            /* leave the work to BIOS */
        }

    if ((tbl[0] & NORMAL) == 0)         /* is it a normal key ?? */
        {
        return scancode;        /* scancode identified, but we don't want
                                ** to handle it; give it to BIOS
                                */
        }

    if (tbl[0] & CAPS)
        {
        if (BIOSstate & (0x04|0x40))/* any CTRL or CAPS pressed */
            tbl++;
        }
    else {
        if (BIOSstate & (0x04|0x03))/* any CTRL or SHIFT pressed */
            tbl++;
        }
    if (BIOSstate & 0x04)       /* CTRL pressed */
        tbl++;

    tbl++;                      /* points to normal key  */



simulateKeyPress:
    if (tbl[0] <= COMBI5)
        {
#ifdef COMBI
        currentCombi         = tbl[0];
        currentCombiScancode = scancode;
#endif
        return 0;
        }

    GENERATE_KEYSTROKE(scancode,tbl[0]);

    return 0;
}
