LOCAL ulong	FAST_	EXT_E820	(void);
LOCAL void	FAST_	EXT_get		(void);

/*----------------------------------------------------------------------*/

#ifdef ASM386
# pragma option -3 /* enable 80386 instructions */
LOCAL ulong FAST_ EXT_E820 (void) {
# define SMAP 0x534D4150ul		/* ='SMAP'			*/
	_EBX = 0, _ESI = 0;		/* continuation and total value	*/
	do {	struct {
		  union {
			dword	based [2];
			word	basew [4];
		  } _;
			dword	size [2];
			dword	type;
		} map; /* sizeof (map) == 20 */

		_ES = FP_SEG (&map),
		_DI = FP_OFF (&map),		/* pointer to and	*/
		_ECX = sizeof map,		/*   buffer size	*/
		_EDX = SMAP, _EAX = 0xE820;	/* upper word zeroed	*/
		geninterrupt (0x15);	/* get system memory map	*/
					/* CF -> fail or end of list	*/
		if (_FLAGS & 1 || _EAX != SMAP) break;

		/* check if memory is available/ACPI			*/
		_EAX = map.type - 1; if (_EAX > 3 || _AL == 1) continue;

		/* exclude memory portion below 1M			*/
		_EDX = map.size [1], _EAX = map.size [0];
		if (map._.based [1] == 0 && map._.basew [3] < 1024ul/64ul) {
			_ECX = 1024ul*1024ul, _ECX -= map._.based [0];
			if (_EAX < _ECX) {
				if (_EDX == 0) continue; /* base+size < 1M */
				_EDX--;
			}
			_EAX -= _ECX; /* base + size - 1M */
		}

		/* exit if size > 4G or summary exceed 4G		*/
		_ESI += _EAX; if (_EDX || _ESI < _EAX) return ULONG_MAX;
	} while (_EBX);
/*!*/	_EAX = 0, _EAX += _ESI;
	return _EAX;
}
# pragma option -3. /* return default CPU mode code generation */
#else
LOCAL ulong FAST_ EXT_E820 (void) { return 0; }
#endif

LOCAL void FAST_ EXT_get (void) {
	/* extended memory present on 286+ only */
	if (SYS.CPU < 2) return;

	AH = 0x88; callint (0x15);	/* get extended memory size	*/
	if (AH > 0x7Fu) AX = 0;		/* AH=80h,86h,88h or AX=	*/
	EXT.free_kb = AX;		/* ...number of kb above 1M	*/

	/* scan system memory map */
	if (SYS.CPU > 2 && (EXT.total = EXT_E820 ()) != 0) return;

	BX = 0, AX = 0xE801;		/* PhoenixBIOS: get memory size	*/
	callint (0x15);			/*  for >64M configurations	*/
	count size_64k = BX;
	if (CFLAG || size_64k == 0) {
		outp (0x70, 0x18); AH = inp (0x71); /* read CMOS */
		outp (0x70, 0x17); AL = inp (0x71);
		size_64k = 0;
	}
	EXT.total = AX * 1024ul + size_64k * (64u * 1024ul);
}
