/*----------------------------------------------------------------------*/
/* Declare types:							*/
/*	count, ulong, FPROC;						*/
/*	STATE, VERSION, SYSINFO;					*/
/*	MEM_TYPE, MCBINFO, MEMINFO;					*/
/*	EXTINFO, XMSINFO, EMSINFO					*/
/* Declare macroses:							*/
/*	FP, FS								*/

typedef unsigned int	count;
typedef unsigned long	ulong;
typedef const char	CStr[], *PCStr;
typedef char		Str[], *PStr;
typedef void far (far *FPROC) (void);

typedef enum { NONE, DONE, ERROR } STATE;

typedef union {
  struct { byte minor, major; } h;
  word x;
} VERSION;

typedef struct {
  count	CPU;
  struct {
	int	pause;
	count	last_row,
		filled;
  } screen;
  struct {
	VERSION	ver;
	byte	OEM, flags;
	DOSLoL	*LoL;
	DEVICE	*first_device;
  } OS;
} SYSINFO;

typedef enum {
  MT_SYSCODE	= 0x01,
  MT_SYSDATA	= 0x02,
  MT_SUBSEG	= 0x04,
  MT_CODE	= 0x08,
  MT_DATA	= 0x10,
  MT_ENV	= 0x20,
  MT_FREE	= 0x40,
  MT_UNKNOWN	= 0x80
} MEM_TYPE;

typedef struct mcbinfo {
  MEM_TYPE type;
  seg_t	seg,
	next_seg,
	owner;
  struct mcbinfo *next;
} MCBINFO;

typedef struct {
  MCBINFO *root, *last;
  struct {
	count	total_kb,
		free,
		largest;
	seg_t	last_seg;
  } BASE;
  struct {
	STATE	state;
	count	total,
		free,
		largest;
  } UMB;
} MEMINFO;

typedef struct {
  ulong	total;
  count	free_kb;
} EXTINFO;

typedef struct {
  STATE	state;
  FPROC	handler;
  count	free_kb,
	largest_kb;
  struct {
	count	free,
		largest;
  } UMB;
  struct {
	STATE	state;
	ulong	free_kb,
		largest_kb;
  } XMS32;
} XMSINFO;

typedef struct {
  STATE	state;
  count	verBCD;
  seg_t	frame_seg;
  count	pages_total,
	pages_free;
} EMSINFO;

typedef struct {
  byte	ID;
  PCStr	str;
} MAP;

#define FP(type,seg,off) ((type far*) MK_FP (seg,off))
#define FS(type,seg)	 FP (type, seg, 0)
