{****************************************************************************}
{Modul PASJPEG.PAS - addon for VenomGFX graphics library                     }
{                                                                            }
{It brings an alternate JPG loader based on robust library PasJPEG (JPEGlib) }
{which is considered as the standard library for JPG files handling.         }
{It should be more compatible but the code is much bigger and a little bit   }
{slower. It also doesn't support the loading files from .GRP archives        }
{****************************************************************************}

{$UNITPATH .\pasjpeg}
{$OBJECTPATH .\pasjpeg}
{$INLUDEPATH .\pasjpeg}

unit vnm_jpg2;

interface
uses VenomGFX;

Function Load_JPG(s:string;var w:virtualwindow):byte;

implementation
uses GRPfile,VenomMng,objects,JPG_read;

Function Load_JPG(s:string;var w:virtualwindow):byte;
var h:PMemoryStream;
    grp:PGrpStream;
    grppos:longint;
    a:byte;

begin
w.VWoffset:=0;
h:=New(PMemoryStream,Init(40000,20000));

grp:=New(PGRPstream,Init(s,stOpenRead));
grppos:=grp^.startpos;
{zjistim na jake pozici archivu zacina vnitrni soubor}
Dispose(grp,Done);
a:=Pos('#',s);
if a<>0 then s:=Copy(s,1,a-1);

JPG_2_BMP(s,grppos,h);
h^.Seek(0);
Load_JPG:=_Load_BMP(h,w);
Dispose(h,Done);
end;


Procedure Register_JPG_Loader;
begin
RegisterImageLoader('JPG',@Load_JPG);
end;


begin
Register_JPG_loader;
end.
