Unit Test;

interface

uses
  jmorecfg, jpeglib;

const
  MaxWidth = 175;
  MaxLines = 4;
type
  RGB_pixel = packed record
             Case byte of
             0:(r,g,b : byte);
             1:(color:array[0..2] of byte);
             2:(cyan,magenta,yellow : byte);
             3:(Y,Cb,Cr : byte);
           end;
var
  image_line : array[0..MaxLines-1,0..MaxWidth-1] of RGB_pixel;
var
  image_buffer : JSAMPROW;      { Points to large array of R,G,B-order data }
  image_height : int;           { Number of rows in image }
  image_width : int;            { Number of columns in image }
var
  current_line : int;
type
  jmp_buf = pointer;

  { This routine does the output }
  procedure put_scanline_someplace(buffer : JSAMPROW; row_stride : int);

  { define an error recovery point. Return 0 when OK }
  function setjmp(setjmp_buffer : jmp_buf) : int;

  { Return control to the setjmp point }
  procedure longjmp(setjmp_buffer : jmp_buf; flag : int);

  procedure save_color_map(cinfo : j_decompress_ptr);

  procedure define_image_params;

  procedure  pre_decode;

  procedure  post_decode;

implementation

var
  outfile : file;

{ This routine does the output }
procedure put_scanline_someplace(buffer : JSAMPROW; row_stride : int);
var
  line_size : int;
begin
  WriteLn(output, current_line:3, '. line of image data read');
  line_size := 3 * MaxWidth;

  BlockWrite(outfile, buffer^, row_stride);

  if line_size > row_stride then
    line_size := row_stride;

  if current_line < MaxLines then
    Move(buffer^, image_line[current_line], line_size);
  Inc(current_line);
end;

{ define an error recovery point. Return 0 when OK }
function setjmp(setjmp_buffer : jmp_buf) : int;
begin
  setjmp := 0;
  current_line := 0;
end;

{ Return control to the setjmp point }
procedure longjmp(setjmp_buffer : jmp_buf; flag : int);
begin
  Halt(2);
end;

procedure define_image_params;
var
  i, j : JDIMENSION;
  r0, b0, g0 : byte;
begin
  r0 := 255;
  g0 := 255;
  b0 := 255;
  for j := 0 to pred(MaxLines) do
  begin
    for i := 0 to Pred(MaxWidth) do
    with image_line[j][i] do
    begin
      r := r0;
      Dec(r0);
      g := g0;
      b := b0;
    end;
    Dec(b0, 16);
  end;
  image_buffer := JSAMPROW(@image_line);
  image_height := MaxLines;
  image_width := MaxWidth;
end;


procedure pre_decode;
begin
  Assign(outfile, 'PasJpeg.raw');
  ReWrite(outfile, 1);
end;

procedure save_color_map(cinfo : j_decompress_ptr);
var
  VGAPalette : Array[0..255] of RGB_pixel;
  i, count : int;
begin
  count := cinfo^.actual_number_of_colors;
  if (cinfo^.colormap <> NIL) and (count > 0) then
  begin
    if count > 256 then
      count := 256;
    if (cinfo^.out_color_components = 3) then
      for i := 0 to pred(count) do
      begin
        VGAPalette[i].r := cinfo^.colormap^[0]^[i];
        VGAPalette[i].g := cinfo^.colormap^[1]^[i];
        VGAPalette[i].b := cinfo^.colormap^[2]^[i];
      end
    else { Grayscale colormap (only happens with grayscale quantization) }
      for i := 0 to pred(count) do
      begin
        VGAPalette[i].r := cinfo^.colormap^[0]^[i];
        VGAPalette[i].g := cinfo^.colormap^[0]^[i];
        VGAPalette[i].b := cinfo^.colormap^[0]^[i];
      end;
    BlockWrite(outfile, VGAPalette, 3*count);
  end;
end;

procedure  post_decode;
begin
  Close(outfile);
end;

end.
f]Mu &    U}ffGPeuVeEG^]^]ËvXMMfÉJu &    &    Uu&ff&FPeeE&FƉË}&W&GE&GE&XMMfÉJu t& U0}uE;G
  F
  ];_   ^   SPE }؉EE    
E    EE }؉EE    
E    EX;G
F
E	G
+EEX;GFE	G+EEE+EEE+EEeefFEЋEeEvƋGEԋEeEǉu1ҋE   EUMMf]ԉߋUU؋uMu t& U8}uE;G
  F
  ];_  ^   SPE }؉EE    
E    EE }؉EE    
E    EX;G
F
E	G
+EEX;GFE	G+EEE+EEE+EEeeff&f&FEȋEeE&v&GE̋EeE&Ǉu1ҋE   EUMMf]ȉߋUUЋuMu t& U}uFEGEfF
EGEeeEEǉËVuMff;Et&fIu]Ju &    t& U}uGEFEf&G
E&FEeeEEƉ&W}Mff;Et&fIu]Ju     U,E};G
  uF
   ];_   ^   SPE }؉EE    
E    EE }؉EE    
E    EX;G
F
E	G
+EEX;GFE	G+EEE+EEE+EEeefFEԋEeEvƋGE؋EeEǉu܋Mff;Et&fIu]؉ߋUU܋uMu &    U4u}E;F
  G
  ];^   _   SPE }؉EE    
E    EE }؉EE    
E    EX;F
G
E	F
+EEX;FGE	F+EEE+EEE+EEeeE_]EǋE^]fvEfۉűMff;Et&fIu]ԉߋUŰuMu t& U$}fGEeeEGǉEuN
MNMvMfff*e }0e*E< }0E*U }0҈U&fff}]U r@r? rf f &fI|EE}Mg &    t& U4u}E;G
  F
w  ];_k  ^_  SPE }؉EE    
E    EE }؉EE    
E    EX;G
F
E	G
+EEX;GFE	G+EEE+EEE+EEeefNWM܉U؋EeEvƋEeEǉ}ЉuԋMfff*e }0e*E< }0E΀*U }0҈U&fff}]Ù r@r? rf f &fI|EEЋ}ЋUUԋuM^ Uu}fF
EFEGEeeEGǉEvMff;Et   ff*e }0e*E< }0E*U }0҈U&fff}]U r@r? rf f &fIrEE}M] U4}uE;G
  F
  ];_u  ^i  SPE }؉EE    
E    EE }؉EE    
E    EX;G
F
E	G
+EEX;GFE	G+EEE+EEE+EEeefFE؋GE܋EeEvƋEeEǉ}ЉuԋMff;Et   ff*e }0e*E< }0E΀*U }0҈U&fff}]Ù r@r? rf f &fIrEEЋ}ЋUUԋuMT &    U$u}fF
EFEGEeeEGǉEvMfffeEU&fff*} }0*] }0*U }0}]U r@r? rf f &fI{EE}Mf &    v U4u}E;G
  F
x  ];_l  ^`  SPE }؉EE    
E    EE }؉EE    
E    EX;G
F
E	G
+EEX;GFE	G+EEE+EEE+EEeefFE؋EeEvƋGE܋EeEǉ}ЉuԋMfffeE΀U&fff*} }0*] }0*U }0}]Ù r@r? rf f &fI{EEЋ}ЋUUԋuM] Uu}fF
EFEGEeeEGǉEvMff;Eu   ffeEU&fff*} }0*] }0*U }0}]U r@r? rf f &fIqEE}M\ U4u}E;G
  F
  ];_v  ^j  SPE }؉EE    
E    EE }؉EE    
E    EX;G
F
E	G
+EEX;GFE	G+EEE+EEE+EEeefFE؋GE܋EeEvƋEeEǉ}ЉuԋMff;Eu   ffeE΀U&fff*} }0*] }0*U }0}]Ù r@r? rf f &fIqEEЋ}ЋUUԋuMS     Uu}fGEFEF
EG
eEGǉEvMfffeEU&fff}]U r@r? rf f &fIuEE}M &    v U4u}E;G
b  F
V  ];_J  ^>  SPE }؉EE    
E    EE }؉EE    
E    EX;G
F
E	G
+EEX;GFE	G+EEE+EEE+EEeefFE؋EeEvƋGE܋EeEǉ}ЉuԋMfffeE΀U&fff}]Ù r@r? rf f &fIuEEЋ}ЋUUԋuM Uu}fGEFEF
EG
eEGǉEvMff;EtWffeEU&fff}]U r@r? rf f &fIuEE}M t& U4u}E;G
h  F
\  ];_P  ^D  SPE }؉EE    
E    EE }؉EE    
E    EX;G
F
E	G
+EEX;GFE	G+EEE+EEE+EEeefFE؋EeEvƋGE܋EeEǉ}ЉuԋMff;EtWffeE΀U&fff}]Ù r@r? rf f &fIuEEЋ}ЋUUԋuMy &    t& U}OfuvfffeEU&fff:evEsM:Ev*E<rE(E#:Esfu(E}r
fEmfEM:UvEsMEffUfUffI\ &    t& U$fh  uuEP4QEx}Ex}Ex
W$_}W$_]܃E܃
<$k  -d Ƀ
<$d  fEE܃
<${d  EExW$_}W$_]܃E܃
<$j  -d Ƀ
<$9d  fEE܃
<$!d  EEx}ff}u1efE  ]f1ҋ]fufUrKuMfEfEsAueMu &        UE@;E|	Ex}E@&;E|	Ex&}uuEPcfEEPEPEP}fW1 &    v Uhfh  uu}WtO=n }ċ=r }ȋEx
W$_-v EP$_]ExW$_-v EP$_]EHEE    E;E  = }̋= }ЋEHEE    E;E  }W}W}WEă
<$cb  PẼ
<$Nb  PEP}W}W}WEE
<$b  PẼ
<$
b  PEPM}W}W}WEă
<$a  PEE
<$a  PEP	}W}W}WEE
<$a  PEE
<$}a  PEPE- E]̃EUEUyfREUEUyfREUEUyfRO\fPuu}WaE;E}EKE- E]ċE;E}EE8u
   f UuNvfÀfeE]~ }0<?~?< }0~ }0f f
     UuNvff;EtOÀfeE]~ }0<?~?< }0~ }0f fI &    t& UuNvfÀfeE]~<?~?~f f
 UuNvff;Et5ÀfeE]~<?~?~f f &    v UuNvfÀfeE] }0< }0 }0f f
 UuNvff;Et5Àf*e*E*] }0< }0 }0f f &    v UuFv}ffÀ=?  t"1ҹ   o&w1ҹ        Uu}Nv΃f&fIu &    &    U,fh  Ep
Ep}WI}WEPE8u
   f &    Uu}FEV
NˋFv+uVf&f+uIu^Ju &    v U,fh  Ep
Ep}W.I}WEP~E8u
   f &    Uu}FEV
NˋvƃVf&fuIu^Ju &        U,fh  Ep
Ep}WH}WEP~E8u
   f &    Uu}FEN
VˋvƃVf&fIu^uJu &        U,fh  EpEp
}WG}WEP~E8u
   f &    Uu}FEN
VˋFv+uVf&fIu^+uJu &    v U,fh  EpEp
}WNG}WEP~E8u
   f &    U   EEP$_]E EEx}Ex}E EEx}Ex}Ex
}E -=i  |-h   h  EE1ҩ   tPRE`M EɃ
<$"Z  ÉуZXщ]̋E1ҩ   tPRE? EɃ
<$Y  ÉуZX)ʉEȋE    =i  |-h   h  EE1ҩ   tPRE`M EɃ
<$Y  ÉуZXщ]ԋE1ҩ   tPRE? EɃ
<$JY  ÉуZX)ʉEЋE    =i  |-h   h  EE1ҩ   tPRE`M EɃ
<$X  ÉуZXщ]ċE1ҩ   tPRE? EɃ
<$X  ÉуZX)ʉEE ;  =i  |-h   h  EE1ҩ   tPRE`M EɃ
<$QX  ÉуZXщ]E1ҩ   tPRE? EɃ
<$X  ÉуZX)ʉEEԉEEЉEE    E;E|tEE   E;E|tEE   E+EPX  EE+EPW  EEU+UԉT E@U+UЉT EE;E   E؉EuEE؋EEE؅6EU+UԉT E@U+UЉT EEEE)E؋EU+UԉT E@U+UЉT EE;E    E؉EuEE؋EEE؅6EU+UԉT E@U+UЉT EEEE)E؋EU+UԉT E@U+UЉT EE;E ExW$_}W$_]E
<$\  -d Ƀ
<$V  fEE
<$U  EEx&W$_uuuu&|P$_]E
<$\  -d Ƀ
<$U  fEE
<$U  EE;E|tEE   E;E|tEE   E+EPU  EE+EP{U  EE    fE}Ee1ɍ5T Ƌ]ԋVUEf]u&ff}fEfEsA;MrEEfEfEsEE;E'  E؉E  EE؋EEԋE؅|   fE}Ee1ɍ5T Ƌ]ԋVUEf]u&ff}fEfEsA;MrEEfEfEsEEEЋE)EfE}Ee1ɍ5T Ƌ]ԋVUEf]u&ff}fEfEsA;MrEEfEfEsEE;E "  E؉E  EE؋EEЋE؅|   fE}Ee1ɍ5T Ƌ]ԋVUEf]u&ff}fEfEsA;MrEEfEfEsEEEԋE)EfE}Ee1ɍ5T Ƌ]ԋVUEf]u&ff}fEfEsA;MrEEfEfEsEE;E  &    U   EEP$_]E EEx}Ex}E EEx}Ex}Ex
}E -=i  |-h   h  EE1ҩ   tPRE`M EɃ
<$Q  ÉуZXщ]̋E1ҩ   tPRE? EɃ
<$eQ  ÉуZX)ʉEȋE    =i  |-h   h  EE1ҩ   tPRE`M EɃ
<$Q  ÉуZXщ]ԋE1ҩ   tPRE? EɃ
<$P  ÉуZX)ʉEЋE    =i  |-h   h  EE1ҩ   tPRE`M EɃ
<$lP  ÉуZXщ]ċE1ҩ   tPRE? EɃ
<$/P  ÉуZX)ʉEE ;  =i  |-h   h  EE1ҩ   tPRE`M EɃ
<$O  ÉуZXщ]E1ҩ   tPRE? EɃ
<$O  ÉуZX)ʉEEԉEEЉEE    E;E|tEE   E;E|tEE   E+EPO  EE+EPrO  EEU+UԉT E@U+UЉT EE;E   E؉EuEE؋EEE؅6EU+UԉT E@U+UЉT EEEE)E؋EU+UԉT E@U+UЉT EE;E    E؉EuEE؋EEE؅6EU+UԉT E@U+UЉT EEEE)E؋EU+UԉT E@U+UЉT EE;E ExW$_}W$_]E
<$
T  -d Ƀ
<$M  fEE
<$oM  EEx&W$_uuuusP$_]E
<$S  -d Ƀ
<$M  fEE
<$ M  EE;E|tEE   E;E|tEE   E+EP
M  EE+EPL  EE    fE}Ee1ɍ5T Ƌ]ԋVUEf]u&ff;U$tf}fEfEsA;MrEEfEfEsEE;E3  E؉E  EE؋EEԋE؅   fE}Ee1ɍ5T Ƌ]ԋVUEf]u&ff;U$tf}fEfEsA;MrEEfEfEsEEEЋE)EfE}Ee1ɍ5T Ƌ]ԋVUEf]u&ff;U$tf}fEfEsA;MrEEfEfEsEE;E .  E؉E  EE؋EEЋE؅   fE}Ee1ɍ5T Ƌ]ԋVUEf]u&ff;U$tf}fEfEsA;MrEEfEfEsEEEԋE)EfE}Ee1ɍ5T Ƌ]ԋVUEf]u&ff;U$tf}fEfEsA;MrEEfEfEsEE;E  &    UUuNv}mmʃR!1%؉E uZ tfE ] &    &    U,fh  EpEp
}Wn5}WEPEPZE8u
   f t& UUuNv}mmʃR%    
    )؉Á    k1؋@ @ )ډӁ@ @ k?1	Ћ        )ډӁ    k1	ЃE \Z t ] &    &    U,