/* keydeftr.h */

/*
 * history
 * 17 apr 22: davide bresolin - creation
 */

#define NAME(x) x##_TR

#include <dos.h>
#include "mkeyb.h"

#define LANGUAGE "turkish-q"
#define STATUS   "by Davide"

#define COMBI

/********************************************************
 * TURKISH Q keyboard mappings				*
 ********************************************************/

/* keyboard image (by arkady)

Standard layout characters+scancodes:
ͻ
~29!02@03#04$05%06^07&08*09(0A)0B-0C=0DBacksp 0E
Ķ
Tab 0Fq10w11e12r13t14y15u16i17o18p19[1A]1B      
 < 
 Caps 3Aa1Es1Fd20f21g22h23j24k25l26;27'28Enter 1C
Ķ
 Shift 2A z2Cx2Dc2Ev2Fb30n31m32,33.34/35 Shift 36 
Ķ
 Ctrl 1D Alt 38\56    Spacebar 39    \2BAlt E38Ctrl E1D
ͼ
*/

/* Created from the Turkish Q Layout at http://kbdlayout.info/kbdtuq
   Codepage: 857
   
Changes from US layout. An extra '@' at the end is a COMBI key

Code	US	Norm	Shift	AltGr	AltGr+Shift
----------------------------------------------------------------
02	1	1	!	>		// DIGIT ONE, EXCLAMATION MARK, GREATER-THAN SIGN
03	2	2	'	0x9C		// DIGIT TWO, APOSTROPHE, POUND SIGN
04	3	3	^@	#		// DIGIT THREE, CIRCUMFLEX ACCENT, NUMBER SIGN
05	4	4	+	$		// DIGIT FOUR, PLUS SIGN, DOLLAR SIGN
06	5	5	%	0xAB		// DIGIT FIVE, PERCENT SIGN, VULGAR FRACTION ONE HALF
07	6	6	&			// DIGIT SIX, AMPERSAND
08	7	7	/	{		// DIGIT SEVEN, SOLIDUS, LEFT CURLY BRACKET
09	8	8	(	[		// DIGIT EIGHT, LEFT PARENTHESIS, LEFT SQUARE BRACKET
0a	9	9	)	]		// DIGIT NINE, RIGHT PARENTHESIS, RIGHT SQUARE BRACKET
0b	0	0	=	}		// DIGIT ZERO, EQUALS SIGN, RIGHT CURLY BRACKET
0c	-	*	?	\		// ASTERISK, QUESTION MARK, REVERSE SOLIDUS
0d	=	-	_	|		// HYPHEN-MINUS, LOW LINE, VERTICAL LINE
10	Q	q	Q	@		// LATIN SMALL LETTER Q, LATIN CAPITAL LETTER Q, COMMERCIAL AT
12	E	e	E	0xD5		// LATIN SMALL LETTER E, LATIN CAPITAL LETTER E, EURO SIGN
17	I	0x8D	I	i	0x98	// LATIN SMALL LETTER DOTLESS I, LATIN CAPITAL LETTER I, LATIN SMALL LETTER I, LATIN CAPITAL LETTER I WITH DOT ABOVE
1a	[	0xA7	0xA8	0xF9@		// LATIN SMALL LETTER G WITH BREVE, LATIN CAPITAL LETTER G WITH BREVE, DIAERESIS
1b	]	0x81	0x9A	~@		// LATIN SMALL LETTER U WITH DIAERESIS, LATIN CAPITAL LETTER U WITH DIAERESIS, TILDE
1e	A	a	A	0x91	0x92	// LATIN SMALL LETTER A, LATIN CAPITAL LETTER A, LATIN SMALL LETTER AE, LATIN CAPITAL LETTER AE
1f	S	s	S	0xE1		// LATIN SMALL LETTER S, LATIN CAPITAL LETTER S, LATIN SMALL LETTER SHARP S
27	;	0x9F	0x9E	0xEF@		// LATIN SMALL LETTER S WITH CEDILLA, LATIN CAPITAL LETTER S WITH CEDILLA, ACUTE ACCENT
28	'	i	0x98			// LATIN SMALL LETTER I, LATIN CAPITAL LETTER I WITH DOT ABOVE
29	`	"	0x82	<		// QUOTATION MARK, LATIN SMALL LETTER E WITH ACUTE, LESS-THAN SIGN
2b	        ,	;	`@		// COMMA, SEMICOLON, GRAVE ACCENT
33	,	0x94	0x99			// LATIN SMALL LETTER O WITH DIAERESIS, LATIN CAPITAL LETTER O WITH DIAERESIS
34	.	0x87	0x80			// LATIN SMALL LETTER C WITH CEDILLA, LATIN CAPITAL LETTER C WITH CEDILLA
35	/	.	:			// FULL STOP, COLON
56	\	<	>	|		// LESS-THAN SIGN, GREATER-THAN SIGN, VERTICAL LINE

*/

uchar NAME(scancodetable)[] = {

 /* ` */ PUNCT_ALTGR	(0x29, '"',  0x82,      '<'   )
 /* 1 */ PUNCT_ALTGR	(0x02, '1',  '!',       '>'   )
 /* 2 */ PUNCT_ALTGR	(0x03, '2',  '\'',      0x9C  )
#ifdef COMBI
 /* 3 */ PUNCT_ALTGR	(0x04, '3',  COMBI1,    '#'   )
#else
 /* 3 */ PUNCT_ALTGR	(0x04, '3',  '^',       '#'   )
#endif
 /* 4 */ PUNCT_ALTGR	(0x05, '4',  '+',       '$'   )
 /* 5 */ PUNCT_ALTGR	(0x06, '5',  '%',       0xAB  )
 /* 6 */ PUNCT		(0x07, '6',  '&'              )
 /* 7 */ PUNCT_ALTGR	(0x08, '7',  '/',       '{'   )
 /* 8 */ PUNCT_ALTGR	(0x09, '8',  '(',       '['   )
 /* 9 */ PUNCT_ALTGR	(0x0a, '9',  ')',       ']'   )
 /* 0 */ PUNCT_ALTGR	(0x0b, '0',  '=',       '}'   )
 /* - */ PUNCT_ALTGR	(0x0c, '*',  '?',       '\\'  )
 /* = */ PUNCT_ALTGR	(0x0d, '-',  '_',       '|'   )

 /* Q */ ALPHA_ALTGR	(0x10, 'q',  'Q',       '@'   )
 /* E */ ALPHA_ALTGR	(0x12, 'e',  'E',       0xD5  )
 /* I */ ALPHA_ALTGRSHIFT(0x17, 0x8D, 'I',      'i',   0x98)
#ifdef COMBI
 /* [ */ ALPHA_ALTGR	(0x1a, 0xA7, 0xA6,      COMBI2)
 /* ] */ ALPHA_ALTGR	(0x1b, 0x81, 0x9A,      COMBI3)
#else
 /* [ */ ALPHA_ALTGR	(0x1a, 0xA7, 0xA6,      0xF9  )
 /* ] */ ALPHA_ALTGR	(0x1b, 0x81, 0x9A,      '~'   )
#endif

 /* A */ ALTGRSHIFT 	(0x1e,                  0x91,  0x92)
 /* S */ ALPHA_ALTGR	(0x1f, 's',  'S',       0xE1  )
#ifdef COMBI
 /* ; */ ALPHA_ALTGR	(0x27, 0x9F, 0x9E,      COMBI4)
 /*   */ PUNCT_ALTGR	(0x2b, ',',  ';',       COMBI5)
#else
 /* ; */ ALPHA_ALTGR	(0x27, 0x9F, 0x9E,      0xEF  )
 /*   */ PUNCT_ALTGR	(0x2b, ',',  ';',       '`'   )
#endif
 /* ' */ ALPHA		(0x28, 'i',  0x98             )

 /* , */ ALPHA		(0x33, 0x94, 0x99             )
 /* . */ ALPHA		(0x34, 0x87, 0x80             )
 /* / */ PUNCT		(0x35, '.',  ':'              )
 /* \ */ PUNCT_ALTGR	(0x56, '<',  '>',      '|'    )

	 0
};

/*
   These keys are generated on a COMBI+character base.
   Some of them are correct only for codepage 857, since
   the standard 437 codepage doesn't have all accented characters
*/

#ifdef COMBI

uchar NAME(combi1table)[] = {         /* CIRCUMFLEX ACCENT */
	/*scancode lower upper*/
 /* A */ 0x1E, 0x83, 0xB6,
 /* E */ 0x12, 0x88, 0xD2,
 /* I */ 0x17, 0x8C, 0xD7,
 /* i */ 0x28, 0x8C, 0xD7,
 /* O */ 0x18, 0x93, 0xE2,
 /* U */ 0x16, 0x96, 0xEA,
 /*   */ 0x39,  '^',  '^', /* and additional generated character */
	 0
};

uchar NAME(combi2table)[] = {         /* DIAERESIS */
	/*scancode lower upper*/
 /* A */ 0x1E, 0x84, 0x8E,
 /* E */ 0x12, 0x89, 0xD3,
 /* I */ 0x17, 0x8B, 0xD8,
 /* i */ 0x28, 0x8B, 0xD8,
 /* O */ 0x18, 0x94, 0x99,
 /* U */ 0x16, 0x81, 0x9A,
 /*   */ 0x39, 0xF9, 0xF9, /* and additional generated character */
	 0
};

uchar NAME(combi3table)[] = {        /* TILDE */
	/*scancode lower upper*/
 /* A */ 0x1E, 0xC6, 0xC7,
 /* O */ 0x18, 0xE4, 0xE5,
 /* N */ 0x31, 0xA4, 0xA5,
 /*   */ 0x39,  '~',  '~', /* and additional generated character */
	0
};

uchar NAME(combi4table)[] = {         /* ACUTE ACCENT */
	/*scancode lower upper*/
 /* A */ 0x1E, 0xA0, 0xB5,
 /* E */ 0x12, 0x82, 0x90,
 /* I */ 0x17, 0xA1, 0xD6,
 /* i */ 0x28, 0xA1, 0xD6,
 /* O */ 0x18, 0xA2, 0xE0,
 /* U */ 0x16, 0xA3, 0xE9,
 /*   */ 0x39, 0xEF, 0xEF, /* and additional generated character */
	 0
};

uchar NAME(combi5table)[] = {         /* GRAVE ACCENT */
	/*scancode lower upper*/
 /* A */ 0x1E, 0x85, 0xB7,
 /* E */ 0x12, 0x8A, 0xD4,
 /* I */ 0x17, 0xEC, 0xDE,
 /* i */ 0x28, 0xEC, 0xDE,
 /* O */ 0x18, 0x95, 0xE3,
 /* U */ 0x16, 0x97, 0xEB,
 /*   */ 0x39,  '`',  '`', /* and additional generated character */
	 0
};

uchar NAME(combi6table)[] = {
	/*scancode lower upper*/
	 0
};

#endif

struct KeyboardDefinition NAME(Keyboard) = {
	"TR",                                          //char LanguageShort[4];			// "GR",
	"TURKISH - Q with combis (by Davide, verified by W. Spiegl, @cardpuncher)",    //char *Description;		// created by, "with combis"
	DRIVER_FUNCTION_FULL,                          //char DriverFunctionRequired;
	NAME(scancodetable),                           //char *ScancodeTable;
#ifdef COMBI
	{	NAME(combi1table),NAME(combi2table),NAME(combi3table),
		NAME(combi4table),NAME(combi5table),NAME(combi6table) },
#else
	{ 0 },
#endif			
	',',                                           //char DezimalDingsbums;                                        
	0,                                             //char DefaultLayoutUS;			// TRUE for russian             
	} ;
