# GNUmakefile

.PHONY: clean cleanall

PROG = 7zdec.exe
LDFLAGS = -s
RM = rm -f
CC = gcc

UPX = upx
UPXFLAGS = -qq --best --lzma --all-filters

DEBUG = # -g
MARCH = -march=pentium
OPTIMIZE = $(OPTLEVEL) $(MARCH) $(MTUNE)
OPTLEVEL = -Os

ifeq ($(shell $(CC) -dumpversion),2.953)
  MTUNE = -mcpu=i686
  WARN = -Wall -W
  OBJS = tiny.o mktime.o
else
  MTUNE = -mtune=native
  WARN = -Wall -Wextra
endif

CFLAGS = $(DEBUG) $(WARN) $(OPTIMIZE)

USEPPMD = -DPPMD # -D_7ZIP_PPMD_SUPPPORT


OBJS += 7zmain.o 7zalloc.o 7zarcin.o 7zbuf.o 7zbuf2.o \
        7zcrc.o 7zcrcopt.o 7zdec.o cpuarch.o delta.o \
        lzmadec.o lzma2dec.o bra.o bra86.o braia64.o \
        bcj2.o ppmd7.o ppmd7dec.o 7zfile.o 7zstream.o


$(PROG): $(OBJS)
	$(CC) -o $@ $(LDFLAGS) $(OBJS)
	-$(UPX) $(UPXFLAGS) $@


.c.o:
	$(CC) $(CFLAGS) -c $<


clean:
	-@$(RM) $(OBJS)

cleanall: clean
	-@$(RM) $(PROG)


tiny.o:     tiny.c
mktime.o:   mktime.c


7zdec.o:    7zdec.c precomp.h compiler.h 7ztypes.h 7z.h \
            7zcrc.h bcj2.h bra.h cpuarch.h delta.h \
            lzmadec.h lzma2dec.h
	$(CC) $(CFLAGS) $(USEPPMD) -c $<


bcj2.o:     bcj2.c precomp.h compiler.h 7ztypes.h bcj2.h \
            cpuarch.h
	$(CC) $(CFLAGS) -fno-strict-aliasing -c $<


7zalloc.o:  7zalloc.c precomp.h compiler.h 7ztypes.h 7zalloc.h
7zarcin.o:  7zarcin.c precomp.h compiler.h 7ztypes.h 7z.h \
            7zbuf.h 7zcrc.h cpuarch.h
7zbuf.o:    7zbuf.c precomp.h compiler.h 7ztypes.h 7zbuf.h
7zbuf2.o:   7zbuf2.c precomp.h compiler.h 7ztypes.h 7zbuf.h
7zcrc.o:    7zcrc.c precomp.h compiler.h 7ztypes.h 7zcrc.h \
            cpuarch.h
7zcrcopt.o: 7zcrcopt.c precomp.h compiler.h 7ztypes.h cpuarch.h
7zfile.o:   7zfile.c precomp.h compiler.h 7ztypes.h 7zfile.h
7zmain.o:   7zmain.c precomp.h compiler.h 7ztypes.h 7z.h \
            7zalloc.h 7zbuf.h 7zcrc.h 7zfile.h 7zversio.h
7zstream.o: 7zstream.c precomp.h compiler.h 7ztypes.h
bra.o:      bra.c precomp.h compiler.h 7ztypes.h bra.h
bra86.o:    bra86.c precomp.h compiler.h 7ztypes.h bra.h
braia64.o:  braia64.c precomp.h compiler.h 7ztypes.h bra.h
cpuarch.o:  cpuarch.c precomp.h compiler.h 7ztypes.h cpuarch.h
delta.o:    delta.c precomp.h compiler.h 7ztypes.h delta.h
lzma2dec.o: lzma2dec.c precomp.h compiler.h 7ztypes.h lzma2dec.h \
            lzmadec.h
lzmadec.o:  lzmadec.c precomp.h compiler.h 7ztypes.h lzmadec.h
ppmd7.o:    ppmd7.c precomp.h compiler.h 7ztypes.h ppmd7.h \
            ppmd.h cpuarch.h
ppmd7dec.o: ppmd7dec.c precomp.h compiler.h 7ztypes.h ppmd7.h \
            ppmd.h cpuarch.h

# EOF
