#ifndef ZIP7_INC_DOS_SYSTEM_H
#define ZIP7_INC_DOS_SYSTEM_H

#include "../../C/Threads.h"
#include "../Common/MyTypes.h"
#include "../Common/MyWindows.h"

namespace NDOS {
namespace NSystem {

struct CProcessAffinity
{
  UInt32 numSysThreads;

  UInt32 GetNumSystemThreads() const { return (UInt32)numSysThreads; }
  BOOL Get();

  void InitST()
  {
    numSysThreads = 1;
  }
  
  UInt32 GetNumProcessThreads() const
  {
    return numSysThreads;
    /*
    UInt32 num = 0;
    for (unsigned i = 0; i < sizeof(cpu_set) * 8; i++)
      num += (UInt32)((cpu_set >> i) & 1);
    return num;
    */
  }

  void CpuZero() { }
  void CpuSet(unsigned /* cpuIndex */) { /* UNUSED_VAR(cpuIndex) */ }
  int IsCpuSet(unsigned cpuIndex) const { return (cpuIndex < numSysThreads) ? 1 : 0; }

  BOOL SetProcAffinity() const
  {
    errno = ENOSYS;
    return FALSE;
  }
};

UInt32 GetNumberOfProcessors();

bool LongFileNames(); // returns true if the host has LFN support

bool GetRamSize(uint32_t &size); // returns false, if unknown ram size

// Returns the number of bits for -mdN and the dictionary_size in bytes.
unsigned int MaximumDictionarySize(uint32_t &dictionary_size);

unsigned long Get_File_OPEN_MAX();
unsigned Get_File_OPEN_MAX_Reduced_for_3_tasks();

}}

#endif // ZIP7_INC_DOS_SYSTEM_H