;                                                                           ;
;                     CHKSUM.S    v1.04a    04-24-2000                      ;
;                     Copyright 1997-2000, Charles Dye                      ;
;                       email:  raster@highfiber.com                        ;
;                                                                           ;
;       This is source for NASM, the Netwide Assembler.  Type               ;
;       NASM CHKSUM.S -O CHKSUM.COM  to re-assemble.  NASM is               ;
;       freeware, available from  http://www.cryogen.com/Nasm               ;
;                                                                           ;
;       This program is copyrighted, but may be freely distributed          ;
;       under the terms of the Free Software Foundation's GNU General       ;
;       Public License v2 (or later.)  See the file COPYING for the         ;
;       legalities.  If you did not receive a copy of COPYING, you          ;
;       may request one from the Free Software Foundation, Inc.,            ;
;       59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.           ;
;       ABSOLUTELY NO WARRANTY -- use it at your own risk!                  ;
;                                                                           ;


org 0100h

; -------------------------------------- MACROS AND EQUATES :

%macro doscall 1                       ; call to dos int 21 with a one-byte
%if %1 >= 0100h                        ; value in .ah, or a two-byte value
mov ax,%1                              ; in .ax :
%else
mov ah,%1
%endif
int 21h
%endmacro

%macro dosprint 1                      ; a simple wrapper for the dos 21/09
mov dx,%1                              ; print-a-string function
mov ah,09h
int 21h
%endmacro

%macro zero 1                          ; cheap way to zero a two-byte
xor %1,%1                              ; register
%endmacro

%macro testzero 1                      ; cheap way to test a 16-bit register
or %1,%1                               ; against zero
%endmacro

%macro zprint 1                        ; a wrapper for a call to my asciiz-
mov di,%1                              ; print routine
call zprint1
%endmacro

%macro bomb 2                          ; jump to handler for fatal errors
call bombs_away                        ; ... does not return!
%ifdef DEBUG_INLINE
db 80h,0bfh
%endif
dw %1                                  ; inline:  address of error message
db %2                                  ; inline:  exit code (errorlevel)
%endmacro

%define hilo(a,b) (a * 100h + b)       ; easy way to code two-byte quantities

fn_max    equ  0104h                   ; max. filename length, including null

attr_a   equ  20h                      ; value of archive attribute
attr_d   equ  10h                      ; value of directory attribute
attr_s   equ  04h                      ; value of system attribute
attr_h   equ  02h                      ; value of hidden attribute
attr_r   equ  01h                      ; value of read-only attribute

SPC   equ  20h                         ; ascii space
BS    equ  08h                         ; ascii backspace
CR    equ  0dh                         ; ascii carriage return
LF    equ  0ah                         ; ascii line feed
EOF   equ  1ah                         ; ascii end-of-file


; -------------------------------------- UNINITIALIZED VARIABLES IN THE PSP :

dp_t4    equ  0055h                    ; decimal print character count
dp_t1    equ  0056h                    ; low  word for decimal print routine
dp_t2    equ  0058h                    ; high word for decimal print routine

country  equ  005ch                    ; put country data in the psp :
country_date equ country + 00h         ; local date format, usa-eur-japan
country_thou equ country + 07h         ; local thousands char (',' in usa)
country_deci equ country + 09h         ; local decimal char   ('.' in usa)
country_dsep equ country + 0bh         ; local date separator ('-' in usa)
country_tsep equ country + 0dh         ; local time separator (':' in usa)
country_time equ country + 11h         ; local time format (0 12hr, 1 24hr)

temp      equ  006eh                   ; local temp variable (byte or word)

crc_lo    equ  0070h                   ; crc32
crc_hi    equ  0072h

date1     equ  0074h                   ; used to compute day-of-the-week
date2     equ  0076h
date3     equ  0078h

baton     equ  007ah                   ; used by twirling-baton routine

timer_lo  equ  007ch                   ; used to time program operation
timer_hi  equ  007eh                   ; in jiffies


; -------------------------------------- START OF CODE:

begin:
doscall 3000h                          ; check ms-dos version:
cmp al,02h
ja dos_okay
bomb msg_err_dos_bad,12h               ; dos prior to version 3 :  complain!
dos_okay:
call read_timer                        ; get clock ticks in dx:ax
mov [timer_hi],dx
mov [timer_lo],ax                      ; and save the start time
mov ax,sp                              ; examine stack pointer:
cmp ax,stack_end                       ; plenty of room?
jae trs_80.l1
trs_80:                                ; not enough memory:
bomb msg_trs_80,11h                    ; complain and exit with errorlevel 17
.l1:
mov sp,stack_end                       ; reduce stack size
push cs
pop es                                 ; .es points to program's code segment
mov bx,(stack_end / 10h) + 2h
doscall 4ah                            ; shrink program's memory block
jc trs_80

call check_output                      ; determine output to screen or file
call get_country_info                  ; get current country info
call get_vga_lines                     ; get screen size
mov dx,dta
doscall 1ah                            ; set up disk transfer area
mov si,0080h                           ; read from command line

parse_main:                            ; PRIMARY PARSER LOOP:
inc si
switch_done:
mov al,[si]                            ; examine next character
call force_uc                          ; in uppercase:
call test_eol                          ; end of line?
je parse_done                          ; if so, terminate primary parser
call test_space                        ; is it a space?
je parse_main                          ; if so, ignore it
call test_switch                       ; is it a switch character?
je found_switch                        ; if so, interpret it
mov bx,[pointer_pointer]               ; otherwise, this is the start of a
mov [filespec_pointers+bx],si          ; filespec; remember it
add bx,byte 02h
mov [pointer_pointer],bx               ; and bump pointer to file pointers
cmp bx,byte 40h                        ; out of space for file pointers?
jb .l2                                 ; if so,
bomb msg_err_specs_galore,10h          ; complain and exit with errorlevel 16
.l2:
call parse_fn                          ; parse through the filespec
mov al,[si]
call test_eol                          ; if the end of the line was found,
je parse_done                          ; terminate primary parser
jmp short parse_main                   ; otherwise, keep on truckin'

found_switch:                          ; FOUND A SWITCH CHARACTER:
inc si
lodsb                                  ; examine next character
call force_uc                          ; in uppercase:
mov bx,0ffffh                          ; start at beginning of switch table
.l0:
inc bx
cmp byte [switches+bx],00h             ; run out of legal switches to try?
je syntax                              ; if so, syntax error
cmp [switches+bx],al                   ; found this letter in table?
jne .l0                                ; if not, keep looking
shl bx,01h                             ; multiply .bx by two
mov ax,[switch_routines+bx]            ; and get address of switch routine
jmp ax                                 ; to jump to

syntax:                                ; SYNTAX ERROR IN COMMAND LINE:
call error_out
dosprint msg_syntax                    ; print error message
doscall 4c10h                          ; and exit with errorlevel 16

parse_done:                            ; DONE WITH PRIMARY PARSER:
mov bx,[pointer_pointer]
testzero bx                            ; found any filespecs at all?
jne .l1
mov ax,star_dot_star
mov [filespec_pointers],ax             ; if not, slip in a star-dot-star-cr
add bx,byte 02h
.l1:
zero ax
mov word [filespec_pointers+bx],ax     ; add a null to end of list
mov word [pointer_pointer],ax          ; and point to the start of the list

call make_crc32_table                  ; create table of crc32 values
call alloc_tree_buffer                 ; create buffer for /s tree if needed
call alloc_file_buffer                 ; get buffer for file reads
call alloc_list_buffer                 ; get buffer for file list
call fix_paging                        ; disable paging if output redirected
call hook_int_24                       ; disable critical-error handling
mov byte [last_dir_shown],00h          ; empty the last-directory buffer

big_loop:                              ; LOOP THROUGH COMMAND-LINE FILESPECS:
mov bx,[pointer_pointer]
mov ax,[filespec_pointers+bx]          ; get offset of command-line filespec
testzero ax                            ; have we run out yet?
je big_loop_done                       ; if so, exit
add word [pointer_pointer],byte 02h    ; otherwise, point to next filespec
mov si,ax
call parse_fn                          ; and parse this one
call clean_up_filespec                 ; canonicalize it

filespec_loop:
call get_fn_from_list                  ; read filespec from list, if needed
jc big_loop                            ; if eof, back for next user filespec
subdir_loop:
call use_multiple_files                ; use files matching this filespec
call find_any_subdirs                  ; add any subdirectories to tree buff.
call use_next_subdir                   ; is there a subdirectory in buffer?
jnc subdir_loop                        ; if so, find any files in it
test byte [flags],fb_list              ; using a file list?
jne filespec_loop                      ; if so, get next filespec from it
jmp short big_loop

big_loop_done:                         ; done with all user filespecs:
call show_summary
doscall 4c00h                          ; exit with errorlevel 0


parse_fn:                              ; READ FILESPEC FROM COMMAND LINE:
and byte [flags],0ffh ^ (fb_quote | fb_list)   ; turn off quote-mode, at-mode
mov di,fnbuf                           ; point to filespec buffer
zero cx                                ; no characters yet
mov [di],cl                            ; empty the buffer

parse_fn_1:                            ; parse filename loop:
lodsb                                  ; get a character from command line
call force_uc                          ; and force it to uppercase
call test_eol                          ; end of line?
je parse_fn_eol                        ; if so, handle it
call test_space                        ; space or tab?
je parse_fn_space                      ; if so, handle it
cmp al,'"'                             ; quote mark?
je parse_fn_quote                      ; if so, handle it
cmp al,'/'                             ; forward slash?
jne .l2
mov al,'\'                             ; if so, convert to backslash
.l2:
cmp al,'@'                             ; at sign?
jne parse_fn_char                      ; no, treat like a normal character
testzero cx                            ; yes:  got any characters yet?
jne parse_fn_char                      ; yes:  at sign is part of filename
test byte [flags],(fb_list | fb_quote) ; quote-mode or at-mode?  if either,
jne parse_fn_char                      ; at sign is part of filename
or byte [flags],fb_list                ; note:  file list
jmp short parse_fn_1                   ; continue parsing

parse_fn_char:                         ; NORMAL CHARACTER IN FILENAME:
mov ah,00h                             ; stash character and null-terminate
mov [di],ax                            ; the string
inc di
inc cx                                 ; increment count of characters
cmp cx,fn_max                          ; buffer overflow?
jb parse_fn_1                          ; if not, continue parsing
bomb msg_err_fn_ovf,10h                ; complain and exit with errorlevel 16

parse_fn_eol:                          ; FOUND THE END OF COMMAND LINE:
testzero cx                            ; found a filename yet?
jne .l0                                ; if not,
bomb msg_err_in_filespec,10h           ; complain and exit with errorlevel 16
.l0:
dec si                                 ; let the primary parser see it
ret                                    ; and we're done parsing the filespec

parse_fn_space:                        ; FOUND A SPACE IN THE FILESPEC:
test byte [flags],fb_quote             ; parsing between quotes?
jne parse_fn_char                      ; if so, treat like any other char
testzero cx                            ; any characters in filespec yet?
jne .l1                                ; if not,
bomb msg_err_in_filespec,10h           ; complain and exit with errorlevel 16
.l1:
dec si                                 ; if so, we're done parsing filespec
.quit:
ret

parse_fn_quote:                        ; found a quote mark:
test byte [flags],fb_quote             ; has an opening quote been found?
jne parse_close_quote                  ; if so, this is a close quote
testzero cx                            ; is the filename empty?
jne parse_fn_char                      ; if not, quote is part of filename
or byte [flags],fb_quote               ; note that open quote was found
jmp short parse_fn_1                   ; and continue parsing
parse_close_quote:
testzero cx                            ; empty filename?
jne parse_fn_space.quit                ; if so,
bomb msg_err_in_filespec,10h           ; complain and exit with errorlevel 16


use_multiple_files:                    ; USE FILES MATCHING CURRENT SPEC:
call append_short_filespec             ; add user's filespec
and byte [flags],0ffh ^ fb_shown       ; directory name not displayed yet
mov dx,fnbuf                           ; point to working filespec
mov cx,0006h                           ; include hidden and system files
doscall 4eh                            ; find first matching file
use_multi_1:
jc use_multi_exit                      ; any error, exit loop
call show_cur_dir_maybe                ; display current directory if need be
call append_found_filespec             ; make full filename in fnbuf
call show_cur_filename                 ; display current filename
call checksum_file                     ; compute its checksum
call show_file_info                    ; and its date, time, attributes
doscall 4fh                            ; find next matching file
jmp short use_multi_1                  ; till the cows come home
use_multi_exit:
ret

checksum_file:                         ; READ THROUGH FILE, COMPUTE CHECKSUM:
call zero_handle                       ; note no file open
mov dx,fnbuf                           ; point to full filename
doscall 3d20h                          ; open file for read
jnc .l03                               ; any problem with open?
jmp read_error                         ; if so, go deal with it
.l03:
mov [handle],ax                        ; save file handle
mov word [baton],1000h                 ; initialize baton
mov si,0ffffh                          ; note that we must fill the buffer
zero di                                ; no bytes in the file buffer yet
mov es,[file_seg]                      ; es points to the file buffer
mov dx,si
mov ax,si                              ; checksum starts with all bits set
zero bp                                ; xdir sum starts with all bits clear
checksum_loop:
cmp si,di                              ; finished with the current buffer?
jae checksum_read                      ; if so, read in another
got_bufferfull:
mov bl,[es:si]                         ; get byte from buffer
xor bh,bh                              ; and convert to a word
add bp,bx                              ; add it into xdir checksum
rol bp,1                               ; rotate xdir checksum left one bit
xor bl,al                              ; xor with low byte of current crc32
shl bx,1                               ; multiply pointer by two
mov al,ah
mov ah,dl                              ; shift current crc right eight bits
mov dl,dh
xor dh,dh                              ; clearing the top eight
xor dx,[table_hi+bx]                   ; exclusive-or current crc
xor ax,[table_lo+bx]                   ; with appropriate value from table
inc si                                 ; and increment pointer
jmp short checksum_loop                ; and loop back for next byte

checksum_read:                         ; READ IN ONE BUFFERFULL:
mov [crc_hi],dx                        ; save working checksum
mov [crc_lo],ax
test byte [flags],fb_cons              ; is output to the console?
je .l30                                ; if not, don't twirl the baton
dec byte [baton+1]                     ; time for the next twirl?
jne .l30                               ; if not, don't twirl the baton
mov byte [baton+1],04h                 ; reset the twirl count
mov bl,byte [baton]                    ; get current baton number
mov bh,00h                             ; as a sixteen-bit pointer
mov dl,[msg_baton+bx]                  ; get current baton as ascii
doscall 02h                            ; print it
mov dl,BS                              ; print a backspace
int 21h
inc byte [baton]                       ; increment the baton number
cmp byte [baton],04h                   ; overflow?
jb .l30
mov byte [baton],00h                   ; if so, zero it
.l30:                                  ; done with baton twirling :
mov bx,[handle]                        ; using the saved file handle
mov cx,8000h                           ; read up to 32 kilobytes
zero dx                                ; to the beginning
mov ds,[file_seg]                      ; of the file buffer
doscall 3fh                            ; read from file
jc read_error                          ; any error?  go deal with it
push cs
pop ds                                 ; restore .ds
testzero ax                            ; end of file?
je checksum_eof                        ; if so, deal with it
mov di,ax                              ; save length of current bufferfull
zero si                                ; point to the start of the buffer
mov dx,[crc_hi]
mov ax,[crc_lo]                        ; get current crc in dx:ax
jmp got_bufferfull                     ; and loop back to continue crc

checksum_eof:                          ; end of file:
call close_handle                      ; close file handle
xor word [crc_hi],byte -1
xor word [crc_lo],byte -1              ; flip all bits in checksum
mov cx,[crc_hi]
add [master_hi],cx
call hex_word_out                      ; display high word of crc32
mov cx,[crc_lo]
add [master_lo],cx
call hex_word_out                      ; display low  word of crc32
dosprint msg_info_space
mov cx,bp
add [master_xdir],cx
call hex_word_out                      ; display xdir sum
add word [files_lo],byte 01h
adc word [files_hi],byte 00h           ; increment number of files processed
mov ax,[dta_sizl]
mov dx,[dta_sizh]                      ; add the size of the latest file
add [sizes_lo],ax                      ; into the running size total
adc [sizes_hi],dx
ret                                    ; and exit

close_handle:
mov bx,[handle]
doscall 3eh                            ; close file handle
zero_handle:
mov word [handle],0000h
ret

read_error:                            ; error opening or reading from file :
push cs
pop ds                                 ; put .ds back where god intended
mov cx,ax                              ; save dos error number
cmp word [handle],byte 00h             ; was the file opened?
je .l10
call close_handle                      ; if so, close it
.l10:
dosprint msg_read_err
call hex_word_out
add word [fails_lo],byte 01h
adc word [fails_hi],byte 00h           ; increment the file-failure count
mov si,fnbuf
mov di,problem_name                    ; copy fnbuf into problem_name buffer
jmp copy_string                        ; and exit

show_file_info:                        ; DISPLAY FILE'S DATE, TIME, ATTRIBS:
dosprint msg_info_space3
mov ax,[dta_date]
call show_dow                          ; compute and show day of week
mov ax,[dta_date]
call show_date                         ; display file's date stamp
dosprint msg_info_space
mov ax,[dta_time]
call show_time                         ; display file's time stamp
mov al,[dta_attr]
call show_attribs                      ; display file's attributes
dosprint msg_info_space
call show_file_size                    ; display the file's size
call crlf                              ; terminate output line
ret                                    ; and exit

find_any_subdirs:                      ; FIND SUBDIRECTORIES, ADD TO TREE BUF
test byte [flags],fb_sws               ; was /s specified?
je dir_loop_exit                       ; if not, don't bother finding subdirs
mov si,star_dot_star                   ; copy star-dot-star filespec
mov di,[last_bs]                       ; just after the final backslash
inc di
call copy_string
cmp di,fnbuf + fn_max                  ; did the copy overflow the buffer?
jna .l2                                ; no, continue
jmp error_fnbuf_over                   ; yes, crash and burn
.l2:
mov dx,fnbuf
mov cx,0016h                           ; look for subdir, hidden, system ...
doscall 4eh
dir_loop:
jc dir_loop_exit                       ; any error, stop subdir search
test byte [dta_attr],attr_d            ; is the item found a subdir?
je dir_loop_next                       ; if not, keep looking
cmp byte [dta_name],'.'                ; stupid dos . or .. entries?
je dir_loop_next                       ; if so, keep looking
call append_found_filespec             ; add subdir name to current dir name
mov es,[tree_seg]
call find_es_zz                        ; find the end of the tree buffer
mov dx,si                              ; and remember where it was
mov di,si
mov si,fnbuf                           ; copy full pathname of found subdir
call copy_string_far                   ; into the tree buffer
mov cx,di
stosb                                  ; and add a second null
push ds
pop es
cmp cx,dx                              ; did we overflow the tree buffer?
jb tree_buffer_over                    ; if so, bomb out
dir_loop_next:                         ; look for next subdirectory:
doscall 4fh                            ; dos find-next function
jmp short dir_loop
dir_loop_exit:
ret

tree_buffer_over:                      ; TREE BUFFER HAS OVERFLOWED:
bomb msg_tree_buffer_over,16h          ; complain and exit with errorlevel 22

use_next_subdir:                       ; IS A DIRECTORY NAME BUFFERED?
test byte [flags],fb_sws               ; was /s specified?
jne .l1
.l0:
stc                                    ; if not, exit with no new subdir
.quit:
ret
.l1:                                   ; /s was specified:
mov es,[tree_seg]
zero bx                                ; .bx holds a convenient zero
cmp byte [es:bx],bl                    ; is there anything in the buffer?
je .l0                                 ; if not, don't use it.  duh.
push ds
pop es
mov di,fnbuf                           ; es:di points to fnbuf
mov ds,[tree_seg]
zero si                                ; ds:si points to start of tree buffer
call copy_string_far                   ; get directory name from buffer
cmp byte [si],bl                       ; was it the last name in the buffer?
jne .l4
mov [bx],bx                            ; if so, empty the tree buffer
jmp short .l6
.l4:                                   ; if not,
zero di                                ; copy to the start of the tree buffer
mov es,[cs:tree_seg]
.l5:
lodsb                                  ; copy one byte from tree buffer
stosb                                  ; down into its new location
cmp al,00h                             ; null marking end of one subdir name?
jne .l5
cmp byte [si],00h                      ; if so, look for second (final) null
jne .l5                                ; and keep copying until you find it
stosb                                  ; store final null to new location
.l6:
push cs                                ; restore
push cs
pop ds                                 ; data segment
pop es                                 ; and extra segment
call find_null_fnbuf                   ; find the end of fnbuf
mov [last_bs],di
mov word [di],hilo (00h,'\')           ; add a backslash and terminal null
clc                                    ; and exit with carry clear
ret                                    ; to indicate new dir. name present

switch_s:                              ; /S -- RECURSE INTO SUBDIRECTORIES
or byte [flags],fb_sws
jmp switch_done

switch_e:                              ; /E -- SUPPRESS AUTOMATIC .* EXT
or byte [flags],fb_swe
jmp switch_done

switch_h:                              ; /H -- DO NOT HOOK INT 24
or byte [flags],fb_swh
jmp switch_done

switch_m_err:                          ; PROBLEM WITH /M SYNTAX
call error_out
dosprint msg_err_sw_m                  ; display error message
doscall 4c10h                          ; and exit with errorlevel 16

switch_m:                              ; /M -- CONTROL PAGING
mov al,[si]                            ; examine the next character:
cmp al,'?'                             ; is it a question mark?
je switch_m_err                        ; if so, display syntax help
call test_colon                        ; is the next character a colon?
jne .l1
inc si                                 ; if so, skip over it
mov al,[si]                            ; and expect the next character
call test_digit                        ; to be a digit
jne switch_m_err                       ; colon but no digit = syntax error!
.l1:                                   ; no colon:
call test_digit                        ; is the character a digit?
je .l3                                 ; if so, skip ahead, get user value
mov al,[vga_lines]
mov [screen_lines],al                  ; otherwise, default to 23 lines
jmp switch_done                        ; and return to main parse loop
.l3:                                   ; user-specified paging value:
call get_num                           ; read it in
cmp ah,00h                             ; more than 255?
jne switch_m_err                       ; if so, problem
mov [screen_lines],al                  ; otherwise, save it
jmp switch_done                        ; and exit

switch_f:                              ; /F -- SELECT DATE FORMAT
mov al,[si]                            ; examine the next character
call test_colon                        ; is it a colon or equals sign?
jne .l1
inc si                                 ; if so, skip over it
.l1:
mov al,[si]                            ; examine the next character
call force_uc
cmp al,'U'
je switch_fu                           ; /f:u  -- united states format
cmp al,'E'
je switch_fe                           ; /f:e  -- european date format
cmp al,'J'
je switch_fj                           ; /f:j  -- japanese date format
cmp al,'I'
je switch_fj                           ; /f:i  -- iso (japanese) format

switch_f_err:                          ; PROBLEM WITH /F SYNTAX
call error_out
dosprint msg_err_sw_f                  ; display error message
doscall 4c10h                          ; and exit with errorlevel 16

switch_fu:
mov al,00h
jmp short switch_f_x
switch_fe:
mov al,01h
jmp short switch_f_x
switch_fj:
mov al,02h
switch_f_x:
mov [country_date],al
inc si
jmp switch_done


show_cur_dir_maybe:                    ; DISPLAY DIRECTORY NAME IF NEEDED:
cmp word [last_bs],byte 00h            ; is there a backslash in fnbuf?
je show_cur_dir.quit                   ; if not, exit in disgust
mov si,fnbuf
mov di,last_dir_shown
.l2:
lodsb
cmp al,[di]
jne .l8
inc di
cmp si,[last_bs]
jbe .l2
cmp byte [di],00h
je show_cur_dir.quit
.l8:
call crlf

show_cur_dir:
mov si,fnbuf                           ; point to start of filespec buffer
mov di,last_dir_shown
mov ah,02h                             ; dos print-a-character function
.l0:
cmp si,[last_bs]                       ; passed the final backslash yet?
ja .l8                                 ; if so, exit
mov dl,[si]                            ; get a character from directory name
inc si
mov [di],dl
inc di
int 21h                                ; and print it out
jmp short .l0                          ; and loop back for more
.l8:                                   ; done printing current directory name
mov byte [di],00h
call crlf                              ; terminate the current print line
.quit:
ret                                    ; get outta here

show_cur_filename:                     ; DISPLAY FILENAME OF FOUND FILE:
mov di,dta_name                        ; point to start of found filename
mov ah,02h                             ; dos print-a-character function
mov cx,000fh                           ; must print 15 characters
.l0:
mov dl,[di]                            ; get a character from filename
cmp dl,'A'
jb .l4                                 ; is it an uppercase letter?
cmp dl,'Z'                             ; if not, don't lowercase it
ja .l4
or dl,20h                              ; if it is, force it to lowercase
.l4:
inc di
cmp dl,00h                             ; found the terminal null yet?
je .l1
int 21h                                ; if not, print the character
dec cx                                 ; decrement the characters index
jmp short .l0                          ; and loop back
.l1:                                   ; done printing filename:
mov dl,SPC
.l2:
int 21h                                ; print spaces
loop .l2                               ; until 13 characters have been shown
ret                                    ; then quit

show_date:                             ; display file's date stamp:
mov bx,ax                              ; save date stamp
mov cl,[country_date]                  ; check country's date format
cmp cl,01h
je show_datee                          ; 01, european date format
cmp cl,02h
je show_datej                          ; 02, japanese date format
and ah,01h                             ; file's date stamp:
mov cl,05h
shr ax,cl                              ; get month value in al
mov ah,80h                             ; suppress leading zeroes
call time_print                        ; print month
mov dl,[country_dsep]
doscall 02h                            ; print the date separator
mov ax,bx                              ; get file's date stamp
and ax,001fh                           ; get day value in al
call time_print                        ; print day with leading zeroes
mov dl,[country_dsep]
doscall 02h                            ; and the date separator
show_year:
mov ax,bx                              ; get file's date stamp
mov cl,09h
shr ax,cl                              ; get year value in al
add ax,1980                            ; and normalize
jmp decout                             ; print the year

show_datee:                            ; show date, european:
and ax,001fh                           ; get day value in al
or ah,80h
call time_print                        ; print day without leading zeroes
mov dl,[country_dsep]
doscall 02h                            ; and the date separator
mov ax,bx                              ; file's date stamp:
and ah,01h
mov cl,05h
shr ax,cl                              ; get month value in al
call time_print                        ; print month, with leading zeroes
mov dl,[country_dsep]
doscall 02h                            ; and the date separator
jmp short show_year                    ; show the year value

show_datej:                            ; show date, japanese:
call show_year                         ; show the year value
mov dl,[country_dsep]
doscall 02h                            ; and the date separator
mov ax,bx                              ; file's date stamp:
and ah,01h
mov cl,05h
shr ax,cl                              ; get month value in al
call time_print                        ; print month, with leading zeroes
mov dl,[country_dsep]
doscall 02h                            ; and the date separator
mov ax,bx                              ; file's date stamp:
and ax,001fh                           ; get day value in al
jmp time_print                         ; print day with leading zeroes, exit

show_time:                             ; display file's time stamp:
push ax                                ; save time stamp for future reference
mov cl,0bh
shr ax,cl                              ; get hour in al
call time_print                        ; and print hours
mov dl,[country_tsep]
doscall 02h                            ; followed by the time separator char
pop ax
push ax                                ; file's time stamp:
and ah,07h
mov cl,05h
shr ax,cl                              ; get minutes in al
call time_print                        ; print minutes with leading zeroes
mov dl,[country_tsep]
doscall 02h                            ; followed by the time separator char
pop ax                                 ; file's time stamp:
and ax,001fh
shl ax,01h
call time_print                        ; print seconds with leading zeroes
dosprint msg_info_space                ; if so, just print some blanks
ret

time_print:                            ; STUPID TWO-DIGIT DECIMAL PRINT:
mov dh,ah
aam                                    ; unpack decimal digits
add ax,hilo ('0','0')                  ; and convert to ascii digits
push ax                                ; save the remainder
mov dl,ah
test dh,80h                            ; supposed to suppress leading zero?
je .l10                                ; if not, skip ahead
cmp dl,'0'                             ; is the tens digit zero?
jne .l10                               ; if not, skip ahead
mov dl,SPC                             ; if so, print a space instead
.l10:
doscall 02h                            ; print the tens digit
pop dx                                 ; get the ones digit
int 21h                                ; print the ones digit
ret

show_dow_err:                          ; error computing day of week:
mov dx,0007                            ; return 7 (no day-of-week)
jmp show_dow_x

show_dow:                              ; compute and display day of week:
mov [temp],ax                          ; save date in directory format
mov cl,09h
shr ax,cl
mov [date3],ax                         ; save year
mov ax,[temp]
mov cl,05h
shr ax,cl
and ax,000fh                           ; extract month value
cmp al,01h                             ; month less than 1?
jb show_dow_err                        ; if so, no day-of-week
cmp al,0ch                             ; month greater than 12?
ja show_dow_err                        ; if so, no day-of-week
mov [date1],ax                         ; save month
mov ax,[temp]
and ax,001fh                           ; extract day value
cmp al,01h                             ; day less than 1?
jb show_dow_err                        ; if so, no day-of-week
mov [date2],ax                         ; save day
call test_leap_year                    ; set correct length for february
mov bx,[date1]
mov cl,[months_table-1+bx]             ; get length of month in .cl
cmp cl,[date2]                         ; date greater than maximum?
jb show_dow_err                        ; if so, no day-of-week
zero bx
.l3:
mov al,[months_table+bx]               ; get length of month
cbw                                    ; as a word
inc bx
cmp bx,[date1]                         ; hit the user's month yet?
je .l4                                 ; yes, exit this loop
add [date2],ax                         ; no, add month length into julian
jmp short .l3                          ; and loop back for next month
.l4:                                   ; added in lengths of previous months:
mov bx,[date3]                         ; get dos year in .bx
testzero bx                            ; dos year zero?
je .l8                                 ; if so, skip following calculations
inc word [date2]                       ; add one for leap day 1980
mov ax,bx
mov dx,365
mul dx                                 ; multiply year number by 365
add [date2],ax                         ; and add into the julian number
mov ax,bx
dec ax                                 ; decrement year number
shr ax,01h
shr ax,01h                             ; and divide by four
add [date2],ax                         ; add leap days into julian number
cmp bx,byte 120                        ; year greater than 2100?
jbe .l8
dec word [date2]                       ; if so, subtract one leap day
.l8:                                   ; done computing julian number:
zero dx
mov ax,[date2]                         ; get julian date as 32-bit number
inc ax                                 ; add one (1-1-1980 was a tuesday)
mov cx,0007h                           ; divide julian number by seven
div cx                                 ; remainder in .dx is the day of week
show_dow_x:
shl dx,01h
shl dx,01h                             ; multiply dow number by four
add dx,dow_names                       ; to get offset within dow names table
doscall 09h                            ; print dow name
mov dl,SPC                             ; and a space
doscall 02h
ret                                    ; exit

show_attribs:                          ; display file's attributes:
mov ch,al                              ; save attributes byte
zero si                                ; pointer to bit-name letters
mov cl,attr_a                          ; highest bit is #5 (archive)
mov ah,02h                             ; dos print-a-character function
attr_loop:
mov dl,'.'                             ; assume a space
test ch,cl                             ; is this bit set?
je attr_go                             ; clear, use the space
mov dl,[attr1+si]                      ; set, get the bit-name letter instead
attr_go:
int 21h                                ; display letter or dot
inc si                                 ; and point to the next letter
attr_skip:
shr cl,1h                              ; and shift right to next bit
test cl,18h                            ; bits 5 and 4 (volume/subdir) we
jne attr_skip                          ; don't care about, so skip them
cmp cl,00h                             ; run out of bits?
jne attr_loop                          ; no, loop back for next
ret                                    ; yes, exit

show_file_size:                        ; display file's size in bytes :
mov byte [dp_min],0dh                  ; justify to thirteen digits
mov ax,[dta_sizl]                      ; get low  byte of file size
mov dx,[dta_sizh]                      ; get high byte of file size
                                       ; fall through to....

dec_print_big:                         ; DISPLAY DOUBLEWORD IN DX:AX
mov [dp_t1],ax                         ; save the doubleword value
mov [dp_t2],dx                         ; for later use
mov byte [dp_t4],00h
mov bx,000ah                           ; ten decimal is our divisor
push bx                                ; also our end-of-stack marker
mov cl,00h                             ; init digits-between-commas count
dec_print_1:                           ; main decimal division loop
zero dx
mov ax,[dp_t2]                         ; dx:ax contains the high word as quad
div bx                                 ; divide by ten
mov [dp_t2],ax                         ; save new high-order word
mov ax,[dp_t1]                         ; get the old low word
div bx                                 ; and divide by ten
mov [dp_t1],ax                         ; save new low word
add dx,byte '0'                        ; convert remainder to ascii digit
push dx                                ; and save it on the stack
inc byte [dp_t4]
testzero ax                            ; anything left?
jne dec_print_12                       ; if so, continue with divisions
cmp word [dp_t2],byte 00h
je dec_print_15                        ; if not, print out digits
dec_print_12:
inc cl                                 ; increment digits-between-commas
cmp cl,03h                             ; three digits yet?
jne dec_print_1                        ; if not, loop back for next digit
mov cl,00h                             ; yes, zero counter
mov dl,[country_thou]                  ; and push a comma on the stack
mov dh,dl
push dx
inc byte [dp_t4]
jmp short dec_print_1                  ; and loop back for next digit
dec_print_15:                          ; done with divisions:
mov ah,02h                             ; dos print-character function:
cmp byte [dp_min],00h                  ; right-justified?
je dec_print_2                         ; if not, print digits now
mov cl,[dp_min]
sub cl,[dp_t4]                         ; get number of spaces needed
jbe dec_print_2                        ; if negative, never mind!
mov ch,00h
mov dl,SPC
dec_print_17:
int 21h                                ; print space
loop dec_print_17                      ; until done
dec_print_2:                           ; decimal printout loop
pop dx                                 ; get a digit from the stack
cmp dx,byte 0ah                        ; hit the end of stack yet?
je dec_print_3                         ; if so, exit decimal print routine
int 21h                                ; otherwise, print the digit
jmp short dec_print_2                  ; and loop back for next digit
dec_print_3:
mov byte [dp_min],00h
ret

dp_min:                                ; minimum number of chars to print
db 00

decout:                                ; DECIMAL PRINT, ONE WORD, NO COMMAS:
zero dx
push dx                                ; save zero as end-of-stack marker
mov cx,000ah                           ; use ten as decimal divisor
decout1:                               ; decimal division loop:
div cx                                 ; divide to get next lowest digit
add dx,byte '0'                        ; convert to ascii
push dx                                ; and save on the stack
zero dx                                ; recover high word for division
cmp ax,dx                              ; and check whether done dividing yet
jne decout1                            ; if not, loop back for more
mov ah,02h                             ; dos print-a-character function
decout2:                               ; decimal print loop:
pop dx                                 ; get a word from the stack
testzero dx                            ; run out of decimal digits yet?
je decout3                             ; if so, we're done
int 21h                                ; otherwise, print this digit
jmp short decout2                      ; and loop back for more
decout3:
ret

hex_word_out:                          ; PRINT VALUE IN .CX AS HEX :
mov si,0004h                           ; four digits
mov ah,02h                             ; dos print-a-character function
.l10:
rol cx,01h
rol cx,01h
rol cx,01h
rol cx,01h                             ; get next digit in low 4 bits of .cx
mov dl,cl
and dl,0fh                             ; next digit in .dl
cmp dl,0ah                             ; ten or more ?
jae .l15
add dl,'0'                             ; if not, make ascii '0' through '9'
jmp short .l20
.l15:
add dl,37h                             ; if so, make ascii 'A' through 'F'
.l20:
int 21h                                ; print digit
dec si                                 ; done four digits yet?
jne .l10                               ; nope, loop back
.quit:
ret                                    ; yup, exit

get_num:                               ; READ DEC. NUMBER FROM COMMAND LINE:
mov al,[si]                            ; examine first digit
call test_digit                        ; it is a digit, right?
jne get_num_err                        ; if not, exit with carry set
zero bx                                ; start with zero
get_num_loop:
lodsb                                  ; get digit from command line
sub al,'0'                             ; and convert to a value
mov cl,al                              ; save it in .cl
mov ch,00h                             ; as a word value
mov ax,bx                              ; get interim value
mov bx,000ah
mul bx                                 ; and multiply by ten
testzero dx                            ; if overflow on multiply,
jne get_num_err                        ; abort
add ax,cx                              ; add in value of most recent digit
jc get_num_err
mov bx,ax                              ; and save
mov al,[si]                            ; examine next character
call test_digit                        ; is it a decimal digit?
je get_num_loop                        ; if so, use it as well
mov ax,bx                              ; if not, done -- return value in .ax
clc                                    ; with carry clear
ret
get_num_err:                           ; overflow, or no number at all:
stc                                    ; exit with carry set
ret

force_uc:                              ; FORCE CHARACTER IN .AL TO UPPERCASE:
cmp al,'a'
jb .l0                                 ; lowercase letter?
cmp al,'z'                             ; if not, make no changes
ja .l0
and al,0dfh                            ; if so, force to uppercase
.l0:
ret

test_switch:                           ; IS CHAR IN .AL A SWITCH CHARACTER?
cmp al,'/'                             ; exit with zero-flag set if it is
je .l1
cmp al,'-'
.l1:
ret

test_space:                            ; IS CHARACTER IN .AL A SPACE OR TAB?
cmp al,SPC                             ; exit with zero-flag set if it is
je .l1
cmp al,09h
.l1:
ret

test_colon:                            ; IS CHAR. IN .AL A COLON OR EQUALS?
cmp al,':'                             ; exit with zero-flag set if it is
je .l0
cmp al,'='
.l0:
ret

test_digit:                            ; IS CHARACTER IN .AL A DECIMAL DIGIT?
cmp al,'0'                             ; exit with zero-flag set if it is
jb .l0
cmp al,'9'
ja .l0
cmp al,al
.l0:
ret

test_eol:                              ; IS CHARACTER IN .AL AN END-OF-LINE?
cmp al,CR
je .l0
cmp al,00h
.l0:
ret

clean_up_filespec:                     ; CANONICALIZE FILESPEC:
call fix_last_bs                       ; find final backslash
call must_have_drive                   ; supply drive letter if needed
call must_have_path                    ; supply pathname if needed
call never_ends_in_bs                  ; make sure filespec doesn't end in \
call doesnt_name_dir                   ; make sure it isn't a directory name
call dots_fix                          ; eliminate any . or .. entries
call add_star_maybe                    ; add .* if permitted in this context
call get_short_filespec                ; extract short filespec from long
ret

must_have_drive:                       ; MAKE SURE FILESPEC HAS A DRIVE:
cmp word [fnbuf],hilo ('\','\')        ; is this a unc filespec?
je .l2                                 ; if so, don't muck about with it
mov ax,[fnbuf]                         ; examine first two characters:
cmp ah,':'                             ; is the second a colon?
jne .l0                                ; if not, add drive letter
cmp al,'A'
jb .l0                                 ; is the first a letter?
cmp al,'Z'                             ; if not, add drive letter
ja .l0                                 ; a drive letter was specified:
cmp byte [fnbuf+2],00h                 ; was there anything after it?
je .l5                                 ; if not, add star-dot-star
ret                                    ; otherwise, exit with no change
.l0:
call find_null_fnbuf                   ; find the end of the filespec
mov si,di                              ; source for copy
add di,byte 02h                        ; and add 2 (destination)
cmp di,fnbuf + fn_max                  ; will this overflow fnbuf?
jae .l7                                ; if so, problem
.l1:
mov al,[si]                            ; copy a byte from source
dec si
mov [di],al                            ; to destination
dec di
cmp si,fnbuf                           ; done yet?
jae .l1                                ; no, continue
doscall 19h                            ; get current drive number
add al,'A'                             ; and convert to a letter
mov [fnbuf+0],al                       ; stash it in the filename buffer
mov byte [fnbuf+1],':'                 ; poke in a colon
cmp word [last_bs],byte 00h            ; if a backslash was found,
je .l2
add word [last_bs],byte 02h            ; add 2 to its location
.l2:
ret                                    ; and we're done
.l5:                                   ; only a drive letter found:
mov si,star_dot_star
mov di,fnbuf+2                         ; supply a star-dot-star
jmp copy_string                        ; and exit
.l7:                                   ; adding a drive would overflow fnbuf:
jmp error_fnbuf_over                   ; handle error

must_have_path:                        ; SUPPLY PATHNAME IF NEEDED:
cmp word [fnbuf],hilo ('\','\')        ; is this a unc filespec?
je .l4                                 ; if so, don't muck about with it
cmp byte [fnbuf+2],'\'                 ; did the user supply an abs. path?
je .l4                                 ; if so, exit without further ado
mov si,fnbuf+2h                        ; starting immediately after colon,
mov di,dta                             ; copy everything to temp buffer
call copy_string
mov word [fnbuf+2],hilo (00h,'\')      ; poke in initial backslash
mov dl,[fnbuf]                         ; get drive letter
sub dl,40h                             ; and convert to a number
mov si,fnbuf + 3h
doscall 47h                            ; get current directory name
call find_null_fnbuf                   ; find the end of the pathname
dec di
cmp byte [di],'\'                      ; does path already end in backslash?
je .l3
inc di
.l3:
mov byte [di],'\'                      ; terminate pathname
inc di
mov si,dta
call copy_string                       ; and copy remainder of filespec back
call fix_last_bs                       ; repair last_bs variable
.l4:
ret

never_ends_in_bs:                      ; FIX PATHNAMES ENDING IN BACKSLASH:
mov di,[last_bs]                       ; get address of final backslash
inc di                                 ; and examine the following char.
cmp byte [di],00h                      ; is it a null?
jne .quit                              ; if not, do nothing and exit
mov si,star_dot_star                   ; if so, tack on a star-dot-star
call copy_string                       ; after the backslash
cmp di,fnbuf + fn_max                  ; didn't overflow the buffer, did we?
ja .l2
.quit:
ret
.l2:
jmp error_fnbuf_over                   ; oops

doesnt_name_dir:                       ; MAKE SURE IT'S NOT A DIRECTORY NAME:
mov di,fnbuf - 0001h                   ; start at beginning of fnbuf
.l10:
inc di
mov al,[di]                            ; examine byte from buffer
cmp al,'?'                             ; found a wildcard?
je never_ends_in_bs.quit               ; if so, this is not the name of
cmp al,'*'                             ; a subdirectory, so just exit
je never_ends_in_bs.quit
cmp al,00h                             ; end of filespec?
jne .l10                               ; if not, loop back, keep checking
mov si,[last_bs]
inc si                                 ; period after the final backslash?
cmp byte [si],'.'                      ; if so, this is a directory name
je .l50                                ; so go handle it
mov cx,0016h
mov dx,fnbuf
doscall 4eh                            ; get directory info on item
jc never_ends_in_bs.quit               ; if any problem, just exit
test byte [dta_attr],attr_d            ; is item a subdirectory?
je never_ends_in_bs.quit               ; if not, just exit
.l50:
mov si,slash_star_dot_star
call copy_string
cmp di,fnbuf + fn_max
jbe never_ends_in_bs.quit
jmp error_fnbuf_over                   ; yes, apologize

dots_fix:                              ; LOOK FOR . OR .. ENTRIES:
mov si,fnbuf                           ; start at beginning of filespec
.l0:
mov ax,[si]                            ; look at two bytes at a time
inc si
cmp al,00h                             ; found the end of the filespec yet?
jne .l1
.l9:
jmp fix_last_bs                        ; if so, fix last_bs and exit
.l1:
cmp ax,hilo ('.','\')                  ; found a . entry?
jne .l0                                ; if not, keep looking
mov cx,0001h                           ; one dot found so far
.l2:
inc si                                 ; skip past that first dot
mov al,[si]                            ; examine the next character
cmp al,00h                             ; end of filespec?
je .l9                                 ; if so, exit
cmp al,'.'                             ; another dot?
jne .l3
inc cx                                 ; if so, count it
jmp short .l2                          ; and keep parsing
.l3:
cmp al,'\'                             ; another backslash?
jne .l0                                ; if not, ignore this (weird) entry
mov di,si                              ; point .di to backslash after dots
.l4:
dec di                                 ; and scan backwards through fnbuf
cmp di,fnbuf                           ; fell off the beginning of fnbuf?
jbe .l8                                ; if so error
cmp byte [di],'\'                      ; found a backslash?
jne .l4                                ; if not, keep searching backwards
loop .l4                               ; decrement dots count, continue
call copy_string                       ; copy string after dots down
jmp short dots_fix                     ; and loop back for more .\ entries
.l8:                                   ; too many dot entries:
bomb msg_err_dots_fix,15h              ; complain and exit with errorlevel 21

add_star_maybe:                        ; ADD .* IF PERMITTED IN THIS CONTEXT:
test byte [flags],fb_swe               ; allowed to add .* ?
jne .l8                                ; if not, exit without effect
test byte [flags],fb_list              ; list file name?  name from list?
jne .l8                                ; either case, exit without effect
mov cl,00h                             ; have not found dot yet
mov si,fnbuf                           ; start at beginning of filespec
.l1:
lodsb                                  ; get a character from filespec
cmp al,'\'                             ; backslash?
jne .l3
mov cl,00h                             ; if so, note dot not found yet
.l3:
cmp al,'.'                             ; dot?
jne .l4
mov cl,01h                             ; if so, note dot has been found
.l4:
cmp al,00h                             ; found end of filespec?
jne .l1                                ; if not, keep parsing
cmp cl,00h                             ; found a dot in the filespec?
jne .l8                                ; if so, exit with no effect
cmp si,fnbuf + fn_max - 0002h          ; have room to add the .* ?
ja .l9                                 ; if not, bomb out
dec si                                 ; point to the terminal null
mov word [si],hilo ('*','.')           ; add the .*
inc si
inc si
mov byte [si],00h                      ; and the terminal null
.l8:                                   ; normal exit
ret
.l9:                                   ; filespec buffer overflow:
jmp error_fnbuf_over                   ; bomb out

get_short_filespec:                    ; EXTRACT SHORT FILESPEC FROM LONG:
mov si,fnbuf + 2h                      ; copy entire filespec
cmp word [last_bs],byte 00h            ; or, if directory was specified,
je .l0
mov si,[last_bs]                       ; the filespec immediately following
inc si                                 ; the last backslash
.l0:
mov di,nambuf                          ; into the short name buffer
push ds
pop es
.l1:
lodsb                                  ; copy one character at a time
stosb                                  ; into the short name buffer
cmp al,00h                             ; until the terminal null is found
jne .l1                                ; then stop.
cmp di,nambuf + 0eh                    ; overflowed the short name buffer?
jae .l3
ret                                    ; no, bliss
.l3:                                   ; nambuf has overflowed:
bomb msg_err_nambuf_over,10h           ; complain and exit with errorlevel 16


alloc_tree_buffer:                     ; CREATE BUFFER FOR /S TREE IF NEEDED:
test byte [flags],fb_sws               ; /s specified?
je .l1                                 ; no, don't bother with tree buffer
mov bx,1000h                           ; yes, allocate 64k
doscall 48h                            ; for tree buffer
jnc .l0
jmp trs_80                             ; any problem, complain and abort
.l0:
mov [tree_seg],ax                      ; no problem, remember segment
mov es,ax
zero bx
mov [es:bx],bx                         ; and empty the tree buffer
.l1:
ret

alloc_file_buffer:                     ; CREATE BUFFER FOR FILE READS:
mov bx,0800h                           ; allocate thirty-two kilobytes
doscall 48h                            ; for file input buffer
jnc .l0
jmp trs_80                             ; any problem, complain and abort
.l0:
mov [file_seg],ax                      ; no problem, remember segment
ret                                    ; and exit

alloc_list_buffer:                     ; CREATE BUFFER FOR FILE LIST:
mov bx,0100h                           ; allocate four kilobytes
doscall 48h                            ; for list buffer
jnc .l0
jmp trs_80                             ; any problem, complain and abort
.l0:
mov [list_seg],ax                      ; no problem, remember segment
mov word [list_pnt],2000h              ; and note that the buffer is empty
ret

test_leap_year:                        ; SET CORRECT LENGTH FOR FEBRUARY:
cmp word [date3],byte 120              ; year 2100 (dos year 120) ?
je .l1                                 ; if so, not a leap year
test byte [date3],03h                  ; year divisible by 4 ?
je .l2                                 ; if so, it is a leap year
.l1:                                   ; not a leap year:
mov byte [months_table+1],28           ; february has 28 days
ret
.l2:                                   ; leap year:
mov byte [months_table+1],29           ; february has 29 days
ret

get_fn_from_list:                      ; READ FILESPEC FROM FILE LIST:
test byte [flags],fb_list              ; are we using a file list?
jne .l1
clc
ret                                    ; if not, simply exit with carry clear
.l1:
cmp word [auxhandle],byte 00h          ; is it open yet?
jne .l3                                ; if so, continue
mov dx,fnbuf
doscall 3d20h                          ; open file list file
jnc .l2
dosprint msg_err_listfile              ; problem:  print error message
zprint fnbuf                           ; and filename
stc                                    ; and exit with carry
ret
.l2:
mov [auxhandle],ax                     ; save file handle
mov word [list_pnt],2000h              ; and note that the buffer is empty
.l3:
mov di,fnbuf
mov byte [di],00h                      ; empty the filespec buffer
and byte [flags],0ffh ^ fb_quote       ; not between quotes
read_fn_loop:
call read_from_list                    ; get a character from the file list
cmp al,EOF                             ; end of file?
je read_fn_eof                         ; if so, deal with it
cmp al,SPC                             ; end of line?
jb read_fn_eol                         ; if so, deal with it
call test_space                        ; space?
je read_fn_sp                          ; if so, deal with it
cmp al,'"'                             ; quote mark?
je read_fn_qu                          ; if so, deal with it
cmp al,';'                             ; semicolon?
je read_fn_semi                        ; if so, deal with it
cmp al,':'                             ; colon?
je read_fn_semi                        ; if so, deal with it
call force_uc
cmp al,'/'                             ; slash?
jne read_fn_ch
mov al,'\'                             ; if so, convert to a backslash
read_fn_ch:                            ; got a legal character for filename:
mov ah,00h
mov [di],ax                            ; put it in the buffer
inc di
cmp di,fnbuf + fn_max                  ; blown past the end of the buffer?
jb read_fn_loop                        ; no, loop back for more
jmp read_fn_spam                       ; yes, deal with it
read_fn_eof:                           ; found end of list file:
mov bx,[auxhandle]
doscall 3eh                            ; close the list file
mov word [auxhandle],0000h             ; and mark it closed
and byte [flags],0ffh ^ fb_list        ; no more file list!
cmp byte [fnbuf],00h                   ; was a filename retrieved before eof?
je .l1
clc                                    ; yes, exit with carry clear
ret
.l1:
stc                                    ; no, exit with carry set
ret
read_fn_sp:                            ; found a space:
test byte [flags],fb_quote             ; between quotes?
jne read_fn_ch                         ; if so, treat like any other char
read_fn_eol:                           ; found end of line:
cmp byte [fnbuf],00h                   ; anything in the buffer yet?
je read_fn_loop                        ; if not, keep looking
call clean_up_filespec                 ; clean it up
clc
ret                                    ; and exit
read_fn_qu:                            ; found a quote:
test byte [flags],fb_quote             ; was there an open quote?
jne read_fn_eol                        ; if so, it ends the filespec
cmp byte [fnbuf],00h                   ; anything in the buffer yet?
jne read_fn_ch                         ; if so, treat like any other char
or byte [flags],fb_quote               ; otherwise, this is an open quote
jmp short read_fn_loop                 ; keep reading
read_fn_semi:                          ; found a semicolon:
test byte [flags],fb_quote             ; between quotes?
jne read_fn_ch                         ; if so, treat like any other char
cmp byte [fnbuf],00h                   ; anything in the buffer yet?
jne read_fn_ch                         ; if so treat like any other char
cmp al,':'                             ; was comment character a colon?
je read_fn_notice                      ; if so, this is a printable 'notice'
read_fn_remark:                        ; NONPRINTABLE COMMENT IN FILE LIST:
call read_from_list                    ; get a character from the file list
cmp al,EOF                             ; end of file?
je read_fn_eof                         ; if so, deal with it
cmp al,SPC                             ; found the end of the remark?
jae read_fn_remark                     ; if not, keep looking
jmp read_fn_loop                       ; otherwise, resume hunt for filespec
read_fn_notice:                        ; PRINTABLE NOTICE IN FILE LIST:
dosprint msg_notice                    ; introduce it
.l0:
call read_from_list                    ; get a character from the file list
cmp al,EOF                             ; end of file?
je .l2                                 ; if so, deal with it
cmp al,SPC                             ; found the end of the notice?
jae .l1
call crlf                              ; if so, terminate the output line
jmp read_fn_loop                       ; and go back to the filespec search
.l1:
mov dl,al                              ; otherwise, this is a printable char
doscall 02h                            ; print it
jmp short .l0                          ; and continue scanning through notice
.l2:                                   ; end-of-file within notice:
call crlf                              ; terminate the output line
jmp read_fn_eof                        ; and the input file

read_fn_spam:                          ; overflowed the working buffer:
mov byte [fnbuf],00h                   ; empty the working buffer
dosprint msg_err_list_spam             ; print an error message
jmp read_fn_eof                        ; and kill the current file list

read_from_list:                        ; GET CHARACTER FROM FILE LIST FILE:
mov ax,[list_pnt]
cmp ax,1000h                           ; need to refill the buffer?
jb read_list                           ; nope, skip ahead
mov cx,1000h                           ; read four kilobytes
mov bx,[auxhandle]                     ; from the file list
zero dx                                ; to the start
mov ds,[list_seg]                      ; of the list buffer
doscall 3fh
push cs
pop ds                                 ; restore data segment
jnc .l3                                ; if any problem,
bomb msg_err_read_list,13h             ; complain and exit with errorlevel 19
.l3:
mov word [list_pnt],0000h              ; move pointer back to start of buffer
cmp ax,1000h                           ; got four kilobytes?
je read_list                           ; cool!
testzero ax                            ; got anything at all?
jne .l4
mov al,EOF                             ; if not, return end-of-file
ret
.l4:
mov si,ax                              ; got less than four kilobytes:
mov es,[list_seg]                      ; poke in an eof
mov byte [es:si],EOF                   ; just to be on the safe side
read_list:                             ; get buffered char from file list:
mov es,[list_seg]                      ; segment of file list buffer
mov si,[list_pnt]                      ; pointer into list buffer
mov al,[es:si]                         ; get character from buffer
inc si
mov [list_pnt],si                      ; and increment the pointer
push ds
pop es                                 ; fix data segment
ret                                    ; and exit

find_null_fnbuf:                       ; FIND END OF FILESPEC:
mov di,fnbuf                           ; fall through to:

find_null:                             ; FIND END OF ASCIIZ STRING:
cmp byte [di],00h                      ; found null yet?
je fix_last_bs.quit                    ; yes, exit
inc di                                 ; no, keep searching
jmp short find_null

fix_last_bs:                           ; REPAIR LAST_BS VARIABLE:
mov word [last_bs],0000h               ; note no backslashes found yet
mov si,fnbuf                           ; point to start of filespec buffer
.l0:
mov al,[si]                            ; look at character
cmp al,00h                             ; terminal null?
je .l2                                 ; if so, exit
cmp al,'\'                             ; backslash?
jne .l1
mov [last_bs],si                       ; if so, save its address
.l1:
inc si                                 ; and keep on going
jmp short .l0
.l2:                                   ; found the terminal null
cmp si,fnbuf + fn_max                  ; have we wandered off the edge?
jae .l4                                ; if so, problem
.quit:
ret
.l4:                                   ; spammed fnbuf:
jmp error_fnbuf_over                   ; abort

flush_key_buffer:                      ; EMPTY KEYBOARD BUFFER:
mov ah,01h
int 16h                                ; check keyboard buffer
je check_output.l10                    ; exit if empty
mov ah,00h                             ; otherwise,
int 16h                                ; get a keystroke from buffer
jmp short flush_key_buffer             ; and loop back

check_output:                          ; decide whether output is to console
mov bx,0001h                           ; standard-output handle
doscall 4400h                          ; get info on handle
jc .l10
and dl,82h                             ; examine console and device bits
cmp dl,82h                             ; output to the console device?
jne .l10
or byte [flags],fb_cons                ; note that output is to console
.l10:
ret

get_country_info:                      ; time and date formats, etcetera
mov dx,country
doscall 3800h                          ; get current country info
ret                                    ; and exit

make_crc32_table:                      ; CREATE TABLE OF CRC32 VALUES:
zero bx                                ; bx holds index into the table
zero di
.l10:
mov ax,bx                              ; set value equal to index
zero dx                                ; as a 32-bit quantity
mov cx,0008h                           ; and repeat eight times:
.l20:
shr dx,1h
rcr ax,1h                              ; rotate the crc value right one bit
jnc .l30                               ; and if lsb was not set,
xor dx,0edb8h
xor ax,08320h                          ; xor in a magic number
.l30:
loop .l20                              ; repeat eight times
mov [table_lo+di],ax
mov [table_hi+di],dx                   ; save crc32 value in table
inc di
inc di
inc bx                                 ; next index
cmp bx,0100h                           ; done yet?
jb .l10                                ; no, party on wayne
ret                                    ; yes, exit

show_summary:                          ; SHOW FINAL SUMMARY INFO :
call crlf                              ; blank line
dosprint msg_files_done                ; 'files processed:  '
mov dx,[files_hi]
mov ax,[files_lo]
call dec_print_big                     ; print number of files completed
dosprint msg_total_sizes               ; 'total size:  '
mov dx,[sizes_hi]
mov ax,[sizes_lo]
call dec_print_big                     ; print total of file sizes
dosprint msg_bytes                     ; and 'bytes' message
mov al,[flags]
and al,fb_cons | fb_pause
cmp al,fb_cons
je .l10
jmp dont_show_time
.l10:
call read_timer                        ; get current jiffy count in dx:ax
sub ax,[timer_lo]
sbb dx,[timer_hi]                      ; and subtract the starting time
mov [timer_lo],ax
mov [timer_hi],dx                      ; save elapsed time
dosprint msg_time                      ; print 'time' message
mov ax,[timer_lo]
mov bx,10                              ; multiply low word of elapsed time
mul bx                                 ; by ten
mov [timer_lo],ax                      ; and save it
mov cx,dx                              ; save overflow
mov ax,[timer_hi]                      ; multiply high word of elapsed time
mul bx                                 ; by ten
add ax,cx                              ; and add in overflow from low word
mov [timer_hi],ax                      ; save high word of elapsed time
mov bx,182  
zero dx                                ; divide high word of elapsed time
div bx                                 ; by 182
mov [timer_hi],ax                      ; save new high word
mov ax,[timer_lo]                      ; divide low word of elapsed time
div bx                                 ; by 182
mov [timer_lo],ax                      ; now we have elapsed time in seconds
push dx                                ; save the remainder (182th seconds)
mov ax,[timer_hi]                      ; divide elapsed seconds
mov bx,60                              ; by sixty
zero dx
div bx
mov [timer_hi],ax
mov ax,[timer_lo]
div bx
mov [timer_lo],ax                      ; save elapsed minutes in timer var.
push dx                                ; push remaining seconds onto stack
mov dx,[timer_hi]
mov ax,[timer_lo]
call dec_print_big                     ; print elapsed minutes
mov dl,[country_tsep]                  ; print country separator character
doscall 02h                            ; (colon in u.s.)
pop ax                                 ; get remaining seconds
call time_print                        ; print seconds as two digits
mov dl,[country_deci]                  ; print decimal separator character
doscall 02h                            ; (period in u.s.)
pop ax                                 ; get fractional seconds
mov bl,100
mul bl                                 ; multiply by one hundred
mov bl,182
div bl                                 ; then divide by 182
mov ah,00h                             ; to get 1/100th seconds
call time_print                        ; print fractional seconds
dont_show_time:
call crlf                              ; end of first summary line
dosprint msg_master
mov cx,[master_hi]
call hex_word_out                      ; display high word of master crc32
mov cx,[master_lo]
call hex_word_out                      ; display low  word of master crc32
dosprint msg_info_space
mov cx,[master_xdir]
call hex_word_out                      ; display master xdir checksum
call crlf                              ; end of second summary line
mov ax,[fails_hi]
or ax,[fails_lo]                       ; were there any failures ?
je .l50                                ; if not, don't display fails count
dosprint msg_files_not_done            ; 'could not read:  '
mov dx,[fails_hi]
mov ax,[fails_lo]
call dec_print_big                     ; print number of failed files
dosprint msg_last_failure              ; 'last error:  '
zprint problem_name                    ; name of last unreadable file
.l50:
ret                                    ; done with final summary

append_found_filespec:                 ; ADD FOUND FILESPEC AFTER PATHNAME:
mov di,[last_bs]                       ; destination is
inc di                                 ; character following final backslash
mov si,dta_name                        ; source is filename in dta
call copy_string                       ; copy found filename into fnbuf
cmp di,fnbuf + fn_max                  ; fnbuf overflow?
ja error_fnbuf_over                    ; if so, handle it
ret                                    ; else exit

append_short_filespec:                 ; ADD USER FILESPEC AFTER PATHNAME:
mov di,[last_bs]                       ; destination is
inc di                                 ; character following final backslash
mov si,nambuf                          ; source is short filespec buffer
call copy_string                       ; copy found filename into fnbuf
cmp di,fnbuf + fn_max                  ; fnbuf overflow?
ja error_fnbuf_over                    ; if so, handle it
ret                                    ; else exit

error_fnbuf_over:                      ; fnbuf has overflowed:
bomb msg_err_fnbuf_over,14h            ; complain and exit with errorlevel 20

copy_string:                           ; COPY ASCIIZ STRING [SI] TO [DI]:
push ds                                ; make .es equal to .ds
pop es                                 ; and fall through ....

copy_string_far:                       ; COPY ASCIIZ STRING [SI] TO [ES:DI]:
lodsb                                  ; get a character from [ds:si]
stosb                                  ; put it in [es:di]
cmp al,00h                             ; until the final null is found
jne copy_string_far
ret                                    ; then quit

find_es_zz:                            ; FIND TERMINAL DOUBLE-NULL:
zero si                                ; start at beginning of tree buffer
cmp word [es:si],byte 00h              ; is the tree buffer empty?
je .l2                                 ; if so, return zero in .si
.l0:                                   ; scan forward through tree buffer:
cmp word [es:si],byte 00h              ; found the double null null yet?
je .l1
inc si                                 ; if not, increment pointer
jmp short .l0                          ; and keep looking
.l1:                                   ; found the double null:
inc si                                 ; return offset of _second_ null
.l2:
ret                                    ; exit

read_timer:                            ; RETURN CURRENT TIME IN DX:AX
push es
mov ax,0040h                           ; look in bios data segment
mov es,ax
cli                                    ; with interrupts off
mov ax,[es:006ch]                      ; grab jiffy count low
mov dx,[es:006eh]                      ; and high words
sti                                    ; irq's are okay again
pop es                                 ; restore old .es
ret                                    ; and exit

zprint1:                               ; PRINT ASCIIZ STRING VIA .DI:
mov ah,02h                             ; dos print-a-character function
.l0:
mov dl,[di]                            ; get a byte from string
inc di
cmp dl,00h                             ; found the final null?
je .l1                                 ; if so, deal with it
int 21h                                ; otherwise, print the character
jmp short .l0                          ; and loop back for more abuse
.l1:                                   ; found the final null:

crlf:                                  ; END OF PRINT LINE :
dosprint msg_crlf                      ; print a carriage return, line feed
test byte [flags],fb_cons              ; was output redirected?
je .l25                                ; if so, skip control and alt tests
push es
mov ax,0040h                           ; bios data segment
mov es,ax
test byte [es:0017h],04h               ; is control key down?
je .l20                                ; if not, don't do delay
.l15:                                  ; slow scrolling :
test byte [es:006ch],01h               ; wait for an even jiffy
jne .l15
.l17:
test byte [es:006ch],01h               ; then wait for an odd jiffy
je .l17
or byte [flags],fb_pause               ; note that a pause has occurred
.l20:
cmp byte [line],00h                    ; continuous scrolling?
jne .l22                               ; if not, skip alt-key test
test byte [es:0017h],08h               ; is alt key down?
je .l22                                ; if not, don't interrupt scroll
call flush_key_buffer                  ; pause request!  empty key buffer
mov byte [line],01h                    ; and note that next line should pause
cmp byte [screen_lines],00h
jne .l22                               ; if number of screen lines not set,
mov al,[vga_lines]
mov [screen_lines],al                  ; set screen lines to 23
.l22:
pop es
.l25:
cmp byte [line],00h                    ; paging output?
je pause_maybe.quit                    ; if not, just exit
                                       ; if so, fall through to....

pause_maybe:                           ; CHECK WHETHER PAUSE NEEDED :
dec byte [line]                        ; decrement line count
jne .quit                              ; hit zero yet?  if not, just exit
dosprint msg_pause                     ; time for a pause -- announce it
or byte [flags],fb_pause               ; note that a pause has occurred
call flush_key_buffer                  ; empty keyboard buffer
.l1:
mov ah,00h
int 16h                                ; get a keystroke
call force_uc                          ; and force it to uppercase
call unpause                           ; erase pause message
cmp al,CR                              ; enter?
je pause_cr                            ; if so, deal with it (scroll line)
cmp al,'/'                             ; slash?
je pause_slash                         ; if so, deal with it (scroll half)
cmp al,'C'                             ; C ?
je pause_c                             ; if so, deal with it (continuous)
cmp al,1bh                             ; escape ?
je pause_c                             ; if so, deal with it (continuous)
cmp al,03h
je pause_brk
mov al,[screen_lines]                  ; otherwise, move scroll value
mov [line],al                          ; into line count
.quit:
ret                                    ; and exit
pause_cr:                              ; scroll line:
inc byte [line]                        ; set line count to one
ret                                    ; and exit
pause_slash:                           ; scroll half:
mov al,[screen_lines]                  ; get normal scroll value
shr al,01h                             ; divide by two
inc al                                 ; and add one
mov [line],al                          ; save new line count
ret                                    ; and exit
pause_c:                               ; continuous:
mov byte [line],00h                    ; set for no paging
ret                                    ; and exit
pause_brk:
dosprint msg_brk
doscall 4c03h


unpause:                               ; ERASE PAUSE MESSAGE FROM SCREEN:
push ax                                ; save .ax
mov ah,02h                             ; dos print-a-character function
mov dl,CR                              ; carriage return
int 21h                                ; move cursor to start of line
mov dl,SPC                             ; ascii space
mov cx,79                              ; 79 repetitions:
.l0:
int 21h                                ; print a space
loop .l0                               ; over and over again
mov dl,CR                              ; then another carriage return
int 21h                                ; move cursor to start of line
pop ax                                 ; restore previous .ax value
ret                                    ; and exit

bombs_away:                            ; HANDLE VARIOUS ERRORS:
call error_out                         ; prepare to display error message
dosprint msg_error                     ; print start of error message
pop di
%ifdef DEBUG_INLINE
inc di
inc di
%endif
mov dx,[di]                            ; get pointer to error message
doscall 09h                            ; print error message
mov al,[di+02h]                        ; get errorlevel
doscall 4ch                            ; and exit program
int 20h

error_out:                             ; FORCE STDOUT TO STDERR:
mov cx,0001h                           ; force stdout
mov bx,0002h                           ; to stderr
doscall 46h
mov byte [line],00h                    ; and disable paging
ret

fix_paging:                            ; CHECK FOR OUTPUT REDIRECTION:
test byte [flags],fb_cons              ; output to the console?
jne .l0
mov byte [screen_lines],00h            ; if not, disable paging
.l0:
mov al,[screen_lines]                  ; use paging value
mov [line],al                          ; to initialize lines count
ret                                    ; and exit

get_vga_lines:                         ; FIGURE DEFAULT SCROLL LENGTH
push cs
pop es                                 ; point es:di
mov di,dta                             ; to temporary buffer
mov ax,1b00h                           ; vga call:
zero bx
int 10h                                ; get state information
cmp al,1bh                             ; was call successful?
jne .l2                                ; if not, done with paging setup
mov al,[dta+22h]                       ; get number of lines
sub al,02h                             ; and subtract 2
mov [vga_lines],al                     ; save as number of lines to scroll
.l2:
ret

hook_int_24:                           ; DISABLE CRITICAL-ERROR HANDLING
test byte [flags],fb_swh               ; was /h specified?
jne .l1                                ; if so, do not hook int 24
mov dx,new_int_24                      ; get address of replacement handler
doscall 2524h                          ; and hook int 24
.l1:
ret

new_int_24:                            ; REPLACEMENT INT 24 HANDLER
mov al,03h                             ; always fail
iret


msg_markver:                           ; for mark aitchison's version utility
db 'VeRsIoN=1.04a',00h
db 'CoPyRiGhT=Copyright 1997-2000, Charles Dye',00h

msg_syntax:
db CR,LF
db 'CHKSUM.COM   v1.04a   04-24-2000   C. Dye   raster@highfiber.com',CR,LF
db 'GPL Freeware.  Copyright 1997-2000, Charles Dye.  No warranty!',CR,LF
db LF
db 'Computes checksums for specified files.',CR,LF
db LF
db 'Syntax:  CHKSUM  [filespecs] [switches]',CR,LF
db '         /S  recurse into subdirectories',CR,LF
db '         /M  page output',CR,LF
db '         /H  do not hook critical errors',CR,LF
db LF
db 'If you specify both filespecs and switches, separate them with spaces.',CR,LF
db 'If you do not specify any filespecs, a default of *.* is used.  Filespecs',CR,LF
db 'may include DR DOS-style file lists.',CR,LF
db LF
db 'This program may be freely distributed under the terms of the Free',CR,LF
db "Software Foundation's GNU General Public License, version 2; or, at",CR,LF
db 'your option, any later version of that License.  See the file COPYING',CR,LF
db 'for details.'

msg_crlf:
db CR,LF,'$'

switches:
db 'SMPEHF',00h

switch_routines:
dw switch_s, switch_m, switch_m, switch_e, switch_h, switch_f


months_table:                          ; number of days in each month
db 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31

dow_names:
db 'Sun$Mon$Tue$Wed$Thu$Fri$Sat$---$'

msg_error:
db CR,LF,'Error:  $'

msg_err_dos_bad:
db 'Requires DOS version 3 or better!',CR,LF,'$'

msg_trs_80:
db 'Not enough memory!',CR,LF,'$'

msg_err_fn_ovf:
db 'Filespec too long!',CR,LF,'$'

msg_err_in_filespec:
db 'Empty filespec!',CR,LF,'$'

msg_err_specs_galore:
db 'More than 31 filespecs on command line!',CR,LF,'$'

msg_err_dots_fix:
db 'Resolving dots in directory name!',CR,LF,'$'

msg_err_listfile:
db 'Unable to open file list:  $'

msg_err_read_list:
db 'Problem reading from file list!$'

msg_err_fnbuf_over:
db 'Spammed working buffer!',CR,LF,'$'

msg_tree_buffer_over:
db 'Tree buffer overflow!  Too many subdirectories.',CR,LF,'$'

msg_err_list_spam:
db 'Filespec too long in file list!  Closing file list.',CR,LF,'$'

msg_err_nambuf_over:
db 'Filename longer than 12 characters!',CR,LF,'$'

msg_err_sw_m:
db CR,LF
db 'CHKSUM /M:x  -- select lines per page (More)',CR,LF,LF
db 'Sets the number of lines to print to the screen before pausing.',CR,LF
db 'Use 0 to disable screen pausing.  If x is not specified, the default',CR,LF
db 'is 23.',CR,LF
db '$'

msg_err_sw_f:
db CR,LF
db 'CHKSUM /F:x  -- select date format for display',CR,LF,LF
db '   /F:U  United States format:  MM-DD-YYYY',CR,LF
db '   /F:E  European date format:  DD-MM-YYYY',CR,LF
db '   /F:J  Japanese date format:  YYYY-MM-DD',CR,LF
db LF
db 'If no /F:x is specified, the default will be the local date format',CR,LF
db 'set by any COUNTRY= statement in CONFIG.SYS.',CR,LF
db '$'


msg_notice:
db 'Notice:  $'

attrib_values:
db attr_a,attr_s,attr_h,attr_r

msg_info_space3:
db SPC

msg_info_space:
db '  $'

attr1:
db 'ASHR'

msg_bytes:
db ' bytes$'

msg_read_err:
db '--------  $'

msg_master:
db 'Master total:  $'

msg_files_done:
db 'Files processed:  $'

msg_total_sizes:
db '    Total size:  $'

msg_time:
db '    Time:  $'

msg_files_not_done:
db 'Could not read:  $'

msg_last_failure:
db '    Last error:  $'

msg_brk:
db '^C',CR,LF,'$'

msg_pause:
db '--- MORE ---   <space> page, <enter> line, </> half page, <C> continuous $'

msg_baton:
db '-\|/'

slash_star_dot_star:
db '\*.*',00h

star_dot_star  equ  slash_star_dot_star + 0001h


; -------------------------------------- BYTE LENGTH VARIABLES :

flags:
db 00h

; Values for manipulating the Flags byte :

fb_swe    equ  80h                     ; never add .*                    /E
fb_swh    equ  40h                     ; do not hook int 24              /H
fb_cons   equ  20h                     ; output is to the console
fb_pause  equ  10h                     ; output was paused at least once
fb_sws    equ  08h                     ; recurse into subdirectories     /S
fb_list   equ  04h                     ; use file list            @filename
fb_shown  equ  02h                     ; current directory has been shown
fb_quote  equ  01h                     ; parsing between quotes


vga_lines:                             ; default number of lines to scroll
db 17h

screen_lines:                          ; lines to print between pauses
db 00h

line:                                  ; lines remaining before next pause
db 00h


align 2 ; ------------------------------ WORD LENGTH VARIABLES :

files_lo:                              ; number of files processed
dw 0000h
files_hi:
dw 0000h

fails_lo:                              ; number of files not processed
dw 0000h
fails_hi:
dw 0000h

sizes_lo:                              ; total of sizes of files processed
dw 0000h
sizes_hi:
dw 0000h

handle:                                ; handle for reading files
dw 0000h

auxhandle:                             ; handle for file list
dw 0000h

last_bs:                               ; offset of final backslash in fnbuf
dw 0000h

tree_seg:                              ; segment of tree buffer
dw 0000h

file_seg:                              ; segment of file buffer
dw 0000h

list_seg:                              ; segment of file list buffer
dw 0000h

list_pnt:                              ; pointer into file list buffer
dw 0000h

pointer_pointer:                       ; pointer into list of filespec
dw 0000h                               ; pointers

master_lo:
dw 0000h
master_hi:
dw 0000h
master_xdir:
dw 0000h


; -------------------------------------- UNINITIALIZED DATA AREA :

filespec_pointers:                               ; room for 32 pointers
                                                 ; (31 valid plus final null)

dta       equ  filespec_pointers + 0040h         ; disk transfer area:
dta_attr  equ  dta + 0015h                       ; attribute of found file
dta_time  equ  dta + 0016h                       ; time stamp of found file
dta_date  equ  dta + 0018h                       ; date stamp of found file
dta_sizl  equ  dta + 001ah                       ; low  word of file size
dta_sizh  equ  dta + 001ch                       ; high word of file size
dta_name  equ  dta + 001eh                       ; name of found file


dta_offset   equ  (dta - $$ + 0100h)

crc32_table  equ  (dta_offset * 10h + 0fh) / 10h + 0040h
table_lo     equ  crc32_table
table_hi     equ  crc32_table + 0200h

fnbuf           equ  crc32_table + 0400h         ; working filename buffer
problem_name    equ  fnbuf + fn_max              ; last file with read error
last_dir_shown  equ  problem_name + fn_max       ; last directory-name buffer
nambuf          equ  last_dir_shown + fn_max     ; short filename buffer

stack_start  equ  nambuf + 000eh                 ; stack
stack_end    equ  stack_start + 0800h            ; stack is about 2k long

;
;   Errorlevel Returns:
;
;   0    happiness
;   16   general syntax
;   17   not enough memory
;   18   bad dos
;   19   error reading from file list
;   20   filename buffer overflow
;   21   error resolving dots
;   22   tree buffer overflow
;
;
;   Version Log:
;
;   1.00   07-09-1997
;          First release.  Supports /S /M /P and /E.
;
;   1.01   07-31-1997    5,230 bytes                           EE3180C4  61FD
;          Hooks INT 24 to disable critical-error handling.  /H prevents
;          this.
;
;   1.02   10-06-1997    5,502 bytes                           131A3013  AA81
;          The same directory name will not be displayed twice in a row,
;          making multiple filespecs in the same directory easier to read.
;   If read errors occur, the filename of the last unreadable file will be
;   displayed.
;
;   1.03   05-23-1999    5,688 bytes                           746AC619  D292
;          Name changed to CHKSUM (was CC.)  License changed to GPL.  Now
;          compatible with 8086/8088 systems.  Added support for DR DOS XDIR
;   checksums.  Changes for FreeDOS:  null now terminates the command line,
;   like CR; added strings for VERSION.EXE.  Display changes:  time is always
;   shown in 24-hour format; file sizes up to 2GB are justified; new /F:x
;   switch to select date display format.  Changes to scrolling:  Control key
;   slows scrolling; Alt key interrupts; Esc is now ignored; Control-C while
;   paused now exits the program.  Better method of checking for subdirectory
;   names.  General code bumming:  filename buffers and other uninitialized
;   data areas moved to the end; error handler with inline arguments, etc.
;
;   1.04   07-26-1999    5,700 bytes                           95028062  9DF9
;          Rewritten for NASM.  Added 'master checksums' for all files
;          processed.  The 16-bit master checksum is compatible with XDIR's;
;   the 32-bit master checksum is not compatible with anything at all.  Both
;   are unaffected by the order of files.  Also, leading zeroes are no longer
;   suppressed in the hours value.
;
;   1.04a  04-24-2000    5,696 bytes                           E248E220  9C30
;          Filespec buffers expanded to 260 bytes to handle the super-long
;          pathnames permitted by Windows 95/98.

