/*********************************************************************/
/*                                                                   */
/*  This Program Written by Paul Edwards.                            */
/*  Released to the Public Domain                                    */
/*                                                                   */
/*********************************************************************/
/*********************************************************************/
/*                                                                   */
/*  crcfile.c - calculate the various CRC's for a file               */
/*                                                                   */
/*********************************************************************/

#include <stdio.h>
#include <stdlib.h>

#include "crc32.h"
#include "crcxm.h"
#include "crc16.h"
#include "crcit.h"

int main(int argc, char **argv)
{
  CRC32 crc32;
  CRCXM crcxm;
  CRC16 crc16;
  CRCIT crcit;
  FILE *fp;
  int c;

  if (argc < 2)
  {
      printf("usage: crcfile <filename>\n");
      return (EXIT_FAILURE);
  }
  crc32Init(&crc32);
  crcxmInit(&crcxm);
  crc16Init(&crc16);
  crcitInit(&crcit);
  fp = fopen(*(argv+1), "rb");
  if (fp == NULL)
  {
      printf("failed to open file %s\n", *(argv+1));
      return (EXIT_FAILURE);
  }
  while ((c = fgetc(fp)) != EOF)
  {
      crc32Update(&crc32, c); 
      crcxmUpdate(&crcxm, c); 
      crc16Update(&crc16, c); 
      crcitUpdate(&crcit, c); 
  }
  fclose(fp);
  printf("crc32 is 0x%.8lx\n", crc32Value(&crc32));
  printf("crcxm is 0x%.4x\n", crcxmValue(&crcxm));
  printf("crc16 is 0x%.4x\n", crc16Value(&crc16));
  printf("crcit is 0x%.4x\n", crcitValue(&crcit));
  return (0);
}
