/********************************************************************************
 * program:     wp2latex                                                        *
 * function:    convert WordPerfect 1.x,2.x,3.x,4.x,5.x and 6.x files into LaTeX*
 * modul:       wp2latex.cc                                                     *
 * description: The main program that communicates with OS.                     *
 * licency:     GPL		                                                *
 ********************************************************************************/

///To do list:///
// u minipage se musi nacist vertical position a v pripade full nastavit \vsize
// podivat se na pismo wsuipa
// sjednotit LineSpacing pro vsechny verze WP
// vnorene dokumenty
// udelat titulni stranku i pro WP6.x
// pokusit se zkonvertovat invisible characters
// nechodi center tab a right tab
// konverze prikazu alignr, alignl, alignc v matematickem modu
// reagovat na systemovou promennou NOCLOBBER
// List of authotrities neni dodelan

#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <math.h>

//Non standard include files
#include <common.h>
#include <strings.h>
#include <lists.h>
#include "wp2latex.h"


#if defined(__UNIX__)||defined(__DJGPP__)
 #include <unistd.h>
 #include <signal.h>
#endif

#ifdef _MSC_VER
 #include <locale.h>
#endif


//#include <alloc.h>

void Sys_Variable(void);
WORD CheckSum(char *PassWord);

extern FILE *wpd, *table;
extern FILE *strip, *logg, *err;
extern FILE *latex;
extern string force, FORCE;


extern string wpd_filename, strip_filename, table_filename, latex_filename,
       log_filename;
extern string wpd_password;

extern list ImgInputDirs;

#ifdef _has_MemStreams
extern int UseMemStream;
#endif


//Definition of methods of the Percentor class - only integer arithmetic due to the speed problems
void Percentor::Actualise(long NewValue)
{
  NewValue-=StartValue;
  NewValue>>=Shift;
  NewValue = (100*NewValue)/Range;

  if(NewValue!=CurrentPercent)
	{
	CurrentPercent=NewValue;
	Show();
	}
		
}


void Percentor::Hide(void)
{
 if(displayed) printf("\b\b\b\b");
 displayed=false;
 CurrentPercent=-1;
}


void Percentor::Init(long Start, long End, const char *text)
{
 StartValue=Start;
 EndValue=End;
 if(Start==End) Range=1;
	   else Range=End-Start;
 Shift=0;
 while(Range>=512) 	   
    {
    Shift++;
    Range>>=1;
    //printf("R=%ld\n",Range);
    }
 if (Verbosing >= 1)
	{
	if(text) printf(text);
	printf(_("\nConverting-percentage: "));
	}
}


Percentor::Percentor(void)
{
 Range=100;
 Shift=0;
 displayed=false;
 CurrentPercent=-1;
}


Percentor::~Percentor(void)
{
 return;
}


void Percentor::SetPercent(int NewPercent)
{
 if(NewPercent==CurrentPercent && displayed) return;
 CurrentPercent=NewPercent;
 Show();
}


void Percentor::Show(void)
{
 printf(displayed?"\b\b\b\b%3d%%":"%3d%%",CurrentPercent);
 fflush(stdout);
 displayed=true;
}


/*This function reads string from standard input*/
void StrGets(string & s)
{
char c;

  c=0;
  s="";
  while(c!='\n')
      {
      c=fgetc(stdin);
      switch(c)
	 {
	 case '\n':break;
	 default:s+=c;
	 }
      }
}


/*This procedure displays errors that occured inside atoms unit*/
#ifdef ERROR_HANDLER
void RaiseError(int ErrNo,void *Instance)
{
static int LastErrNo=0;
static void *LastInstance=NULL;
const char *UnitName="";
  if(Verbosing<=-1) return;
  if(LastErrNo!=ErrNo || LastInstance!=Instance)
    {
    if((ErrNo&0xFF00)==ListsId) UnitName=" Lists";
    if((ErrNo&0xFF00)==StringsId) UnitName=" Strings";
    fprintf(err,_("\nERROR: Internal inside ATOMS unit%s 0x%X object:(%p)"),
	UnitName,ErrNo,Instance);
    LastErrNo=ErrNo;LastInstance=Instance;
    }
}
#endif


/*This function handles error situation*/
void RunError(int ExitCode, const char *s, const void *arg)
{
  putchar('\n');
  switch (ExitCode)
    {
    case -2:
    case -1:   ExitCode=0;	/*silently exit program*/
	       break;
    case 0:    fprintf(err,_("Conversion completed.\n\n"));
	       break;
    case 0x2:  fprintf(err,_("Error: File %s not found.\n"),chk(s));
	       break;
    case 0x3:  fprintf(err,_("Error: Path not found.\n"));
	       break;
    case 0x6:  fprintf(err,_("Error: Temporary file %s cannot be created!\n"),s);
	       break;
    case 0x10: fprintf(err,_("Info: Program was aborted.\n"));
	       break;
    case 0x15: fprintf(err,_("Info: Please report this situation to enable further developping WP2LaTeX.\n%s"),chk(s));
	       break;
    case 0x20: fprintf(err,_("Error: Output device is full.\n"));
    	       break;           
    case 0x8B: fprintf(err,_("Fatal: Program Error. Write full bug report.\n"));
               break;           
    case 0x200:fprintf(err,_("Error: No filename entered!\n"));
               break;
    case 0x201:fprintf(err,_("Error: File \"%s\" is not a WordPerfect document!\n"),wpd_filename());
	       break;
    case 0x202:fprintf(err,_("\nError: Unsupported format "));
	       if(arg)
		 {
		 const FFormatDetect *FFD = (const FFormatDetect *)arg;
		 fprintf(err,"(%s",FFD->DocumentType);
		 if(FFD->DocVersion!=0)
		   fprintf(err," r%d.%d",FFD->DocVersion>>8,FFD->DocVersion & 0xFF);
		 fprintf(err,")");
		 }
	       fprintf(err,"!\n");
	       break;
    case 0x203:fprintf(err,_("Error: Sorry, I have no idea how to decrypt this file!\n"));
	       break;
    case 0x204:fprintf(err,_("Fatal: Memory exhausted!\n"));
	       break;
    }


  if (wpd != NULL)   fclose(wpd);     	  wpd = NULL;
  if (strip != NULL)
  	{
	fclose(strip);			  strip = NULL;
#ifndef DEBUG
	if(EraseStrip) unlink(strip_filename);
#endif
	}
  if (table != NULL)
	{
	fclose(table);			 table = NULL;
#ifndef DEBUG
	if(EraseStrip) unlink(table_filename);
#endif
	}
  if (latex_filename != '-')
      if (latex != NULL) fclose(latex);   latex = NULL;
  if (logg != NULL)
        {
        if(!ExitCode)
	  fprintf(logg,_("\n!!!! Fatal Exit No %d!!!!\n"),ExitCode);
	fclose(logg);		          logg = NULL;
        }

  exit(ExitCode);
}


/*This function asks user to enter password*/
void ObtainPassword(string & password)
{
  printf(_("\nEnter Password: "));
  StrGets(password);
}


/*This function asks waits for user response Yes, Ino or Ignore*/
char YesNoIgnore(const char *str)
{
char c;

//TryAgain:
  printf(str);

NextChar:
  c=getchar();
//putchar('\n');
  switch(c)
	{
	case 'A':
	case 'a':
	case 'Y':
	case 'y':getchar();return('Y');
	case '\n':return('Y');//goto TryAgain;
	case 'n':
	case 'N':getchar();return('N');
	case 'I':
	case 'i':getchar();
		 ExtendedCheck=true;
		 return('I');		// ignore=run anyway
	default:if(isspace(c)) goto NextChar;
	}
return('?');
}


/*This function prints text console WP2LaTeX heading*/
void Heading(void)
{
static boolean printed=false;
 if(printed) return;
 printed=true;

 if(Verbosing < 1) return;
 printf(_("\n>>>WP2LaTeX<<< Conversion program: From Wordperfect to LaTeX Version %s \n"
	  "  (c) Made by J.Fojtik  ---- Date : 1996-2013\n"),
	    version);
}


/*This function prints wp2latex help to the text console*/
void ShowHelp()
{
 printf(_("\nSomebody at Eindhoven Univ of Techn wrote a WordPerfect 5.0 to LaTeX"
	  "\nconversion program (only running on MSDOS of course) :=)"
	  "\n           This program was completely rewritten by Jaroslav Fojtik"
	  "\nand many new functions was added (eg conversion of math equations)"
	  "\nWrite any suggestions, reports or bugs to address FOJTIK@PENGUIN.CZ"
	  "\nor JaFojtik@seznam.cz."
	  "\n"
	  "\nImportant note: Conversions performed by wp2latex are only partial."
	  "\nPrint the resulting document and compare carefully with original."
	  "\nIn all but the simplest documents you will have to do further editing."
	  "\nOr you may wisch to edit the WordPerfect document to remove unwanted"
	  "\ncodes (such as Tab, Tab Set), then run it through wp2latex again."
	  "\n"));
 printf(_(
	  "\nParametters: WP2LATEX [switches] [input_file [output_file]] [switches]"
	  "\n   -?  --help   Display this help page."
	  "\n   -amssymb     %sUse aditional package AMSsymb with special characters."
	  "\n   -bbm         %sUse aditional package Bbm with special characters."
	  "\n   -configfile -@ filename   Load an external configuration file."
	  "\n   -copyright   Display informations about Copyright of WP2LaTeX."
	  "\n   -cp-codepage Use \"codepage\" for output text. Supported code pages are"
	  "\n         \"852\"(ISO8), \"866\"(Russ), \"895\"(Kamenicky), \"1250\"(Win),"
	  "\n         \"1251\"(WinRuss), \"ISO8859_1\", \"ISO8859-2\", \"KOI8R\"."
	  "\n   -cp-styles   Turn on special styles for codepages."
	  "\n   -epsfig      Use style epsfig.sty for Postscript images."
	  "\n   -extract-WPG %sImages will be extracted into separate files (only WP 5.x)"
	  "\n   -fancyhdr    Use package fancyhdr.sty for headers and footers"
	  "\n   -fig-output-dir Use this directory for storing images. Prefer relative path."
	  "\n   -fix-spaces  Try to fix multiple spaces by ~."
	  "\n   -fontenc-T1  Use package fontenc.sty [T1] with additional characters"
	  "\n   -force-xxx   Force of defined format xxx = WP4.x, WP5.x, HTML, RTF"
	  "\n   -FORCE-xxx   Like -force but override any attempt of autodetection."
	  "\n   -graphicx    Use style graphicx.sty for Postscript images."	  
	  "\n   -charset1    %sSwitch internal WordPerfect char set to set 1."
	  "\n   -charsetCZ   %sSwitch internal WordPerfect char set to keybcs."
	  "\n   -i; -o; -l   Explicitely define an imput; output; log file"
	  "\n   -ignore-tabs %sRemove all [TAB] symbols from WP document."
	  "\n   -image-path PATH/  Add one item to searching path for images."
	  "\n   -input-PS    Use Postscript features in the LaTeX (mainly images)."
	  "\n   -L LANGUAGE  Switch message translations to language LANGUAGE."
	  "\n   -LaTeX2      %sOptimize output for LaTeX 2.09."
	  "\n   -LaTeX3      %sOptimize output for LaTeX 2e or LaTeX 3.0"
	  "\n   -latexsym    %sUse aditional package latexsym with special characters."
	  "\n   -longtable   Use aditional package longtable for better tables."
	  "\n   -makeidx     %sUse aditional package makeidx for placing index."
	  "\n   -no-amssymb  %sDisable aditional package AMSsymb with special characters."
	  "\n   -no-bbm      %sDisable aditional package Bbm with special characters."
	  "\n   -no-columns  Do not translate multicolumn text to more columns."
	  "\n   -no-extractWPG Turn an all extracing images off."
	  "\n   -no-fancyhdr Do not use package fancyhdr.sty."
	  "\n   -no-input-PS Disable using anything from Postscript in the LaTeX."
	  "\n   -no-latexsym Disable aditional package latexsym."
	  "\n   -no-lang-XXX Disables language XXX."
	  "\n   -no-safemode Disable checking features - faster conversion."
	  "\n   -no-texchars %sStandard conversion of all characters to proper TeX sequences."
	  "\n   -no-wasy     %sDisable aditional package Wasy2 with special characters."
	  "\n   -rsfs        %sUse aditional package mathrsfs with special characters."
	  "\n   -safemode    %sCheck safely consistency of each object and try to fix all"
	  "\n                incorrect things. Good for corrupted WP files."
	  "\n   -s \"password\" Password for decoding WP document (WP4.x & WP5.x only)."
	  "\n   -S -silent   %sSwitch to the silent mode."
	  "\n   -texchars    %sDo not interpret tex macros (all chars 32-128 will not be"
	  "\n                converted to TeX sequences)."
	  "\n   -ulem        %sUse aditional package ulem for underlining and striking out."
	  "\n   -v           Get info about version."
	  "\n   -wasy        %sUse aditional package Wasy2 with special characters."
	  "\n"),
	  Amssymb>=false?"*":"",
	  Bbm>=false?"*":"",
	  SaveWPG>=true?"":"*",		//bold the default options
	  WPcharset==1?"*":"",
	  WPcharset==2?"*":"",
	  Tabs<=false?"*":"",
	  (LaTeX_Version & 0xFF00) == 0x200?"*":"",
	  (LaTeX_Version & 0xFF00) == 0x300?"*":"",
	  LaTeXsym>=false?"*":"",
	  MakeIdx>=false?"*":"",
	  Amssymb>=false?"":"*",
	  Bbm>=false?"":"*",
	  TexChars>=true?"":"*",
	  Wasy>=false?"":"*",
	  Rsfs>=false?"*":"",
	  ExtendedCheck==true?"*":"",
	  Verbosing>0?"":"*",
	  TexChars<=false?"":"*",
	  Ulem>=false?"*":"",
	  Wasy>=false?"*":""
	  );
#ifndef Registered
   puts(_("\nPlease send me a postcard. Run \"wp2latex -copyright\" for more details."));
#endif
}


/** Ask user to get log file. */
void GetLogFileName(string & LogFile)
{
string s;
  Heading();
  printf(_("\nLog file name [%s] : "), chk(LogFile()));
  StrGets(s);
  if(s != "") LogFile=s;
}


static int Filenames(void)
{
string StrName;
int p;

  Heading();

  if (latex_filename == "")
      {
      if (Verbosing >= 1 || wpd_filename == "")
         {
	 printf(_("\nWordPerfect-filename [%s]: "), chk(wpd_filename()));
	 StrGets(StrName);
	 if (StrName != "") wpd_filename=StrName;
         }

    if (wpd_filename == "")
        { 			  /* No filename entered */
	RunError(0x200);
        }

    p=length(wpd_filename);
    while(p>0)
	 {
	 if(wpd_filename[p]=='.') break;
	 if((wpd_filename[p]=='/')||(wpd_filename[p]=='\\'))
		{
		p=length(wpd_filename);
		break;
		}
	 p--;
	 }
    if(p<=0) p=length(wpd_filename); //no extension


    if (latex_filename == "")
          {
	  latex_filename=copy(wpd_filename,0,p) + ".tex";
	  }

    if (Verbosing >= 1 || latex_filename == "")
       {
       printf(_("LaTeX-filename [%s]: "), chk(latex_filename()));
       StrGets(StrName);
       if (StrName != "") latex_filename = StrName;
       }
  }

  p=length(wpd_filename);
    while(p>0)
    	 {
         if(wpd_filename[p]=='.') break;
         if((wpd_filename[p]=='/')||(wpd_filename[p]=='\\'))
	 	{
                p=length(wpd_filename);
                break;
		}
         p--;
	 }

  strip_filename = copy(wpd_filename,0,p) + ".STR";
  table_filename = copy(wpd_filename,0,p) + ".TBL";

  return(0);
}


static void CheckOptions(void)
{
if(LaTeX_Version<0x300)		//disable colors for LaTeX 2.09
	{
	if(colors>true)
		fprintf(err,_("Warning: Color style is available only for LaTeX 2e !\n"));
	colors=-1;
	}
}


#if (defined(__UNIX__)||defined(__DJGPP__)) & !defined(DEBUG)
/* This is a main signal handler */
void sig_int(int signo)
{
static int sigcount=0;

 if(sigcount++>2) abort();
 switch(signo)
    {
    case SIGINT:RunError( 0x10, "");   break;
    case SIGSEGV:RunError(0x8B, "");   break;
    }
}

static void HookSignals(void)
{
 signal(SIGINT,sig_int);
 signal(SIGSEGV,sig_int);
}
#endif


/*This procedure checks sizes of standard variables*/
static void CheckCompiler(void)
{
char str[20];
 if((sizeof(__u8)!=1)||(sizeof(__u16)!=2)||(sizeof(__u32)!=4)||
   (sizeof(__s8)!=1)||(sizeof(__s16)!=2)||(sizeof(__s32)!=4))
	{
	Heading();
	fprintf(err,_("\nFatal: Code was badly compiled. sizeof(__u8)=%d sizeof(__u16)=%d sizeof(__u32)=%d\nCheck types.h !!!!!"),
           sizeof(__u8),sizeof(__u16),sizeof(__u32) );	
	fprintf(err,_("\nContinue anyway? y/N "));
	if(toupper(getchar())!='Y') abort();
	getchar();			//Get rid of buffered Enter key.
	}
  sprintf(str,"%4.3f",1234.567);
  if(strcmp(str,"1234.567"))
    {
#ifdef _MSC_VER
    setlocale(LC_NUMERIC,"English"); 
    sprintf(str,"%4.3f",1234.567);
    }
  if(strcmp(str,"1234.567"))
    { 
#endif
    Heading();
    fprintf(err,_("\nFatal: Problem inside locale conversion of doubles '%s' expected '%s'!"),
       str,"1234.567");
    fprintf(err,_("\nContinue anyway? y/N "));
    if(toupper(getchar())!='Y') abort();
    getchar();				//Get rid of buffered Enter key.
    }
}


/*---begin of PROGRAM---*/
int main(int argc , char *argv[])
{
TconvertedPass1 *cqPass1;

  latex = NULL;		/* The output Latex file */
  strip = NULL;		/* The temporary file rough conversion */
  table = NULL;		/* The temporary file with line informations */
  wpd   = NULL;		/* The input WP file */
  logg  = NULL;		/* The output log file */
  err   = stderr;	/* The output for error messages */

/* Default initialization */
  Verbosing = 1;
  TexChars = false;
  CodePage = 0;		/*unknown - no 8 bit code generated*/
  WPcharset = 1;	/*common char set 1*/
  ExtendedCheck = true;	/*true*/
  FixSpaces = false;
  OptimizeSection = true;
  UnknownCharacters=UnknownObjects=CorruptedObjects=0;
  cqPass1 = NULL;

#if (defined(__UNIX__)||defined(__DJGPP__)) & !defined(DEBUG)
  HookSignals();
#endif

#ifdef DEBUG
  log_filename="default.log";
#endif
//  clrscr();

#ifdef __gettext__
  InitGettext();
#endif /* __gettext__ */

//printf("%ld",coreleft());

  CheckCompiler();
  Sys_Variable();
  CommandLine(argc,argv);	//parse command line arguments
#ifdef __gettext__
  CheckGettext(argv==NULL?NULL:*argv);
#endif
  Filenames();			//ask user to enter filename if missing 
  UpdateFigDir();
  CheckOptions();

  if( (wpd = fopen(wpd_filename, "rb"))   == NULL )
	RunError(2,wpd_filename);

  if(FORCE != "")
     {
     cqPass1=GetConvertor(FORCE);
     if(cqPass1==NULL)
       {
         fprintf(err,_("\nError: FORCED conversion module \"%s\" was not found!"),FORCE());
         goto NoModule;					// It makes no sense to continue, exit a program.
       }
     else fprintf(err,_("\nWarning: Conversion module %s is FORCED. No autodetection is possible. ERRORS may occur!!!"),FORCE());
     }
  else
     {
     CheckFileFormat(wpd,FilForD);
     cqPass1=GetConvertor(FilForD.Convertor);
     if(cqPass1==NULL && force!="")
	{
	cqPass1=GetConvertor(force);
	if(cqPass1==NULL)
	   {
	   fprintf(err,_("\nError: forced conversion module \"%s\" was not found!"),force());
NoModule:  fprintf(err,_("\nType \"wp2latex -v\" to see a list of available modules."));
	   RunError(-2);			   // It makes no sense to continue, exit a program.
	   }
	else
	   {
	   fprintf(err,_("\nWarning: Conversion module %s is forced. No autodetection is possible. ERRORS may occur!!!"),force());
	   ExtendedCheck = true;	/* It would be better to switch safe mode on. */
	   }
	}
     }
#ifdef _has_MemStreams
  char *bp_strip=NULL,*bp_table=NULL;
  size_t size_strip,size_table;
  if(UseMemStream)
       {
       if((strip=open_memstream(&bp_strip, &size_strip)) == NULL)
 RunError(2,"memstream");
       if((table=open_memstream(&bp_table, &size_table)) == NULL)
 RunError(2,"memstream");
       }
  else
#endif  
       {
       if((strip=fopen(strip_filename, "w"))   == NULL)
	 RunError(2,strip_filename);
       if((table=fopen(table_filename, "w+b")) == NULL)
	 RunError(2,table_filename);
       }    	    
       
  logg=NULL;
  if (log_filename != "")
      {
      if((logg = fopen(log_filename, "w")) == NULL )
	{
	fprintf(err,_("\nWarning: Cannot open log file %s ..."),log_filename());
	}
	else fprintf(logg,_("%% log file for converted file %s, %s ver %d.%d\n"
			    "%% conversion program WP2LaTeX v. %s from %s.\n"),
			   wpd_filename(), chk(FilForD.DocumentType), FilForD.DocVersion >> 8, FilForD.DocVersion & 0xFF,
                           version, versiondate);
      }

  if(cqPass1!=NULL)
	{
	if(Verbosing >= 1) printf(_("\nConverting ...\n"));
	cqPass1->InitMe(wpd, table, strip, logg, err);
	if(cqPass1->Convert_first_pass()<=0)
	   {
	   if(Verbosing >= 1) printf(_("\nInput file is empty\n"));
	   goto EmptyInput;
	   }
	if(Verbosing >= 1) putchar('\n');
	delete cqPass1;
	cqPass1=NULL;
	}
  else RunError(0x202,"",&FilForD);  /* unsupported document version */

  if(wpd != NULL)
          {
          fclose(wpd);
          wpd = NULL;
          }	  
  if(strip != NULL)
          {
          if(fflush(strip)) RunError(0x20,""); //The RunError procedure will erase strip in this case
	  if(fclose(strip)) {strip = NULL;RunError(0x20,"");}
          strip = NULL;
          }
	  		 
  if(table != NULL)
         {
         if(fflush(table)) RunError(0x20,""); //The RunError procedure will erase table in this case
         if(fclose(table)) {table = NULL;RunError(0x20,"");}
         table = NULL;
         }
		 
  if(logg!=NULL) fprintf(logg,_("\n%% pass1 finished going to pass2\n\n"));

  /* Prepare files for pass2*/
#ifdef _has_MemStreams  
  if(UseMemStream)
       {
       if((strip=fmemopen(bp_strip, size_strip, "r")) == NULL)
	 RunError(2,strip_filename);
       if((table=fmemopen(bp_table, size_table, "r+b")) == NULL)
	 RunError(2,table_filename);
       }	  
  else       
#endif
       {
       if((strip=fopen(strip_filename, "r")) == NULL)
	 RunError(2,strip_filename);
       if((table=fopen(table_filename, "r+b")) == NULL)
	 RunError(2,table_filename);
       }	   
	
  if (latex_filename == '-') latex=stdout;
      else if ( (latex=fopen(latex_filename, "w")) == NULL )
		 RunError(2,latex_filename);
	
	
  if (Verbosing >= 1) putchar('\n');
  Convert_second_pass(strip, table, latex, logg, err);
  if(Verbosing >= 1) putchar('\n');

EmptyInput:
  if (strip != NULL) fclose(strip);   strip = NULL;
  if (table != NULL) fclose(table);   table = NULL;
  if (latex_filename != '-')
       if (latex != NULL)
                 {
                 if(fclose(latex)) {latex = NULL;RunError(0x20,"");}
                 }
  latex = NULL;
  if (logg != NULL)
  	{
	fprintf(logg,_("\n%% pass2 finished\n"
	              "%%  There were %ld unconverted characters.\n"
		      "%%  There were %ld unrecognized/ignored objects.\n"),UnknownCharacters,UnknownObjects);
	if(CorruptedObjects>0)
	    fprintf(logg,_("%%  There were %ld corrupted objects.\n"),CorruptedObjects);
	if(fclose(logg))
	       fprintf(err,_("\nError: Log file is not completely written."));
        }
  logg = NULL;


/* Delete auxillary files */
#ifdef _has_MemStreams  
  if(bp_strip!=NULL) {free(bp_strip);bp_strip=NULL;}
  if(bp_table!=NULL) {free(bp_table);bp_table=NULL;}
  if(!UseMemStream) 
#endif  
    if(EraseStrip)
       {
#ifndef DEBUG
       unlink(strip_filename);
       unlink(table_filename);
#endif
       }

//printf("%ld",coreleft());
  return(0);
}

