/*
 * GETOUTHN.C
 *
 *  This file is part of DOSZIP
 *  Copyright (c) 1996 Hjort Nidudsson.
 */
#include <io.h>
#include <arch.h>
#include <errno.h>

int getouthandle(const char *p)
{
	int h;

	h = osopen(p, _A_NORMAL, M_WRONLY, A_CREATE);
	if (h == -1 && errno == EEXIST) {
		if ((confirmflag & CFDELETEALL) == 0) {
			setfattr(p, 0);
			h = openfile(p, M_WRONLY, A_TRUNC);
		} else {
			switch (confirm_delete(p, 0)) {
/* jump */		case 3:	return 0;
/* delete all */	case 2: confirmflag &= ~CFDELETEALL;
/* delete */		case 1:
				setfattr(p, 0);
				h = openfile(p, M_WRONLY, A_TRUNC);
			}
		}
	}
	return h;
}