;
; CHSIZE.ASM
;
; This file is part of DOSZIP
; Copyright (c) 1996 Hjort Nidudsson.
;

INCLUDE		clib.inc

ZEROBUFSIZ = 	128

PPROC		chsize
LOCAL		zerobuf: BYTE:[ZEROBUFSIZ],\
		posn: 	DWORD
USES		si,di
ARG             HANDLE: WORD,\
		NSIZE:	DWORD
		mov	ax,4201h
		mov	bx,HANDLE
		xor	cx,cx
		mov	dx,cx
		int	21h
		jc	SHORT @@Failed
		mov	[bp-4],ax
		mov	[bp-2],dx
		mov	ax,4202h
		sub	cx,cx
		mov	dx,cx
		int	21h
		jc	SHORT @@Failed
		cmp	dx,WORD PTR [NSIZE+2]
		ja	SHORT @@Truncate
		jb	SHORT @@Pad
		cmp	ax,WORD PTR [NSIZE]
		jnc	SHORT @@Truncate
@@Pad:		sub	WORD PTR [NSIZE],ax
		sbb	WORD PTR [NSIZE+2],dx
		mov	cx,dx
		xchg	ax,dx
		mov	ax,4200h
		int	21h
		jc	SHORT @@Failed
		push	SS
		pop	ES
		lea	di,zerobuf
		xor	ax,ax
		mov	cx,ZEROBUFSIZ / 2
		cld
	repz	stosw
@@writeLoop:	mov	cx,ZEROBUFSIZ
		cmp	WORD PTR [NSIZE+2],0
		jnz	SHORT @@writeChunk
		cmp	cx,WORD PTR [NSIZE]
		jbe	SHORT @@writeChunk
		mov	cx,WORD PTR [NSIZE]
@@writeChunk:	sub	WORD PTR [NSIZE],cx
		sbb	WORD PTR [NSIZE+2],0
		lea	dx,zerobuf
		MPUSH	DS
		MPUSH	SS
		MPOP	DS
		push	cx
		mov	ah,40h
		int	21h
		pop	cx
		pop	DS
		jc	SHORT @@Failed
		cmp	ax,cx
		jnz	SHORT @@Failed
		mov	ax,WORD PTR [NSIZE]
		or	ax,WORD PTR [NSIZE+2]
		jnz	SHORT @@writeLoop
		jmp	SHORT @@Seekback
@@Failed:	mov	doserrno,ax
		jmp	SHORT @@toend
@@Truncate:	mov	ax,4200h
		mov	bx,HANDLE
		mov	dx,WORD PTR [NSIZE]
		mov	cx,WORD PTR [NSIZE+2]
		int	21h
		jc	SHORT @@Failed
		mov	ah,40h
		xor	cx,cx
		int	21h
		jc	SHORT @@Failed
@@Seekback:	mov	dx,[bp-4]
		mov	cx,[bp-2]
		xchg	ax,si
		mov	ax,4200h
		int	21h
		jc	SHORT @@Failed
		xor	ax,ax
@@toend:	ret
PEND		chsize

		END

