/*
 * READ.C
 *
 *  This file is part of DOSZIP
 *  Copyright (c) 1996 Hjort Nidudsson.
 */

#include <io.h>
#include <errno.h>

#define LF 	10
#define CR 	13
#define CTRLZ 	26

#define ER_BROKEN_PIPE		109
#define ER_ACCESS_DENIED	5

static char pipech[_NFILE_] = {
	10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 10, 10, 10, 10, 10, 10, 10
	};

int read(int h, void *b, unsigned len)
{
	char *bp;
	char *p, *q;
	char peekchr;
	int  os;
	int  count;
	int  result;

	if (h >= _nfile) {
		errno = EBADF;
		doserrno = 0;
		return -1;
	}
	count = 0;
	bp = b;
	if (len == 0 || (_osfile[h] & FH_EOF))
		return 0;
	if ((_osfile[h] & (FH_PIPE | FH_DEVICE)) && pipech[h] != LF) {
		*bp++ = pipech[h];
		count++;
		len--;
		pipech[h] = LF;
	}
	if (!(os = osread(h, bp, len))) {
		if ((result = doserrno) == ER_ACCESS_DENIED) {
			errno = EBADF;
			return -1;
		} else if (result == ER_BROKEN_PIPE) {
			return 0;
		}
		return -1;
	}
	count += os;
	if (_osfile[h] & FH_TEXT) {
		if (*(char *)b == LF)
			_osfile[h] |= FH_CRLF;
		else
			_osfile[h] &= ~FH_CRLF;
		p = q = b;
		while (p < (char *)b + count) {
			if (*p == CTRLZ) {
				if ((_osfile[h] & FH_DEVICE) == 0)
					_osfile[h] |= FH_EOF;
				break;
			} else if (*p != CR) {
				*q++ = *p++;
			} else {
				if (p < (char *)b + count - 1) {
					if (*(p+1) == LF) {
						p += 2;
						*q++ = LF;
					} else {
						*q++ = *p++;
					}
				} else {
					++p;
					result = 0;
					if (!(os = osread(h, &peekchr, 1)))
						result = doserrno;
					if (result != 0 || os == 0) {
						*q++ = CR;
					} else {
						if (_osfile[h] & (FH_DEVICE | FH_PIPE)) {
							if (peekchr == LF)
								*q++ = LF;
							else {
								*q++ = CR;
								pipech[h] = peekchr;
							}
						} else {
							if (q == b && peekchr == LF) {
								*q++ = LF;
							} else {
								(void)lseek(h, -1, SEEK_CUR);
								if (peekchr != LF)
									*q++ = CR;
							}
						}
					}
				}
			}
		}
		count = q - (char *)b;
	}
	return count;
}
