/*
 * _STBUF.C
 *
 *  This file is part of DOSZIP
 *  Copyright (c) 1996 Hjort Nidudsson.
 */

#include <io.h>
#include <alloc.h>
#include <stdio.h>

void *_stdbuf[2] = { NULL, NULL }; /* buffer for stdout and stderr */

int _stbuf(FILE *p)
{
	int index;

	if (!osisatty(_fileno(p)))
		return 0;
	if (p == stdout)
		index = 0;
	else if (p == stderr)
		index = 1;
	else
		return 0;
	if (anybuf(p))
		return 0;
	if ( (_stdbuf[index] == NULL) &&
	    ((_stdbuf[index] = malloc(_INTIOBUF)) == NULL) ) {
		p->bp = p->base = (void *)&(p->charbuf);
		p->cnt = p->bufsize = 2;
	} else {
		p->bp = p->base = _stdbuf[index];
		p->cnt = p->bufsize = _INTIOBUF;
	}
	p->flag |= (_IOWRT | _IOYOURBUF | _IOFLRTN);
	return 1;
}

void _exitbuf(void)
{
	if (_stdbuf[0] != NULL)
		free(_stdbuf[0]);
	if (_stdbuf[1] != NULL)
		free(_stdbuf[1]);
}

#pragma exit _exitbuf 30
