;
; WCZIP.ASM
;
; This file is part of DOSZIP
; Copyright (c) 1996 Hjort Nidudsson.
;

INCLUDE		clib.inc

PPROC		wczip
USES		DS,si,di
ARG		DEST:	DWORD,\
		SRC:	DWORD,\
		COUNT:	WORD
		cld
		mov	cx,COUNT
		les	di,DEST
		lds	si,SRC
		add	di,3
		mov	bx,di
		add	bx,cx
CNEXTW:		lodsw
		xchg	al,ah
		mov	ES:[bx],ah
		stosb
		inc	bx
		loop	SHORT CNEXTW
		lds	si,DEST
		mov	di,si
		add	si,3
		mov	cx,COUNT
		call	COMPRESS
		mov	cx,COUNT
		call	COMPRESS
TOEND:		mov	ax,di
		sub	ax,WORD PTR DEST
		shr	ax,1
		inc	ax
BYEBYE:		ret
PEND		wczip

_TEXT		SEGMENT

COMPRESS:	lodsb
		mov	dl,al
		mov	dh,al
		and	dh,0F0H
		cmp	al,[si]
		jnz	SHORT TESTBYTE
		mov	bx,0F001H
		jmp	SHORT CNLOOP
TESTBYTE:	cmp	dh,0F0H
		jnz	SHORT SAVEBYTE
		mov	ax,01F0H
		jmp	SHORT WRITECNT
WRITETWO:	mov	al,dl
		stosb
		jmp	SHORT SAVEBYTE
CMPNEXT:	inc	bx
		lodsb
		cmp	al,[si]
		jnz	SHORT STORECOUNT
CNLOOP:		loop	SHORT CMPNEXT
STORECOUNT:     mov	ax,bx
		cmp	bx,0F002H
		jnz	SHORT INITCNT
		cmp	dh,0F0H
		jz	SHORT INITCNT
		mov	al,dl
		stosb
		jmp	SHORT SAVEBYTE
INITCNT:	xchg	ah,al
WRITECNT:	stosw
		mov	al,dl
SAVEBYTE:	stosb
RCLOOP:		or	cx,cx
		jz	SHORT RCEND
		loop	SHORT COMPRESS
RCEND:		ret

_TEXT		ENDS

		END
