/*
 * CMPANELS.C
 *
 *  This file is part of DOSZIP
 *  Copyright (c) 1996 Hjort Nidudsson.
 */

#include <disk.h>
#include <dzmain.h>

static int cm_longnames(panel *);
static int cm_hidden(panel *);
static int cm_sort(int, unsigned);
static void __toggle_flag(WORD *, int);

int cm_longnames(panel *p)
{
	if (*p->flag & _W_LONGNAME) {
		*p->flag &= ~_W_LONGNAME;
	} else if (_ifsmgr) {
		*p->flag |= _W_LONGNAME;
	}
	return panel_update_all(p);
}

int cmalong(void)
{
	return cm_longnames(&panela);
}

int cmblong(void)
{
	return cm_longnames(&panelb);
}

void __toggle_flag(WORD *flag, int bits)
{
	if (*flag & bits)
		*flag &= ~(bits);
	else
		*flag |= bits;
}

int cmadetail(void)
{
	__toggle_flag(panela.flag, _W_DETAIL);
	return panel_update_rect(&panela);
}

int cmbdetail(void)
{
	__toggle_flag(panelb.flag, _W_DETAIL);
	return panel_update_rect(&panelb);
}

int cm_hidden(panel *p)
{
	__toggle_flag(p->flag, _W_HIDDEN);
	return panel_update_all(p);
}

int cmahidden(void)
{
	return cm_hidden(&panela);
}

int cmbhidden(void)
{
	return cm_hidden(&panelb);
}

int cmamini(void)
{
	return panel_togglemini(&panela);
}

int cmbmini(void)
{
	return panel_togglemini(&panelb);
}

int cm_sort(int p, unsigned flag)
{
	if (panel_state(&spanel[p]) == 0)
		return 0;
	config.ide[p].flag &= ~_W_SORTSIZE;
	config.ide[p].flag |= flag;
	wssort(spanel[p].ide);
	panel_putitem(&spanel[p], 0);
	return 1;
}

int cmadate(void) { return cm_sort(0, _W_SORTDATE); }
int cmbdate(void) { return cm_sort(1, _W_SORTDATE); }
int cmatype(void) { return cm_sort(0, _W_SORTTYPE); }
int cmbtype(void) { return cm_sort(1, _W_SORTTYPE); }
int cmasize(void) { return cm_sort(0, _W_SORTSIZE); }
int cmbsize(void) { return cm_sort(1, _W_SORTSIZE); }
int cmaname(void) { return cm_sort(0, _W_SORTNAME); }
int cmbname(void) { return cm_sort(1, _W_SORTNAME); }

int cm_chdrv(panel *p, const char *cp)
{
	int q;

	if (panel_state(p) == 0)
		return 0;
	q = _disk_select(cp);
	if (q)
		panel_sethdd(p, q - 1);
	while (mousep());
	return q;
}

int cmachdrv(void)
{
	return cm_chdrv(&panela, cp_selectdrv_A);
}

int cmbchdrv(void)
{
	return cm_chdrv(&panelb, cp_selectdrv_B);
}

int cmatoggle(void)
{
	return panel_toggle(&panela);
}

int cmbtoggle(void)
{
	return panel_toggle(&panelb);
}

int cmaupdate(void)
{
	return panel_update_fcb(&panela);
}

int cmbupdate(void)
{
	return panel_update_fcb(&panelb);
}

int cmclong(void)
{
	return (cpanel == &panela) ? cmalong() : cmblong();
}

int cmcdetail(void)
{
	return (cpanel == &panela) ? cmadetail() : cmbdetail();
}

int cmchidden(void)
{
	return (cpanel == &panela) ? cmahidden() : cmbhidden();
}

int cmcmini(void)
{
	return (cpanel == &panela) ? cmamini() : cmbmini();
}

int cmcname(void)
{
	return (cpanel == &panela) ? cmaname() : cmbname();
}

int cmctype(void)
{
	return (cpanel == &panela) ? cmatype() : cmbtype();
}

int cmcdate(void)
{
	return (cpanel == &panela) ? cmadate() : cmbdate();
}

int cmcsize(void)
{
	return (cpanel == &panela) ? cmasize() : cmbsize();
}

int cmcupdate(void)
{
	return (cpanel == &panela) ? cmaupdate() : cmbupdate();
}