/*
 * ASCII.C - Ascii table
 *
 *  This file is part of DOSZIP
 *  Copyright (c) 1996 Hjort Nidudsson.
 */

#include <dialog.h>

DOBJ *d;
ROBJ *IDD_Ascii;

int event(void)
{
	int x,y,k,c;
	RECT rc;

	rc.col = 16;
	rc.row = 16;
	while ( !(k = getkey()) ) {
		x = mousex();
		y = mousey();
		if (mousep() && rcxyrow(d->rc, x, y) == 1)
			return MOUSECMD;
		rc.x = d->rc.x + 7;
		rc.y = d->rc.y + 3;
		if ((k = rcxyrow(rc, x, y)) == 0) {
			if (c) {
				scputc(rc.x + 11, rc.y - 1, 0, 5, 196);
				c = 0;
			}
		} else {
			c = 1;
			wcputf(getxyp(rc.x + 11, rc.y - 1), 0, 0,
				"[%03d]", (--k * 16) + x - rc.x);
		}
	}
	return k;
}

int main(void)
{
	if ((d = rsopen(IDD_Ascii)) == NULL)
		return 1;

	d->object[0].proc = event;
	mouseinit();
	mouseon();
	tdmodal(d);
	mouseoff();
	return 0;
}

/******** Resource begin Ascii *
	{ 0x001C,   1,   0, {26, 1,30,22} },
	{ 0x2A01,   0, 'Q', { 0, 0, 1, 1} },
********* Resource data  *******************/
static int Ascii_RC[] = {
	0x0590,0x001C,0x0001,0x011A,0x161E,0x2A01,0x5100,0x0000,
	0x0101,0x1EF0,0xF070,0x1F43,0x10F0,0xF01B,0x1F0E,0x10F0,
	0xF01B,0x1F0E,0x10F0,0xF01B,0x1F0E,0x10F0,0xF01B,0x1F0E,
	0x10F0,0xF01B,0x1F0E,0x10F0,0xF01B,0x1F0E,0x10F0,0xF01B,
	0x1F0E,0x10F0,0xF01B,0x1F0E,0x10F0,0xF01B,0x1F0E,0x10F0,
	0xF01B,0x1F0E,0x10F0,0xF01B,0x1F0E,0x10F0,0xF01B,0x1F0E,
	0x10F0,0xF01B,0x1F0E,0x10F0,0xF01B,0x1F0E,0x10F0,0xF01B,
	0x1F0E,0x10F0,0xF01B,0x1F61,0x0BF0,0x4120,0x6373,0x6969,
	0x6320,0x646F,0xF065,0x202D,0xF0DA,0xC410,0xF0BF,0x2009,
	0x3030,0xB420,0x0100,0x0302,0x0504,0x0706,0x0908,0x0B0A,
	0x0D0C,0x0F0E,0x20C3,0x4630,0x06F0,0x3120,0x2030,0x10B4,
	0x1211,0x1413,0x1615,0x1817,0x1A19,0x1C1B,0x1E1D,0xC31F,
	0x3120,0xF046,0x2006,0x3032,0xB420,0x2120,0x2322,0x2524,
	0x2726,0x2928,0x2B2A,0x2D2C,0x2F2E,0x20C3,0x4632,0x06F0,
	0x3320,0x2030,0x30B4,0x3231,0x3433,0x3635,0x3837,0x3A39,
	0x3C3B,0x3E3D,0xC33F,0x3320,0xF046,0x2006,0x3034,0xB420,
	0x4140,0x4342,0x4544,0x4746,0x4948,0x4B4A,0x4D4C,0x4F4E,
	0x20C3,0x4634,0x06F0,0x3520,0x2030,0x50B4,0x5251,0x5453,
	0x5655,0x5857,0x5A59,0x5C5B,0x5E5D,0xC35F,0x3520,0xF046,
	0x2006,0x3036,0xB420,0x6160,0x6362,0x6564,0x6766,0x6968,
	0x6B6A,0x6D6C,0x6F6E,0x20C3,0x4636,0x06F0,0x3720,0x2030,
	0x70B4,0x7271,0x7473,0x7675,0x7877,0x7A79,0x7C7B,0x7E7D,
	0xC37F,0x3720,0xF046,0x2006,0x3038,0xB420,0x8180,0x8382,
	0x8584,0x8786,0x8988,0x8B8A,0x8D8C,0x8F8E,0x20C3,0x4638,
	0x06F0,0x3920,0x2030,0x90B4,0x9291,0x9493,0x9695,0x9897,
	0x9A99,0x9C9B,0x9E9D,0xC39F,0x3920,0xF046,0x2006,0x3041,
	0xB420,0xA1A0,0xA3A2,0xA5A4,0xA7A6,0xA9A8,0xABAA,0xADAC,
	0xAFAE,0x20C3,0x4641,0x06F0,0x4220,0x2030,0xB0B4,0xB2B1,
	0xB4B3,0xB6B5,0xB8B7,0xBAB9,0xBCBB,0xBEBD,0xC3BF,0x4220,
	0xF046,0x2006,0x3043,0xB420,0xC1C0,0xC3C2,0xC5C4,0xC7C6,
	0xC9C8,0xCBCA,0xCDCC,0xCFCE,0x20C3,0x4643,0x06F0,0x4420,
	0x2030,0xD0B4,0xD2D1,0xD4D3,0xD6D5,0xD8D7,0xDAD9,0xDCDB,
	0xDEDD,0xC3DF,0x4420,0xF046,0x2006,0x3045,0xB420,0xE1E0,
	0xE3E2,0xE5E4,0xE7E6,0xE9E8,0xEBEA,0xEDEC,0xEFEE,0x20C3,
	0x4645,0x06F0,0x4620,0x2030,0xF0B4,0xF001,0x01F0,0xF0F1,
	0xF201,0x01F0,0xF0F3,0xF401,0x01F0,0xF0F5,0xF601,0x01F0,
	0xF0F7,0xF801,0x01F0,0xF0F9,0xFA01,0x01F0,0xF0FB,0xFC01,
	0x01F0,0xF0FD,0xFE01,0x01F0,0xC3FF,0x4620,0xF046,0x2009,
	0xF0C0,0xC210,0xF0D9,0x200D,0x3130,0x3332,0x3534,0x3736,
	0x3938,0x4241,0x4443,0x4645,0x25F0,0x1F20,
}; //	636 byte
ROBJ *IDD_Ascii = (ROBJ *)&Ascii_RC;
/******** Resource end   Ascii */
