/*
 * EDITATTR.C
 *
 *  This file is part of DOSZIP
 *  Copyright (c) 1996 Hjort Nidudsson.
 */

#include <dialog.h>
#include <string.h>

extern ROBJ *IDD_EditColor;
extern const char *cp_editcolor[];
extern const char *cp_panelcolor[];

int edc_putattrib(DOBJ *);

enum {	ID_OK = 16 + 8,
	ID_CANCEL };

static DOBJ *dialog;
static int attrib_event(void);

static void update_dialog(void)
{
	int x,y,q;

	x = dialog->rc.x;
	y = dialog->rc.y + 4;
	for (q = 0; q < 8; q++)
		scputf(x + 7, y + q, 0, 3, "%X", at_background[q] >> 4);
	for (q = 0; q < 6; q++)
		scputs(x + 24, y + q + 1, 0, 0, cp_panelcolor[q]);
	for (q = 0; q < 16; q++)
		scputf(x + 19, y + q, MKAT(B_Dialog, q), 3, "%X", at_foreground[q]);
	edc_putattrib(dialog);
	for (q = 0; q < 16; q++)
		scputs(x + 46, y + q, 0, 0, cp_editcolor[q]);
	scputs(x +  4, y - 2,  0, 0, cp_editcolor[16]);
	scputs(x + 16, y - 2,  0, 0, cp_editcolor[17]);
	scputs(x + 35, y,      0, 0, cp_editcolor[16]);
	scputs(x + 35, y + 8,  0, 0, cp_editcolor[17]);
	scputs(x + 35, y + 12, 0, 0, cp_editcolor[18]);
}

int editattrib(void)
{
	int q;
	COLOR edc;

	if ((dialog = rsopen(IDD_EditColor)) == NULL)
		return 0;
	memcpy(&edc, at_background, 40);
	tdshow(dialog);
	for (q = 0; q < ID_OK; q++)
		dialog->object[q].proc = attrib_event;
	update_dialog();
	q = rsevent(IDD_EditColor, dialog);
	tdclose(dialog);
	if (q == 0) {
		LoadColor(&edc);
		return 0;
	}
	return 1;
}

int attrib_event(void)
{
	int x,y,id,result;

	x = dialog->rc.x;
	y = dialog->rc.y;
	for (id = 0; id < 8; id++)
		scputf(x + 7, y + 4 + id, 0, 3, "%X ", at_background[id] >> 4);
	for (; id < 16; id++)
		scputf(x + 19, y + 4 + id, 0, 3, "%X ", at_foreground[id]);
	result = tdxcellevent(dialog, &dialog->object[dialog->index]);
	x = 0;
	id = dialog->index;
	if (result == PGUP) {
		if (id < 8) {
			if (at_background[id] < 0x70) {
				at_background[id] += 0x10;
				x++;
			}
		} else {
			if (at_foreground[id - 8] < 0x0F) {
				at_foreground[id - 8]++;
				x++;
			}
		}
	} else if (result == PGDN) {
		if (id < 8) {
			if (at_background[id] >= 0x10) {
				at_background[id] -= 0x10;
				x++;
			}
		} else {
			if (at_foreground[id - 8] >= 0x01) {
				at_foreground[id - 8]--;
				x++;
			}
		}
	}
	if (x != 0) {
		tdhide(dialog);
		rsreload(IDD_EditColor, dialog);
		tdshow(dialog);
		update_dialog();
	}
	return result;
}
