/*
 * FWRITE.C
 *
 *  This file is part of DOSZIP
 *  Copyright (c) 1996 Hjort Nidudsson.
 */

#include <io.h>
#include <errno.h>
#include <string.h>
#include <stdio.h>

size_t fwrite(const void *buffer, size_t size, size_t num, FILE *o)
{
	const char *data;
	unsigned total;
	unsigned count;
	unsigned bufsize;
	unsigned nbytes;
	unsigned nwritten;
	int c;

	data = buffer;
	count = total = size * num;
	if (0 == count)
		return 0;
	if (anybuf(o))
		bufsize = o->bufsize;
	else
		bufsize = _MAXIOBUF;
	while (count != 0) {
		if (bigbuf(o) && o->cnt != 0)	{
			nbytes = (count < (unsigned)o->cnt) ? count : o->cnt;
			memcpy(o->bp, data, nbytes);
			count -= nbytes;
			o->cnt -= nbytes;
			o->bp += nbytes;
			data += nbytes;
		} else if (count >= bufsize) {
			if (bigbuf(o)) {
				if (fflush(o))
					return (total - count) / size;
			}
			nbytes = (bufsize ? (count - count % bufsize) : count);
			nwritten = write(_fileno(o), data, nbytes);
			if (nwritten == (unsigned)EOF) {
				o->flag |= _IOERR;
				return (total - count) / size;
			}
			count -= nwritten;
			data += nwritten;
			if (nwritten < nbytes) {
				o->flag |= _IOERR;
				return (total - count) / size;
			}
		} else {
			c = *data;
			if (_flsbuf(c, o) == EOF)
				return (total - count) / size;
			++data;
			--count;
			bufsize = o->bufsize > 0 ? o->bufsize : 1;
		}
	}
	return num;
}
