/*
 * WZIPENDS.C
 *
 *  This file is part of DOSZIP
 *  Copyright (c) 1996 Hjort Nidudsson.
 */
#include <io.h>
#include <string.h>
#include <arch.h>
/*
 * return:	0 found
 *		1 not found
 *	       -1 error	open archive
 */
int wzipgetendcentral(WSUB *wp, ZCEN *zp)
{
	int s,c,x,h;
	long coff;
	char *p;
	char rb[512];

	if ((h = wsopenarch(wp)) == -1)
		return -1;
	coff = lseek(h, 0L - sizeof(ZCEN), SEEK_END);
	osread(h, zp, sizeof(ZCEN));
	if (zp->signature == ZID_ENDSENTR) {
		close(h);
		return 0;
	}
	p = rb;
	if (coff < 512)
		coff = 512;
	c = (WORD)coff / 512;
	do {
		if ((coff -= 512) < 0L)
			break;
		lseek(h, coff, SEEK_SET);
		if ((s = osread(h, rb, 512)) == 0)
			break;
		memcpy(zp, rb, sizeof(ZCEN));
		if (zp->signature == ZID_ENDSENTR) {
			close(h);
			return 0;
		}
		x = s;
		do {
			if (p[--x] == 6) {
				if (x < 3)
					coff += (s - 3 + x);
				else if (p[x - 3] == 'P' &&
					 p[x - 2] == 'K' &&
					 p[x - 1] == 5)
					coff += (s + x - 3);
				else
					continue;
				break;
			}
		} while (x);
	} while (c--);
	close(h);
	return 1;
}
