/*
 * CMFBLOCK.C
 *
 *  This file is part of DOSZIP
 *  Copyright (c) 1996 Hjort Nidudsson.
 */
#include <io.h>
#include <time.h>
#include <string.h>
#include <stdlib.h>
#include <ifsmgr.h>
#include <dir.h>
#include <progress.h>
#include <dzmain.h>

#define STATE_IFS	0x0003FFFF
#define STATE_DOS	0x000333FF

enum {	ID_SETRDONLY,
	ID_CLRRDONLY,
	ID_SETARCH,
	ID_CLRARCH,
	ID_SETHIDDEN,
	ID_CLRHIDDEN,
	ID_SETSYSTEM,
	ID_CLRSYSTEM,
	ID_DOSUBDIR,
	ID_MASK,
	ID_DATECREATE,
	ID_TIMECREATE,
	ID_DATEWRITE,
	ID_TIMEWRITE,
	ID_DATEACCESS,
	ID_TIMEACCESS,
	ID_SET,
	ID_CANCEL,
	ID_MNUFRAME1,
	ID_MNUFRAME2,
	ID_MNUFRAME3,
	ID_STATICTEXT1,
	ID_STATICTEXT2,
	ID_STATICTEXT3,
	ITEMCOUNT	};

const char
	cp_ldatefrm	[] = "%02d.%02d.%d",
	cp_ltimefrm	[] = "%02d:%02d:%02d";
static char
	__spath		[WMAXPATH];
static wfblk
	ifsblock;
static unsigned char
	clr_attrib,
	set_attrib;
static int
	setnewdate,
	setnewattrib;
static unsigned
	time_access,
	time_create,
	time_modified,
	date_access,
	date_create,
	date_modified;

static int __setfdate(const char *, const char *);
static int __setfattr(const char *, char);
static int __dodirectory(const char *);
static int __dofiles(const char *, wfblk *);
static int __setdirectory(DOBJ *, const char *);
static int __setfile(char *, const char *, char);

int crename(const char *oldname, const char *newname)
{
	if (strcmp(oldname, newname)) {
		if (rename(oldname, newname) == 0)
			return 1;
	}
	return 0;
}

int cmblkprop(void)
{
	int 	q;
	int	flag_init;
	int	flag_exit;
	char *	p;
	FBLK *	b;
	DOBJ *	dp;
	BYTE	clear;

	if (!(b = cpanel_findfirst()))
		return 0;
	if (ISARCHIVE(b->flag)) {
		notsup();
		return 0;
	}
	if (fullpath(__spath, 0) == NULL)
		return 0;
	fp_maskp = cp_stdmask;
	fp_fileblock = __dofiles;
	fp_directory = __dodirectory;
	if ((dp = rsopen(IDD_PROPERTY)) == 0)
		return 0;
	p = dp->object[ID_MASK].data;
	if (_ifsmgr) {
		_ifsmgr = 0;
		if ((q = wfindfirst(b->name,  &ifsblock, b->flag & 0xFF)) != -1) {
			wcloseff(q);
			strcpy(p, ifsblock.name);
		} else {
			twclose(dp);
			return 0;
		}
		_ifsmgr = 1;
	} else {
		strcpy(p, b->name);
		ifsblock.attrib = (b->flag & _A_FATTRIB);
		ifsblock.date_modified = b->date;
		ifsblock.time_modified = b->time;
		ifsblock.time_create = 0;
		ifsblock.date_create = 0;
		ifsblock.time_access = 0;
		ifsblock.date_access = 0;
	}
	dwtolstr(dp->object[ID_DATEACCESS].data, ifsblock.date_access);
	dwtolstr(dp->object[ID_DATECREATE].data, ifsblock.date_create);
	twtostr(dp->object[ID_TIMEACCESS].data, ifsblock.time_access);
	twtostr(dp->object[ID_TIMECREATE].data, ifsblock.time_create);
	dwtolstr(dp->object[ID_DATEWRITE].data, ifsblock.date_modified);
	twtostr(dp->object[ID_TIMEWRITE].data, ifsblock.time_modified);
	if (ISSELECTED(b->flag)) {
		dp->object[ID_CLRRDONLY].flag |= _O_FLAGB;
		strcpy(p, cpanel->ide->mask);
	} else {
		if (ISRDONLY(ifsblock.attrib))
			dp->object[ID_SETRDONLY].flag |= _O_FLAGB;
		if (ISARCH(ifsblock.attrib))
			dp->object[ID_SETARCH].flag |= _O_FLAGB;
		if (ISHIDDEN(ifsblock.attrib))
			dp->object[ID_SETHIDDEN].flag |= _O_FLAGB;
		if (ISSYSTEM(ifsblock.attrib))
			dp->object[ID_SETSYSTEM].flag |= _O_FLAGB;
	}
	if (ISCDROOM(b->flag)) {
		for (q = 0; q < ID_CANCEL - 1; q++)
			dp->object[q].flag |= _O_STATE;
	}
	if (_ifsmgr == 0) {
		dp->object[ID_TIMEACCESS].flag |= _O_STATE;
		dp->object[ID_DATEACCESS].flag |= _O_STATE;
		dp->object[ID_TIMECREATE].flag |= _O_STATE;
		dp->object[ID_DATECREATE].flag |= _O_STATE;
	}
	flag_init = tdgetbitflag(dp->object, ID_DOSUBDIR + 1, _O_FLAGB);
	tdinit(dp);
	twshow(dp);
	if (tdevent(dp) == 0) {
		twclose(dp);
		return 0;
	}
	flag_exit = tdgetbitflag(dp->object, ID_DOSUBDIR + 1, _O_FLAGB);
	setnewattrib = (flag_exit ^ flag_init);
	set_attrib   = 0;
	clr_attrib   = ~_A_SUBDIR;
	if (dp->object[ID_SETRDONLY].flag & _O_FLAGB)
		set_attrib = _A_RDONLY;
	if (dp->object[ID_SETARCH].flag & _O_FLAGB)
		set_attrib |= _A_ARCH;
	if (dp->object[ID_SETHIDDEN].flag & _O_FLAGB)
		set_attrib |= _A_HIDDEN;
	if (dp->object[ID_SETSYSTEM].flag & _O_FLAGB)
		set_attrib |= _A_SYSTEM;
	if (set_attrib != 0)
		setnewattrib = 1;
	clear = clr_attrib;
	if (dp->object[ID_CLRRDONLY].flag & _O_FLAGB)
		clr_attrib &= ~_A_RDONLY;
	if (dp->object[ID_CLRARCH].flag & _O_FLAGB)
		clr_attrib &= ~_A_ARCH;
	if (dp->object[ID_CLRHIDDEN].flag & _O_FLAGB)
		clr_attrib &= ~_A_HIDDEN;
	if (dp->object[ID_CLRSYSTEM].flag & _O_FLAGB)
		clr_attrib &= ~_A_SYSTEM;
	if (clr_attrib != clear)
		setnewattrib = 1;
	time_access   = strtotw(dp->object[ID_TIMEACCESS].data);
	time_create   = strtotw(dp->object[ID_TIMECREATE].data);
	time_modified = strtotw(dp->object[ID_TIMEWRITE].data);
	date_access   = strtodw(dp->object[ID_DATEACCESS].data);
	date_create   = strtodw(dp->object[ID_DATECREATE].data);
	date_modified = strtodw(dp->object[ID_DATEWRITE].data);
	if (	time_access   == ifsblock.time_access 	&&
		date_access   == ifsblock.date_access)
		date_access    = time_access = 0;
	if (	time_create   == ifsblock.time_create	&&
		date_create   == ifsblock.date_create)
		date_create    = time_create = 0;
	if (	time_modified == ifsblock.time_modified	&&
		date_modified == ifsblock.date_modified)
		date_modified  = time_modified = 0;
	setnewdate =
		time_access   +
		time_create   +
		time_modified +
		date_access   +
		date_create   +
		date_modified;
	if (setnewdate == 0 && setnewattrib == 0) {
		if (ISSELECTED(b->flag) || ISSUBDIR(b->flag)) {
			twclose(dp);
			return 0; /* nothing to do.. */
		}
	}
	progress_open(cp_property, "");
	progress_set(NULL, cpanel->ide->path, 0);
	do {
		if (ISSUBDIR(b->flag)) {
			if (__setdirectory(dp, b->name))
				break;
		} else {
			if (ISSELECTED(b->flag) == 0)
				crename(b->name, dp->object[ID_MASK].data);
			p = wshortname(b->name);
			__setfdate(__spath, p);
			__setfattr(p, b->flag & _A_FATTRIB);
		}
		b->flag &= ~(_A_SELECTED);
		if (getesc())
			break;
	} while ((b = panel_ffselected(cpanel)) != NULL);
	progress_close();
	twclose(dp);
	if (panel_state(&panela))
		panel_update_fcb(&panela);
	if (panel_state(&panelb))
		panel_update_fcb(&panelb);

	return 0;
}

int __setfdate(const char *p, const char *fn)
{
	int handle;
	char fname[WMAXPATH];

	if (setnewdate == 0)
		return 0;
	if (fn != NULL)
		strfcat(fname, p, fn);
	else
		strcpy(fname, p);
	if (_ifsmgr) {
		if (date_modified)
			wsetwrdate(fname, date_modified, time_modified);
		if (date_access)
			wsetacdate(fname, date_access);
		if (date_create)
			wsetcrdate(fname, date_create, time_create);
		return 0;
	}
	if ((handle = osopen(fname, _A_NORMAL, M_RDONLY, A_OPEN)) != -1) {
		if (date_modified)
			setfdate(handle, date_modified, time_modified);
		close(handle);
		return 0;
	}
	return -1;
}

int __setfattr(const char *file, char attrib)
{
	char newattrib;

	if (setnewattrib == 0)
		return 0;
	newattrib = attrib;
	newattrib |= set_attrib;
	newattrib &= clr_attrib;
	if (newattrib == attrib)
		return 0;
	if (ISSUBDIR(attrib)) {
		if (setfattr(file, 0) == 0)
			return setfattr(file, newattrib & ~_A_SUBDIR);
		return -1;
	}
	return setfattr(file, newattrib);
}

int __setfile(char *p, const char *fn, char attrib)
{
	wfblk ff;

	ff.attrib = attrib;
	strcpy(ff.name, fn);
	return __dofiles(p, &ff);
}

int __dofiles(const char *p, wfblk *wf)
{
	char fname[WMAXPATH];

	if (getesc())
		return 1;
	progress_set(NULL, wf->name, 1);
	if (__setfdate(p, wf->name) == 0)
		return __setfattr(strfcat(fname, p, wf->name), wf->attrib);

	return -1;
}

int __dodirectory(const char *p)
{
	char attrib;

	progress_set(NULL, p, 0);
	delay(60);
	if (scan_files(p) == 0) {
		if ((attrib = getfattr(p)) != -1)
			__setfattr(p, attrib);
		return  __setfdate(p, NULL);
	}
	return -1;
}

int __setdirectory(DOBJ *dp, const char *name)
{
	char attrib;
	char fname[WMAXPATH];

	strfcat(fname, __spath, wshortname(name));
	if (dp->object[ID_DOSUBDIR].flag & _O_FLAGB)
		return scan_directory(0, fname);
	if ((attrib = getfattr(fname)) != -1)
		__setfattr(fname, attrib);
	return  __setfdate(fname, NULL);
}