;
; ENVIRON.ASM
;
; This file is part of DOSZIP
; Copyright (c) 1996 Hjort Nidudsson.
;
; Search environment for variables: COMSPEC, PATH, TEMP and DZ.
;

INCLUDE		clib.inc
INCLUDE		dzmain.inc

		.386p

_DATA		SEGMENT

dzexe		DD	0
dzerrno		DW	0
dzerflag	DW	0
dzcount		DW	0
comspec		DD	0
envpath		DD	0
envtemp		DD	0
envconf		DD	0

_DATA		ENDS

_TEXT		SEGMENT

DZEnviron:	push	di
		mov	ax,envseg
		mov	ES,ax
		xor	ax,ax
		mov	bx,ax
		mov	di,ax
		mov	cx,7FFFh
		cld
		jmp	SHORT @@cmpcoms
@@env_COMSPEC: 	cmp	DWORD PTR ES:[di+4],'=CEP'
		jne	SHORT @@envloop
		mov	dx,di
		add	dx,8
		mov	WORD PTR [comspec],dx
		mov	WORD PTR [comspec+2],ES
		jmp	SHORT @@envloop
@@env_PATH:	cmp	BYTE PTR ES:[di+4],'='
		jne	SHORT @@envloop
		mov	dx,di
		add	dx,5
		mov	WORD PTR [envpath],dx
		mov	WORD PTR [envpath+2],ES
		jmp	SHORT @@envloop
@@env_TEMP:	cmp	BYTE PTR ES:[di+4],'='
		jne	SHORT @@envloop
		mov	dx,di
		add	dx,5
		mov	WORD PTR [envtemp],dx
		mov	WORD PTR [envtemp+2],ES
		jmp	SHORT @@envloop
@@env_DZ:	cmp	BYTE PTR ES:[di+2],'='
		jne	SHORT @@envloop
IFDEF DEBUG
		jmp	SHORT @@envloop
ENDIF
		mov	dx,di
		add	dx,3
		mov	WORD PTR [envconf],dx
		mov	WORD PTR [envconf+2],ES
@@envloop:	repnz	scasb
		jcxz	SHORT @@toend
		inc	bx
@@cmpcoms:	cmp	DWORD PTR ES:[di],'SMOC'
		je	SHORT @@env_COMSPEC
		cmp	DWORD PTR ES:[di],'HTAP'
		je	SHORT @@env_PATH
		cmp	DWORD PTR ES:[di],'PMET'
		je	SHORT @@env_TEMP
		cmp	WORD PTR ES:[di],'ZD'
		je	SHORT @@env_DZ
		cmp	ES:[di],al
		jne	SHORT @@envloop
@@toend:	pop	di
		ret

InitDZEXE:	xor	ax,ax
		mov	ES,ax
		mov	bx,03C4h
		les	bx,ES:[bx]
		mov	eax,ES:[bx]
		mov	edx,ES:[bx+4]
		les	bx,ES:[bx+4]
		cmp	eax,50495A44h
		je	SHORT @@Loaded
		xor	ax,ax
		ret
@@Loaded:	mov	dzexe,edx
		add	bx,208
		mov	ax,ES:[bx]
		mov	dzerrno,ax
		mov	ax,ES:[bx+2]
		mov	dzerflag,ax
		mov	ax,ES:[bx+4]
		mov	dzcount,ax
		ret

_TEXT		ENDS

INITPROC	DZEnviron 0 90
INITPROC	InitDZEXE 0 91

		END
