/* BUILD.C--
 *
 * build <root_directory> [<ini_section>]
 *
 * creates:
 * <root_directory>/doszip.txt
 * <root_directory>/dzbin???.txt
 * <root_directory>/dzscr???.txt
 * <root_directory>/inc/build.inc
 * <root_directory>/inc/version.inc
 */

#include <stdio.h>
#include <time.h>
#include <ini.h>
#include <dir.h>
#include <stdlib.h>
#include <string.h>

char build_dir[WMAXPATH];

char build_inc	[] = "inc\\build.inc";
char version_inc[] = "inc\\version.inc";
char doszip_txt	[] = "doszip.txt";
char dzbin_txt	[] = "dzbin138.txt";
char dzsrc_txt	[] = "dzsrc138.txt";

char  SectionBuild[] = "Build";

#define MAXBUILDENTRIES	25

char *BuildINI[MAXBUILDENTRIES] = {
	"MaxHeap",
	"MinHeap",
	"HeapMargin",
	"StackSize",
	"ExtendHeap",
	"C0ARGV",
	"C0INT24",
	"C0INT23",
	"C0BSS",
	"C0CONST",
	"C0INIT",
	"C0EXIT",
	"LongFileNames",
	"Mouse",
	"Clipboard",
	"Textview",
	"ViewMemory",
	"ReadZIP",
	"Unzip",
	"Crypt",
	"Packer",
	"FindFile",
	"Calendar",
	"ColorEdit",
	"MemConfig"
};

char *BuildINC[MAXBUILDENTRIES] = {
	"MAXHEAPSIZE",
	"MINHEAPSIZE",
	"HEAPMARGIN",
	"STACKLENGTH",
	"USE_EXTENDHEAP",
	"USE_C0ARGV",
	"USE_C0INT24",
	"USE_C0INT23",
	"USE_C0BSS",
	"USE_C0CONST",
	"USE_C0INIT",
	"USE_C0EXIT",
	"USE_IFSMGR",
	"USE_MOUSE",
	"USE_CLIPBOARD",
	"USE_TEXTVIEW",
	"USE_MEMREAD",
	"USE_READZIP",
	"USE_UNZIP",
	"USE_CRYPT",
	"USE_PACKER",
	"USE_FILEFIND",
	"USE_CALENDAR",
	"USE_COLOREDIT",
	"USE_MEMCONFIG"
};

char *BuildCMT[] = {
	"",
	"",
	"",
	"",
	"; Expand memory if needed",
	"; Include Args (_argc, _argv)",
	"; Hook Int 24h (error)",
	"; Hook Int 23h (Ctrl-C)",
	"; * if use WCC",
	"; * if use WCC",
	"; Include _INIT_",
	"; Include _EXIT_",
	"; Long File Name functions",
	"; Mouse functions",
	"; Windows clipboard functions",
	"; Memory IO-functions (Text View)",
	"; Read ZIP Files",
	"; Inline unzip",
	"; Password encryption",
	"; Inline Packer",
	"; Inline Text View",
	"; Inline File Find",
	"; Inline Calendar",
	"; Edit Color",
	"; Store config in memory (CD-BOOT)"
};

long build_flags[MAXBUILDENTRIES];


int version = 0x0150;
int minvers = 0x0138;
int ver_h = 1;
int ver_l = 50;
int date_modified;
int time_modified;

char format_version_inc[] =
"DZVERSION\t=\t%04Xh\n"
"MINVERSION\t=\t%04Xh\n"
"\n"
"DOSZIP_VSTR\tEQU\t<'%d.%01d%01d'>\n"
"DOSZIP_TIME\tEQU\t<'%02u:%02u:%02u'>\n"
"DOSZIP_DATE\tEQU\t<'%04u-%02u-%02u'>\n"
"DOSZIP_DSTR\tEQU\t<'%02u %s %d'>\n"
;
char mndl[12][4] = {
	"Jan", "Feb", "Mar", "Apr", "May", "Jun",
	"Jul", "Aug", "Sep", "Oct", "Nov", "Dec"
};
char mnd[12][4] = {
	"JAN", "FEB", "MAR", "APR", "MAY", "JUN",
	"JUL", "AUG", "SEP", "OCT", "NOV", "DEC"
};

char format_dzsrc_txt[] =
"Name                : DOSZIP\n"
"Version             : %d.%02d\n"
"Filename            : DZ%s%d%02d.ZIP\n"
"FileDate            : %02u%s%02u\n"
"Status              : BETA\n"
"E-Mail              : nidud@users.sourceforge.net\n"
"Homepage            : http://sourceforge.net/projects/doszip/\n"
"File Location       : http://sourceforge.net/projects/doszip/\n"
"\n"
"The version of the source code and binary files is the date\n"
"and time in the .ZIP file (1:00 == v1.00)\n"
"\n"
"The .ZIP files are:\n"
"DZBIN???.ZIP - Program files\n"
"DZSRC???.ZIP - Source code\n"
;

char format_doszip_txt[] =
"DOSZIP.TXT--\n"
"Copyright %d Hjort Nidudsson.\n"
"\n"
"DOSZIP COMMANDER\n"
"Version %d.%02d\n"
"\n"
"Welcome to Doszip Commander Version %d.%02d!\n"
;

char buf[WMAXPATH];
char tmp[WMAXPATH];

int main(int argc, char *argv[])
{
	int q;
	char *p;
	FILE *fp, *bp;

	if (argc < 2) {
		printf("Syntax error: build <root_directory>  [<ini_section>]\n");
		return 1;
	}
	strcpy(build_dir, argv[1]);
	p = inientry("Version", "Version", NULL);
	if (p != NULL) {
		version = strtol(p);
		ver_h = version >> 8;
		ver_l = (version & 0x000F) + ((version & 0x00F0) >> 4) * 10;
	} else {
		printf("Syntax error: Missing [Version] ini section\n");
		return 1;
	}
	p = inientry("Version", "MinVersion", NULL);
	if (p != NULL) {
		minvers  = strtol(p);
	}
	time_modified = ((ver_h << 11) | (ver_l << 5));
	date_modified = dwdosdate();

	strfcat(tmp, build_dir, version_inc);
	if ((fp = fopen(tmp, "wt+")) == NULL) {
		perror(tmp);
		return 1;
	}
	fprintf(fp, format_version_inc,
		version,
		minvers,
		version >> 8,
		(version >> 4) & 0x0F,
		version & 0x0F,
		gethour(),
		getmin(),
		getsec(),
		getyear(),
		getmnd(),
		getday(),
		getday(),
		mndl[getmnd()-1],
		getyear()
		);
	fclose(fp);
	wsetwrdate(tmp, date_modified, time_modified);

	sprintf(dzbin_txt + 5, "%d%02d.txt", ver_h, ver_l);
	sprintf(dzsrc_txt + 5, "%d%02d.txt", ver_h, ver_l);
	strfcat(tmp, build_dir, dzbin_txt);
	if ((fp = fopen(tmp, "wt+")) == NULL) {
		perror(tmp);
		return 1;
	}
	fprintf(fp, format_dzsrc_txt,
		ver_h, ver_l,
		"BIN", ver_h, ver_l,
		getday(), mnd[getmnd()-1], getyear() - 2000
		);
	fclose(fp);
	wsetwrdate(tmp, date_modified, time_modified);

	strfcat(tmp, build_dir, dzsrc_txt);
	if ((fp = fopen(tmp, "wt+")) == NULL) {
		perror(tmp);
		return 1;
	}
	fprintf(fp, format_dzsrc_txt,
		ver_h, ver_l,
		"SRC", ver_h, ver_l,
		getday(), mnd[getmnd()-1], getyear() - 2000
		);
	fclose(fp);
	wsetwrdate(tmp, date_modified, time_modified);

	strfcat(tmp, build_dir, "src\\readme.txt");
	if ((fp = fopen(tmp, "rt")) == NULL) {
		perror(tmp);
		return 1;
	}
	strfcat(tmp, build_dir, doszip_txt);
	if ((bp = fopen(tmp, "wt+")) == NULL) {
		perror(tmp);
		fclose(fp);
		return 1;
	}
	fprintf(bp, format_doszip_txt,
		getyear(), ver_h, ver_l, ver_h, ver_l);
	while (fgets(buf, 128, fp) != NULL) {
		fputs(buf, bp);
	}
	fclose(fp);
	fclose(bp);
	wsetwrdate(tmp, date_modified, time_modified);

	memzero(build_flags, sizeof(build_flags));
	for (q = 0; q < MAXBUILDENTRIES; q++) {
		p = inientry(SectionBuild, BuildINI[q], NULL);
		if (p != NULL)
			build_flags[q] = strtol(p);
	}
	if (argc == 3) {
		for (q = 0; q < MAXBUILDENTRIES; q++) {
			p = inientry(argv[2], BuildINI[q], NULL);
			if (p != NULL)
				build_flags[q] = strtol(p);
		}
	}
	strfcat(tmp, build_dir, build_inc);
	if ((bp = fopen(tmp, "wt+")) == NULL) {
		perror(tmp);
		return 1;
	}
	fprintf(bp, "; BUILD.INC--\n; Auto generated include file\n;\n");
	for (q = 0; q < 3; q++)
		fprintf(bp, "%s\t= %04lXh\t; para\n", BuildINC[q], build_flags[q] >> 4);
	fprintf(bp, "%s\t= %04lXh\t; byte\n", BuildINC[q], build_flags[q]);
	++q;
	fprintf(bp, "\n");
	for (; q < MAXBUILDENTRIES; q++)
		fprintf(bp, "%s\t= %ld\t%s\n", BuildINC[q], build_flags[q], BuildCMT[q]);
	fclose(bp);
	return 0;
}
