; DZ.ASM--
; Copyright (c) 1996-2010 Hjort Nidudsson
;
; This program is free software; you can redistribute it and/or modify
; it under the terms of the GNU General Public License as published by
; the Free Software Foundation; either version 2 of the License, or
; (at your option) any later version.
;
; This program is distributed in the hope that it will be useful,
; but WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
; GNU General Public License for more details.
;

	.186
	.model	tiny

include	build.inc
include	version.inc

if USE_MEMCONFIG
PROGRAMSIZE	EQU	2048
else
PROGRAMSIZE	EQU	1024
endif

DZCONFIG	STRUC
dz_envlen	DW ?
dz_envseg	DW ?
dz_command	DW 2 dup(?)
dz_fcb_0P	DW 2 dup(?)
dz_fcb_1P	DW 2 dup(?)
dz_dzmain	DB 80 dup(?)
dz_dzcommand	DB 128 dup(?)
dz_fcb_160	DB 16 dup(?)
dz_fcb_161	DB 16 dup(?)
dz_exeproc	DB 80 dup(?)
dz_execommand	DB 128 dup(?)
dz_errno	DW ?
dz_eflag	DW ?
dz_count	DW ?
dz_exename	DW ?
dz_oldintF1	DD ?
DZCONFIG	ENDS

	.code

	org	100h

Config	LABEL	DZCONFIG
start:	jmp	around
	DB	10
Copyright 	LABEL BYTE
	DB	'The Doszip Commander, BETA Version ',DOSZIP_VSTR,13,10
	DB	'Copyright (c) 1996-2010 Hjort Nidudsson',13,10,13,10,'$'

InvalidEnviron	LABEL BYTE
	DB	'Environment invalid',13,10,'$'

around:	mov	AH,9
	mov	DX,OFFSET Copyright
	int	21h
	mov	SI,OFFSET Config
	mov	BX,002Ch
	mov	AX,[BX]
	mov	[SI.dz_envseg],AX
	mov	BP,ES
	mov	BX,PROGRAMSIZE/16
	mov	AH,4Ah
	int	21h
	mov	SP,PROGRAMSIZE-2
	mov	BX,[SI.dz_envseg]
	mov	ES,BX
	xor	AX,AX
	mov	DI,AX
	mov	CX,7FFFh
	cld
environ_loop:
	repnz	scasb
	or	CX,CX
	jz	errorlevel_10
	cmp	ES:[DI],AL
	jne	environ_loop
	or	CH,80h
	neg	CX
	jmp	init_vector

errorlevel_10:
	mov	DX,OFFSET InvalidEnviron
	mov	AH,9
	int	21h
	mov	AX,4C0Ah
	int	21h

init_vector:
	mov	AX,DS
	mov	VECTOR+6,AX
	mov	VECTOR+4,OFFSET Config.dz_exeproc
	mov	[SI.dz_fcb_0P+2],AX
	mov	[SI.dz_fcb_1P+2],AX
	mov	[SI.dz_fcb_0P],OFFSET Config.dz_fcb_160
	mov	[SI.dz_fcb_1P],OFFSET Config.dz_fcb_161
	mov	[SI.dz_command+2],AX
	mov	DX,AX
	mov	DI,CX
	add	DI,2
	mov	SI,DI
	mov	CX,-1
	xor	AX,AX
	repnz	scasb
	not	CX
	push	CX
	mov	ES,DX
	mov	DI,OFFSET Config.dz_dzmain
	mov	DS,BX
	rep	movsb
	mov	DS,DX
	mov	ES,DX
	mov	BX,DI
	mov	DI,OFFSET Config.dz_fcb_160
	mov	SI,OFFSET Config.dz_dzmain
	mov	AX,2901h
	int	21h
	mov	CX,8
	lea	DI,[BX-5]
	mov	SI,OFFSET DZMAIN
	rep	movsb
	xor	AX,AX
	stosb
	mov	DI,OFFSET Config.dz_dzcommand
	mov	SI,128
	mov	DS,BP
	mov	CX,128
	rep	movsb
	mov	DS,DX
	mov	AX,4300h
	mov	DX,OFFSET Config.dz_dzmain
	int	21h
	pop	DI
	jc	file_not_found
if USE_MEMCONFIG
	xor	AX,AX
	mov	VECTOR+8,AX
endif
	jmp	main

file_not_found:
	mov	DX,OFFSET NOFILE
	mov	CX,15
	call	write
	mov	CX,DI
	add	CX,4
	mov	DX,OFFSET Config.dz_dzmain
	call	write
	mov	AX,2
	jmp	toend

write:	mov	AH,40h
	mov	BX,2
	int	21h
	ret

	DB	10
	DB	'$Id: DZ.ASM ',DOSZIP_DATE,' ',DOSZIP_TIME,10
	DB	' 2 '
NOFILE	DB	'File not found '
	DB	'DZ'
DZMAIN	DB	'MAIN.EXE',13,10
	DB	' 5 access',10
	DB	' 8 memory',10
	DB	'10 environ',10
	DB	60 dup('*')

	ORG	SIZE DZCONFIG - 12 + 100h

	DW	0
	DW	0
	DW	0
	DW	0A00h
	DD	3A534F44h

main:	mov	AX,35F1h
	int	21h
	mov	SI,OFFSET Config
	mov	WORD PTR [SI.dz_oldintF1],BX
	mov	WORD PTR [SI.dz_oldintF1+2],ES
	mov	AX,25F1h
	mov	DX,OFFSET VECTOR
	int	21h
	mov	Config.dz_exename,OFFSET Config.dz_dzmain
	mov	Config.dz_command,OFFSET Config.dz_dzcommand
spawn:  mov	BX,DS
	mov	ES,BX
	mov	DI,OFFSET Config.dz_fcb_161
	mov	SI,Config.dz_exename
	mov	AX,2901h
	int	21h
	mov	ES,BX
	mov	BX,OFFSET Config.dz_envseg
	mov	DX,Config.dz_exename
	mov	AX,4B00h
	int	21h
	mov	DX,CS
	mov	DS,DX
	jc	error
	xor	AX,AX
error:	mov	SI,OFFSET Config
	mov	[SI.dz_errno],AX
	mov	AX,4D00h
	int	21h
	mov	[SI.dz_eflag],AX
	cmp	[SI.dz_exename],OFFSET Config.dz_dzmain
	jne	main
	mov	DI,AX
	mov	AX,25F1h
	lds	DX,[SI.dz_oldintF1]
	int	21h
	mov	AX,CS
	mov	DS,AX
	mov	AX,DI
	cmp	AL,23
	jne	toend
	inc	[SI.dz_count]
	mov	[SI.dz_exename],OFFSET Config.dz_exeproc
	mov	[SI.dz_command],OFFSET Config.dz_execommand
	jmp	spawn
toend:  mov	AH,4Ch
	int	21h
VECTOR  LABEL   WORD
	DD	50495A44h
	DD	564A4A0Ah
ENDCODE	LABEL	WORD

	END	start
