include doszip.inc
include string.inc
include dir.inc
include stdio.inc
include errno.inc
include syserrls.inc
include dos.inc
include io.inc

;DEBUG_DZEXE=1

	.186

	public	dzexe
	public	dzcount
	public	comspec
	public	envpath
	public	envtemp
	public	configfile
	public	configextp
	public	programpath
	public	argvfile
if USE_MEMCONFIG
	public	memcfg
endif

_DZIP	SEGMENT

CMP_ENVSTRING PROC
	PUSH	DI
CMP_NEXT:
	MOV	AH,ES:[DI]
	LODSB
	INC	DI
	CMP	AL,AH
	JE	CMP_NEXT
	ADD	AL,AH
	CMP	AL,'='
	POP	DI
	RET
CMP_ENVSTRING ENDP

CMP_ENVIRON PROC
	MOV	SI,OFFSET CP_DZ
	CALL	CMP_ENVSTRING
	JNZ	CMP_TEMP
	MOV	SI,OFFSET envconf
	MOV	AX,3
	JMP	CMP_FOUND
CMP_TEMP:
	MOV	SI,OFFSET CP_TEMP
	CALL	CMP_ENVSTRING
	JNZ	CMP_PATH
	MOV	SI,OFFSET envtemp
	MOV	AX,5
	JMP	CMP_FOUND
CMP_PATH:
	MOV	SI,OFFSET CP_PATH
	CALL	CMP_ENVSTRING
	JNZ	CMP_COMSPEC
	MOV	SI,OFFSET envpath
	MOV	AX,5
	JMP	CMP_FOUND
CMP_COMSPEC:
	MOV	SI,OFFSET CP_COMSPEC
	CALL	CMP_ENVSTRING
	JNZ	CMP_END
	MOV	SI,OFFSET comspec
	MOV	AX,8
CMP_FOUND:
	ADD	AX,DI
	MOV	[SI],AX
	MOV	[SI+2],ES
CMP_END:
	RET
CMP_ENVIRON ENDP

PRINTABORTTYPE PROC
	MOV	AL,BYTE PTR dzerflag
	PUSH	AX
	MOV	AL,BYTE PTR dzerflag+1
	AND	AL,3
	ADD	AX,AX
	MOV	BX,AX
	PUSH	DS
	PUSH	[BX+cp_termintype]
	PUSH	WORD PTR dzexe+2
	PUSH	WORD PTR dzexe
	MOV	AX,OFFSET cp_termination
	CALL	COUT
	ADD	SP,10
	RET
PRINTABORTTYPE	ENDP

VERBOSE	PROC
	XOR	AX,AX
	CMP	AX,dzcount
	JE	VERB_04
	CMP	dzerflag,AX
	JNE	VERB_00
	CMP	dzerrno,AX
	JE	VERB_01
VERB_00:
	CALL	PRINTABORTTYPE
VERB_01:
	CMP	dzerrno,0
	JZ	VERB_04
	MOV	AX,OFFSET cp_system_error
	CALL	COUT
	MOV	AX,dzerrno
	MOV	CX,6
VSWITCH_00:
	CMP	[BX+VERBOSE_ERROR],AL
	JE	VSWITCH_01
	INC	BX
	DEC	CX
	JNZ	VSWITCH_00
	MOV	AX,OFFSET CP_EILSEQ
	JMP	VERB_03
VSWITCH_01:
	ADD	BX,BX
	MOV	AX,[BX+VERBOSE_LABEL]
VERB_03:
	CALL	COUT
VERB_04:
	MOV	AX,1
	RET
VERBOSE	ENDP

DOSZIP_INIT PROC FAR
	PUSH	SI
	PUSH	DI
	MOV	AX,envseg
	MOV	ES,AX
	XOR	DI,DI
	MOV	BX,DI
	MOV	CX,7FFFh
	CLD
INIT_00:
	CALL	CMP_ENVIRON
	MOV	AL,0
	REPNZ	SCASB
	OR	CX,CX
	JZ	INIT_01
	INC	BX
	CMP	ES:[DI],AL
	JNE	INIT_00
INIT_01:
ifdef DEBUG
ifdef DEBUG_DZEXE
	MOV	WORD PTR dzexe,OFFSET VECTOR
	MOV	WORD PTR dzexe+2,DS
endif
endif
	LES	BX,dzexe
ifdef DEBUG
 ifdef DEBUG_DZEXE
 else
	ADD	BX,03C4h
	LES	BX,ES:[BX]
 endif
else
	ADD	BX,03C4h
	LES	BX,ES:[BX]
endif
	MOV	SI,ES:[BX]
	MOV	DI,ES:[BX+2]
	MOV	AX,ES:[BX+6]
if USE_MEMCONFIG
	MOV	DX,BX
	ADD	DX,8
endif
	MOV	BX,ES:[BX+4]
	MOV	ES,AX
	CMP	DI,5049h
	JNE	INIT_02
	CMP	SI,5A44h
	JNE	INIT_02
if USE_MEMCONFIG
	MOV	WORD PTR memcfg,DX
	MOV	WORD PTR memcfg+2,ES
endif
	MOV	WORD PTR dzexe,BX
	MOV	WORD PTR dzexe+2,ES
	ADD	BX,208
	MOV	AX,ES:[BX]
	MOV	dzerrno,AX
	MOV	AX,ES:[BX+2]
	MOV	dzerflag,AX
	MOV	AX,ES:[BX+4]
	MOV	dzcount,AX
INIT_02:
	PUSH	DS
	PUSH	OFFSET programpath
	LES	BX,_argv
	PUSH	WORD PTR ES:[BX+2]
	PUSH	WORD PTR ES:[BX]
	CALL	strcpy
	PUSH	DX
	PUSH	AX
	PUSH	'\'
	CALL	strrchr
	JZ	INIT_03
	MOV	BX,AX
	MOV	BYTE PTR [BX],0
INIT_03:
	MOV	AX,1
	CMP	AX,_argc
	JB	ARGS_00
	JMP	INIT_04
ARGS_00:
	MOV	SI,AX
ARGS_01:
	MOV	AX,SI
	ADD	AX,AX
	ADD	AX,AX
	LES	BX,_argv
	ADD	BX,AX
	MOV	BX,ES:[BX]
	MOV	AL,ES:[BX]
	CMP	AL,'?'
	JE	ARGS_07
	CMP	AL,'/'
	JE	ARGS_02
	CMP	AL,'-'
	JE	ARGS_02
	MOV	WORD PTR argvfile,BX
	MOV	WORD PTR argvfile+2,ES
	JMP	ARGS_08
ARGS_02:
	INC	BX
	MOV	AL,ES:[BX]
	OR	AL,20h
	CMP	AL,'x'
	JNE	ARGS_03
	MOV	AX,dzcount
	OR	AX,AX
	JNZ	ARGS_08
	MOV	AL,03h
	INT	10h
	JMP	ARGS_08
ARGS_03:
	CMP	AL,'v'
	JNE	ARGS_04
	CALL	VERBOSE
	JMP	ARGS_08
ARGS_04:
	CMP	AL,'t'
	JNE	ARGS_05
	MOV	numfblock,500
	JMP	ARGS_08
ARGS_05:
	CMP	AL,'l'
	JNE	ARGS_06
	MOV	numfblock,5000
	JMP	ARGS_08
ARGS_06:
	CMP	AL,'c'
	JNE	ARGS_07
	INC	BX
	PUSH	ES
	PUSH	BX
	PUSH	ES
	PUSH	BX
	CALL	filexist
	CMP	AX,2
	POP	AX
	POP	DX
	JNE	ARGS_07
	PUSH	DS
	PUSH	OFFSET programpath
	PUSH	DX
	PUSH	AX
	CALL	strcpy
	JMP	ARGS_08
ARGS_07:
	MOV	AX,OFFSET _bufin
	CALL	COUT
	CALL	_restorezero
	MOV	AX,4C00h
	INT	21h
ARGS_08:
	INC	SI
	CMP	SI,_argc
	JAE	INIT_04
	JMP	ARGS_01
INIT_04:
	PUSH	DS
	PUSH    OFFSET configfile
	MOV	AX,WORD PTR envconf
	MOV	DX,WORD PTR envconf+2
	OR	AX,AX
	JZ	CONF_00
	PUSH	DX
	PUSH	AX
	PUSH	DX
	PUSH	AX
	CALL	filexist
	CMP	AX,2
	JE	CONF_01
	POP	AX
	POP	DX
CONF_00:
	PUSH	DS
	PUSH	OFFSET programpath
CONF_01:
	PUSH	DS
	PUSH	OFFSET cp_dzdot
	CALL	strfcat
	PUSH	DX
	PUSH	AX
	PUSH	'.'
	CALL	strrchr
	INC	AX
	MOV	configextp,AX
	CALL	configread
INIT_05:
	CMP	WORD PTR comspec,0
	JNZ	INIT_06
	MOV	AX,OFFSET cp_ercomspec
	CALL	COUT
	MOV	WORD PTR comspec,OFFSET CP_DEFAULTCMD
	MOV	WORD PTR comspec+2,DS
INIT_06:
	CALL	getinifile
	PUSH	DX
	PUSH	AX
	CALL	filexist
	OR	AX,AX
	JNZ	INIT_07
	PUSH	OPENINI_WRITE
	CALL	opencfg
	JZ	INIT_07
	PUSH	AX
	PUSH	AX
	PUSH	DS
	PUSH	OFFSET default_ini
	PUSH	DS
	PUSH	OFFSET default_ini
	CALL	strlen
	PUSH	AX
	CALL	oswrite
	CALL	close
INIT_07:
	POP	DI
	POP	SI
	RET
DOSZIP_INIT ENDP

_DZIP	ENDS

_TEXT	SEGMENT
	ASSUME	CS:_TEXT

COUT	PROC	FAR
	MOV	DX,AX
	CALL	@vsbufin
	PUSH	AX
	MOV	CX,AX
	MOV	DX,OFFSET _bufin
	CALL	stderrmsg
	POP	AX
	RET
COUT	ENDP

_TEXT	ENDS

_DATA	SEGMENT

dzexe		DD	0
dzerrno		DW	0
dzerflag	DW	0
dzcount		DW	0
comspec		DD	0
envpath		DD	0
envtemp		DD	0
envconf		DD	0
argvfile	DD	0

CP_DZ		DB	'DZ',0
CP_TEMP		DB	'TEMP',0
CP_PATH		DB	'PATH',0
CP_COMSPEC	DB	'COMSPEC',0
CP_DEFAULTCMD	DB	'COMMAND',0

programpath     DB      0
		DB	MAXPATH-1 dup(0)
configfile      DB      0
		DB	MAXPATH-1 dup(0)
configextp	DW	0

_bufin	DB	"Command line switches",13,10
	DB	" The following switches may be used in the command line:",13,10
	DB	13,10
	DB	"  -T (tiny)  - read maximum 500 files in each panel",13,10
	DB	"  -L (large) - read maximum 5000 files in each panel",13,10
	DB	"     default is 3000.",13,10
	DB	13,10
	DB	"  -XP (WinXP)     - trigger a mode change on startup",13,10
	DB	"  -V (verbose)    - print DOS return code (errorlevel)",13,10
	DB	"  -C<config_path> - Read/Write setup from/to <config_path>",13,10
	DB	13,10
	DB	"  DZ <filename> command starts DZ and forces it to show <filename>",13,10
	DB	"contents if it is an archive or show folder contents if <filename>",13,10
	DB	"is a folder.",13,10,0
	DB	10

	DB	'For more information about DOSZIP, visit the',10
	DB	'Web site at: http://sourceforge.net/projects/doszip/',10
	DB	10
	DB	10
	DB	9,'Hjort Nidudsson - nidud@users.sourceforge.net',10
	DB	9,'Robert Riebisch - bttr@users.sourceforge.net',10
	DB	10
	DB	10
	DB	9,'A special thanks to Kennedy Software & Systems',10
	DB	9,'Ltd in Dublin for technical support and advice.',10
	DB	10

cp_system_error	DB	"System error message: ",0
cp_termination	DB	"**Error** running %s:",13,10
		DB	"Termination type: %s",13,10
		DB	"DOS return code:  %d",13,10,0
cp_termination0	DB	"Normal",0
cp_termination1	DB	"Control-C abort",0
cp_termination2	DB	"Critical error abort",0
cp_termination3	DB	"Terminate and stay resident",0

cp_termintype	DW	OFFSET cp_termination0
		DW	OFFSET cp_termination1
		DW	OFFSET cp_termination2
		DW	OFFSET cp_termination3

cp_ercomspec	DB	'Error loading COMMAND.COM..',13,10,13,10,0

default_ini	LABEL	BYTE
	DB	'; DZ.INI - DOSZIP Configuration file',13,10
	DB	';',13,10
	DB	'; This file contains all the variables that "customize"',13,10
	DB	"; DOSZIP to your particular needs.",13,10
	DB	";",13,10
	DB	"; The entries have the following format:",13,10
	DB	";",13,10
	DB	"; [<Section name>]",13,10
	DB	"; <Entry name>=<properties>",13,10
	DB	";",13,10
	DB	"; Space and tabs may appear before or after the equal sign.",13,10
	DB	";",13,10
	DB	"; Last Updated: 14 Nov 2009",13,10
	DB	";",13,10
	DB	13,10
	DB	"[View]",13,10
	DB	"F3      = ; You can override the internal viewer by redefine F3",13,10
	DB	"Alt     = ; Viewer for Alt+F3",13,10
	DB	"Ctrl    = ; Viewer for Ctrl+F3",13,10
	DB	"Shift   = ; Viewer for Shift+F3",13,10
	DB	13,10
	DB	"[Edit]",13,10
	DB	"F4      = EDIT",13,10
	DB	"Alt     = NOTEPAD ; Editor for Alt+F4",13,10
	DB	"Ctrl    = ; Editor for Ctrl+F4",13,10
	DB	"Shift   = ; Editor for Shift+F4",13,10
	DB	13,10
	DB	"[Filetype] ; This assumes the Borland tools is in the PATH",13,10
	DB	"asm=bc     ; Borland C++",13,10
	DB	"c=bc",13,10
	DB	"h=bc",13,10
	DB	"inc=bc",13,10
	DB	"mak=wmake -f !.!",13,10
	DB	"makefile=wmake -f !.!",13,10
	DB	"prj=bc",13,10
	DB	"txt=bc",13,10
	DB	"idd=rcedit",13,10
	DB	13,10
	DB	"[Directory] ; Directories for Ctrl-[0..9]",13,10
	DB	"00=Doszip &Directory          Ctrl-0, %DOSZIP%",13,10
	DB	"01=Doszip &Source Directory   Ctrl-1, %DOSZIP%\src",13,10
	DB	"02=System &Root               Ctrl-2, %SYSTEMROOT%",13,10
	DB	"03=&Program Files             Ctrl-3, %PROGRAMFILES%",13,10
	DB	"04=&Common Program Files      Ctrl-4, %COMMONPROGRAMFILES%",13,10
	DB	"05=&Application Data          Ctrl-5, %APPDATA%",13,10
	DB	"06=&Temp Directory            Ctrl-6, %TEMP%",13,10
	DB	"07=&Home Path                 Ctrl-7, %HOMEDRIVE%%HOMEPATH%",13,10
	DB	"08=&User Profile              Ctrl-8, %USERPROFILE%",13,10
	DB	"09=A&ll Users Profile         Ctrl-9, %ALLUSERSPROFILE%",13,10
	DB	"10=<>",13,10
	DB	"11=L&ogon Server...,                  %LOGONSERVER%",13,10
	DB	13,10
	DB	"[Tools] ; Tools [0..9] use key Alt-[0..9]",13,10
	DB	"00=&Add tool                   Alt-0, %EDIT% %DOSZIP%\DZ.INI",13,10
	DB	"01=<>",13,10
	DB	"02=&Doszip Commandline         Alt-2, %DOSZIP%\dz -?",13,10
	DB	"03=&View DZ.INI                Alt-3, %VIEW% %DOSZIP%\DZ.INI",13,10
	DB	"04=View &README.TXT            Alt-4, %VIEW% %DOSZIP%\DOSZIP.TXT",13,10
	DB	13,10
	DB	"[Filter]",13,10
	DB	"00=&Executable, *.exe *.com *.bat",13,10
	DB	"01=&Compressed, *.lzh *.zoo *.zip *.arj *.pak *.arc *.7z *.bz2 *.tar",13,10
	DB	13,10
if USE_PACKER
	DB	"[Packer]",13,10
	DB	"00=ZIP",13,10
	DB	"01=7Z",13,10
	DB	"02=TAR",13,10
	DB	"03=BZ2",13,10
	DB	"04=GZ",13,10
	DB	"05=ARJ",13,10
	DB	"06=ARC",13,10
	DB	"07=PAK",13,10
	DB	"08=LZH",13,10
	DB	"09=ZOO",13,10
	DB	13,10
	DB	"[ZIP]",13,10
	DB	"00=pkzip -u -wHS",13,10
	DB	"01=pkzip -u -P -wHS",13,10
	DB	"02=pkunzip -o",13,10
	DB	"03=pkunzip -o -d",13,10
	DB	"04=pkzip -d",13,10
	DB	"05=-ex",13,10
	DB	"06=-es",13,10
	DB	"07=-s",13,10
	DB	"09=@",13,10
	DB	"10=7za u -tzip -y",13,10
	DB	"11=7za u -tzip -y",13,10
	DB	"12=7za e -y",13,10
	DB	"13=7za x -y",13,10
	DB	"14=7za d -y",13,10
	DB	"15=-mx9",13,10
	DB	"16=-mx1",13,10
	DB	"17=-p",13,10
	DB	"18=-o",13,10
	DB	"19=-scsDOS @",13,10
	DB	13,10
	DB	"[7Z]",13,10
	DB	"10=7za u -y",13,10
	DB	"11=7za u -y",13,10
	DB	"12=7za e -y",13,10
	DB	"13=7za x -y",13,10
	DB	"17=-p",13,10
	DB	"18=-o",13,10
	DB	"19=-scsDOS @",13,10
	DB	13,10
	DB	"[TAR]",13,10
	DB	"10=7za u -ttar -y",13,10
	DB	"11=7za u -ttar -y",13,10
	DB	"12=7za e -y",13,10
	DB	"13=7za x -y",13,10
	DB	"17=-p",13,10
	DB	"18=-o",13,10
	DB	"19=-scsDOS @",13,10
	DB	13,10
	DB	"[BZ2]",13,10
	DB	"10=7za u -tbzip2 -y",13,10
	DB	"11=7za u -tbzip2 -y",13,10
	DB	"12=7za e -y",13,10
	DB	"13=7za x -y",13,10
	DB	"17=-p",13,10
	DB	"18=-o",13,10
	DB	"19=-scsDOS @",13,10
	DB	13,10
	DB	"[GZ]",13,10
	DB	"10=7za u -tgzip -y",13,10
	DB	"11=7za u -tgzip -y",13,10
	DB	"12=7za e -y",13,10
	DB	"13=7za x -y",13,10
	DB	"17=-p",13,10
	DB	"18=-o",13,10
	DB	"19=-scsDOS @",13,10
	DB	13,10
	DB	"[ARJ]",13,10
	DB	"00=arj u -y",13,10
	DB	"01=arj u -y",13,10
	DB	"02=arj e -y -e",13,10
	DB	"03=arj x -y",13,10
	DB	"05=-m4",13,10
	DB	"06=-m1",13,10
	DB	"07=-g",13,10
	DB	"09=!",13,10
	DB	13,10
	DB	"[ARC]",13,10
	DB	"00=arc a",13,10
	DB	"01=arc a",13,10
	DB	"02=arc eow",13,10
	DB	"03=arc xow",13,10
	DB	"09=@",13,10
	DB	13,10
	DB	"[PAK]",13,10
	DB	"00=pak u",13,10
	DB	"01=pak u",13,10
	DB	"02=pak e -wa",13,10
	DB	"03=pak e -i -wa",13,10
	DB	"05=/C",13,10
	DB	"06=/CR",13,10
	DB	"09=@",13,10
	DB	13,10
	DB	"[LZH]",13,10
	DB	"00=lharc u -am",13,10
	DB	"01=lharc a -apm",13,10
	DB	"02=lharc e -m",13,10
	DB	"03=lharc e -m",13,10
	DB	13,10
	DB	"[ZOO]",13,10
	DB	"00=zoo -add",13,10
	DB	"01=zoo -add",13,10
	DB	"02=zoo -extract",13,10
	DB	"03=zoo -extract",13,10
	DB	"04=zoo -delete",13,10
	DB	"09=@",13,10
	DB	13,10
endif
	DB	"[%%EOF]",13,10,0
	DB	4096 - ($ - _bufin) dup('*')

	DW	0

cp_dzdot DB	'dz.',0

VERBOSE_ERROR	LABEL BYTE
	DB	2,5,8,1,10,11

VERBOSE_LABEL	LABEL WORD
	DW	OFFSET CP_ENOENT
	DW	OFFSET CP_EACCES
	DW	OFFSET CP_ENOMEM
	DW	OFFSET CP_ENOEXEC
	DW	OFFSET CP_ENOEXEC
	DW	OFFSET CP_ENOEXEC

if USE_MEMCONFIG
memcfg	DD	0
endif

ifdef DEBUG
ifdef DEBUG_DZEXE
VECTOR  LABEL   WORD
	DD	50495A44h
	DW	$ + 512 ;OFFSET _bufin
	DW	SEG _DATA
	DB 1024 dup(0)
endif
endif

_DATA	ENDS

_INIT_	SEGMENT
	DB	1
	DB	20
	DD	_DZIP:DOSZIP_INIT
_INIT_	ENDS

	END
