; SCAN_IO.ASM--
; Copyright (c) 2000 Hjort Nidudsson
;
; 04/16/2000
;
; Change history:
; 09/09/2009 - Modified for JWASM
; 06/17/2004 - Added LFN to scan
;
include	clib.inc
include	dos.inc
include	dir.inc
include	string.inc

	public	fp_maskp
	public	fp_directory
	public	fp_fileblock
	public	scan_fblock

	extrn	cp_stdmask: byte

ATTRIB_ALL	= 37h
ATTRIB_FILE	= 27h

_DATA	SEGMENT

fp_maskp	PD ?
fp_directory	PF ?
fp_fileblock	PF ?
scan_fblock	db SIZE S_WFBLK dup(?)
scan_curpath	db WMAXPATH dup(?)
scan_curfile	db WMAXPATH dup(?)

_DATA	ENDS

_TEXT	SEGMENT

scan_init proc
	mov [bp-12],dx
	mov [bp-10],ds
	mov word ptr [bp-8],offset scan_fblock
	mov [bp-6],ds
	xor ax,ax
	mov [bp-4],ax
	mov [bp-16],ax
      ifdef __LFN__
	.if _ifsmgr
	    ret
	.endif
      endif
	mov ah,2Fh
	int 21h
	mov [bp-16],es
	mov [bp-14],bx
	lea dx,[bp-62]
	mov ah,1Ah
	int 21h
	ret
scan_init endp

scan_findfirst proc
	mov dx,[bp-12]
      ifdef __LFN__
	.if _ifsmgr
	    mov ax,714Eh
	    mov si,1
	    les di,[bp-8]
	    stc
	    int 21h
	    jc scan_error
	    ret
	.endif
      endif
	mov ah,4Eh
	int 21h
	jnc scan_copy
	call restore_DTA
	jmp scan_error
scan_findfirst endp

scan_error proc
	call @dosmaper
	mov ax,-1
	mov dx,ax
	ret
scan_error endp

scan_findnext proc
      ifdef __LFN__
	.if _ifsmgr
	    stc
	    mov ax,714Fh
	    mov bx,[bp-18]
	    mov si,1
	    les di,[bp-8]
	    int 21h
	    jb scan_error
	    mov ax,0
	    ret
	.endif
      endif
	mov ah,4Fh
	int 21h
	jc scan_error
	jmp scan_copy
scan_findnext endp

scan_close proc
      ifdef __LFN__
	.if _ifsmgr
	    mov bx,[bp-18]
	    mov ax,71A1h
	    int 21h
	.else
	    call restore_DTA
	.endif
	ret
      endif
scan_close endp

restore_DTA proc
	mov ax,[bp-16]
	.if ax
	    push ds
	    mov ds,ax
	    mov dx,[bp-14]
	    mov ah,1Ah
	    int 21h
	    pop ds
	.endif
	ret
restore_DTA endp

scan_copy proc
	push si
	les di,[bp-8]
	mov si,di
	mov cx,SIZE S_WFBLK/2
	xor ax,ax
	cld
	rep stosw
	mov di,si
	lea si,[bp-62]
	mov al,[si.ff_attrib]
	mov [di],al
	mov ax,[si.ff_ftime]
	mov [di.wf_timemodified],ax
	mov ax,[si.ff_fdate]
	mov [di.wf_datemodified],ax
	mov ax,word ptr [si.ff_fsize]
	mov word ptr [di.wf_sizeax],ax
	mov ax,word ptr [si.ff_fsize+2]
	mov word ptr [di.wf_sizeax+2],ax
	add si,ff_name
	add di,wf_name
	mov cx,12
	rep movsb
	mov al,0
	stosb
	pop si
	ret
scan_copy endp

scan_directory proc dist pascal public uses ds si di flag:word, path:dword
local locsp_d[62]:byte
	mov dx,offset scan_curpath
	call scan_init
	.if byte ptr flag & 1
	    pushm path
	    call fp_directory
	    mov [bp-4],ax
	    .if ax
		call restore_DTA
		jmp @F
	    .endif
	.endif
	invoke strlen, path
	add ax,offset scan_curpath
	mov [bp-2],ax
	invoke strfcat, [bp-12], path, addr cp_stdmask
	mov cx,ATTRIB_ALL
	.if func(scan_findfirst) != -1
	   mov [bp-18],ax
	   .if !func(scan_findnext)
		.repeat
		    call scan_findnext
		    .break .if ax
		    .continue .if !(scan_fblock & _A_SUBDIR)
		    mov ax,[bp-2]
		    inc ax
		    push ds
		    push ax
		    push [bp-6]
		    mov ax,[bp-8]
		    add ax,wf_name
		    push ax
		    call strcpy
		    invoke scan_directory, flag, [bp-12]
		    mov [bp-4],ax
		.until ax
		call scan_close
	   .endif
	.endif
	xor ax,ax
	mov bx,[bp-2]
	mov [bx],al
      @@:
	mov ax,[bp-4]
	.if !(byte ptr flag & 1)
	    pushm path
	    call fp_directory
	.endif
	ret
scan_directory endp

scan_files proc dist pascal public uses ds si di fpath:dword
local locsp_f[62]:byte
	mov dx,offset scan_curfile
	call scan_init
	invoke strfcat, [bp-12], fpath, fp_maskp
	mov cx,ATTRIB_FILE
	.if func(scan_findfirst) != -1
	    mov [bp-18],ax
	    .repeat
		pushm fpath
		pushm [bp-8]
		call fp_fileblock
		mov [bp-4],ax
		.break .if ax
		call scan_findnext
	    .until ax
	    call scan_close
	.endif
	mov ax,[bp-4]
	ret
scan_files endp

scansub proc dist pascal public spath:dword, smask:dword, sflag:word
	movmm fp_maskp,smask
	invoke scan_directory, sflag, spath
	ret
scansub endp

_TEXT	ENDS

	END
