include	clib.inc
include	alloc.inc
include	errno.inc

mb	struc
mb_size	d? ?
mb_used	d? ?
mb	ends

ifdef	__f__
	public	memseg

	.data
	memseg	dd 0
	brklvl	dd ?
	mavail	dd ?
	.code

getmaxblock:
	push	ecx
	push	ebx
	push	edi
	mov	eax,memseg
	mov	edx,eax		; largest free block
	xor	ecx,ecx		; size of largest free block
    getmaxblock_do:
	cmp	[eax].mb.mb_used,0
	jne	getmaxblock_next
	mov	edi,eax		; merge free block's
    getmaxblock_add:
	add	eax,[eax].mb.mb_size
      	mov	ebx,[eax].mb.mb_size
	cmp	[eax.mb.mb_used],0	; if next block is free
	jne	getmaxblock_test
	add	[edi].mb.mb_size,ebx
	jmp	getmaxblock_add
    getmaxblock_test:
	mov	eax,edi		; update result
	cmp	ecx,[eax].mb.mb_size
	ja	getmaxblock_next
	mov	ecx,[eax].mb.mb_size
	mov	edx,eax
    getmaxblock_next:
	add	eax,[eax].mb.mb_size
	cmp	eax,brklvl
	jb	getmaxblock_do
	mov	eax,ecx		; return size in eax
	test	eax,eax
	jz	getmaxblock_end
	mov	mavail,edx
    getmaxblock_end:
    	pop	edi
	pop     ebx
	pop	ecx
	ret

malloc	proc _CType msize:dword
	mov	eax,msize
	test	eax,eax
	jz	malloc_failed
	add	eax,SIZE mb
	test	eax,3
	jz	@F
	and	eax,not 3
	add	eax,4
      @@:
	mov	ecx,eax
	mov	eax,mavail
	test	eax,eax
	jz	malloc_create
	mov	edx,eax
	cmp	[eax].mb.mb_used,0
	mov	eax,[eax].mb.mb_size
	je	malloc_found
    malloc_find:
	call	getmaxblock
	jz	malloc_failed
	cmp	eax,ecx
	jb	malloc_failed
    malloc_found:
	cmp	eax,ecx
	jb	malloc_find
	mov	[edx].mb.mb_used,1
	je	malloc_set
	mov	[edx].mb.mb_size,ecx
	sub	eax,ecx
	add	ecx,edx
	mov	[ecx].mb.mb_size,eax
	mov	[ecx].mb.mb_used,0
    malloc_set:
	mov	eax,[edx].mb.mb_size
	add	eax,edx
	mov	mavail,eax
	mov	eax,edx
	add	eax,SIZE mb
    malloc_end:
	test	eax,eax
	ret
    malloc_create:
	push	ecx
	invoke	GlobalAlloc,GMEM_FIXED,MAXMEMORY
	pop	ecx
	mov	memseg,eax
	mov	mavail,eax
	test	eax,eax
	jz	malloc_failed
	mov	[eax].mb.mb_size,MAXMEMORY-SIZE mb
	mov	[eax].mb.mb_used,0
	add	eax,MAXMEMORY-SIZE mb
	mov	[eax].mb.mb_size,0
	mov	[eax].mb.mb_used,1
	mov	brklvl,eax
	jmp	malloc_find
    malloc_failed:
	mov	errno,ENOMEM
	xor	eax,eax
	jmp	malloc_end
malloc	endp

free 	proc _CType uses eax maddr:dword
	mov eax,maddr
	sub eax,SIZE mb
	.if eax >= memseg && eax < brklvl
	    mov [eax].mb.mb_used,0
	    mov mavail,eax
	.endif
	ret
free	endp

freememseg proc
	.if memseg
	    invoke GlobalFree,memseg
	    sub eax,eax
	    mov memseg,eax
	    mov mavail,eax
	.endif
	ret
freememseg endp

pragma_exit freememseg, 128

else ; __f__

extrn	_psp:word
extrn	heapbase:word
extrn	brklvl:word
extrn	heaptop:word
extrn	heapfree:word

	.code

resize_block:
	mov	bx,ax
	mov	ax,ss:_psp
	sub	bx,ax
	mov	es,ax
	mov	ah,4Ah
	int	21h
	ret

create_heap:
	mov	ax,ss:heapbase
	inc	ax
	cmp	ax,ss:heaptop
	ja	create_heap_failed
	call	resize_block
	jc	create_heap_failed
	mov	ax,ss:heapbase
	mov	ss:brklvl,ax
	mov	ss:heapfree,ax
	mov	es,ax
	xor	ax,ax
	mov	bx,ax
	mov	es:[bx].mb.mb_size,ax
	inc	ax
	mov	es:[bx].mb.mb_used,ax
	ret
    create_heap_failed:
	xor	ax,ax
	ret

extend_heap:
	mov	ax,ss:brklvl
	inc	ax
	add	ax,cx
	cmp	ax,ss:heaptop
	ja	extend_heap_failed
	call	resize_block
	jc	extend_heap_failed
	mov	ax,ss:brklvl
	mov	es,ax
	xor	bx,bx
	mov	es:[bx].mb.mb_size,cx
	mov	dx,ax
	add	ax,cx
	mov	ss:brklvl,ax
	mov	es,ax
	xor	ax,ax
	mov	es:[bx].mb.mb_size,ax
	inc	ax
	mov	es:[bx].mb.mb_used,ax
	ret
    extend_heap_failed:
	xor	ax,ax
	ret

getmaxblock:
	push	si
	push	di
	push	bx
	xor	cx,cx		; max size of block
	mov	ax,ss:heapbase	; segment of block
	mov	dx,ax
	mov	bx,cx
	mov	si,ax		; segment of last block
    getmaxblock_loop:
	mov	es,ax
	mov	di,es:[bx].mb.mb_size
	test	di,di
	jz	getmaxblock_exit
	mov	si,ax
	cmp	es:[bx].mb.mb_used,bx
	jne	getmaxblock_next
	add	ax,di
	mov	es,ax
	cmp	es:[bx].mb.mb_used,bx
	jne	getmaxblock_set
	mov	ax,es:[bx].mb.mb_size
	test	ax,ax
	jz	getmaxblock_set
	add	di,ax
	mov	ax,si
	mov	es,ax
	mov	es:[bx].mb.mb_size,di
	jmp	getmaxblock_loop
    getmaxblock_set:
	mov	ax,si
	cmp	di,cx
	jb	getmaxblock_next
	mov	cx,di
	mov	dx,ax
    getmaxblock_next:
	add	ax,di
	jmp	getmaxblock_loop
    getmaxblock_exit:
	mov	ax,si		; last block
	test	cx,cx
	jz	getmaxblock_end
	mov	ss:heapfree,dx
    getmaxblock_end:
    	pop	bx
	pop	di
	pop	si
	ret

free 	proc _CType public uses bx maddr:dword
	mov ax,word ptr maddr+2
	.if ax >= ss:heapbase && ax < ss:brklvl
	    mov es,ax
	    xor bx,bx
	    add ax,es:[bx]
	    mov es:[bx+2],bx
	    .if ax == ss:brklvl
		call getmaxblock
		mov es,ax
		mov es:[bx],bx
		inc bx
		mov es:[bx+1],bx
		mov ss:brklvl,ax
		inc ax
		call resize_block
	    .else
		mov ax,es
		mov ss:heapfree,ax
	    .endif
	.else
	    xor ax,ax
	.endif
	ret
free	endp

palloc	proc _CType public uses bx
	test	ax,ax
	jz	palloc_failed
	mov	cx,ax
	mov	ax,ss:heapfree
	test	ax,ax
	jz	palloc_create
	mov	es,ax
	mov	dx,ax
	xor	bx,bx
	cmp	es:[bx+2],bl
	mov	ax,es:[bx]
	je	palloc_found
    palloc_find:
	push	cx
	call	getmaxblock
	mov	ax,cx
	pop	cx
	jz	palloc_extend
	cmp	ax,cx
	jb	palloc_extend
	mov	es,dx
    palloc_found:
	cmp	ax,cx
	jb	palloc_find
	mov	word ptr es:[bx+2],1
	je	palloc_set
	mov	es:[bx],cx
	sub	ax,cx
	add	cx,dx
	mov	es,cx
	mov	es:[bx],ax
	mov	es:[bx+2],bx
	mov	es,dx
    palloc_set:
	mov	ax,es:[bx]
	add	ax,dx
	mov	ss:heapfree,ax
    palloc_seto:
	mov	ax,4
    palloc_end:
	test	ax,ax
	ret
    palloc_create:
	call	create_heap
	jz	palloc_failed
    palloc_extend:
	call	extend_heap
	jnz	palloc_seto
    palloc_failed:
	mov	ss:errno,ENOMEM
	xor	ax,ax
	cwd
	jmp	palloc_end
palloc	endp

malloc	proc _CType public msize:word
	mov ax,msize
	add ax,4
	.if CARRY?
	    mov ax,1001h
	.else
	    mov dl,al
	    shr ax,4
	    .if dl & 15
		inc ax
	    .endif
	.endif
	call palloc
	or ax,ax
	ret
malloc	endp

endif

	END
