include	clib.inc
include	stdio.inc
include	math.inc

public	output_flush

BUFFERSIZE	equ 512		; ANSI-specified minimum is 509

FLAG_SIGN	equ 0001h     	; put plus or minus in front
FLAG_SIGNSP	equ 0002h     	; put space or minus in front
FLAG_LEFT	equ 0004h     	; left justify
FLAG_LEADZERO	equ 0008h     	; pad with leading zeros
FLAG_LONG       equ 0010h     	; long value given
FLAG_SHORT      equ 0020h     	; short value given
FLAG_SIGNED	equ 0040h     	; signed data given
FLAG_ALTERNATE	equ 0080h     	; alternate form requested
FLAG_NEGATIVE	equ 0100h     	; value is negative
FLAG_FORCEOCTAL equ 0200h     	; force leading '0' for octals

	.data

cl_table label byte
	db	 06h, 00h, 00h, 06h, 00h, 01h, 00h, 00h
	db	 10h, 00h, 03h, 06h, 00h, 06h, 02h, 10h
	db	 04h, 45h, 45h, 45h, 05h, 05h, 05h, 05h
	db	 05h, 35h, 30h, 00h, 50h, 00h, 00h, 00h
	db	 00h, 20h, 28h, 38h, 50h, 58h, 07h, 08h
	db	 00h, 37h, 30h, 30h, 57h, 50h, 07h, 00h
	db	 00h, 20h, 20h, 08h, 00h, 00h, 00h, 00h
	db	 08h, 60h, 60h, 60h, 60h, 60h, 60h, 00h
	db	 00h, 70h, 78h, 78h, 78h, 78h, 78h, 08h
	db	 07h, 08h, 00h, 00h, 07h, 00h, 08h, 08h
	db	 08h, 00h, 00h, 08h, 00h, 08h, 00h, 00h
	db	 08h

formchar	db 'bcdefginopsuxEGX'
nullstring	db '(null)',0
output_flush 	p? ?

OPST_table 	label size_t
	d?	OPST_normal
	d?	OPST_percent
	d?	OPST_flag
	d?	OPST_width
	d?	OPST_dot
	d?	OPST_precision
	d?	OPST_size
	d?	OPST_type

output_proctab 	label size_t
	d?	OUTPUT_b
	d?	OUTPUT_c
	d?	OUTPUT_d
	d?	OUTPUT_dummy
	d?	OUTPUT_dummy
	d?	OUTPUT_dummy
	d?	OUTPUT_d
	d?	OUTPUT_n
	d?	OUTPUT_o
	d?	OUTPUT_p
	d?	OUTPUT_s
	d?	OUTPUT_u
	d?	OUTPUT_x
	d?	OUTPUT_dummy
	d?	OUTPUT_dummy
	d?	OUTPUT_xu

S_OUTPUT 	STRUC
OP_filep	dd ?
OP_format	dd ?
OP_charsout 	d? ?
OP_hexoff	d? ?
OP_state	d? ?
OP_curadix	d? ?
OP_prefix	db 2 dup(?)
OP_count	d? ?
OP_prefixlen	d? ?
OP_no_output	d? ?
OP_fldwidth	d? ?
OP_padding	d? ?
OP_text		dd ?
OP_capitalize	d? ?
ifdef __f__
OP_numeax	dd ?
OP_numedx	dd ?
else
OP_number	dd ?
endif
OP_ddtemp	dd ?
OP_dwtemp	d? ?
OP_buffer	db BUFFERSIZE dup(?)
OP_STACK	dd ? ; [(E)BP]
ifndef __c__
OP_CSIP		d? ?
endif
ifdef __CDECL__
OP_ARGfile	dd ?
OP_ARGformat	dd ?
OP_argp		dd ?
else
OP_argp		dd ?
OP_ARGformat	dd ?
OP_ARGfile	dd ?
endif
S_OUTPUT 	ENDS

	.code

	ASSUME bp?:ptr S_OUTPUT

OPST_normal:
	mov	al,dl

OUTPUT_PUTC:
	les?	bx?,[bp?].OP_filep
	dec	ebx?.S_FILE.iob_cnt
	jl	OPPUTC_00
	inc	word_ptr ebx?.S_FILE.iob_bp
	les?	bx?,ebx?.S_FILE.iob_bp
	mov	ebx?-1,al
    OPPUTC_01:
	inc	[bp?].OP_charsout
	ret
    OPPUTC_00:
      ifdef __CDECL__
	pushm	[bp?].OP_filep
	push	ax?
      else
	push	ax?
	pushm	[bp?].OP_filep
      endif
	call	output_flush
	cmp	ax?,-1
	jne	OPPUTC_01
	mov	[bp?].OP_charsout,ax?
	ret

OUTPUT_GETD:	; Get DWORD from stack
    ifndef __f__
	lea	bx,[bp].OP_argp
	mov	ax,[bx+2]
	add	word ptr [bx],4
	mov	bx,[bx]
	mov	es,ax
      ifdef __3__
	mov	eax,es:[bx-4]
      else
	mov	ax,es:[bx-4]
	mov	dx,es:[bx-2]
      endif
    else
	mov	ebx,[ebp].OP_argp
	add	[ebp].OP_argp,4
	mov	eax,[ebx]
	xor	edx,edx
    endif
	ret

ifndef __f__
OUTPUT_GETW:	; Get WORD from stack
	lea	bx,[bp].OP_argp
	mov	ax,[bx+2]
	add	word ptr [bx],2
	mov	bx,[bx]
	mov	es,ax
	mov	ax,es:[bx-2]
	ret
else
OUTPUT_GETQ: 	; Get QWORD from stack
	mov	ebx,[ebp].OP_argp
	add 	[ebp].OP_argp,8
	mov	eax,[ebx]
	mov	edx,[ebx+4]
	ret
endif

OPST_percent:
	sub	ax?,ax?
	mov	[bp?].OP_no_output,ax?
	mov	[bp?].OP_fldwidth,ax?
	mov	[bp?].OP_prefixlen,ax?
	mov	[bp?].OP_capitalize,ax?
	mov	si?,ax?	; bufferiswide (default)
	mov	di?,ax?	; precision
	dec	di?
	ret

OPST_flag:
	mov al,dl
	.if al == '+'
	    or si?,FLAG_SIGN    	; '+' force sign indicator
	.elseif al == ' '
	    or si?,FLAG_SIGNSP  	; ' ' force sign or space
	.elseif al == '#'
	    or si?,FLAG_ALTERNATE	; '#' alternate form
	.elseif al == '-'
	    or si?,FLAG_LEFT		; '-' left justify
	.elseif al == '0'
	    or si?,FLAG_LEADZERO	; '0' pad with leading zeros
	.endif
	ret

OPST_width:
	.if dl == '*'
	  ifndef __f__
	    call OUTPUT_GETW
	  else
	    call OUTPUT_GETD
	  endif
	    mov [bp?].OP_fldwidth,ax?
	    cmp ax?,0
	    jge @F
	    or  si?,4
	    neg ax?
	    mov [bp?].OP_fldwidth,ax?
	  @@:
	.else
	  ifndef __f__
	    mov al,dl
	    cbw
	  else
	    movsx eax,dl
	  endif
	    push ax?
	    mov  ax?,[bp?].OP_fldwidth
	    mov  dx?,10
	    imul dx?
	    pop  dx?
	    add  dx?,ax?
	    add  dx?,-48
	    mov  [bp?].OP_fldwidth,dx?
	.endif
	ret

OPST_dot:
	sub di?,di?
	ret

OPST_precision:
	.if dl == '*'
	  ifndef __f__
	    call OUTPUT_GETW
	  else
	    call OUTPUT_GETD
	  endif
	    mov di?,ax?
	    cmp ax?,0
	    jge @F
	    mov di?,-1
	.else
	  ifndef __f__
	    mov al,dl
	    cbw
	  else
	    movsx eax,dl
	  endif
	    push ax?
	    mov  ax?,di?
	    mov  dx?,10
	    imul dx?
	    pop  dx?
	    add  dx?,ax?
	    add  dx?,-48
	    mov  di?,dx?
	.endif
      @@:
	ret

OPST_size:
	.if dl == 'l'
	    or si?,FLAG_LONG
	.endif
	ret

OPST_type:
	sub bx?,bx?
	mov cx?,16
	.repeat
	    .if dl == formchar[bx?]
	    	shl bx?,size_l/2
		call output_proctab[bx?]
		.break
	    .endif
	    inc bx?
	.untilcxz
	call OUTPUT
	ret

OUTPUT_b:
	push	si?
      ifndef __f__
	call	OUTPUT_GETW
      else
	call	OUTPUT_GETD
      endif
	test	si?,FLAG_LONG
	mov	si?,16
	jnz	OUTPB_00
	mov	si?,8
    OUTPB_00:
	mov	[bp?].OP_count,si?
    OUTPB_01:
	mov	dx?,ax?
	xor	cx?,cx?
    OUTPB_02:
	mov	ax?,dx?
	shr	ax?,cl
	and	ax?,1
	add	ax?,48
	mov	[bp?].OP_buffer[si?-1],al
	inc	cx?
	dec	si?
	jnz	OUTPB_02
	pop	si?
	jmp	OUTPUT_LDTEXT

OUTPUT_c:
      ifndef __f__
	call	OUTPUT_GETW
      else
	call	OUTPUT_GETD
      endif
	mov	dx?,ax?
	mov	[bp?].OP_buffer,al
	mov	[bp?].OP_count,1

OUTPUT_LDTEXT:
	lea	ax?,[bp?].OP_buffer
	mov?	word ptr [bp].OP_text+2,ss
	mov	word_ptr [bp?].OP_text,ax?
	ret

OUTPUT_s:
	.if di? == -1
	    mov cx?,7FFFh
	.else
	    mov cx?,di?
	.endif
	call	OUTPUT_GETD
      ifdef __16__
	mov	word ptr [bp].OP_text+2,dx
	mov	word ptr [bp].OP_text,ax
	or	ax,dx
      else
      	mov	[bp?].OP_text,eax
	test	eax,eax
      endif
	jnz	OUTPS_02
    OUTPS_NULL:
	mov?	word ptr [bp].OP_text+2,ds
	mov	word_ptr [bp?].OP_text,offset nullstring
    OUTPS_02:
	les?	bx?,[bp?].OP_text
    OUTPS_03:
	cmp	byte ptr ebx?,0
	je	OUTPS_04
	inc	bx?
	dec	cx?
	jnz	OUTPS_03
    OUTPS_04:
      ifndef __f__
	sub	bx,word ptr [bp].OP_text
      else
	sub	ebx,[ebp].OP_text
      endif
	mov	[bp?].OP_count,bx?
	ret

OUTPUT_n:
	call	OUTPUT_GETD
	les?	bx?,ebx?-4
	test	si?,FLAG_LONG
	jnz	@F
	mov	ax?,[bp?].OP_charsout
	mov	ebx?,ax?
	ret
      @@:
	mov	ax?,[bp?].OP_charsout
	mov	ebx?,ax?
	mov	[bp?].OP_no_output,1
	ret

OUTPUT_p:
	mov	di?,8
	or	si?,FLAG_LONG

OUTPUT_xu:
	mov	[bp?].OP_hexoff,'A'-'9'-1
	jmp	OPCOMMONHEX

OUTPUT_x:
	mov	[bp?].OP_hexoff,'a'-'9'-1

OPCOMMONHEX:
	mov	[bp?].OP_curadix,16
	test	si?,FLAG_ALTERNATE
	jz	@F
	mov	[bp?].OP_prefix,'0'
	mov	[bp?].OP_prefix+1,'x'
	mov	[bp?].OP_prefixlen,2
      @@:
	test	si?,FLAG_LONG
	jnz	OUTPUT_LONGINT
	cmp	[bp?].OP_fldwidth,2
	jne	OUTPUT_SHORTINT
      ifndef __f__
	call	OUTPUT_GETW
      else
	call	OUTPUT_GETD
      endif
	and	ax?,00FFh
	jmp	OUTPUT_UNSIGNED

OUTPUT_o:
	mov	[bp?].OP_curadix,8
	test	si?,FLAG_ALTERNATE
	jz	OUTPUT_GENINT
	or	si?,FLAG_FORCEOCTAL
	jmp	OUTPUT_GENINT

OUTPUT_d:
	or	si?,FLAG_SIGNED

OUTPUT_u:
	mov	[bp?].OP_curadix,10

OUTPUT_GENINT:
	test	si?,FLAG_LONG
	jz	OUTPUT_SHORTINT

OUTPUT_LONGINT:
      ifndef __f__
	call	OUTPUT_GETD
      else
	call	OUTPUT_GETQ
      endif
	jmp	OUTPUT_NUMBER

OUTPUT_SHORTINT:
      ifndef __f__
	call	OUTPUT_GETW
      else
	call	OUTPUT_GETD
      endif
	test	si?,FLAG_SIGNED
	jz	OUTPUT_UNSIGNED
      ifndef __f__
       ifdef __3__
	movsx eax,ax
       else
	cwd
       endif
      else
	cmp	eax,0
	jnl	OUTPUT_NUMBER
	dec	edx
      endif
      	jmp	OUTPUT_NUMBER

OUTPUT_UNSIGNED:
ifndef __f__
  ifdef __3__
	movzx eax,ax
  else
	xor dx,dx
  endif
endif

OUTPUT_NUMBER:
      ifndef __f__
       ifdef __3__
	mov	[bp].OP_ddtemp,eax
	test	si,FLAG_SIGNED
	jz	@F
	cmp	eax,0
	jnl	@F
	neg	eax
	or	si,FLAG_NEGATIVE
      @@:
	mov	[bp].OP_number,eax
       else
	stom	[bp].OP_ddtemp
	test	si,FLAG_SIGNED
	jz	@F
	test	dx,dx
	jns	@F
	neg	ax
	neg	dx
	sbb	dx,0
	or	si,FLAG_NEGATIVE
      @@:
	stom	[bp].OP_number
       endif
      else
	test	esi,FLAG_SIGNED
	jz	@F
	test	edx,edx
	jns	@F
	neg	eax
	neg	edx
	sbb	edx,0
	or	esi,FLAG_NEGATIVE
      @@:
	mov	[ebp].OP_numeax,eax
	mov	[ebp].OP_numedx,edx
      endif
	test	di?,di?
	jnl	OPNUM_01
	mov	di?,1
	jmp	OPNUM_02
    OPNUM_01:
	and	si?,-9
    OPNUM_02:
  ifdef __3__
	test	eax,eax
  else
	test	ax?,ax?
	jnz	OPNUM_03
	test	dx?,dx?
  endif
	jnz	OPNUM_03
	mov	[bp?].OP_prefixlen,ax?
    OPNUM_03:
	lea	ax?,[bp?].OP_buffer+512-1
	mov?	word ptr [bp].OP_text+2,ss
	mov	word_ptr [bp?].OP_text,ax?
	jmp	OPNUM_06
    OPNUM_04:
    ifdef __16__
	mov	bx,[bp].OP_curadix
	xor	cx,cx
	lodm	[bp].OP_number
	call	_div32
	stom	[bp].OP_number
	add	bx,'0'
	mov	cx,bx
    else
      ifdef __f__
	mov	ecx,[ebp].OP_curadix
	mov	eax,[ebp].OP_numeax
	mov	edx,[ebp].OP_numedx
	call	_div64
	mov	[ebp].OP_numeax,eax
	mov	[ebp].OP_numedx,edx
	add	ecx,'0'
      else
	movzx	ebx,[bp].OP_curadix
	mov	eax,[bp].OP_number
	sub	edx,edx
	div	ebx
	mov	[bp].OP_number,eax
	add	dx,'0'
	mov	cx,dx
      endif
    endif
	cmp	cx?,'9'
	jng	OPNUM_05
	add	cx?,[bp?].OP_hexoff
    OPNUM_05:
	les?	bx?,[bp?].OP_text
	mov	ebx?,cl
    ifndef __f__
	dec	word ptr [bp].OP_text
    else
	dec	[ebp].OP_text
    endif
    OPNUM_06:
	mov	cx?,di?
	dec	di?
	test	cx?,cx?
	jg	OPNUM_04
    ifdef __3__
	test	eax,eax
    else
	or	ax?,dx?
    endif
	jnz	OPNUM_04
	lea	ax?,[bp?].OP_buffer+512-1
    ifndef __f__
	sub	ax,word ptr [bp].OP_text
	mov	[bp].OP_count,ax
	inc	word ptr [bp].OP_text
    else
	sub	eax,[ebp].OP_text
	mov	[ebp].OP_count,eax
	inc	[ebp].OP_text
    endif
	test	si?,FLAG_FORCEOCTAL
	jz	OUTPUT_dummy
	les?	bx?,[bp?].OP_text
	cmp	byte ptr ebx?,'0'
	jne	OPNUM_07
	cmp	[bp?].OP_count,0
	jne	OUTPUT_dummy
    OPNUM_07:
	dec	bx?
	mov	word_ptr [bp?].OP_text,bx?
	mov	byte ptr ebx?,'0'
	inc	[bp?].OP_count
OUTPUT_dummy:
	ret

OUTPUT_MULTI:
	push	si?
	push	di?
	movzx?	ax?,al
	mov	si?,ax?
	mov	di?,dx?
	jmp	OPMULTI_01
    OPMULTI_00:
	mov	ax?,si?
	call	OUTPUT_PUTC
	cmp	[bp?].OP_charsout,-1
	je	OPMULTI_02
    OPMULTI_01:
	mov	ax?,di?
	dec	di?
	test	ax?,ax?
	jg OPMULTI_00
    OPMULTI_02:
	pop	di?
	pop	si?
	ret

OUTPUT_STRING:
	push?	di
	push	si?
	mov?	di,ax
	mov	si?,cx?
	mov	bx?,dx?
	jmp	OPSTR_01
    OPSTR_00:
	mov?	es,di
	mov	al,ebx?
	inc	bx?
	push	bx?
	call	OUTPUT_PUTC
	pop	bx?
	cmp	[bp?].OP_charsout,-1
	jz	OPSTR_02
    OPSTR_01:
	mov	ax?,si?
	dec	si?
	or	ax?,ax?
	jg	OPSTR_00
    OPSTR_02:
	pop	si?
	pop?	di
	ret

OUTPUT:
	sub	ax?,ax?
	cmp	ax?,[bp?].OP_no_output
	je	OUTPUT_00
	ret
    OUTPUT_00:
	test	si?,FLAG_SIGNED
	jz	OUTPUT_03
	test	si?,FLAG_NEGATIVE
	jz	OUTPUT_01
	mov	[bp?].OP_prefix,'-'
	mov	[bp?].OP_prefixlen,1
	jmp	OUTPUT_03
    OUTPUT_01:
	test	si?,FLAG_SIGN
	jz 	OUTPUT_02
	mov	[bp?].OP_prefix,43
	mov	[bp?].OP_prefixlen,1
	jmp	OUTPUT_03
    OUTPUT_02:
	test	si?,FLAG_SIGNSP
	jz	OUTPUT_03
	mov	[bp?].OP_prefix,' '
	mov	[bp?].OP_prefixlen,1
    OUTPUT_03:
	mov	ax?,[bp?].OP_fldwidth
	sub	ax?,[bp?].OP_count
	sub	ax?,[bp?].OP_prefixlen
	mov	[bp?].OP_padding,ax?
	test	si?,FLAG_LEFT or FLAG_LEADZERO
	jnz	OUTPUT_04
	mov	dx?,ax?
	mov	ax?,' '
	call	OUTPUT_MULTI
    OUTPUT_04:
	mov?	ax,ss
	lea	dx?,[bp?].OP_prefix
	mov	cx?,[bp?].OP_prefixlen
	call	OUTPUT_STRING
	test	si?,FLAG_LEADZERO
	jz	OUTPUT_05
	test	si?,FLAG_LEFT
	jnz	OUTPUT_05
	mov	ax?,'0'
	mov	dx?,[bp?].OP_padding
	call	OUTPUT_MULTI
    OUTPUT_05:
	cmp	[bp?].OP_count,0
	jng	OUTPUT_08
	movmx	[bp?].OP_ddtemp,[bp?].OP_text
	mov	ax?,[bp?].OP_count
	mov	[bp?].OP_dwtemp,ax?
	jmp	OUTPUT_07
    OUTPUT_06:
	les?	bx?,[bp?].OP_ddtemp
	inc	word_ptr [bp?].OP_ddtemp
	mov	al,ebx?
	call	OUTPUT_PUTC
    OUTPUT_07:
	mov	ax?,[bp?].OP_dwtemp
	dec	[bp?].OP_dwtemp
	or	ax?,ax?
	jg	OUTPUT_06
	jmp	OUTPUT_09
    OUTPUT_08:
	mov?	ax,word ptr [bp].OP_text+2
	mov	dx?,word_ptr [bp?].OP_text
	mov	cx?,[bp?].OP_count
	call	OUTPUT_STRING
    OUTPUT_09:
	test	si?,FLAG_LEFT
	jz	OUTPUT_10
	mov	ax?,' '
	mov	dx?,[bp?].OP_padding
	call	OUTPUT_MULTI
    OUTPUT_10:
	ret

_output proc _CType public uses dx? cx? bx? si? di? bp? filep:dword,
	format:dword, argp:dword
local	OP[S_OUTPUT.OP_STACK]:byte
	lea bp?,OP
	movmx [bp?].OP_format,[bp?].OP_ARGformat
	movmx [bp?].OP_filep,[bp?].OP_ARGfile
	sub ax?,ax?
	mov [bp?].OP_count,ax?
	mov [bp?].OP_charsout,ax?
	mov [bp?].OP_state,ax?
	.repeat
	    les? bx?,[bp?].OP_format
	  ifdef __16__
	    inc word ptr [bp?].OP_format
	  else
	    inc [bp?].OP_format
	  endif
	    movzx? ax?,byte ptr ebx?
	    mov dx?,ax?
	    .break .if !al
	    .break .if [bp?].OP_charsout > 7FFFh
	    .if al < ' ' || al > 'x'
		sub ax?,ax?
	    .else
		mov bx?,ax?
		mov al,cl_table[bx?-32]
		and ax?,15
	    .endif
	    mov cx?,ax?
	    mov bx?,ax?
	    shl bx?,3
	    add bx?,[bp?].OP_state
	    mov al,cl_table[bx?]
	    shr ax?,4
	    mov [bp?].OP_state,ax?
	    mov bx?,ax?
	    .if ax? <= 7
	      ifdef __f__
		shl ebx,2
	      else
		add bx,bx
	      endif
		call OPST_table[bx?]
	    .endif
	.until 0
	mov ax?,[bp?].OP_charsout
	ret
_output	endp

	end
