include	clib.inc
include	time.inc
include	conio.inc
include	mouse.inc
include	keyb.inc

STARTDAY  	equ 5
STARTYEAR       equ 0
MAXYEAR 	equ 3000

;USE_MDALTKEYS	= 1

	.data

;******** Resource begin CALENDAR *
;	{ 0x005C,   0,   0, {42, 2,29,10} },
;******** Resource data  *******************
CALENDAR_RC label word
	dw	00283h	; Alloc size
	dw	0005Ch,00000h,0022Ah,00A1Dh,03AF0h,0F02Eh,02A3Ah,01DF0h
	dw	0F02Eh,02A74h,01DF0h,0F02Eh,0DF1Dh,04D20h,06E6Fh,05420h
	dw	06575h,05720h,06465h,05420h,07568h,04620h,06972h,05320h
	dw	07461h,05320h,06E75h,02020h,01BF0h,0F0C4h,020AFh,01DF0h
	dw	02EDCh
;	68 byte
;******** Resource end   CALENDAR *

;******** Resource begin CALENDAR2 *
;	{ 0x0010,   0,   0, {45,12,14, 1} },
;******** Resource data  *******************
CALENDAR2_RC label word
	dw	0002Ch	; Alloc size
	dw	00010h,00000h,00C2Dh,0010Eh,00EF0h,0F007h,0200Eh,00707h
;	18 byte
;******** Resource end   CALENDAR2 *

	cp_jan	db "January",0
	cp_feb	db "February",0
	cp_mar	db "March",0
	cp_apr	db "April",0
	cp_may	db "May",0
	cp_jun	db "June",0
	cp_jul	db "July",0
	cp_aug	db "August",0
	cp_sep	db "September",0
	cp_oct	db "October",0
	cp_nov	db "November",0
	cp_dec	db "December",0
	cp_month label size_t
		d? offset cp_jan
		d? offset cp_feb
		d? offset cp_mar
		d? offset cp_apr
		d? offset cp_may
		d? offset cp_jun
		d? offset cp_jul
		d? offset cp_aug
		d? offset cp_sep
		d? offset cp_oct
		d? offset cp_nov
		d? offset cp_dec
	keylocal label size_t
		d? MOUSECMD
		d? KEY_ESC
		d? KEY_HOME
		d? KEY_RIGHT
		d? KEY_LEFT
		d? KEY_UP
		d? KEY_DOWN
		d? KEY_PGUP
		d? KEY_PGDN
		d? KEY_CTRLPGUP
		d? KEY_CTRLPGDN
		d? KEY_ENTER
		d? KEY_ALTX
	ifdef USE_MDALTKEYS
		d? KEY_ALTUP
		d? KEY_ALTDN
		d? KEY_ALTLEFT
		d? KEY_ALTRIGHT
	endif
	keyproc label size_t
		d? event_mouse
		d? event_ESC
		d? event_HOME
		d? event_nextday
		d? event_prevday
		d? event_UP
		d? event_DOWN
		d? event_prevmnd
		d? event_nextmnd
		d? event_prevyear
		d? event_nextyear
		d? event_ENTER
		d? event_ESC
	ifdef USE_MDALTKEYS
		d? event_ALTUP
		d? event_ALTDN
		d? event_ALTLEFT
		d? event_ALTRIGHT
	endif
	keycount = (($ - offset keyproc) / size_l)
	mnd_table  db 31,28,31,30,31,30,31,31,30,31,30,31
	keypos	   db 1,5,9,13,17,21,25
	format_s_d db '%s %d',0
	format_2d  db '%2d',0

	DLG_Calendar	dd ?
	DLG_Calendar2	dd ?
	xpos		d? ?
	ypos		d? ?
	year		d? ?
	month		d? ?
	day		d? ?
	week_day	d? ?
	days_in_month	d? ?
	current_year	d? ?
	current_month	d? ?
	calender	d? ?
	result		d? ?

	.code

days_in_feb:
	push	dx?
	push	bx?
	test	cx?,cx?
	jz	days_in_feb_29
	mov	ax?,cx?
	and	al,3
	jnz	@F
	mov	ax?,cx?
	mov	bx?,100
	xor	dx?,dx?
	div	bx?
	or	dx?,dx?
	jnz	days_in_feb_29
      @@:
	mov	bx?,400
	mov	ax?,cx?
	xor	dx?,dx?
	div	bx?
	test	dx?,dx?
	jz	days_in_feb_29
	mov	ax?,28
    days_in_feb_end:
	pop	bx?
	pop	dx?
	ret
    days_in_feb_29:
	mov	ax?,29
	jmp	days_in_feb_end

days_in_mnd:
	cmp	bx?,2
	je	days_in_feb
	mov	ah,0
	mov	al,mnd_table[bx?-1]
	ret

weekday_jan1:
	push	bp?
	push	si?
	push	di?
	xor	bp?,bp?
	mov	si?,STARTDAY
	mov	di?,cx?
	mov	cx?,STARTYEAR
    weekday_jan1_loop:
	cmp	cx?,di?
	jnb	weekday_jan1_break
	call	days_in_feb
	cmp	ax?,29
	jne	@F
	add	si?,1
 	adc	bp?,0
      @@:
	inc	cx?
	add	si?,1
	adc	bp?,0
	jmp	weekday_jan1_loop
    weekday_jan1_break:
	push	dx?
	mov	dx?,bp?
	mov	ax?,si?
	mov	si?,7
	div	si?
	mov	ax?,dx?
	pop	dx?
	mov	cx?,di?
	pop	di?
	pop	si?
	pop	bp?
	ret

getweekday:
	call	weekday_jan1
	push	si?
	push	di?
	mov	si?,ax?
	mov	di?,bx?
	mov	bx?,1
      @@:
	cmp	bx?,di?
	jnb	@F
	call	days_in_mnd
	add	si?,ax?
	inc	bx?
	jmp	@B
      @@:
	push	dx?
	mov	di?,7
	xor	dx?,dx?
	mov	ax?,si?
	div	di?
	mov	ax?,dx?
	pop	dx?
	pop	di?
	pop	si?
	ret

getcurdate:	; GET SYSTEM DATE
	call	getday
	mov	day,ax?
	call	getmnd
	mov	month,ax?
	call	getyear
	mov	year,ax?
	mov	dx?,day
	mov	cx?,ax?
	mov	ax?,month
	mov	bx?,ax?
	call	getweekday
	mov	week_day,ax?
	call	days_in_mnd
	mov	days_in_month,ax?
	ret

incyear:
	mov	cx?,year
	cmp	cx?,MAXYEAR
	je	@F
	inc	cx?
	ret
      @@:
	mov	cx?,STARTYEAR
	ret

decyear:
	mov	cx?,year
	test	cx?,cx?
	jz	@F
	dec	cx?
	ret
      @@:
	mov	cx?,MAXYEAR
	ret

putdate:
	push	si?
	push	di?
	mov	ax?,year
	mov	dx?,month
	cmp	ax?,current_year
	jne	@F
	cmp	dx?,current_month
	je	putdate_day
      @@:
	mov	current_month,dx?
	mov	current_year,ax?
	mov	ax?,xpos
	mov	dx?,ypos
	add     al,3
	add	dl,10
	invoke	scputw,ax?,dx?,14,0720h
	mov	bx?,month
	dec	bx?
	shl	bx?,size_l/2
	mov	bx?,cp_month[bx?]
	invoke	scputf,ax?,dx?,0,0,addr format_s_d,ssbx,year
	mov	bx?,xpos
	mov	dx?,ypos
	add	dl,3
	mov	cx?,6
	mov	ax?,20h
	mov	ah,at_background[7]
	or	ah,at_foreground[0]
      @@:
	invoke	scputw,bx?,dx?,29,ax?
	inc	dl
	dec	cx?
	jnz	@B
    putdate_day:
	xor	si?,si?
	mov	di?,3
    putdate_loop:
	cmp	si?,days_in_month
	jnb	putdate_end
	xor	cx?,cx?
    putdate_xloop:
	cmp	cx?,7
	jnb	putdate_yloop
	mov	ax?,3		; first line
	cmp	week_day,cx?	; week day
	ja      @F
	cmp	di?,ax?
	je	putdate_putday
      @@:
	cmp	di?,ax?
	jna	putdate_next
	cmp	si?,days_in_month	; days in month
	jae	putdate_next
    putdate_putday:
	inc	si?
	push	cx?
	push	di?
	mov	bx?,cx?
	mov	cl,at_background[7]
	mov	al,at_foreground[0Fh]
	cmp	si?,day
	je	@F
	mov	al,at_foreground[0]
      @@:
	or	cl,al
	mov	al,keypos[bx?]
	mov	bx?,di?
	add	bx?,ypos
	add	ax?,xpos
	mov	di?,ax?
	invoke	scputf,ax?,bx?,cx?,2,addr format_2d,si?
	call	getday
	cmp	ax?,si?
	jne	@F
	call	getmnd
	cmp	ax?,month
	jne	@F
	call	getyear
	cmp	ax?,year
	jne	@F
	mov	al,04h
	or	al,at_background[7]
	invoke	scputa,di?,bx?,2,ax?
      @@:
	pop	di?
	pop	cx?
    putdate_next:
	inc	cx?
	jmp	putdate_xloop
    putdate_yloop:
	add	di?,1
	cmp	di?,10
	jb	putdate_loop
    putdate_end:
	pop	di?
	pop	si?
	ret

setdate:
	mov	day,dx?
	mov	month,bx?
	mov	year,cx?
	call	getweekday
	mov	week_day,ax?
	call	days_in_mnd
	mov	days_in_month,ax?
	call	putdate
	ret

ifdef USE_MDALTKEYS
event_ALTUP:
	mov	ax?,rcmoveup
	jmp	DLMOVE_MOVE
event_ALTDN:
	mov	ax?,rcmovedn
	jmp	DLMOVE_MOVE
event_ALTLEFT:
	mov	ax?,rcmoveleft
	jmp	DLMOVE_MOVE
event_ALTRIGHT:
	mov	ax?,rcmoveright
DLMOVE_MOVE:
	push	ax
	pushm	[bp-6]
	call	dlhide
	pop	ax
	les	bx,[bp-28]
	pushm	es:[bx+4]
	pushm	es:[bx+12]
	push	es:[bx]
	pushl	cs
	call	ax
	mov	ax,dx
	les	bx,[bp-28]
	mov	es:[bx+4],ax
	mov	[bp-24],ax
	add	ax,0A03h
	les	bx,[bp-6]
	mov	es:[bx+4],ax
	pushm	[bp-6]
	call	dlshow
	ret
endif

event_ENTER:
	mov	ax?,1
	mov	result,ax?

event_ESC:
	inc	byte ptr calender
	ret

event_HOME:
	call	getcurdate
	jmp	putdate

event_nextday:
	mov	dx?,day
	inc	dx?
	cmp	dx?,days_in_month
	ja	event_nextmnd
	mov	day,dx?
	jmp	putdate

event_prevday:
	mov	dx?,day
	cmp	dx?,1
	je	@F
	mov	cx?,year
	mov	bx?,month
	dec	dx?
	jmp	setdate
      @@:
	call	event_prevmnd
	mov	ax?,days_in_month
	mov	day,ax?
	jmp	putdate

event_UP:
	mov	ax?,7
	cmp	day,ax?
	jbe	event_prevday
	sub	day,ax?
	jmp	putdate

event_DOWN:
	mov	ax?,day
	add	ax?,7
	cmp	ax?,days_in_month
	ja	event_nextday
	mov	day,ax?
	jmp	putdate

event_prevmnd:
	mov	dx?,1
	mov	bx?,month
	mov	cx?,year
	cmp	bx?,1
	je	@F
	dec	bx?
	jmp	setdate
    @@:
	mov	bx?,12
	call	decyear
	jmp	setdate

event_nextmnd:
	mov	bx?,month
	cmp	bx?,12
	je	event_nextyear
	mov	dx?,1
	mov	cx?,year
	inc	bx?
	jmp	setdate

event_prevyear:
	mov	dx?,1
	mov	bx?,dx?
	call	decyear
	jmp	setdate

event_nextyear:
	mov	dx?,1
	mov	bx?,dx?
	call	incyear
	jmp	setdate

event_mouse:
  ifdef __MOUSE__
	call	mousex
	mov	dx?,ax?
	call	mousey
	les?	bx?,DLG_Calendar
	invoke	rcxyrow,ebx?.S_DOBJ.dl_rect,dx?,ax?
	test	ax?,ax?
	jz	event_ESC
	invoke	dlhide,DLG_Calendar2
	invoke	dlmove,DLG_Calendar
	les?	bx?,DLG_Calendar
	sub	ax?,ax?
	mov	al,ebx?+4
	mov	dl,al
	mov	xpos,ax?
	mov	al,ebx?+5
	mov	ypos,ax?
	mov	ah,al
	mov	al,dl
	add	ax,0A03h
	les?	bx?,DLG_Calendar2
	mov	ebx?+4,ax
	invoke	dlshow,DLG_Calendar2
  else
	xor	ax?,ax?
  endif
	ret

modal:	cmp	byte ptr calender,0
	je	@F
	ret
      @@:
	call	tgetevent
	mov	cx?,keycount
	xor	bx?,bx?
      @@:
	cmp	ax?,keylocal[bx?]
	je	@F
	add	bx?,size_l
	dec	cx?
	jnz	@B
	jmp	modal
      @@:
	call	keyproc[bx?]
	jmp	modal

cmcalendar proc _CType public uses bx?
	xor	ax?,ax?
	mov     calender,ax?
	mov     current_year,ax?
	mov     current_month,ax?
	mov	result,ax?
	invoke	rsopen,addr CALENDAR_RC
	stom	DLG_Calendar
	jz	cmcalendar_end
	mov	bx?,ax?
	sub	ax?,ax?
	mov	al,ebx?+4
	mov	xpos,ax?
	mov	al,ebx?+5
	mov	ypos,ax?
	invoke	dlshow,DLG_Calendar
	invoke	rsopen,addr CALENDAR2_RC
	stom	DLG_Calendar2
	invoke	dlshow,dxax
	call	getcurdate
	mov	dx?,day
	mov	bx?,month
	mov	cx?,year
	call	setdate
  ifdef __MOUSE__
	call	msloop
  endif
	call	modal
	invoke	dlclose,DLG_Calendar2
	invoke	dlclose,DLG_Calendar
	mov	dx?,day
	mov	bx?,month
	mov	cx?,year
    cmcalendar_end:
	mov	ax?,result
	ret
cmcalendar endp

	end
