include	clib.inc
include	dir.inc
include	io.inc
include	iost.inc
include	string.inc
include	errno.inc
include	conio.inc
include mouse.inc
include	version.inc
include	tview.inc

stderrmsg proto

	public	tvflag
	public	fsflag
	public	searchstring
	public	configpath
	public	configfile
	public	tv_class
	public	tv_clversion
	public	tv_classsize
	public	tv_classrow
	public	_stklen

	extrn	_argc:word
	extrn	_argv:dword
	extrn	tvmem_offs:dword
	extrn	tvmem_size:dword

	.data

_stklen	dw 	3000h

cp_info	label byte
	db	'Text View Version ',VERS?,' Copyright (c) 1998-2012 Hjort Nidudsson',13,10
size_info = $ - offset cp_info

cp_usage label byte
	db	'Syntax is: TV [-options] [file]',13,10
	db	13,10
	db	'  -t',9,9,   	'View Text',13,10
	db	'  -b',9,9,   	'View Binary',13,10
	db	'  -h',9,9,   	'View Hex',13,10
	db	'  -m',9,9,	'View Memory [00000..FFFFF]',13,10
	db	'  -o<offset>',9, 'Start offset',13,10
	db	'  -s<size>',9,	'Limit size of memory to <size>',13,10
	db	'  -q',9,9,	'quiet - no logo',13,10
size_usage = $ - offset cp_usage

cp_ini label byte
	db	'[TVColor]',13,10
	db	'00=17',13,10
	db	'01=1F',13,10
size_ini = $ - offset cp_ini

option_q	db 0
tv_cfg		db 'tv.cfg',0
tv_ini		db 'tv.ini',0
arg_file	dd 0
arg_offset	dd 0
arg_size	dd 0
configpath	db WMAXPATH dup(0)
configfile	db WMAXPATH dup(0)

tvflag		db _TV_HEXOFFSET or _TV_USEMLINE
fsflag		db 0
searchstring	db 128 dup(0)
tv_clversion	dw CLVERSION
tv_classsize	dw CLCOUNT
tv_classrow	dw CLCOUNT
tv_class	S_CLASS CLCOUNT dup(<'byte',1,CLTYPE_BYTE,CLFORM_HEX>)
size_config	= $ - offset tvflag

	.code

main	PROC c public
	.if _argc == 1
	print_usage:
	    mov cx,size_info
	    mov dx,offset cp_info
	    call stderrmsg
	    mov cx,size_usage
	    mov dx,offset cp_usage
	    call stderrmsg
	    xor ax,ax
	    ret
	.endif
	mov bx,word ptr _argv
	invoke strcpy, addr configpath, [bx]
	invoke strfn, dx::ax
	mov bx,ax
	mov byte ptr [bx-1],0
	invoke strfcat, addr configfile, addr configpath, addr tv_cfg
	.if func(osopen, dx::ax, _A_NORMAL, M_RDONLY, A_OPEN) != -1
	    push ax
	    invoke osread, ax, addr tvflag, size_config
	    call close
	.endif
	xor ax,ax
	mov si,1
    arg_loop:
	cmp si,_argc
	jae init_info
	les bx,_argv
	mov ax,si
	inc si
	shl ax,2
	add bx,ax
	les bx,es:[bx]
	mov ax,es:[bx]
	cmp al,'?'
	je print_usage
	cmp al,'/'
	je options
	cmp al,'-'
	je options
	mov word ptr arg_file,bx
	mov word ptr arg_file+2,es
	jmp arg_loop
    options:
	mov al,ah
	or al,20h
	.if al == 't'
	    and tvflag,not (_TV_HEXVIEW or _TV_BINVIEW)
	.elseif al == 'b'
	    or tvflag,_TV_BINVIEW or _TV_HEXVIEW
	.elseif al == 'h'
	    or tvflag,_TV_HEXVIEW
	.elseif al == 'm'
	    mov STDI.ios_flag,IO_MEMREAD
	.elseif al == 'o'
	    add bx,2
	    invoke strtol, es::bx
	    stom arg_offset
	.elseif al == 's'
	    add bx,2
	    invoke strtol, es::bx
	    stom arg_size
	.elseif al == 'q'
	    inc option_q
	.else
	    jmp print_usage
	.endif
	jmp arg_loop
    init_info:
	.if !option_q
	    mov cx,size_info
	    mov dx,offset cp_info
	    call stderrmsg
	.endif
	.if STDI.ios_flag != IO_MEMREAD
	    .if func(access, arg_file, 0)
		invoke strcpy, addr cp_info, arg_file
		call eropen
		xor ax,ax
		ret
	    .endif
	.endif
      ifdef __MOUSE__
	call mouseon
      endif
	invoke	strfcat, addr configfile, addr configpath, addr tv_ini
	.if func(access, dx::ax, 0)
	    .if func(osopen, addr configfile, _A_NORMAL, M_WRONLY, A_CREATE or A_TRUNC) != -1
		push ax
		invoke oswrite, ax, addr cp_ini, size_ini
		call close
	    .endif
	.endif
	invoke tview, arg_file, arg_offset, arg_offset, arg_size
      ifdef __MOUSE__
	call mouseoff
      endif
	invoke strfcat, addr configfile, addr configpath, addr tv_cfg
	.if func(osopen, dx::ax, _A_NORMAL, M_WRONLY, A_CREATE or A_TRUNC) != -1
	    push ax
	    invoke oswrite, ax, addr tvflag, size_config
	    call close
	.endif
	xor ax,ax
	ret
main	ENDP

	END
