
DATA "|     MD5 Calculator | Released 2013-02-10 by DOS386     |"
DATA "| Algorithm (C) 1992 RSA, cracked 2005 but who cares :-D |"

DATA "| Syntax: MD5 infile [outfile] [$sizeoverride] [#sizeoverride] |"

'' Compile with FB 0.24 (use GAS "AS.EXE" from 0.23 if in trouble)

'' License:
'' MD5 code is (C) 1992 by RSA - fact must be mentioned if code
'' reused in derivative works, see below.
'' Other code is (C) 2013 by DOS386 - fact must be mentioned if notable
'' parts of it reused in derivative works.
'' Not to be used inside the virtual hell (NTVDM, VirtualPC, ...).

'' System requirements:
'' DOS: 80386 CPU | 2 MiB RAM | EDR-DOS 7.01.08, FreeDOS 1.1 or compatible
'' Non-DOS: FPU (at least 80387) | Enough CPU and RAM to boot up at all

'' Performance: Win32 binary via HX is faster than DGJPP-style DOS binary
'' Tested with UDMA-incapable device and making sure that file is NOT cached
'' FBMD5 Win32 2013      : FreeDOS + HX 63 s
''                         EDR-DOS + HX 53 s
''                         Win32 (ME)   50 s <<<--- !!! WINNER !!!
'' TotalCommander 7.04   :              61 s
'' FreeCommander 2009.02 :              61 s
'' Conclusion: TotalCommander and FreeCommander most likely
'' pirated their poor MD5 implementation from each other ;-)

'' "http://freebasic.net/forum/viewtopic.php?t=5288" "MD5 Calculator"
'' "http://en.wikipedia.org/wiki/MD5"
'' "http://tools.ietf.org/html/rfc1321"
'' "http://ibiblio.org/pub/micro/pc-stuff/freedos/files/util/file/"

'' *******************************
'' *     TYPE'S AND DEFINE'S     *
'' *******************************

type  UINT64  as  ULONGINT
type  UINT32  as  UINTEGER
type  UINT8   as  UBYTE

type  PUINT8P   as  ubyte ptr
type  PUINT32P  as  uinteger ptr

#define  incv(Q)       Q=Q+1
#define  decv(Q)       Q=Q-1
#define  addv(A,B)     A=A+B
#define  subv(A,B)     A=A-B
#define  gluestr(X,Y)  X=X+Y
#define  ueglstr(X,Y)  X=Y+X

#define  CALLSUB

#define  GASUINT32  dword ptr

#define  DIAS    DIM AS
#define  DISHAS  DIM SHARED AS

#define  CL32     4294967295UL             '' $FFFF'FFFF

#define  CL32X64  4294967295ULL            '' $0000'0000'FFFF'FFFF
#define  CL64X64  18446744073709551615ULL  '' $FFFF'FFFF'FFFF'FFFF

#define  C128GIB  137438953472ULL          '' 137'438'953'472 = 128 GiB

'' *************************
'' *     GLOBAL DIMX'S     *
'' *************************

'' Global variables needed for BUOB SUB's

DISHAS STRING VGSPASS
'' Global ^^^ string passing into and from SUB's and misc junk usage
DISHAS STRING VGSKMGTPE
'' Const ^^^ for BUOB
DISHAS UINT32 VGN32KMGTPE
'' Address ^^^ of the stuff

'' Global variables needed for SSINCREMENT

DISHAS STRING VGSTEMP1 '' In and out

'' ---------------------------------------------------------------------

#DEFINE _FILE_OFFSET_BITS=64
#DEFINE FILE_OFFSET_BITS=64

#include once "crt.bi" '' Otherwise the "C"-stuff won't work

#ifdef __FB_DOS__

  '' DPMI stuff declarations
  #include "dos/go32.bi"

  '' Don't care about environment variables (saves cca 2 KiB)
  Sub __crt0_load_environment_file Cdecl Alias _
   "__crt0_load_environment_file" ( Byval progname As Zstring Ptr )
  End Sub

#endif

declare sub PEEKTIMER182 (BYREF AS UINT64) '' Returns result in 55 ms units

'' ---------------------------------------------------------------------

' RSA Data Security, Inc., MD5 message-digest algorithm

' Copyright (C) 1992, RSA Data Security, Inc. Created 1991. All
' rights reserved.

' License to copy and use this software is granted provided that it
' is identified as the "RSA Data Security, Inc. MD5 Message-Digest
' Algorithm" in all material mentioning or referencing this software
' or this function.

' License is also granted to make and use derivative works provided
' that such works are identified as "derived from the RSA Data
' Security, Inc. MD5 Message-Digest Algorithm" in all material
' mentioning or referencing the derived work.

' RSA Data Security, Inc. makes no representations concerning either
' the merchantability of this software or the suitability of this
' software for any particular purpose. It is provided "as is"
' without express or implied warranty of any kind.

' These notices must be retained in any copies of any part of this
' documentation and/or software.

'' ---------------------------------------------------------------------

DISHAS FILE PTR QQ        '' That's "C" :-o

#ifdef __FB_DOS__
  DIM SHARED AS UINT32 DDS
#endif

DIM SHARED AS UINT8    SEPARAT=1 '' Separators in result hex string
DIM SHARED AS UINT8    LOWERC=0  '' Causes lowercase hex

DIM SHARED AS UINT8 PADDING(64) => { _
  &H80, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, _
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, _
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 _
}

'' ---------------------------------------------------------------------

'' Constants for MD5Transform routine.

#define S11 7
#define S12 12
#define S13 17
#define S14 22
#define S21 5
#define S22 9
#define S23 14
#define S24 20
#define S31 4
#define S32 11
#define S33 16
#define S34 23
#define S41 6
#define S42 10
#define S43 15
#define S44 21

type MD5CTX
  state(4)   as UINT32  '' state (ABCD)
  count(2)   as UINT32  '' number of bits, modulo 2^64 (lsb first)
  buffer(64) as UINT8   '' input buffer
end type

'' -----------------------------------------------------------

'' F, G, H and I are basic MD5 functions.

#define F(x, y, z) (((x) and  (y)) or ((not x) and (z)))
#define G(x, y, z) (((x) and  (z)) or ((y) and (not z)))
#define H(x, y, z) ( (x) xor  (y)  xor (z))
#define I(x, y, z) ( (y) xor ((x)  or (not z)))

'' ROTATELEFT rotates x left n bits (not used)

'' #define ROTATELEFT(x, n) (((x) shl (n)) or ((x) shr (32-(n))))

'' FF, GG, HH, and II transformations for rounds 1, 2, 3, and 4.
'' Rotation is separate from addition to prevent recomputation.

#macro FF(a, b, c, d, x, s, ac)
 (a) += F (b, c, d) + x + ac
  '' (a) = ROTATELEFT (a, s)
  ASM ROL GASUINT32 [a],s
 (a) += (b)
#endmacro
#macro GG(a, b, c, d, x, s, ac)
 (a) += G (b, c, d) + x + ac
  '' (a) = ROTATELEFT (a, s)
  ASM ROL GASUINT32 [a],s
 (a) += (b)
#endmacro
#macro HH(a, b, c, d, x, s, ac)
 (a) += H (b, c, d) + x + ac
  '' (a) = ROTATELEFT (a, s)
  ASM ROL GASUINT32 [a],s
 (a) += (b)
#endmacro
#macro II(a, b, c, d, x, s, ac)
 (a) += I (b, c, d) + x + ac
  '' (a) = ROTATELEFT (a, s)
  ASM ROL GASUINT32 [a],s
 (a) += (b)
#endmacro

'' ---------------------------------------------------------------------

'' **********************
'' *     BUOB SUB'S     *
'' **********************

'' VGSKMGTPE="KMGTPE" : VGN32KMGTPE=CAST(UINT32,STRPTR(VGSKMGTPE)) '' In Main

'' ---------------------------------------------------------------------

SUB SSTRH (BYVAL VLN64NUM AS UINT64, BYVAL VLN8FF AS UINT8)

DIAS UINT64 VLN64REM
DIAS UINT8  VLN8DIG, VLN8COUNT
DIAS UINT8  VLBFFB

'' STR$ and HEX$ replacement, 64-bit unsigned, HEX numbers use UPPERCASE
'' Minimal number formatting as DEC or HEX
'' Adds apo's by default, doesn't add dollar "$" or cross "#"
'' Value can be 0 ... $FFFF'FFFF'FFFF'FFFF = #18'446'744'073'709'551'615
'' Format flag VLN8FF controls output format:
'' - 0 is HEX, pads to even number only
'' - 1 to 3 is DEC, 2 or 3 is minimal size padded to
'' - 4 is HEX again, but padded to even number and 4 digits at least
'' - 5, 6, 7 prohibited
'' - Bit b3 (8) disables adding apo's
'' Hex numbers including 0 are always padded to even number
'' of digits - "0" -> "00" , "FFFFF" -> "0F'FFFF"
'' Dec numbers can be padded to at least 2 or 3 digits: 7 -> "07" or "007"
'' Decimal ZERO can be padded as well 0 -> "00" or "000"
'' Result in VGSPASS, decimal string size can be up
'' to 26 bytes (not including a "#" or terminating ZERO)
'' VLN64REM is division by 10 remainder
'' VLN8DIG is just picked digit, later reused for missing ZERO's counting
'' VLN8COUNT amount of digits (not including the apo's)
'' VLBFFB is booleanious flag brewed from VLN8FF : 0 HEX , 1 DEC

  VGSPASS="0" : VLN8COUNT=1 : VLBFFB=0 '' Pre-Assume HEX and ZERO

  IF ((VLN8FF AND 3)<>0) THEN VLBFFB=1 '' Indeed DEC

  IF (VLN64NUM<>0) THEN '' Indeed non-ZERO

    VGSPASS="" : VLN8COUNT=0
    DO

      IF (VLN64NUM=0) THEN EXIT DO

      IF (VLBFFB=1) THEN '' DEC
        VLN64REM = VLN64NUM MOD 10
        VLN64NUM = VLN64NUM \ 10
        VLN8DIG=CAST(UINT8,VLN64REM)
      ELSE '' Above DEC, below HEX
        VLN8DIG=CAST(UINT8,VLN64NUM) AND 15
        IF (VLN8DIG>9) THEN addv(VLN8DIG,7) '' No "DAS" in FB :-(((((
        VLN64NUM = VLN64NUM SHR 4
      ENDIF

      addv(VLN8DIG,48)

      IF (((VLN8FF AND 8)=0) AND (VLN8COUNT>0) AND _
      (((VLBFFB=1) AND ((VLN8COUNT MOD 3)=0)) OR _
       ((VLBFFB=0) AND ((VLN8COUNT AND 3)=0)))) THEN ueglstr(VGSPASS,"'")

      ueglstr(VGSPASS,CHR$(VLN8DIG)) : incv(VLN8COUNT)

    LOOP

  ENDIF '' (VLN64NUM<>0) THEN '' Indeed non-ZERO

  VLN8FF = VLN8FF AND 7 '' Delete possible no-apo-flag now
  VLN8DIG=0 '' Now counts "missing" ZERO's
  IF ((VLBFFB=0) AND ((VLN8COUNT AND 1)=1)) THEN VLN8DIG=1 '' Even pad of HEX
  IF (VLN8COUNT<VLN8FF) THEN VLN8DIG=VLN8FF-VLN8COUNT '' Min. pad DEC or HEX
  DO
    IF (VLN8DIG=0) THEN EXIT DO
    ueglstr(VGSPASS,"0")
    decv(VLN8DIG)
  LOOP

END SUB '' SSTRH

'' ---------------------------------------------------------------------

SUB SBUOB (BYVAL VLN64BUM AS UINT64, BYVAL VLN8BUK AS UINT8)

DIAS STRING VLSMOW
DIAS UINT8  VLN8QQ2, VLN8QQ3
DIAS UINT32 VLN32QQ4

'' Formats number as BUOB, input can be ZERO also
'' Will return an empty string if BUOB not available (value<1024)
'' If (and all conditions)
'' - BUOB is inexact
'' - BUOB is < 10
'' - There are decimlas 1 to 9 avaialable
'' then 1/10th are given, otherwise integer only.
'' 0 to 1 KiB-1 no BUOB available, 1023 bytes __NOT__ round up
'' 1 KiB to 10 KiB BUOB is KiB, 1/10th are given if inexact, > 0.5 round up
'' 10 KiB to 1 MiB-1 BUOB is KiB, no 1/10th, 1023.9xx KiB __NOT__ round up
'' 1 MiB to 10 MiB BUOB is MiB, 1/10th are given if inexact
'' Doesn't add any leading or trailing spaces
'' VLN8BUK bits: b0: add "= " or "~ " | b1: skip space | b2: input is in KiB
'' Setting both b0 and b1 is valid but not very useful: "= 2MiB" or "~ 2MiB"
'' Effect of b1 and b2 set: 0 -> "" | 1 -> "1KiB" | 1'048'575 -> "1'023MiB"
'' If BUOB is additional can be exact integer amount -> "=" or inexact -> "~"
'' VLN8QQ2 is evaluating BUOB type: 0 no BUOB 1 K 2 M 3 G 4 T 5 P 6 E
'' VLN8QQ3 holds upper 8 bits of remainder for later, 0 if all 60 bits exact
'' VLN32QQ4 holds temporarily the reduced value 1...1023

  '' Control bit b2
  IF (VLN8BUK AND 4) THEN VLN64BUM = VLN64BUM SHL 10

  '' Pre-assume BUOB not available or exact if at all
  VLSMOW="" : VLN8QQ2=0 : VLN8QQ3=0

  '' Division loop, find out what we got
  DO
    IF (VLN64BUM<1024) THEN EXIT DO '' Can't SHR anymore
    incv(VLN8QQ2) '' Got BUOB or bigger BUOB
    IF ((CAST(UINT32,VLN64BUM) AND 1023) = 0) THEN '' Chance for exact
      VLN64BUM=VLN64BUM SHR 10 '' DIV by 1024, keep QQ3 as is good or bad
    ELSE '' Above chance for exact, below definitely inexact
      VLN64BUM=VLN64BUM SHR 2 '' DIV by 4
      VLN8QQ3=CAST(UINT8,VLN64BUM) '' Now we have high 8 bits from 10
      IF (VLN8QQ3=0) THEN VLN8QQ3=1 '' Here ZERO is prohibited !!!
      VLN64BUM=VLN64BUM SHR 8 '' DIV by 256 -> total by 10 | DIV 1024
    ENDIF
  LOOP

  IF (VLN8QQ2<>0) THEN '' BUOB's are available ???

    VLN32QQ4=CAST(UINT32,VLN64BUM) '' Get reasonale integer

    IF (VLN8QQ3=0) THEN '' BUOB's are exact ???
      IF (VLN8BUK AND 1) THEN gluestr(VLSMOW,"= ")
      CALLSUB SSTRH (VLN32QQ4,1) '' Decimal, no padding, 1 to 1023
      gluestr(VLSMOW,VGSPASS) '' Got integer
    ELSE '' Above exact, below inexact
      IF (VLN8BUK AND 1) THEN gluestr(VLSMOW,"~ ")
      IF (VLN32QQ4>=10) THEN '' No decimlas, round up
        IF ((VLN8QQ3>127) AND (VLN32QQ4<1023)) THEN incv(VLN32QQ4) '' Up
        CALLSUB SSTRH (VLN32QQ4,1) : gluestr(VLSMOW,VGSPASS) '' Got integer
      ELSE '' Below 1...9, possibly decimals, get just one digit via CHR$
        gluestr(VLSMOW,CHR$(CAST(UINT8,VLN32QQ4)+48))
        IF (VLN8QQ3<244) THEN addv(VLN8QQ3,12) '' Round up, 255\26 is 9
        VLN8QQ3=VLN8QQ3 \ 26 '' Convert 1/256th to 1/10th, precision is bad
        IF (VLN8QQ3<>0) THEN '' Got decimals | 1.05xxx becomes 1.1
          gluestr(VLSMOW,".")
          gluestr(VLSMOW,CHR$(VLN8QQ3+48)) '' Can be 1 ... 9 only
        ENDIF '' (VLN8QQ3<>0) THEN '' Got decimals | 1.05xxx becomes 1.1
      ENDIF '' (VLN32QQ4>=10) ELSE '' No decimlas, round up
    ENDIF '' (VLN8QQ3=0) ELSE '' BUOB's are exact ???

    IF ((VLN8BUK AND 2)=0) THEN gluestr(VLSMOW," ") '' Add space if not prohi
    decv(VLN8QQ2) '' 1 ... 6 to 0 ... 5
    VLN8QQ3=PEEK(VGN32KMGTPE+CAST(UINT32,VLN8QQ2))
    gluestr(VLSMOW,CHR$(VLN8QQ3)) : gluestr(VLSMOW,"iB")

  ENDIF '' (VLN8QQ2<>0) THEN '' BUOB's are available ???

  '' Return it
  VGSPASS=VLSMOW

END SUB '' SBUOB

'' ---------------------------------------------------------------------

SUB VALX64 (BYVAL VLBFAG AS UINT8, BYREF VRN64RES AS UINT64)

DIAS UINT64 VLN64RESU
DIAS UINT8  VLN8QUAK, VLN8QUAL, VLN8QUAM '' Chars and counters
DIAS UINT8  VLBO, VLBP, VLBQ '' Internal flags: HEX, negative, digit occur

'' VAL...blah (VALINT, VALUINT, VALLNG, VALIUM, VAULULNG, ...) replacement
'' For DEC and HEX numbers, 64-bit, also negative, skips apo's
'' Value can be 0 ... $FFFF'FFFF'FFFF'FFFF = #18'446'744'073'709'551'615
'' Checks for overflow - unreasonably big strings return $FFFF'FFFF'FFFF'FFFF
'' Note: A decimal string can be up
'' to 26 bytes (including useful apo's, not including the "#" or sign)
'' If VLBFAG is 0 faulty chars (apo isn't) will be skipped, otherwise abort
'' Empty or not valid input returns ZERO
'' Input in VGSPASS, preserved
'' Hex numbers are supported, prefix with "$" , both lowercase and UPPERCASE
'' Prefixing decimal numbers with "#" isn't required but won't hurt
'' Negative numbers are supported (returned as UINT as well), prefix with "-"
'' Multiple prefixes possible, "-$" is valid as $-" , "$#" or "#$##" does HEX
'' Apo's are skipped, "$FFFF'FFFF" is valid, also "1'024" or ugly "'''4'5'6'"

  VLN64RESU=0 : VLBO=0 : VLBP=0 : VLBQ=0 '' Pre-assume not negative not HEX
  '' Prepare convert loop, handle "$" , "#" and "-" , skip apo's + other junk
  VLN8QUAK=1 : VLN8QUAL=LEN(VGSPASS)
  IF (VLN8QUAL>28) THEN VLN8QUAL=28 '' Don't process > 28 chars
  DO '' Convert loop
    IF (VLN8QUAK>VLN8QUAL) THEN EXIT DO '' Done
    VLN8QUAM=ASC(VGSPASS,VLN8QUAK) '' 35 cross 36 dollar 39 apo 45 minus
    IF (VLBQ=0) THEN '' Accept cross, dollar & minus only preceding digits
      IF (VLN8QUAM=35) THEN VLN8QUAM=39 '' Cross: no action, silently ignore
      IF (VLN8QUAM=36) THEN '' Dollar
        VLBO=1 : VLN8QUAM=39 '' Hex
      ENDIF
      IF (VLN8QUAM=45) THEN '' Minus
        VLBP=1 : VLN8QUAM=39 '' Negative
      ENDIF
    ENDIF '' (VLBQ=0) THEN '' Accept cross, dollar & apo only preceding
    IF (VLN8QUAM<>39) THEN '' Char not yet eaten as good, try HEX nd DEC
      IF (VLN8QUAM>96) THEN subv(VLN8QUAM,32) '' UCASE possible letters
      subv(VLN8QUAM,48)
      IF (VLBO=1) THEN '' HEX
        IF (VLN8QUAM>9) THEN '' Could be "A" to "F"
          IF (VLN8QUAM<17) THEN '' 48+17 = 65 | 17 is good 16 is evil
            VLN8QUAM=255 '' Tag as junk
          ELSE
            subv(VLN8QUAM,7) '' Yeah ... chance to be valid
          ENDIF
        ENDIF '' (VLN8QUAM>9) '' Could be "A" to "F"
        IF (VLN8QUAM<16) THEN '' Try to add HEX digit
          IF (VLN64RESU>=1152921504606846976) THEN '' Can't add digit anymore
            VLN64RESU=CL64X64 : EXIT DO
          ENDIF
          VLN64RESU=(VLN64RESU SHL 4) + CAST(UINT64,VLN8QUAM)
          '' Safe ^^^ to SHL and add, HEX 0...15 only, add :-)
          VLBQ=1 : VLN8QUAM=39 '' Tag as valid
        ENDIF
      ELSE '' Above HEX, below DEC
        IF (VLN8QUAM<10) THEN
          IF (VLN64RESU>=1844674407370955162) THEN '' Can't add digit anymore
            VLN64RESU=CL64X64 : EXIT DO
          ENDIF
          VLN64RESU=VLN64RESU * 10 '' Safe to MUL for now
          IF (VLN64RESU>=18446744073709551610) THEN '' Risky to add digit
            addv(VLN64RESU,CAST(UINT64,VLN8QUAM))
            IF (VLN64RESU<10ull) THEN VLN64RESU=CL64X64 '' Overflowed
            EXIT DO '' Added or not, in either case give up now
          ENDIF
          addv(VLN64RESU,CAST(UINT64,VLN8QUAM)) '' Here 0...9 only, add :-)
          VLBQ=1 : VLN8QUAM=39 '' Tag as valid
        ENDIF
      ENDIF '' (VLBO=1) ELSE
    ENDIF '' (VLN8QUAM<>39) THEN '' Char not yet eaten as good
    IF ((VLN8QUAM<>39) AND (VLBFAG=1)) THEN EXIT DO '' Faulty char, give up
    incv(VLN8QUAK)
  LOOP
  IF (VLBP=1) THEN VLN64RESU = 0 - VLN64RESU '' Negative

  VRN64RES=VLN64RESU

END SUB '' VALX64

'' ---------------------------------------------------------------------

SUB SFORNUM (BYVAL VLN64QYQ AS UINT64, BYVAL VLN8FLAGS AS UINT8)

DIAS STRING VLSQQ1
DIAS UINT8  VLN8CRBITS

'' Formats number for output DEC, HEX and BUOB (binary units of bloat)
'' VLN64QYQ is input number, can be 0, returns just "0"
'' VLN8FLAGS holds control flags: b0:DEC b1:HEX b2:BUOB | >=8 is prohibited
'' At least 1 of 3 bits must be used/set, otherwise result is just "0"
'' Additional BUOB can be exact integer amount -> "=" or inexact -> "~"
'' BUOB only is possible, no "=" or "~" then, just number + space + BUOB text
'' Uses SSTRH and SBUOB
'' VLSQQ1 is growing output string, VGSPASS is set at the end
'' VLN8CRBITS holds control bits for SBUOB called from here
'' We use neither STR$ nor HEX$ here :-)))

  IF ((VLN64QYQ=0) OR (VLN8FLAGS=0)) THEN

    VGSPASS="0"

  ELSE

    '' Common
    VLSQQ1=""

    '' DEC
    IF ((VLN8FLAGS AND 1) = 1 ) THEN '' We want DEC
      CALLSUB SSTRH (VLN64QYQ,1) : VLSQQ1=VGSPASS '' Not padded
    ENDIF '' ((VLN8FLAGS AND 1) = 1 ) THEN '' We want DEC

    '' Separate dec and hex
    IF ((VLN8FLAGS AND 3) = 3 ) THEN gluestr(VLSQQ1," = $") '' Want DEC&HEX

    '' Hex
    IF ((VLN8FLAGS AND 2) = 2 ) THEN '' We want HEX
      CALLSUB SSTRH (VLN64QYQ,0)
      gluestr(VLSQQ1,VGSPASS) '' No "pad to 4 min"
    ENDIF '' ((VLN8FLAGS AND 2) = 2 ) THEN '' We want HEX

    '' BUOB
    IF ((VLN8FLAGS AND 4) = 4 ) THEN '' We want BUOB
      VLN8CRBITS=0 '' b0: add "= " or "~ " | b1: skip space | b2: input KiB
      IF ((VLN8FLAGS AND 3)<>0) THEN '' Have DEC or HEX already
        gluestr(VLSQQ1," ") '' SBUOB will __NOT__ add the leading space
        VLN8CRBITS=1 '' Add "= " or "~ "
      ENDIF
      CALLSUB SBUOB (VLN64QYQ,VLN8CRBITS) : gluestr(VLSQQ1,VGSPASS)
    ENDIF '' ((VLN8FLAGS AND 4) = 4 ) THEN '' We want BUOB

    '' Common
    VGSPASS=VLSQQ1

  ENDIF '' ((VLN64QYQ=0) OR (VLN8FLAGS=0)) ELSE

END SUB '' SFORNUM

'' *************************
'' *     INCREMENT SUB     *
'' *************************

SUB SSINCREMENT

'' - Works on VGSTEMP1 (must have 2 to 254 chars before extension)
'' - Increments filename, not extension, returns "" on failure
'' - Will NOT touch ZERO'th character: "BZX"->"BZY"->"BZZ"->EOF
'' - This is supposed to be fool-proof, no input string may crash
''   it or produce invalid results

DIAS UINT32 VLN32COOL,VLN32STRPPP,VLN32STRPOS

  VLN32STRPPP=CAST(UINT32,STRPTR(VGSTEMP1))
  VLN32COOL=INSTR(VGSTEMP1,".") : VLN32STRPOS=0UL
  IF (VLN32COOL=0UL) THEN VLN32COOL=LEN(VGSTEMP1)+1UL '' Non-inclusiv 1-based
  IF ((VLN32COOL>2UL) AND (VLN32COOL<255UL)) THEN

    subv(VLN32COOL,2UL) '' Now inclusive ZERO-based, can be >= 1
    VLN32STRPOS=VLN32STRPPP+VLN32COOL '' Is non-ZERO

    ASM

        mov    eax, [VLN32STRPOS]
        mov    ch, [VLN32COOL]  '' May NOT be ZERO on entry !!!
jj0:    mov    dl, [eax]        '' Pick
        cmp    dl, 48
        jb     jj1            '' NOT incrementable nor wrappable
        cmp    dl, 90
        ja     jj1            '' NOT incrementable nor wrappable
        cmp    dl, 64
        ja     jj2            '' Letter, OK
        cmp    dl, 57
        ja     jj1            '' NOT incrementable nor wrappable
jj2:    mov    dh, 1          '' Pre-ASS'ume "evil" wrap
        mov    cl, 48
        cmp    dl, 57
        je     jj3            '' Hit "9", wrap
        mov    cl, 65
        cmp    dl, 90
        je     jj3            '' Hit "Z", wrap
        inc    dl             '' Safe to increment
        mov    cl, dl
        dec    dh             '' OK, done, not "evil" wrap
jj3:    mov    [eax], cl      '' POKE it back (incremented or wrapped)
        test   dh, dh         '' CMPNTQ DH,0
        jz     jj5            '' Done !
jj1:    dec    ch
        jz     jj4            '' F**K !!! (don't touch ZERO'th character)
        dec    eax            '' Safe to decrement
        jmp    jj0
        '' -------

jj4:    xor    eax, eax           '' MOVNTQ EAX,0
        mov    [VLN32STRPOS], eax '' Failure
jj5:

    END ASM

  ENDIF '' ((VLN32COOL>2UL) AND (VLN32COOL<255UL)) THEN

  IF (VLN32STRPOS=0UL) THEN VGSTEMP1="" '' Failure

END SUB '' SSINCREMENT

'' ---------------------------------------------------------------------

'' MD5 initialization. Begins an MD5 operation, writing a new context.

sub MD5Init (context as MD5CTX ptr)

  '' Set size to ZERO
  CONTEXT->COUNT(0) = 0UL : CONTEXT->COUNT(1) = 0UL

  '' Load magic initialization constants.
  CONTEXT->STATE(0) = &H67452301
  CONTEXT->STATE(1) = &HEFCDAB89 '' 4023233417
  CONTEXT->STATE(2) = &H98BADCFE '' 2562383102
  CONTEXT->STATE(3) = &H10325476

end sub

'' Encodes inpt (UINT32) into output (UINT8). Assumes len is a multiple of 4.
'' MEMCOPY WHERE<- FROM, SIZE

sub Encode (outpt as PUINT8P, inpt as PUINT32P, LEEN as UINT32) '' static

  DIM AS UINT32 I2, J

  I2 = 0: J = 0

  WHILE J < LEEN
    OUTPT[ J ] = cubyte( INPT[I2]         AND &HFF)
    OUTPT[J+1] = cubyte((INPT[I2] SHR 8)  AND &HFF)
    OUTPT[J+2] = cubyte((INPT[I2] SHR 16) AND &HFF)
    OUTPT[J+3] = cubyte((INPT[I2] SHR 24) AND &HFF)
    I2 += 1 : J += 4
  WEND

END SUB

'' MD5 basic transformation. Transforms state based on block.

sub MD5Transform (BYVAL Q32STAT AS UINT32, BYVAL Q32INPU AS UINT32)

  DIAS UINT32 A, B, C, D '' 4 x 32bits = 4 x 4 Bytes = 16 Bytes

  A = PEEK(UINT32,(Q32STAT     ))
  B = PEEK(UINT32,(Q32STAT+ 4UL))
  C = PEEK(UINT32,(Q32STAT+ 8UL))
  D = PEEK(UINT32,(Q32STAT+12UL))

  '' W1 is base
  '' W2, W3, W4 enter the F, G, H, I functions
  '' W5 (one UINT32 from buffer) is added
  '' W6 - "S" thingies range from 4 to 23, ROL count
  '' W7 is additive constant (sine/sin)

  '' ROUND 1
  FF (A, B, C, D, PEEK(UINT32,(Q32INPU+(4UL* 0UL))), S11, &HD76AA478) ' 1
  FF (D, A, B, C, PEEK(UINT32,(Q32INPU+(4UL* 1UL))), S12, &HE8C7B756) ' 2
  FF (C, D, A, B, PEEK(UINT32,(Q32INPU+(4UL* 2UL))), S13, &H242070DB) ' 3
  FF (B, C, D, A, PEEK(UINT32,(Q32INPU+(4UL* 3UL))), S14, &HC1BDCEEE) ' 4
  FF (A, B, C, D, PEEK(UINT32,(Q32INPU+(4UL* 4UL))), S11, &HF57C0FAF) ' 5
  FF (D, A, B, C, PEEK(UINT32,(Q32INPU+(4UL* 5UL))), S12, &H4787C62A) ' 6
  FF (C, D, A, B, PEEK(UINT32,(Q32INPU+(4UL* 6UL))), S13, &HA8304613) ' 7
  FF (B, C, D, A, PEEK(UINT32,(Q32INPU+(4UL* 7UL))), S14, &HFD469501) ' 8
  FF (A, B, C, D, PEEK(UINT32,(Q32INPU+(4UL* 8UL))), S11, &H698098D8) ' 9
  FF (D, A, B, C, PEEK(UINT32,(Q32INPU+(4UL* 9UL))), S12, &H8B44F7AF) ' 10
  FF (C, D, A, B, PEEK(UINT32,(Q32INPU+(4UL*10UL))), S13, &HFFFF5BB1) ' 11
  FF (B, C, D, A, PEEK(UINT32,(Q32INPU+(4UL*11UL))), S14, &H895CD7BE) ' 12
  FF (A, B, C, D, PEEK(UINT32,(Q32INPU+(4UL*12UL))), S11, &H6B901122) ' 13
  FF (D, A, B, C, PEEK(UINT32,(Q32INPU+(4UL*13UL))), S12, &HFD987193) ' 14
  FF (C, D, A, B, PEEK(UINT32,(Q32INPU+(4UL*14UL))), S13, &HA679438E) ' 15
  FF (B, C, D, A, PEEK(UINT32,(Q32INPU+(4UL*15UL))), S14, &H49B40821) ' 16

  '' ROUND 2
  GG (A, B, C, D, PEEK(UINT32,(Q32INPU+(4UL* 1UL))), S21, &HF61E2562) ' 17
  GG (D, A, B, C, PEEK(UINT32,(Q32INPU+(4UL* 6UL))), S22, &HC040B340) ' 18
  GG (C, D, A, B, PEEK(UINT32,(Q32INPU+(4UL*11UL))), S23, &H265E5A51) ' 19
  GG (B, C, D, A, PEEK(UINT32,(Q32INPU+(4UL* 0UL))), S24, &HE9B6C7AA) ' 20
  GG (A, B, C, D, PEEK(UINT32,(Q32INPU+(4UL* 5UL))), S21, &HD62F105D) ' 21
  GG (D, A, B, C, PEEK(UINT32,(Q32INPU+(4UL*10UL))), S22, &H02441453) ' 22
  GG (C, D, A, B, PEEK(UINT32,(Q32INPU+(4UL*15UL))), S23, &HD8A1E681) ' 23
  GG (B, C, D, A, PEEK(UINT32,(Q32INPU+(4UL* 4UL))), S24, &HE7D3FBC8) ' 24
  GG (A, B, C, D, PEEK(UINT32,(Q32INPU+(4UL* 9UL))), S21, &H21E1CDE6) ' 25
  GG (D, A, B, C, PEEK(UINT32,(Q32INPU+(4UL*14UL))), S22, &HC33707D6) ' 26
  GG (C, D, A, B, PEEK(UINT32,(Q32INPU+(4UL* 3UL))), S23, &HF4D50D87) ' 27
  GG (B, C, D, A, PEEK(UINT32,(Q32INPU+(4UL* 8UL))), S24, &H455A14ED) ' 28
  GG (A, B, C, D, PEEK(UINT32,(Q32INPU+(4UL*13UL))), S21, &HA9E3E905) ' 29
  GG (D, A, B, C, PEEK(UINT32,(Q32INPU+(4UL* 2UL))), S22, &HFCEFA3F8) ' 30
  GG (C, D, A, B, PEEK(UINT32,(Q32INPU+(4UL* 7UL))), S23, &H676F02D9) ' 31
  GG (B, C, D, A, PEEK(UINT32,(Q32INPU+(4UL*12UL))), S24, &H8D2A4C8A) ' 32

  '' ROUND 3
  HH (A, B, C, D, PEEK(UINT32,(Q32INPU+(4UL* 5UL))), S31, &HFFFA3942) ' 33
  HH (D, A, B, C, PEEK(UINT32,(Q32INPU+(4UL* 8UL))), S32, &H8771F681) ' 34
  HH (C, D, A, B, PEEK(UINT32,(Q32INPU+(4UL*11UL))), S33, &H6D9D6122) ' 35
  HH (B, C, D, A, PEEK(UINT32,(Q32INPU+(4UL*14UL))), S34, &HFDE5380C) ' 36
  HH (A, B, C, D, PEEK(UINT32,(Q32INPU+(4UL* 1UL))), S31, &HA4BEEA44) ' 37
  HH (D, A, B, C, PEEK(UINT32,(Q32INPU+(4UL* 4UL))), S32, &H4BDECFA9) ' 38
  HH (C, D, A, B, PEEK(UINT32,(Q32INPU+(4UL* 7UL))), S33, &HF6BB4B60) ' 39
  HH (B, C, D, A, PEEK(UINT32,(Q32INPU+(4UL*10UL))), S34, &HBEBFBC70) ' 40
  HH (A, B, C, D, PEEK(UINT32,(Q32INPU+(4UL*13UL))), S31, &H289B7EC6) ' 41
  HH (D, A, B, C, PEEK(UINT32,(Q32INPU+(4UL* 0UL))), S32, &HEAA127FA) ' 42
  HH (C, D, A, B, PEEK(UINT32,(Q32INPU+(4UL* 3UL))), S33, &HD4EF3085) ' 43
  HH (B, C, D, A, PEEK(UINT32,(Q32INPU+(4UL* 6UL))), S34, &H04881D05) ' 44
  HH (A, B, C, D, PEEK(UINT32,(Q32INPU+(4UL* 9UL))), S31, &HD9D4D039) ' 45
  HH (D, A, B, C, PEEK(UINT32,(Q32INPU+(4UL*12UL))), S32, &HE6DB99E5) ' 46
  HH (C, D, A, B, PEEK(UINT32,(Q32INPU+(4UL*15UL))), S33, &H1FA27CF8) ' 47
  HH (B, C, D, A, PEEK(UINT32,(Q32INPU+(4UL* 2UL))), S34, &HC4AC5665) ' 48

  '' ROUND 4
  II (A, B, C, D, PEEK(UINT32,(Q32INPU+(4UL* 0UL))), S41, &HF4292244) ' 49
  II (D, A, B, C, PEEK(UINT32,(Q32INPU+(4UL* 7UL))), S42, &H432AFF97) ' 50
  II (C, D, A, B, PEEK(UINT32,(Q32INPU+(4UL*14UL))), S43, &HAB9423A7) ' 51
  II (B, C, D, A, PEEK(UINT32,(Q32INPU+(4UL* 5UL))), S44, &HFC93A039) ' 52
  II (A, B, C, D, PEEK(UINT32,(Q32INPU+(4UL*12UL))), S41, &H655B59C3) ' 53
  II (D, A, B, C, PEEK(UINT32,(Q32INPU+(4UL* 3UL))), S42, &H8F0CCC92) ' 54
  II (C, D, A, B, PEEK(UINT32,(Q32INPU+(4UL*10UL))), S43, &HFFEFF47D) ' 55
  II (B, C, D, A, PEEK(UINT32,(Q32INPU+(4UL* 1UL))), S44, &H85845DD1) ' 56
  II (A, B, C, D, PEEK(UINT32,(Q32INPU+(4UL* 8UL))), S41, &H6FA87E4F) ' 57
  II (D, A, B, C, PEEK(UINT32,(Q32INPU+(4UL*15UL))), S42, &HFE2CE6E0) ' 58
  II (C, D, A, B, PEEK(UINT32,(Q32INPU+(4UL* 6UL))), S43, &HA3014314) ' 59
  II (B, C, D, A, PEEK(UINT32,(Q32INPU+(4UL*13UL))), S44, &H4E0811A1) ' 60
  II (A, B, C, D, PEEK(UINT32,(Q32INPU+(4UL* 4UL))), S41, &HF7537E82) ' 61
  II (D, A, B, C, PEEK(UINT32,(Q32INPU+(4UL*11UL))), S42, &HBD3AF235) ' 62
  II (C, D, A, B, PEEK(UINT32,(Q32INPU+(4UL* 2UL))), S43, &H2AD7D2BB) ' 63
  II (B, C, D, A, PEEK(UINT32,(Q32INPU+(4UL* 9UL))), S44, &HEB86D391) ' 64

  POKE UINT32, (Q32STAT     ), PEEK(UINT32,(Q32STAT     )) + A
  POKE UINT32, (Q32STAT+ 4UL), PEEK(UINT32,(Q32STAT+ 4UL)) + B
  POKE UINT32, (Q32STAT+ 8UL), PEEK(UINT32,(Q32STAT+ 8UL)) + C
  POKE UINT32, (Q32STAT+12UL), PEEK(UINT32,(Q32STAT+12UL)) + D

END SUB

'' ---------------------------------------------------------------------

''  MD5 block update operation. Continues an MD5 message-digest
''  operation, processing next message block, and updating the context.

sub MD5Update (context as MD5CTX ptr, inpt as PUINT8P, inptLen as UINT32)

  DIM AS UINT32 I2, INDEX, PARTLEN
  DIM AS UINT32 X32STAT, X32INPU

  X32STAT=CAST(UINT32,@context->state(0))

  '' Compute number of bytes already processed mod 64
  '' Finds index in MD5TRANS's internal buffer where to start
  INDEX = CUINT((CONTEXT->COUNT(0) SHR 3) AND &H3F)

  '' Update number of bits
  context->count(0) += (cuint(inptLen) shl 3) '' Add low 32 bits
  if context->count(0) < (cuint(inptLen) shl 3) then context->count(1)+=1
  context->count(1) += (cuint(inptLen) shr 29) '' Useless for "inptLen" <512 MiB ;-)

  partLen = 64 - index '' Remaining space in buffer

  '' Transform as many times as possible.

  if (inptLen >= partLen) then '' Arel we able to fill the buffer ???

    memcpy (cptr(PUINT8P,@context->buffer(index)), cptr(PUINT8P,inpt), partLen)
    '' MEMCOPY (CONTEXT's buffer + index) <- "inpt" , "partLen" - fill it

    X32INPU=CAST(UINT32,@context->buffer(0))
    MD5Transform (X32STAT,X32INPU)
    '' Process it

    i2 = partLen '' Data from input buffer already "eaten"

    while i2 + 63 < inptLen
        X32INPU=CAST(UINT32,@inpt[i2])
        MD5Transform (X32STAT,X32INPU)
        '' Trans directly avoiding internal buffer
        i2 += 64
    WEND

    INDEX = 0 '' Internal buffer is empty now

  ELSE '' Below we were not able to fill the buffer

    I2 = 0 '' Nothing "eaten" so far, INDEX untouched

  ENDIF

  '' Buffer remaining inpt - it will fit
  memcpy( cptr( PUINT8P, @context->buffer( index ) ), cptr( PUINT8P, @inpt[ i2 ] ), inptLen - i2 )
  '' MEMCOPY (CONTEXT's buffer + index) <- "inpt"+I2 , "partLen"-I2

end sub

'' MD5 finalization. Ends an MD5 message-digest operation, writing the
'' the message digest and zeroizing the context.

sub MD5Final (digest() as UINT8, context as MD5CTX ptr)

  dim as UINT8  bits(8) '' 8 Bytes, 64 bits, UINT64
  dim as UINT32 index, padLen

  '' Save number of bits
  Encode ( @bits( 0 ), @context->count( 0 ), 8 )
  '' MEMCOPY "bits"<-"count",8
  '' Just copying an UINT64 ;-)

  '' Pad out to 56 mod 64
  '' Again,  compute number of bytes already processed mod 64
  INDEX = CUINT((CONTEXT->COUNT(0) SHR 3) AND &H3F)

  '' Will pad to 64 bytes or to 128 bytes
  padLen = iif(index < 56, 56 - index, 120 - index)

  '' Add padding (CONTEXT's internal buffer might be not empty before)
  MD5Update (context, @PADDING( 0 ), padLen)

  '' Append and process length (before padding)  - after this buffer WILL be empty
  MD5Update (context, @bits( 0 ), 8)

  '' Store state in digest
  Encode ( @digest( 0 ), @context->state( 0 ), 16)
  '' MEMCOPY "digest"<-"state",16
  '' Just copying 4 UINT32's ;-)

  '' Zeroize sensitive information from context - probably useless
  memset ( cptr( PUINT8P, context ), 0, sizeof (*context) )

end sub

'' ---------------------------------------------------------------------

'' Converts message digest to hexadecimal string

function MD5Print (digest as PUINT8P) as string

  DIM AS UINT32 QQ32
  DIM AS UINT8  WW1, WW2, WW3
  DIM AS STRING OUTSTRING

  OUTSTRING="": QQ32=0

  DO
     WW1 = DIGEST[QQ32]
     WW2=(WW1 SHR 4) + 48  ' 4 HIGH BITS
     WW3=(WW1 AND 15) + 48 ' 4 LOW BITS
     IF WW2>57 THEN
       WW2=WW2+7 : IF LOWERC=1 THEN WW2=WW2+32
     ENDIF
     IF WW3>57 THEN
       WW3=WW3+7 : IF LOWERC=1 THEN WW3=WW3+32
     ENDIF
     gluestr(OUTSTRING,(CHR$(WW2)+CHR$(WW3)))
     IF (QQ32=15UL) THEN EXIT DO
     IF ((SEPARAT=1) AND ((QQ32 AND 1) = 1)) THEN gluestr(OUTSTRING,"'")
     incv(QQ32)
  LOOP
  RETURN OUTSTRING

end function

'' ---------------------------------------------------------------------

'' *** MAIN ***
''
'' Digests a file and prints the result.

  DIM AS MD5CTX CONTEXT
  DIM AS UINT8  DIGEST (0 TO 16)
  DIM AS UINT8  BUFFER (0 TO 262144)
  DIM AS UINT64 TIMEOLD182, TIMENEW182, TIMEDIFF182, PERFINT
  DIM AS UINT64 VMN64TOTLEN, VMN64OVER, VMN64INCCOUNTER
  DIM AS UINT32 TIMESECINT, VMN32BLOKLEN, VMN32LIMIT, Q32Z
  DIM AS STRING COMMA, VMSINFILE, VMSOUTFILE, VMSTEMP, TEXBUF, SEOL
  DIM AS UINT8  VMN8TEMP1, VMN8TEMP2, VMN8TEMP3
  DIM AS UINT8  VMBFAIL

  ? : READ VMSTEMP : ? VMSTEMP : READ VMSTEMP
  ? VMSTEMP : ? : READ VMSTEMP : ? VMSTEMP : ?

  #ifdef __FB_DOS__
    DDS = _go32_info_block.selector_for_linear_memory '' Go to 32, not to hell
  #endif

  VGSKMGTPE="KMGTPE" : VGN32KMGTPE=CAST(UINT32,STRPTR(VGSKMGTPE)) '' BUOB

  SEOL=CHR$(13)+CHR$(10) : VMSINFILE="" : VMSOUTFILE=""
  VMBFAIL=0 : VMN64OVER=0ULL

  VMN8TEMP1=1
  DO
    #ifdef __FB_LINUX__
      COMMA=COMMAND$(VMN8TEMP1) '' Fix "BUG" point by "sir_mud" 2 years ago
    #else
      COMMA=UCASE$(COMMAND$(VMN8TEMP1))
    #endif
    IF (COMMA="") THEN EXIT DO '' No more arg's
    VMN8TEMP2=ASC(COMMA,1)
    IF ((VMN8TEMP2=35) OR (VMN8TEMP2=36)) THEN '' "#" or "$" override
      VGSPASS=COMMA : CALLSUB VALX64(0,VMN64OVER)
    ENDIF
    IF (VMN8TEMP2>36) THEN '' Filename rules - exist at all ? LFN sucks :-(
      IF VMSINFILE="" THEN
        VMSINFILE=COMMA
      ELSE
        VMSOUTFILE=COMMA
      ENDIF
    ENDIF
    incv(VMN8TEMP1) '' COMMAND$ arg's index
  LOOP
  IF (VMN64OVER>C128GIB) THEN VMN64OVER=C128GIB '' Clamp

  IF ((VMN8TEMP1=1) OR (VMN8TEMP1>4)) THEN
    ? "FATAL: ";
    IF (VMN8TEMP1=1) THEN
      ? "No";
    ELSE
      ? "Too many";
    ENDIF
    ? " arguments found !!!" : ?
    VMBFAIL=1
  ENDIF

  IF (VMBFAIL=0) THEN

    QQ=FOPEN(VMSINFILE,"rb")
    '' Here 0 is evil and <>0 good
    '' "rb" is case sensitive and must be lowercase
    IF (QQ=0) THEN
      PRINT "FATAL: Failed to open file """ + VMSINFILE + """ !!!"
      VMBFAIL=1
    ELSE
      IF (VMN64OVER<>0) THEN
         ? "Size override -> " ;
         VMN64TOTLEN=VMN64OVER
         CALLSUB SFORNUM (VMN64TOTLEN,7) : ? VGSPASS
      ELSE
        ? "GetFileSizeEx -> " ;
        FSEEK(QQ,0,2)
        VMN64TOTLEN=FTELL(QQ) '' !!! ToDo: full fix for DOS !!!
        FSEEK(QQ,0,0)
        IF ((VMN64TOTLEN=0) OR (VMN64TOTLEN>C128GIB)) THEN
          ? "???" : ? "FATAL: Empty or corrupt file !!!"
          FCLOSE(QQ) : VMBFAIL=1
        ELSE
          CALLSUB SFORNUM (VMN64TOTLEN,7) : ? VGSPASS
        ENDIF '' VMNTOTLEN checks
        #ifdef __FB_DOS__
          ? : ? "(believe with care or use size override next time)"
        #else
          ?
        #endif
      ENDIF '' (VMN64OVER<>0)
    ENDIF '' (QQ=0) ELSE branch | QQ was result of FOPEN
    ?

  ENDIF '' (VMBFAIL=0)

  IF (VMBFAIL=0) THEN

    PEEKTIMER182(TIMEOLD182)

    VMN32LIMIT=8192UL : VMN8TEMP2=0 '' BlockGrower, progress
    VMN64INCCOUNTER=0ULL

    MD5Init (@context)
    DO

      IF (VMN64OVER<>0) AND (VMN64OVER=VMN64INCCOUNTER) THEN EXIT DO
      VMN32BLOKLEN=FREAD(@BUFFER(0),1,VMN32LIMIT,QQ)
      '' 1 is size ^^^ of byte - can't live without :-D
      IF (VMN32BLOKLEN>VMN32LIMIT) OR (VMN32BLOKLEN=0) THEN EXIT DO '' ERR or beyond EOF
      IF (VMN64OVER<>0) AND (VMN32BLOKLEN>(VMN64OVER-VMN64INCCOUNTER)) THEN
        VMN32BLOKLEN=VMN64OVER-VMN64INCCOUNTER
      ENDIF
      IF (VMN32BLOKLEN=0) THEN EXIT DO '' Override
      VMN64INCCOUNTER=VMN64INCCOUNTER+CAST(UINT64,VMN32BLOKLEN)
      MD5Update (@context, @buffer(0), VMN32BLOKLEN)
      IF (VMN32LIMIT<262144UL) THEN VMN32LIMIT=VMN32LIMIT SHL 1
      '' Increasing ^^^ from  8 KiB to 256 KiB

      PEEKTIMER182(TIMENEW182)
      TIMEDIFF182 = TIMENEW182-TIMEOLD182
      TIMESECINT  = CAST(UINT32,((5ULL*TIMEDIFF182+45ULL)\91ULL))

      VMN8TEMP3=0
      IF (VMN8TEMP2=0) AND (TIMESECINT>=3)   THEN VMN8TEMP3=1
      IF (VMN8TEMP2=1) AND (TIMESECINT>=12)  THEN VMN8TEMP3=1
      IF (VMN8TEMP2=2) AND (TIMESECINT>=50)  THEN VMN8TEMP3=1
      IF (VMN8TEMP2=3) AND (TIMESECINT>=200) THEN VMN8TEMP3=1
      IF (VMN8TEMP2=4) AND (TIMESECINT>=900) THEN VMN8TEMP3=1
      IF (VMN8TEMP3=1) THEN
        ? STR$(TIMESECINT) + " s , ";
        IF (VMN64INCCOUNTER<VMN64TOTLEN) THEN
          ? STR$(100ULL*VMN64INCCOUNTER\VMN64TOTLEN) + " %"
        ELSE
          ? "??? , " + STR$(VMN64INCCOUNTER SHR 20) + " MiB"
        ENDIF
        incv(VMN8TEMP2)
      ENDIF

    LOOP

    MD5Final (digest(), @context)
    FCLOSE(QQ)
    IF (VMN8TEMP2<>0) THEN ?

    PEEKTIMER182(TIMENEW182)
    TIMEDIFF182 = TIMENEW182-TIMEOLD182
    TIMESECINT  = CAST(UINT32,((5ULL*TIMEDIFF182+45ULL)\91ULL))

    IF (VMN64INCCOUNTER<>VMN64TOTLEN) THEN
      ? "WARNING: File size problem :-D" : ?
    ENDIF

    '' Prepare result into TEXBUF, will get printed to the screen
    '' and maybe additionally written into a file

    CALLSUB SFORNUM (VMN64INCCOUNTER,7) '' Result in VGSPASS
    VMSTEMP=MD5Print(@digest(0))
    TEXBUF = VMSINFILE + " " + VGSPASS + SEOL + VMSTEMP + SEOL

    ? TEXBUF : ? "Time <===> Performance"

    IF (TIMEDIFF182<25ULL) THEN
      ? "Less than 1.5 s <===> ??? (File too small, take a bigger one to test)";
    ELSE
      PERFINT = 91ULL * VMN64INCCOUNTER \ (TIMEDIFF182 * 5120ULL)
      ? STR$(TIMESECINT) + " s <===> " + STR$(PERFINT) + " KiB/s !!!";
      IF (PERFINT<1024ULL) THEN ? " BUH it's slooooooooow !!!";
    ENDIF

    ? : ?

    IF (VMSOUTFILE<>"") THEN

      ? "Writing result to file: """ + VMSOUTFILE + """ ... " ;
      VMN8TEMP2=0 : VGSTEMP1=VMSOUTFILE
      DO
        VMN8TEMP1=FREEFILE
        OPEN VGSTEMP1 FOR BINARY ACCESS READ AS #VMN8TEMP1 '' YES it sucks
        Q32Z=ERR : CLOSE #VMN8TEMP1
        IF (Q32Z<>0) THEN EXIT DO '' Does NOT exist
        CALLSUB SSINCREMENT : incv(VMN8TEMP2)
        IF (VGSTEMP1="") THEN VMN8TEMP2=20 '' Can't increment
        IF (VMN8TEMP2=20) THEN EXIT DO '' Can't increment or 20 attempts done
      LOOP
      IF (VMN8TEMP2=20) THEN
        ? "file exists and increment failed !!!" : VMBFAIL=1
      ELSE
        IF (VMN8TEMP2<>0) THEN
          VMSOUTFILE=VGSTEMP1
          ? "oops, file """ + VMSOUTFILE + """ ... " ;
        ENDIF
        VMN8TEMP1=FREEFILE
        OPEN VMSOUTFILE FOR BINARY ACCESS WRITE AS #VMN8TEMP1 '' YES it sucks
        IF (ERR=0) THEN
          PUT #VMN8TEMP1,,TEXBUF
          IF (ERR<>0) THEN VMBFAIL=1
          CLOSE VMN8TEMP1
          IF (ERR<>0) THEN VMBFAIL=1
        ELSE
          VMBFAIL=1
        ENDIF
      ENDIF
      IF (VMBFAIL=0) THEN
        ? "OK !"
      ELSE
        ? "FAILURE - Result is NOT saved !!!"
      ENDIF
      ?
    ENDIF '' (VMSOUTFILE<>"")

  ENDIF '' (VMBFAIL=0)

END

'' ---------------------------------------------------------------------

SUB PEEKTIMER182 (BYREF VRN64PTRESULT AS UINT64)

DIM AS UINT32 VLN32PEE

'' DOS: Peeks the BIOS timer at $046C | Uses global DDS
'' Non-DOS: Peeks the float "TIMER" function

#ifdef __FB_DOS__

  ASM
      mov  eax,[DDS]
      push eax
      pop  gs          '' ZERO-based selector
      mov  eax,[gs:0x046C]
      mov  [VLN32PEE],eax
  END ASM

  VRN64PTRESULT=CAST(UINT64,VLN32PEE)

#else

  VRN64PTRESULT=CAST(UINT64,TIMER*18.2+0.5)

#endif

END SUB

'' ---------------------------------------------------------------------

