/*
  pg.h
  
  Header file for pg program
  
  (c) BearHeart
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

  Revision Notes
                  bh 95.02.27  Initial Coding
*/

#define true (1)
#define false (0)

#define byte unsigned char
#define word unsigned int

/* video attributes */
#define BLACK   (0x00)
#define BLUE    (0x01)
#define GREEN   (0x02)
#define CYAN    (0x03)
#define RED     (0x04)
#define MAGENTA (0x05)
#define BROWN   (0x06)
#define WHITE   (0x07)
#define BRIGHT  (0x08)
#define BLINK   (0x80)
#define YELLOW  (BROWN | BRIGHT)
#define UNDERLINE (0x01)  /* for MONO only */

#define ATTR(fg,bg)  (((bg) << 4) | (fg))

/* for use with asm */
#define BIOS_DATA_SEG 40h
#define DISP_MODE     49h      
#define DISP_COLS     4ah
#define DISP_ROWS     84h
#define CURSOR        50h

/* for use with c */
#define MONO          (7)
/* keyboard scan codes */
#define PG_UP      (0x4900)
#define PG_DN      (0x5100)
#define KEY_HOME   (0x4700)
#define KEY_END    (0x4F00)
#define KEY_UP     (0x4800)
#define KEY_DN     (0x5000)
#define KEY_LT     (0x4B00)
#define KEY_RT     (0x4D00)
#define RETURN     (0x0D)
#define ESC        (0x1B)
#define SPACE      (0x20)
#define BK_SPACE   (0x08)
#define KEY_A1     (0x7800)   /* from alt1..alt5 */
#define KEY_A2     (0x7900)
#define KEY_A3     (0x7A00)
#define KEY_A4     (0x7B00)
#define KEY_A5     (0x7C00)

/* Symbolic constants */    /* Moved from pg.c by BAHCL */
#define MAXSIZELINE   (256)                 /* maximum size of a line */
#define MAXSEGMENTS   (10)                  /* max segments in far memory */
#define LINESPERSEG   (16384)               /* longs that will fit in 64k */

#define SEEK_SET      (0)                           /* for fseek() */
#define BELL          beep(440, 100)                /* 440Hz tone for 100ms */
#define CO_STATUS     ATTR(BRIGHT | GREEN, MAGENTA)
#define CO_LO_STATUS  ATTR(GREEN,          MAGENTA)
#define CO_TEXT       ATTR(BRIGHT | CYAN,  BLACK)
#define MO_STATUS     ATTR(BLACK,          WHITE)
#define MO_LO_STATUS  ATTR(GREEN,          WHITE)   /* lower contrast  */
#define MO_TEXT       ATTR(BRIGHT | WHITE, BLACK)
/* #define SPACE         (0x20)    Duplicate */      /* ASCII space character */
#define TAB           (0x09)                        /* ASCII tab character */
#define TABSTOPS      (8)

/* More symbolic constants .... */ /* Moved from pg.c by BAHCL */

#define STATOK   0                  /* s/b enum */
#define STATTOP  1
#define STATBOT  2

