

PG 1.03                                                 PG 1.03


NAME
        PG -- PaGer
        A simple text file viewer with FreeDOS



SYNOPSIS
        PG [/?] [filename]
            /?       - display a brief help screen.
            filename - page through filename on the PC screen
            if filename is omitted, show this help screen


DESCRIPTION
        PG is a text file viewer offered by the FreeDOS.
        It browses any text file and with more useful features now.


COMMAND
        Control is intuitive, Keys defined as:

        PG Key      Meaning
        ======      =======
        Esc,Q,q     exit program
        Up          scroll down 1 line
        Down,Enter  scroll up 1 line
        Page Up     scroll down 1 page
        Page Down   scroll up 1 page
        Home        first page
        End         last page
        Left        pan view left 10 columns
        Right       pan view right 10 columns (max. 50)
        1..5        save page to boomark #1..5
        Alt1..Alt5  jump to saved bookmark
        /           search text from top line
        F2          continue to search backward
        F3          continue to search forward
        F4          copy 1 screenful of text to "PG.SAV"


        Bookmarks #1..5
            As you're viewing a text file, press any of the numeric
            keys 1..5 (under the Function keys), for instance, pressing
            '1' will save the top position of the file you're viewing to
            bookmark #1. Later on, when you want to return to the place
            where you left bookmark #1, just press 'Alt' and '1' brings
            you back no matter how far you've been.
            Bookmark #1 can be updated whenever you press '1' again.
            The same is true to other bookmark keys.

        '/' Search text
            To start a search, just press the '/' key, you're prompted
            to input a string, then hit the enter key to let it go.
            The search start from the top line of your screen, then
            to next line and so on.  If the string is found, the
            line number of the string found appears behind the
            search string.  If it is not found, nothing happens.
            Press '/' again means to start a new search.

        F2  continues to search backward for the next occurrence,
            the line number appears at the bottom status line if
            the search is successful. It disappears if the search
            failed.

        F3  continues to search forward for the next occurrence,
            the line number appears at the bottom status line if
            the search is successful. It disappears if the search
            failed.

        F4  Save screen to "PG.SAV"   (PG version 1.04 only)
            When we're are viewing a file, sometimes, we tend to get
            an extract from the source instead of retyping.
            PG allows us to save a screenful of text when we press the
            'F4' key to save the text in your screen.
            A file "PG.SAV" will be created in the default directory
            once we quit PG.  If you pressed F4 many times, only the
            last screen is saved.




PACKAGE (version 1.03)
        PG.C        - C source program
        PG.H        - C header
        PG.MAN      - manual (this file)
        PG.COM      - the program
        PGASM.ASM   - Assembly subroutines
        NEWS        - anouncement
        TO_DO       - job list
        COPYING     - Copyright



INSTALL PG (version 1.03)
        To compile PG you need to have DDS Micro-C. v3.22
        PG does not (currently) build using any other C compiler.

        Type:
           cc pg.c -fop

        This will generate the PG.COM program.


Programming Resources
        PG 1.03 -- Dave Dunfield DDS Micro-C PC86 v3.22

        Insight 1.10
          http://www.freedos.org/


COPYING
        Distributed under the terms of the GNU General Public License.
        See the file COPYING for details.
        Read the author's "Legal stuff" as in the comments of the
        program source file




============================================================
I have made a few changes to the source, but didn't (technically)
delete anything.  I removed the verbose GNU License statement in the
usage() function.  To put it back in, add this to the code:

   #define SHOW_GNU_COPYING

or, compile like this:

  cc pg.c -fop SHOW_GNU_COPYING=1

============================================================
I have set the default behavior of the program to operate in
mono-mode only.  This is a color scheme that should work well on all
monitors, even a mono display.  To build using Bill's original
colors, add this to the code:

   #define USE_COLOR_MODE

or, compile like this:

  cc pg.c -fop USE_COLOR_MODE=1



============================================================
(Jim Hall, jhall1@isd.net)





Author  BAHCL : PG Maintainer
        version 1.02  1.03  1.04
        E-mail: freedos_pg@yahoo.com.hk


A Message from the maintainer:

        After version 1.03, PG is migrated to Borland Turbo C 2.01
        for these reasons:
        1. conform to ANSI C standard
        2. long integer support
        3. better programming environment for development
        4. easier to debug (not so true!)
        5. extracted assembly subroutines are usable by other programs
        6. I failed to compile PG with an earlier version of Micro-C.
           The version of DDS Micro-C version 3.22 I once downloaded
           disappears in the internet, I doubt if Dave Dunfield has
           stopped offering version 3.22 as a freeware.

        So, after version 1.03, I'll stop using Micro-C to maintain PG.


