;
;  This file and its related programs are freewares distributed
;  under the terms of GNU GPL version 2.
;
;  Assembly language subroutines callable by pg.c
;  Originally, some routines resided in pg.c are
;     extracted here to make pg easier to debug.
;
;  Author:
;  (c) 1995-1998 Bill Weinman, wew@bearnet.com
;  Maintainer:
;  2003 BAHCL  e-mail: freedos_pg@yahoo.com.hk
;
;  Assemble:
;     nasm16 -f obj pgasm.asm -o pgasm.obj
;     The object file is linkable with tlink
;
; ***** Always save si,di if ever used in asm subroutine *****
;
; global = assembly language function names
        global  _getbiosinfo, _mvaddch,_getstr, _scroll_up, _scroll_down,
        global  _kbget, _setup_help, _on_line_help, _read_infile
; extern = variables defined in caller C program
        extern  _vidrow, _vidcol, _vidchar, _vidattr, _VideoRegen
        extern  _DispRows, _DispCols, _DispMode
        extern  _infilename, _lineaddr, _groups, _numlines, _lpg
;
; Moved here from pg.h
%define BIOS_DATA_SEG 40h
%define DISP_MODE     49h
%define DISP_COLS     4ah
%define DISP_ROWS     84h
%define CURSOR        50h
%define BUFSIZE       256

segment _TEXT   CLASS=CODE

;
; Get BIOS information
;   moved here from pg.c
_getbiosinfo    ;
        push    es
        mov ax, BIOS_DATA_SEG
        mov es, ax
        mov al, [es:DISP_MODE]
        mov [_DispMode], al
        mov ax, [es:DISP_COLS]
        mov [_DispCols], ax
        mov al, [es:DISP_ROWS]         ; actually last row
        inc al
        mov [_DispRows], al
        pop     es
        ret
;
;
; Move cursor then print a char with attribute
;   moved here from pg.c
;   with some modification
_mvaddch        ; parm : vidrow, vidcol, vidchar, vidattr
        push    bp
        mov     bp,sp
        push    di
        push es
        mov ax, BIOS_DATA_SEG
        mov es, ax
        mov al, [bp+6]          ; col
        mov ah, [bp+4]          ; row
        mov [es:CURSOR], ax
        push ax
        mov al, ah
        xor ah, ah
        mov bx, [_DispCols]     ; offset = vidrow * DispCols + vidrow
        mul bl
        pop bx
        xor bh, bh              ; add in the col
        add ax, bx
        shl ax, 1               ; * 2 for word based
        mov di, ax              ; zero origin for regen
        mov ax, [_VideoRegen]
        mov es, ax
        mov ah, [bp+10]         ; attr
        mov al, [bp+8]          ; char
        stosw
        pop es
        pop     di
        pop     bp
        ret
;
;
; get a string into buffer
_getstr         ; parm : buffer addr
                push    bp
                mov     bp,sp
                push    si
                mov     ah,CR                   ; get a string into buffer
                mov     dx,[bp+4]               ; buffer address
                int     21h

                mov     si,dx                   ; make a string null terminated
                inc     si                      ; actual number of chars entered
                lodsb
                cbw
                add     si,ax                   ; get end of string position
                xor     ax,ax
                mov     [si],al                 ; null terminated
                pop     si
                pop     bp
                ret
;
;
;   Scroll down an area of the screen
;_scroll_down     ; parm : x1,y1,x2,y2,lines
;                push    bp
;                mov     bp,sp
;                mov     bh,07
;                mov     cl,[bp+4]                 ; x1
;                mov     ch,[bp+6]                 ; y1
;                mov     dl,[bp+8]                 ; x2
;                mov     dh,[bp+10]                ; y2
;                mov     al,[bp+12]                ; lines
;                mov     ah,07
;                int     10h
;                pop     bp
;                ret
;
;   Scroll up an area of the screen
_scroll_up       ; parm : x1,y1,x2,y2,lines
                push    bp
                mov     bp,sp
                mov     bh,07
                mov     cl,[bp+4]                 ; x1
                mov     ch,[bp+6]                 ; y1
                mov     dl,[bp+8]                 ; x2
                mov     dh,[bp+10]                ; y2
                mov     al,[bp+12]                ; lines
                mov     ah,06
                int     10h
                pop     bp
                ret
;
;  Get keyboard scan code(AH) and char code(AL)
;  wait until a keypressed
_kbget
                xor     ax,ax
                int     16h
                ret
;
;
;  Set up the help information in video page #1
_setup_help
                mov     ax,0501h                ; switch to page 1
                int     10h
                mov     ax,25                   ; lines
                push    ax
                mov     ax,[_DispRows]          ; y2
                xor     ah,ah
                sub     ax,2
                push    ax
                mov     ax,[_DispCols]          ; x2
                sub     ax,1
                push    ax
                xor     ax,ax                   ; y1
                push    ax
                xor     ax,ax                   ; x1
                push    ax
                call    _scroll_up              ; clear entire screen
                add     sp,10
                mov     ax,0500h                ; switch back to page 0
                int     10h

                push    es                      ; save es as <> ds
                push    ds                      ; make es = ds
                pop     es
                push    si
                mov     cx,6                    ; lines in on-line help
                push    cx
                mov     bx,msgaddr
                push    bx
                call    help_heading            ; help heading
                add     sp,4

                mov     cx,17                   ; lines in on-line help
                push    cx
                mov     bx,msgaddr+12
                push    bx
                call    help_details            ; help details
                add     sp,4
                pop     di
                pop     es
                ret

help_heading     ; center message in screen
                push    bp
                mov     bp,sp
                xor     dx,dx
                xor     si,si
                mov     bx,[bp+4]               ; message address
                mov     cx,[bp+6]               ; messages to print
.loop
                push    cx
                mov     ax,[bx+si+2]            ; next message addr
                mov     bp,[bx+si]              ; message to be printed
                sub     ax,bp                   ; length of message
                mov     cx,ax
                mov     dl,80                   ; find position in screen
                sub     dl,cl                   ; calculate column
                shr     dl,1                    ; adjust column div by 2
                push    bx
                mov     bx,0103h                ; page 1, color cyan on black
                mov     ax,1300h                ; write string
                int     10h
                inc     dh                      ; line
                pop     bx
                inc     si
                inc     si
                pop     cx

                loop    .loop

                pop     bp
                ret

help_details     ; align message in screen
                push    bp
                mov     bp,sp
                mov     dx,0600h
                xor     si,si
                mov     bx,[bp+4]
                mov     cx,[bp+6]
.loop
                push    cx
                mov     ax,[bx+si+2]            ; next message addr
                mov     bp,[bx+si]              ; message to be print
                sub     ax,bp                   ; length of message
                mov     cx,ax
                mov     dl,10h
                inc     dh                      ; line
                push    bx
                mov     bx,0107h                ; page 1, normal attriute
                mov     ax,1300h
                int     10h
                pop     bx
                inc     si
                inc     si
                pop     cx

                loop    .loop

                pop     bp
                ret
;
;
; Show On-line help
_on_line_help
                mov     ax,0501h                ; page 1
                int     10h
                xor     ax,ax
                int     16h
                mov     ax,0500h                ; page 0
                int     10h
                ret
;
; breaks the heap limit
; Supercharger
_read_infile  ; read the infile
                xor     ax,ax
                mov     word [linidx],ax
                mov     word [grpidx],ax
                mov     word [tfmsw],ax
                mov     word [tflsw],ax
                push    si                      ; save important registers
                push    di
                mov     ax,4800h                ; get memory
                mov     bx,1000h                ; = 64k = 65536 bytes
                int     21h
                mov     [fbuffer],ax            ; the allocated memory seg addr
                mov     ax,3D00h                ; open file
                mov     dx,[_infilename]        ; file name
                int     21h
                mov     [fhandle],ax            ; save file handle

@0001:
                call    Move_file_ptr           ; move file pointer to
                mov     ax,3F00h                ; read file
                mov     bx,[fhandle]            ; file handle
                mov     cx,0FFF0h
                mov     dx,[fbuffer]
                push    ds                      ; save ds
                mov     ds,dx
                xor     dx,dx
                int     21h
                pop     ds                      ; restore ds
                jc      @eofile                 ; read error
                and     ax,ax                   ; read nothing?
                jz      @eofile
                mov     [bytesread],ax          ; bytes read

                call    Scan_LFCR               ; Scan all chars = CR = 0Ah

                mov     ax,[bytesread]
                cmp     ax,0FFF0h               ; is it eof?
                jz      @0001                   ; not yet
@eofile:
                mov     ax,[fbuffer]            ; release memory
                push    es
                mov     es,ax
                mov     ax,4900h
                int     21h
                pop     es
                mov     ax,3E00h                ; close infile
                mov     bx,[fhandle]
                int     21h
                pop     di
                pop     si
                add     word [_numlines],1      ; last line
                jnc     @0002
                inc     word [_numlines+2]
@0002:
                ret
;
; Move file pointer
Move_file_ptr  ; move file pointer to specific position
                mov     ah,42h
                mov     al,0                    ; 0 = Set, 1=Cur 2=End
                mov     bx,[fhandle]
                mov     cx,[tfmsw]              ; most sig word
                mov     dx,[tflsw]              ; least sig word
                int     21h
                ret
;
;
;
; Scan the Carriage Return char in buffer
Scan_LFCR   ; scan a byte = CR
                push    es
                mov     ax,[fbuffer]
                mov     es,ax
                xor     di,di
                mov     cx,[bytesread]
@again:
                call    Load_index
                mov     [counter],cx
                mov     al,CR
                repnz   scasb
                jcxz    @exhaust
                mov     ax,[counter]            ; calc line length
                sub     ax,cx
                call    Test_Overflow           ; update file offset
                jmp     @again
@exhaust:
                pop     es
                ret
;
; Loading indexes to array _lineaddr, _group
Load_index
                push    bx
                push    ax
                push    dx
                mov     ax,word [linidx]        ; linidx { 0..511 }
                xor     dx,dx
                mov     bx,word [_lpg]          ; lines per group
                div     bx
                add     word [grpidx],ax
                mov     word [linidx],dx
                mov     bx,[grpidx]
                or      bx,bx
                ja      @0003
                xchg    ax,dx
                mov     bx,_lineaddr
                shl     ax,1                    ; mult by 4
                shl     ax,1
                add     bx,ax                   ; calc line array index
                mov     ax,[tflsw]              ; low order word
                mov     [bx],ax                 ; store in line array
                mov     ax,[tfmsw]              ; high order word
                mov     [bx+2],ax               ; makes a long integer
@0003:
                mov     ax,word [linidx]
                or      ax,ax
                jnz     @0004                   ; same group
; new group
                mov     bx,_groups
                mov     ax,word [grpidx]        ; get group id
                shl     ax,1                    ; mult by 4
                shl     ax,1
                add     bx,ax                   ; calc group array index
                mov     ax,[tflsw]              ; low order word
                mov     [bx],ax                 ; store in group array
                mov     ax,[tfmsw]              ; high order word
                mov     [bx+2],ax               ; makes a long integer
@0004:
                pop     dx
                pop     ax
                pop     bx
                ret
;
;
; Test if file pointer in low order word overflows?
Test_Overflow
                add     ax,[tflsw]
                jnc     @0005
                inc     word [tfmsw]            ; overflow
                clc
@0005:
                mov     [tflsw],ax
                add     word [_numlines],1
                jnc     @0006
                inc     word [_numlines+2]
@0006:
                inc     word [linidx]
                ret
;
; Help messages
segment _DATA   CLASS=DATA
CR              equ     0Ah
SIZEOFLONG      equ     4
line00          db      'www.freedos.org'
line01          db      'presents PG'
line02          db      'ver. 1.07'
line03          db      'Under the terms of GNU GPL version 2'
line04          db      '(c) 1995-1998 Bill Weinman, wew@bearnet.com'
line05          db      'Maintainer: BAHCL, freedos_pg@yahoo.com.hk'
line06          db      'Esc,Q,q     Exit program'
line07          db      'Up          Down 1 line'
line08          db      'Down,Enter  Up   1 line'
line09          db      'Page Up     Down 1 page'
line10          db      'Page Down   Up   1 page'
line11          db      'Home        First page'
line12          db      'End         Final page'
line13          db      'Left        Pan view left 20 columns'
line14          db      'Right       Pan view right 20 columns (max. 60)'
line15          db      '1..5        Set bookmark #1..5'
line16          db      'Alt1..Alt5  Jump to bookmark'
line17          db      '?           Jump to line'
line18          db      '/           Find text from screen'
line19          db      'F1   Help                       F9    Prev. file'
line20          db      'F2   Find text backward         F10   Next  file'
line21          db      'F3   Find text forward'
line22          db      'F4   Save screen to "PG.SAV"'
line23          db      0            ; it's a placeholder
msgaddr         dw      line00, line01, line02, line03, line04, line05
                dw      line06, line07, line08, line09, line10, line11
                dw      line12, line13, line14, line15, line16, line17
                dw      line18, line19, line20, line21, line22, line23
tflsw           dw      0
tfmsw           dw      0
fhandle         dw      0                       ; infile handle
fbuffer         dw      0                       ; Seg addr of alloc memory
bytesread       dw      0                       ; # of bytes read last attempt
counter         dw      0                       ; byte count
linidx          dw      0                       ; line count
grpidx          dw      0                       ; group count
