;
;  Stream Viewer (HEX) SVHEX.COM
;    syntax: type filename | svhex
;  Dedicated to FreeDOS www.freedos.org
;    under the terms and license of GNU GPL version 2
;  Designed and programmed by Lo Hung Che
;    Copyright (C) BAHCL 2004
;    All rights reserved
;  Syntax: type filename | svhex
;  or      svhex filename
;
;
org 100h
segment .text
            mov     sp,stackbot+512         ; stack size = 512 bytes
            mov     bx,sp
            mov     cx,4
            shr     bx,cl
            inc     bx
            mov     ax,ds
            add     ax,bx
            mov     [stream],ax

            call    FileType
            mov     ax,[fhandle]
            push    ax
            call    Get_Data
            call    HW_Setting
            call    Clear_Screen

            call    Get_Scancode

            mov     bx,[fhandle]
            or      bx,bx
            jz      @9999
            mov     ax,3E00h
            int     21h
@9999:
            mov     ax,4C00h
            int     21h
;
;
FileType
            xor     ax,ax
            mov     si,80h
            lodsb
            or      al,al
            jz      @0010
            mov     di,si
            add     di,ax
            xchg    ah,al
            stosb
@0011:
            lodsb
            cmp     al,20h
            jz      @0011
            dec     si
            mov     ax,3D00h
            mov     dx,si
            int     21h
            jc      @0010
            mov     [fhandle],ax
@0010:
            ret
;
; Display data to screen
Show_Data
            push    bp
            mov     bp,sp
            mov     cx,[bp+6]               ; lines to print
            xor     di,di
@nextline:
            push    cx
            mov     ax,[bp+4]               ; line# to print
            call    Make_String
            inc     word [bp+4]
            push    es
            mov     ax,[vid_seg]
            mov     es,ax
            mov     cx,[linewidth]           ; line size
            mov     si,buffer
            mov     ah,07                    ; color attribute
@nextbyte:
            lodsb
            stosw
            loop    @nextbyte
            pop     es
            pop     cx
            loop    @nextline

            mov     ax,[bp+4]
            pop     bp
            ret     4
;
;
; format a string for display
Make_String
            push    di
            push    ax
            push    ds
            mov     di,buffer+57
            mov     cx,16                   ; get the offset
            xor     dx,dx
            mul     cx
            mov     si,ax
            mov     cx,16
            mov     ax,[stream]
            mov     ds,ax
            rep     movsb
            pop     ds
            mov     si,buffer+57
            mov     di,buffer+8
            mov     cx,16
            mov     bx,HexTable
.loop
            push    cx
            lodsb
            mov     ah,al
            mov     cl,4
            shr     al,cl
            xlatb
            stosb
            xchg    ah,al
            and     al,00001111b
            xlatb
            stosb
            inc     di
            pop     cx
            loop    .loop

            pop     ax                       ; line #
            xchg    ah,al
            mov     di,buffer+1
            mov     bx,HexTable

            mov     dx,ax
            mov     ah,al
            mov     cl,4
            shr     al,cl
            xlatb
            stosb
            xchg    ah,al
            and     al,00001111b
            xlatb
            stosb

            mov     ax,dx
            xchg    ah,al
            mov     ah,al
            mov     cl,4
            shr     al,cl
            xlatb
            stosb
            xchg    ah,al
            and     al,00001111b
            xlatb
            stosb

            pop     di
            ret
;
;
Get_Scancode
            mov     ax,[lineperpage]
            push    ax
            mov     ax,[linenum]
            push    ax
            call    Show_Data

            xor     ax,ax
            int     16h

            mov     cx,[keys]
            inc     cx
            mov     di,scancode
            mov     si,di
            repne   scasw
            jcxz    Get_Scancode
            mov     ax,di
            sub     ax,si
            dec     ax
            dec     ax

            mov     bx,procnames
            add     bx,ax
            call    [bx]

            push    ax
            call    Clear_Screen
            pop     ax

            cmp     ax,1
            jnz     Get_Scancode
            ret
;
; key = escape
K_Esc
            mov     ax,1
            ret
; key = up
K_Up
            mov     ax,[linenum]
            cmp     ax,0
            ja      @0020
            mov     ax,1
@0020:
            dec     ax
            mov     [linenum],ax
            xor     ax,ax
            ret
; key = down
K_Dn
            mov     ax,[linenum]
            add     ax,[lineperpage]
            jc      @0030
            inc     ax
            jc      @0030
            cmp     ax,[totlines]
            jb      @0031
@0030:
            mov     ax,[totlines]
            sub     ax,[lineperpage]
            dec     ax
            mov     [linenum],ax
            jmp     @0031
@0031:
            mov     ax,[linenum]
            inc     ax
            mov     [linenum],ax
            xor     ax,ax
            ret
; key = page up
K_P_Up
            mov     ax,[linenum]
            cmp     ax,[lineperpage]
            jae     @0040
            mov     ax,[lineperpage]
@0040:
            sub     ax,[lineperpage]
            mov     [linenum],ax
            xor     ax,ax
            ret
; key = page down
K_P_Dn
            mov     ax,[linenum]
            add     ax,[lineperpage]
            jc      @0050
            add     ax,[lineperpage]
            jc      @0050
            cmp     ax,[totlines]
            jb      @0051
@0050:
            mov     ax,[totlines]
            sub     ax,[lineperpage]
            sub     ax,[lineperpage]
            mov     [linenum],ax
            jmp     @0051
@0051:
            mov     ax,[linenum]
            add     ax,[lineperpage]
            mov     [linenum],ax

            xor     ax,ax
            ret
; key = home
K_Home
            xor     ax,ax
            mov     [linenum],ax
            xor     ax,ax
            ret
; key = end
K_End
            mov     ax,[totlines]
            sub     ax,[lineperpage]
            jnc     @0070
            xor     ax,ax
@0070:
            mov     [linenum],ax
            xor     ax,ax
            ret
;
; clear the screen, send cursor home
Clear_Screen
            push    es
            mov     ax,[vid_seg]
            mov     es,ax
            xor     di,di
            mov     cx,2000
            mov     ax,0720h
            rep     stosw
            pop     es
            mov     ah,2                     ; send cursor home
            xor     bx,bx
            xor     dx,dx
            int     10h
            ret
;
;
; get data from stream
Get_Data
            push    bp
            mov     bp,sp
            push    ds
            mov     ax,[stream]
            mov     ds,ax
            mov     ax,3F00h
            xor     dx,dx
            mov     cx,0FFF0h
            mov     bx,[bp+4]                ; file handle
            int     21h
            pop     ds
            mov     [ssize],ax
            mov     bx,16
            xor     dx,dx
            div     bx
            cmp     dx,0
            jz      @0090
            inc     ax
@0090:
            mov     [totlines],ax
            cmp     ax,[lineperpage]
            jae     @0091
            mov     [lineperpage],ax
@0091:
            xor     dx,dx
            mul     bx
            sub     ax,[ssize]
            mov     cx,ax
            push    es
            mov     ax,[stream]
            mov     es,ax
            mov     di,[ssize]
            xor     ax,ax
            rep     stosb
            pop     es
            pop     bp
            ret     2
;
HW_Setting
            mov     ah,0Fh             ; set up display mode seg. address
            int     10h
            cmp     al,7               ; mono
            jnz     @0100
            mov     ax,0B000h
            mov     [vid_seg],ax
@0100:
            ret
;
;
segment .data
TABSTOP         EQU     8
TAB             EQU     9
CR              EQU     0Dh
LF              EQU     0Ah
fhandle         dw      0
vid_seg         dw      0B800h          ; color
lineperpage     dw      25
linewidth       dw      80
stream          dw      0               ; stream segment address
ssize           dw      0               ; stream size
HexTable        dw      '0123456789ABCDEF'
linenum         dw      0               ; line number
totlines        dw      0
keys            dw      7
scancode        dw      011Bh,4800h,5000h,4900h,5100h,4700h,4F00h
procnames       dw      K_Esc,K_Up,K_Dn,K_P_Up,K_P_Dn,K_Home,K_End
buffer          db      '000000  00 00 00 00 00 00 00 00-'
          times 48  db  20h
stackbot
;               db      'Designed and programmed by Lo Hung Che',0
;               db      'Copyright (C) BAHCL 2004',0
;               db      'You understand and agree you are using this',0
;               db      'software on your own risk!'
;
;
