/*
 * Decompiled with CFR 0.152.
 */
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.border.BevelBorder;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class ContextMenuTable
extends JPopupMenu
implements PopupMenuListener,
ActionListener {
    DirFilePane parent;
    private String newLabel = "New";
    private String copyLabel = "Copy";
    private String pasteLabel = "Paste";
    private String deleteLabel = "Delete";
    private String modifyLabel = "Modify";
    private String viewLabel = "View";
    JMenuItem newItem;
    JMenuItem copyItem;
    JMenuItem pasteItem;
    JMenuItem deleteItem;
    JMenuItem modifyItem;
    JMenuItem viewItem;

    public ContextMenuTable(DirFilePane dirFilePane) {
        this.parent = dirFilePane;
        this.newItem = new JMenuItem(this.newLabel);
        this.copyItem = new JMenuItem(this.copyLabel);
        this.pasteItem = new JMenuItem(this.pasteLabel);
        this.deleteItem = new JMenuItem(this.deleteLabel);
        this.modifyItem = new JMenuItem(this.modifyLabel);
        this.viewItem = new JMenuItem(this.viewLabel);
        this.add(this.newItem);
        this.newItem.addActionListener(this);
        this.addSeparator();
        this.add(this.copyItem);
        this.copyItem.addActionListener(this);
        this.add(this.pasteItem);
        this.pasteItem.addActionListener(this);
        this.add(this.deleteItem);
        this.deleteItem.addActionListener(this);
        this.addSeparator();
        this.add(this.modifyItem);
        this.modifyItem.addActionListener(this);
        this.addSeparator();
        this.add(this.viewItem);
        this.viewItem.addActionListener(this);
        this.setBorder(new BevelBorder(0));
        this.addPopupMenuListener(this);
    }

    public void enableAllMenuItems() {
        this.newItem.setEnabled(true);
        this.copyItem.setEnabled(true);
        this.pasteItem.setEnabled(true);
        this.deleteItem.setEnabled(true);
        this.modifyItem.setEnabled(true);
    }

    public void disableAllMenuItemsExceptNewPaste() {
        this.newItem.setEnabled(true);
        this.copyItem.setEnabled(false);
        this.pasteItem.setEnabled(true);
        this.deleteItem.setEnabled(false);
        this.modifyItem.setEnabled(false);
    }

    public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
    }

    public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
    }

    public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
    }

    public void actionPerformed(ActionEvent actionEvent) {
        System.out.println("Popup menu item [" + actionEvent.getActionCommand() + "] was pressed.");
        if (actionEvent.getActionCommand().equals(this.newLabel)) {
            if (this.parent.isLinux()) {
                this.parent.newLinuxDirectory(this.parent.getTreeSelectionPath());
            } else {
                this.parent.newDosDirectory(this.parent.getTreeSelectionPath());
            }
        } else if (actionEvent.getActionCommand().equals(this.copyLabel)) {
            LTOOLSgui.myProg.copyJMenuItem_actionPerformed(actionEvent);
        } else if (actionEvent.getActionCommand().equals(this.pasteLabel)) {
            LTOOLSgui.myProg.pasteJMenuItem_actionPerformed(actionEvent);
        } else if (actionEvent.getActionCommand().equals(this.deleteLabel)) {
            DirFilePane.debugOutput("parent.isLinux(): " + this.parent.isLinux());
            LTOOLSgui.setActiveDirFilePane(this.parent);
            LTOOLSgui.myProg.deleteListItemFiles();
        } else if (actionEvent.getActionCommand().equals(this.modifyLabel)) {
            LTOOLSgui.setActiveDirFilePane(this.parent);
            LTOOLSgui.myProg.modifyListItemFiles();
        } else if (actionEvent.getActionCommand().equals(this.viewLabel)) {
            LTOOLSgui.setActiveDirFilePane(this.parent);
            LTOOLSgui.myProg.viewListItemFiles();
        }
    }
}

