/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;

class LToolGuiTreeIconCellRenderer
extends JLabel
implements TreeCellRenderer {
    protected Color textSelectionColor = UIManager.getColor("Tree.selectionForeground");
    protected Color textNonSelectionColor = UIManager.getColor("Tree.textForeground");
    protected Color bkSelectionColor = UIManager.getColor("Tree.selectionBackground");
    protected Color bkNonSelectionColor = UIManager.getColor("Tree.textBackground");
    protected Color borderSelectionColor = UIManager.getColor("Tree.selectionBorderColor");
    protected boolean selected;

    public LToolGuiTreeIconCellRenderer() {
        this.setOpaque(false);
    }

    public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
        Object object2 = defaultMutableTreeNode.getUserObject();
        this.setText(object2.toString());
        if (object2 instanceof LToolGuiTreeIconData) {
            LToolGuiTreeIconData lToolGuiTreeIconData = (LToolGuiTreeIconData)object2;
            if (bl2) {
                this.setIcon(lToolGuiTreeIconData.getExpandedIcon());
            } else {
                this.setIcon(lToolGuiTreeIconData.getIcon());
            }
        } else {
            this.setIcon(null);
        }
        this.setFont(jTree.getFont());
        this.setForeground(bl ? this.textSelectionColor : this.textNonSelectionColor);
        this.setBackground(bl ? this.bkSelectionColor : this.bkNonSelectionColor);
        this.selected = bl;
        return this;
    }

    public void paintComponent(Graphics graphics) {
        Color color = this.getBackground();
        Icon icon = this.getIcon();
        graphics.setColor(color);
        int n = 0;
        if (icon != null && this.getText() != null) {
            n = icon.getIconWidth() + this.getIconTextGap();
        }
        graphics.fillRect(n, 0, this.getWidth() - 1 - n, this.getHeight() - 1);
        if (this.selected) {
            graphics.setColor(this.borderSelectionColor);
            graphics.drawRect(n, 0, this.getWidth() - 1 - n, this.getHeight() - 1);
        }
        super.paintComponent(graphics);
    }
}

