using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Text ;

namespace FHTE.LTOOLS.GUI
{
	/// <summary>
	/// Summary description for HelpBox.
	/// </summary>
	public class HelpBox : System.Windows.Forms.Form
	{
		#region Fields
        // ############################################################################################################
        // FIELDS
        // ############################################################################################################
        private System.Windows.Forms.ImageList helpBoxImageList;
        private System.ComponentModel.IContainer components;
        private System.Windows.Forms.Panel panelToolbar;
        private System.Windows.Forms.ToolBar toolBar;
        private System.Windows.Forms.ToolBarButton overviewToolBarButton;
        private System.Windows.Forms.ToolBarButton previousToolBarButton;
        private System.Windows.Forms.ToolBarButton nextToolBarButton;
        private System.Windows.Forms.ToolBarButton closeToolBarButton;
        private System.Windows.Forms.Panel panelWebBrowser;
        private AxSHDocVw.AxWebBrowser webBrowser;

        private static int maxFiles = 4 ;                       // number of HTML-Files for Help
        private Uri[] currentFileCache = new Uri[maxFiles] ;    // uris of the files in Help
        private int currentFilePointer ;                        // current Index of HTML-Site in Array
		#endregion

		#region Properties
        // ############################################################################################################
        // PROPERTIES
        // ############################################################################################################
		#endregion

		#region Constructors
        // ############################################################################################################
        // CONSTRUCTORS
        // ############################################################################################################
        /// <summary>
        /// the constructor creates a modal or non-modal HelpBox.
        /// </summary>
        /// <param name="modal">true if the HelpBox should be a modal-dialog</param>
        /// <param name="baseDirectory">the base directory of the helpfiles</param>
		public HelpBox(bool modal, string baseDirectory)
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

			//
			// TODO: Add any constructor code after InitializeComponent call
			//
            baseDirectory = baseDirectory.Replace('\\', '/') ;  // set Files from help in array
            currentFileCache[0] = new Uri(baseDirectory + "/" + "LTOOLSnet1.htm") ;
            currentFileCache[1] = new Uri(baseDirectory + "/" + "LTOOLSnet2.htm") ;
            currentFileCache[2] = new Uri(baseDirectory + "/" + "LTOOLSnet3.htm") ;
            currentFileCache[3] = new Uri(baseDirectory + "/" + "LTOOLSnet4.htm") ;
            
            currentFilePointer = 0 ;
            this.ShowCurrentFile() ;

            previousToolBarButton.Enabled = false ;
            
            webBrowser.DownloadComplete += new System.EventHandler(DownloadCompleteCallback) ;

            if (modal)                                          // show as modal Dialog
            {
                this.ShowDialog() ;
            }
            else                                                // just set visible to true
            {
                this.Visible = true ;
            }
		}
		#endregion

		#region Methods
        // ############################################################################################################
        // METHODS
        // ############################################################################################################
		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
		    this.components = new System.ComponentModel.Container();
		    System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(HelpBox));
		    this.helpBoxImageList = new System.Windows.Forms.ImageList(this.components);
		    this.panelToolbar = new System.Windows.Forms.Panel();
		    this.toolBar = new System.Windows.Forms.ToolBar();
		    this.overviewToolBarButton = new System.Windows.Forms.ToolBarButton();
		    this.previousToolBarButton = new System.Windows.Forms.ToolBarButton();
		    this.nextToolBarButton = new System.Windows.Forms.ToolBarButton();
		    this.closeToolBarButton = new System.Windows.Forms.ToolBarButton();
		    this.panelWebBrowser = new System.Windows.Forms.Panel();
		    this.webBrowser = new AxSHDocVw.AxWebBrowser();
		    this.panelToolbar.SuspendLayout();
		    this.panelWebBrowser.SuspendLayout();
		    ((System.ComponentModel.ISupportInitialize)(this.webBrowser)).BeginInit();
		    this.SuspendLayout();
		    // 
		    // helpBoxImageList
		    // 
		    this.helpBoxImageList.ColorDepth = System.Windows.Forms.ColorDepth.Depth32Bit;
		    this.helpBoxImageList.ImageSize = new System.Drawing.Size(32, 32);
		    this.helpBoxImageList.ImageStream = ((System.Windows.Forms.ImageListStreamer)(resources.GetObject("helpBoxImageList.ImageStream")));
		    this.helpBoxImageList.TransparentColor = System.Drawing.Color.Transparent;
		    // 
		    // panelToolbar
		    // 
		    this.panelToolbar.Controls.AddRange(new System.Windows.Forms.Control[] {
											       this.toolBar});
		    this.panelToolbar.Dock = System.Windows.Forms.DockStyle.Top;
		    this.panelToolbar.Name = "panelToolbar";
		    this.panelToolbar.Size = new System.Drawing.Size(792, 55);
		    this.panelToolbar.TabIndex = 1;
		    // 
		    // toolBar
		    // 
		    this.toolBar.Buttons.AddRange(new System.Windows.Forms.ToolBarButton[] {
											       this.overviewToolBarButton,
											       this.previousToolBarButton,
											       this.nextToolBarButton,
											       this.closeToolBarButton});
		    this.toolBar.ButtonSize = new System.Drawing.Size(60, 52);
		    this.toolBar.DropDownArrows = true;
		    this.toolBar.ImageList = this.helpBoxImageList;
		    this.toolBar.Name = "toolBar";
		    this.toolBar.ShowToolTips = true;
		    this.toolBar.Size = new System.Drawing.Size(792, 55);
		    this.toolBar.TabIndex = 1;
		    this.toolBar.ButtonClick += new System.Windows.Forms.ToolBarButtonClickEventHandler(this.ToolBar_ButtonClick);
		    // 
		    // overviewToolBarButton
		    // 
		    this.overviewToolBarButton.ImageIndex = 0;
		    this.overviewToolBarButton.Text = "Overview";
		    this.overviewToolBarButton.ToolTipText = "Overview";
		    // 
		    // previousToolBarButton
		    // 
		    this.previousToolBarButton.ImageIndex = 1;
		    this.previousToolBarButton.Text = "Previous";
		    this.previousToolBarButton.ToolTipText = "Previous";
		    // 
		    // nextToolBarButton
		    // 
		    this.nextToolBarButton.ImageIndex = 2;
		    this.nextToolBarButton.Text = "Next";
		    this.nextToolBarButton.ToolTipText = "Next";
		    // 
		    // closeToolBarButton
		    // 
		    this.closeToolBarButton.ImageIndex = 3;
		    this.closeToolBarButton.Text = "Close";
		    this.closeToolBarButton.ToolTipText = "Close";
		    // 
		    // panelWebBrowser
		    // 
		    this.panelWebBrowser.Controls.AddRange(new System.Windows.Forms.Control[] {
												  this.webBrowser});
		    this.panelWebBrowser.Dock = System.Windows.Forms.DockStyle.Fill;
		    this.panelWebBrowser.Location = new System.Drawing.Point(0, 55);
		    this.panelWebBrowser.Name = "panelWebBrowser";
		    this.panelWebBrowser.Size = new System.Drawing.Size(792, 418);
		    this.panelWebBrowser.TabIndex = 2;
		    // 
		    // webBrowser
		    // 
		    this.webBrowser.ContainingControl = this;
		    this.webBrowser.Dock = System.Windows.Forms.DockStyle.Fill;
		    this.webBrowser.Enabled = true;
		    this.webBrowser.OcxState = ((System.Windows.Forms.AxHost.State)(resources.GetObject("webBrowser.OcxState")));
		    this.webBrowser.Size = new System.Drawing.Size(792, 511);
		    this.webBrowser.TabIndex = 1;
		    this.webBrowser.DownloadComplete += new System.EventHandler(this.DownloadCompleteCallback);
		    // 
		    // HelpBox
		    // 
		    this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
		    this.ClientSize = new System.Drawing.Size(792, 473);
		    this.Controls.AddRange(new System.Windows.Forms.Control[] {
										  this.panelWebBrowser,
										  this.panelToolbar});
		    this.Icon = ((System.Drawing.Icon)(resources.GetObject("$this.Icon")));
		    this.Name = "HelpBox";
		    this.ShowInTaskbar = false;
		    this.StartPosition = System.Windows.Forms.FormStartPosition.CenterParent;
		    this.Text = "LTOOLSnet-C# Help";
		    this.Closing += new System.ComponentModel.CancelEventHandler(this.HelpBox_Closing);
		    this.panelToolbar.ResumeLayout(false);
		    this.panelWebBrowser.ResumeLayout(false);
		    ((System.ComponentModel.ISupportInitialize)(this.webBrowser)).EndInit();
		    this.ResumeLayout(false);

		}
		#endregion

        /// <summary>
        /// the ToolBar_ButtonClick() method navigates between the help files when you have clicked
        /// a Button in the Toolbar.
        /// </summary>
        /// <param name="sender">sender object</param>
        /// <param name="e">event data</param>
        private void ToolBar_ButtonClick(object sender, System.Windows.Forms.ToolBarButtonClickEventArgs e)
        {
            if (e.Button.Equals(previousToolBarButton))
            {
                currentFilePointer-- ;
                if (currentFilePointer == 0)
                {
                    previousToolBarButton.Enabled = false ;
                }
                nextToolBarButton.Enabled = true ;
                this.ShowCurrentFile() ;
            }
            else if (e.Button.Equals(nextToolBarButton))
            {
                currentFilePointer++ ;
                if (currentFilePointer == (maxFiles - 1))
                {
                    nextToolBarButton.Enabled = false ;
                }
                previousToolBarButton.Enabled = true ;
                
                this.ShowCurrentFile() ;
            }
            else if (e.Button.Equals(overviewToolBarButton))
            {
                currentFilePointer = 0 ;
                previousToolBarButton.Enabled = false ;
                nextToolBarButton.Enabled = true ;
                this.ShowCurrentFile() ;
            }
            else if (e.Button.Equals(closeToolBarButton))
            {
                this.Visible = false ;
            }
        }

        /// <summary>
        /// the DownloadCompleteCallback() method sets the currentFilePointer and enables or disables the
        /// buttons in the toolbar.
        /// </summary>
        /// <param name="sender">sender object</param>
        /// <param name="e">event data</param>
        private void DownloadCompleteCallback(object sender, System.EventArgs e)
        {
            Uri tmpUri = new Uri(webBrowser.LocationURL) ;      // get current HTML file
            if (tmpUri.ToString() == currentFileCache[0].ToString())
            {
                previousToolBarButton.Enabled = false ;
                nextToolBarButton.Enabled = true ;                
                currentFilePointer = 0 ;
            }
            if (tmpUri.ToString() == currentFileCache[1].ToString())
            {
                previousToolBarButton.Enabled = true ;
                nextToolBarButton.Enabled = true ;
                currentFilePointer = 1 ;
            }
            if (tmpUri.ToString() == currentFileCache[2].ToString())
            {
                previousToolBarButton.Enabled = true ;
                nextToolBarButton.Enabled = true ;
                currentFilePointer = 2 ;
            }
            if (tmpUri.ToString() == currentFileCache[3].ToString())
            {
                previousToolBarButton.Enabled = true ;
                nextToolBarButton.Enabled = false ;
                currentFilePointer = 3 ;
            }
        }

        /// <summary>
        /// sets the new HTML-site in WebBrowser
        /// </summary>
        private void ShowCurrentFile()
        {
            int    zero = 0 ;
            object oZero = zero ;
            string emptyString = "" ;
            object oEmptyString = emptyString ;
                   
            webBrowser.Navigate(currentFileCache[currentFilePointer].ToString(),
                ref oZero, ref oEmptyString, ref oEmptyString, ref oEmptyString) ;
        }

        /// <summary>
        /// the HelpBox_Closing() method cancels the closing event and just sets the Visible-property of the
        /// HelpBox to false.
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void HelpBox_Closing(object sender, System.ComponentModel.CancelEventArgs e)
        {
            e.Cancel = true ;
            this.Visible = false ;
        }
		#endregion

	}
}
