using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;

namespace FHTE.LTOOLS.GUI
{
	/// <summary>
	/// It's a Dialog to modify the name and attributes of a (DOS)file.
	/// </summary>
    public class ModifyDosDialog : System.Windows.Forms.Form
    {
        // ############################################################################################################
        // FIELDS
        // ############################################################################################################
        private System.Windows.Forms.Label nameLabel;
        private System.Windows.Forms.Label modificationDateLabel;
        private System.Windows.Forms.Label lengthLabel;
        private System.Windows.Forms.Label typeLabel;
        private System.Windows.Forms.Label fileDateLabel;
        private System.Windows.Forms.Label fileLengthLabel;
        private System.Windows.Forms.TextBox fileNameTextBox;
        private System.Windows.Forms.CheckBox directoryCheckBox;
        private System.Windows.Forms.CheckBox readOnlyCheckBox;
        private System.Windows.Forms.CheckBox hiddenCheckBox;
        private System.Windows.Forms.CheckBox systemCheckBox;
        private System.Windows.Forms.Button okButton;
        private System.Windows.Forms.Button cancelButton;
        /// <summary>
        /// Required designer variable.
        /// </summary>
        private System.ComponentModel.Container components = null;

        // ############################################################################################################
        // PROPERTIES
        // ############################################################################################################
        /// <summary>
        /// returns the new FileName
        /// </summary>
        public string FileName
        {
            get { return fileNameTextBox.Text ; }
        }
        /// <summary>
        /// returns the value of the readOnlyCheckbox, if the file is readonly or not
        /// </summary>
        public bool IsReadOnly
        {
            get { return readOnlyCheckBox.Checked ; }
        }
        /// <summary>
        /// returns the value of the hiddenCheckBox, if the file is hidden or not
        /// </summary>
        public bool IsHidden
        {
            get { return hiddenCheckBox.Checked ; }
        }
        /// <summary>
        /// returns the value of the systemCheckBox, if the file is a system-file or not
        /// </summary>
        public bool IsSystem
        {
            get { return systemCheckBox.Checked ; }
        }
        /// <summary>
        /// returns the value of the directoryCheckBox, if the file is a directory or not
        /// </summary>
        public bool IsDirectory
        {
            get { return directoryCheckBox.Checked ; }
        }

        // ############################################################################################################
        // CONSTRUCTORS
        // ############################################################################################################
        /// <summary>
        /// The Constructor sets the values in the ModifyDosDialog.
        /// </summary>
        /// <param name="isNew">true if you want to create a new directory</param>
        /// <param name="fileName">the filename of the modify-file</param>
        /// <param name="fileLength">the size of the file</param>
        /// <param name="fileDate">the last modified date of the file</param>
        /// <param name="isDirectory">true if the file is a directory</param>
        /// <param name="isReadOnly">true if the file is readonly</param>
        /// <param name="isHidden">true if the file is hidden</param>
        /// <param name="isSystem">true if the file is a system-file</param>
        public ModifyDosDialog(bool isNew, string fileName, string fileLength,
            string fileDate, bool isDirectory, bool isReadOnly, 
            bool isHidden, bool isSystem)
        {
            //
            // Required for Windows Form Designer support
            //
            InitializeComponent();

            //
            // TODO: Add any constructor code after InitializeComponent call
            //
            if (isNew)
            {
                this.Text = "LTOOLS New Dos Directory" ;
            }
            fileNameTextBox.Text = fileName ;
            fileDateLabel.Text   = fileDate ;
            fileLengthLabel.Text = fileLength ;
            if (isDirectory)
            {
                directoryCheckBox.Checked = true ;
            }
            if (isReadOnly)
            {
                readOnlyCheckBox.Checked = true ;
            }
            if (isHidden)
            {
                hiddenCheckBox.Checked = true ;
            }
            if (isSystem)
            {
                systemCheckBox.Checked = true ;
            }
        }

        // ############################################################################################################
        // METHODS
        // ############################################################################################################
        /// <summary>
        /// Clean up any resources being used.
        /// </summary>
        protected override void Dispose( bool disposing )
        {
            if( disposing )
            {
                if(components != null)
                {
                    components.Dispose();
                }
            }
            base.Dispose( disposing );
        }

        /// <summary>
        /// The main entry point to test the ModifyDosDialog.
        /// </summary>
        [STAThread]
        static void Main() 
        {
            Form myForm = new Form () ;   
            myForm.Text = "ModifyDosDialog Test";               // Set the caption bar text of the form.
            myForm.Size = new Size (600, 400) ;
            myForm.Visible = true ;
            ModifyDosDialog myDialog = new ModifyDosDialog(false, "testFileName", 
                "testFileDate", "testFileLength", false, true, true, true) ;
            myDialog.ShowDialog() ;                             // Modaler Dialog
            
            MessageBox.Show("fileName: " + myDialog.FileName + 
                "\nisDirectory: " + myDialog.IsDirectory +
                "\nisReadOnly: " + myDialog.IsReadOnly +
                "\nisHidden: " + myDialog.IsHidden +
                "\nisSystem: " + myDialog.IsSystem) ;
        }

        
		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(ModifyDosDialog));
			this.nameLabel = new System.Windows.Forms.Label();
			this.modificationDateLabel = new System.Windows.Forms.Label();
			this.lengthLabel = new System.Windows.Forms.Label();
			this.typeLabel = new System.Windows.Forms.Label();
			this.fileNameTextBox = new System.Windows.Forms.TextBox();
			this.fileDateLabel = new System.Windows.Forms.Label();
			this.fileLengthLabel = new System.Windows.Forms.Label();
			this.directoryCheckBox = new System.Windows.Forms.CheckBox();
			this.readOnlyCheckBox = new System.Windows.Forms.CheckBox();
			this.okButton = new System.Windows.Forms.Button();
			this.cancelButton = new System.Windows.Forms.Button();
			this.hiddenCheckBox = new System.Windows.Forms.CheckBox();
			this.systemCheckBox = new System.Windows.Forms.CheckBox();
			this.SuspendLayout();
			// 
			// nameLabel
			// 
			this.nameLabel.Location = new System.Drawing.Point(16, 16);
			this.nameLabel.Name = "nameLabel";
			this.nameLabel.Size = new System.Drawing.Size(112, 16);
			this.nameLabel.TabIndex = 0;
			this.nameLabel.Text = "Name:";
			// 
			// modificationDateLabel
			// 
			this.modificationDateLabel.Location = new System.Drawing.Point(16, 48);
			this.modificationDateLabel.Name = "modificationDateLabel";
			this.modificationDateLabel.Size = new System.Drawing.Size(112, 16);
			this.modificationDateLabel.TabIndex = 1;
			this.modificationDateLabel.Text = "Modification date:";
			// 
			// lengthLabel
			// 
			this.lengthLabel.Location = new System.Drawing.Point(16, 80);
			this.lengthLabel.Name = "lengthLabel";
			this.lengthLabel.Size = new System.Drawing.Size(112, 16);
			this.lengthLabel.TabIndex = 2;
			this.lengthLabel.Text = "Length:";
			// 
			// typeLabel
			// 
			this.typeLabel.Location = new System.Drawing.Point(16, 112);
			this.typeLabel.Name = "typeLabel";
			this.typeLabel.Size = new System.Drawing.Size(112, 16);
			this.typeLabel.TabIndex = 3;
			this.typeLabel.Text = "Type:";
			// 
			// fileNameTextBox
			// 
			this.fileNameTextBox.Location = new System.Drawing.Point(136, 16);
			this.fileNameTextBox.MaxLength = 255;
			this.fileNameTextBox.Name = "fileNameTextBox";
			this.fileNameTextBox.Size = new System.Drawing.Size(216, 20);
			this.fileNameTextBox.TabIndex = 4;
			this.fileNameTextBox.Text = "fileName";
			// 
			// fileDateLabel
			// 
			this.fileDateLabel.Location = new System.Drawing.Point(136, 48);
			this.fileDateLabel.Name = "fileDateLabel";
			this.fileDateLabel.Size = new System.Drawing.Size(216, 24);
			this.fileDateLabel.TabIndex = 5;
			this.fileDateLabel.Text = "fileDate";
			// 
			// fileLengthLabel
			// 
			this.fileLengthLabel.Location = new System.Drawing.Point(136, 80);
			this.fileLengthLabel.Name = "fileLengthLabel";
			this.fileLengthLabel.Size = new System.Drawing.Size(216, 24);
			this.fileLengthLabel.TabIndex = 6;
			this.fileLengthLabel.Text = "fileLength";
			// 
			// directoryCheckBox
			// 
			this.directoryCheckBox.Enabled = false;
			this.directoryCheckBox.Location = new System.Drawing.Point(136, 112);
			this.directoryCheckBox.Name = "directoryCheckBox";
			this.directoryCheckBox.Size = new System.Drawing.Size(88, 24);
			this.directoryCheckBox.TabIndex = 7;
			this.directoryCheckBox.Text = "Directory";
			// 
			// readOnlyCheckBox
			// 
			this.readOnlyCheckBox.Location = new System.Drawing.Point(240, 112);
			this.readOnlyCheckBox.Name = "readOnlyCheckBox";
			this.readOnlyCheckBox.TabIndex = 8;
			this.readOnlyCheckBox.Text = "Read only";
			// 
			// okButton
			// 
			this.okButton.DialogResult = System.Windows.Forms.DialogResult.OK;
			this.okButton.Location = new System.Drawing.Point(78, 176);
			this.okButton.Name = "okButton";
			this.okButton.Size = new System.Drawing.Size(100, 25);
			this.okButton.TabIndex = 11;
			this.okButton.Text = "OK";
			// 
			// cancelButton
			// 
			this.cancelButton.DialogResult = System.Windows.Forms.DialogResult.Cancel;
			this.cancelButton.Location = new System.Drawing.Point(214, 176);
			this.cancelButton.Name = "cancelButton";
			this.cancelButton.Size = new System.Drawing.Size(100, 25);
			this.cancelButton.TabIndex = 12;
			this.cancelButton.Text = "Cancel";
			// 
			// hiddenCheckBox
			// 
			this.hiddenCheckBox.Location = new System.Drawing.Point(136, 144);
			this.hiddenCheckBox.Name = "hiddenCheckBox";
			this.hiddenCheckBox.Size = new System.Drawing.Size(88, 24);
			this.hiddenCheckBox.TabIndex = 9;
			this.hiddenCheckBox.Text = "Hidden";
			// 
			// systemCheckBox
			// 
			this.systemCheckBox.Location = new System.Drawing.Point(240, 144);
			this.systemCheckBox.Name = "systemCheckBox";
			this.systemCheckBox.Size = new System.Drawing.Size(96, 24);
			this.systemCheckBox.TabIndex = 10;
			this.systemCheckBox.Text = "System";
			// 
			// ModifyDosDialog
			// 
			this.AcceptButton = this.okButton;
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.CancelButton = this.cancelButton;
			this.ClientSize = new System.Drawing.Size(394, 215);
			this.Controls.AddRange(new System.Windows.Forms.Control[] {
																		  this.systemCheckBox,
																		  this.hiddenCheckBox,
																		  this.cancelButton,
																		  this.okButton,
																		  this.readOnlyCheckBox,
																		  this.directoryCheckBox,
																		  this.fileLengthLabel,
																		  this.fileDateLabel,
																		  this.fileNameTextBox,
																		  this.typeLabel,
																		  this.lengthLabel,
																		  this.modificationDateLabel,
																		  this.nameLabel});
			this.FormBorderStyle = System.Windows.Forms.FormBorderStyle.FixedDialog;
			this.Icon = ((System.Drawing.Icon)(resources.GetObject("$this.Icon")));
			this.MaximizeBox = false;
			this.MaximumSize = new System.Drawing.Size(400, 240);
			this.MinimizeBox = false;
			this.MinimumSize = new System.Drawing.Size(400, 240);
			this.Name = "ModifyDosDialog";
			this.ShowInTaskbar = false;
			this.SizeGripStyle = System.Windows.Forms.SizeGripStyle.Hide;
			this.StartPosition = System.Windows.Forms.FormStartPosition.CenterParent;
			this.Text = "LTOOLS Modify Dos file or directory";
			this.ResumeLayout(false);

		}
		#endregion
	}
}
