/*
 * ContexMenuTable.java
 */
//import java.util.*;
//import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;

/** The Class is a popupmenu for the JTable of the DirFilePane-class
 * @author Joerg Holzaepfel
 */
public class ContextMenuTable extends JPopupMenu implements PopupMenuListener, ActionListener
{
    DirFilePane parent ;                                        // the DirFilePane of this contextmenu
    private String newLabel     = "New" ;                       // the text of the menuitems in the contextmenu
    private String copyLabel    = "Copy" ;
    private String pasteLabel   = "Paste" ;
    private String deleteLabel  = "Delete" ;
    private String modifyLabel  = "Modify" ;
    private String viewLabel    = "View" ;
    
    JMenuItem newItem ;                                         // the menuitems of the contextmenu
    JMenuItem copyItem ;
    JMenuItem pasteItem ;
    JMenuItem deleteItem ;
    JMenuItem modifyItem ;
    JMenuItem viewItem;

    /** Creates an instance of the ContextMenuTable
     * @param parent the DirFilePane of this contextMenu
     */
    public ContextMenuTable(DirFilePane parent) 
    {
        this.parent = parent ;

        newItem = new JMenuItem(newLabel) ;
        copyItem = new JMenuItem(copyLabel) ;
        pasteItem = new JMenuItem(pasteLabel) ;
        deleteItem = new JMenuItem(deleteLabel) ;
        modifyItem = new JMenuItem(modifyLabel) ;
        viewItem = new JMenuItem(viewLabel);
        
        this.add(newItem) ;
        newItem.addActionListener(this) ;
        
        this.addSeparator();
        
        this.add(copyItem);
        copyItem.addActionListener(this) ;

        this.add(pasteItem);
        pasteItem.addActionListener(this) ;
        
        this.add(deleteItem);
        deleteItem.addActionListener(this) ;
        
        this.addSeparator();
        
        this.add(modifyItem);
        modifyItem.addActionListener(this) ;

        this.addSeparator();

        this.add(viewItem);
        viewItem.addActionListener(this) ;

        this.setBorder(new BevelBorder(BevelBorder.RAISED));
        this.addPopupMenuListener(this);
    }

    /** the enableAllMenuItems enables all items in the popupmenu */
    public void enableAllMenuItems()
    {
        newItem.setEnabled(true) ;
        copyItem.setEnabled(true) ;
        pasteItem.setEnabled(true) ;
        deleteItem.setEnabled(true) ;
        modifyItem.setEnabled(true) ;
    }
    /** the disableAllMenuItemsExceptNewPaste()-method disables all items in the
     * popupmenu except the New and Paste item (it's called if the contextmenu is
     * placed on a ListItem like "..")
     */
    public void disableAllMenuItemsExceptNewPaste()
    {
        newItem.setEnabled(true) ;
        copyItem.setEnabled(false) ;
        pasteItem.setEnabled(true) ;
        deleteItem.setEnabled(false) ;
        modifyItem.setEnabled(false) ;
    }
    // PopupMenuListener ##############################################################################################
    /** it's called before the popupMenu becomes visible
     * @param e the event data
     */
    public void popupMenuWillBecomeVisible(PopupMenuEvent e) 
    {
        // System.out.println("Popup menu will be visible!");
    }
    /** it's called before the popupMenu becomes invisible
     * @param e the event data
     */
    public void popupMenuWillBecomeInvisible(PopupMenuEvent e) 
    {
        // System.out.println("Popup menu will be invisible!");
    }
    /** the popupMenuCanceled()-method
     * @param e the event data
     */
    public void popupMenuCanceled(PopupMenuEvent e) 
    {
        // System.out.println("Popup menu is hidden!");
    }
    
    // ActionListener #################################################################################################
    /** the actionPerformed()-method is called if a menuitem was clicked
     * @param event the event data
     */
    public void actionPerformed(ActionEvent event) 
    {
        System.out.println("Popup menu item [" + event.getActionCommand() + "] was pressed.");
        
        if (event.getActionCommand().equals(newLabel))          // new Directory
        {
            if (parent.isLinux())
            {
                parent.newLinuxDirectory(parent.getTreeSelectionPath()) ;
            }
            else
            {
                parent.newDosDirectory(parent.getTreeSelectionPath()) ;
            }
        }
        else if (event.getActionCommand().equals(copyLabel))    // copy
        {
            LTOOLSgui.myProg.copyJMenuItem_actionPerformed(event) ;
        }
        else if (event.getActionCommand().equals(pasteLabel))  // paste
        {
            LTOOLSgui.myProg.pasteJMenuItem_actionPerformed(event) ;
        }
        else if (event.getActionCommand().equals(deleteLabel))  // delete
        {
            parent.debugOutput("parent.isLinux(): " + parent.isLinux()) ;
            LTOOLSgui.setActiveDirFilePane(parent) ;
            LTOOLSgui.myProg.deleteListItemFiles() ;
        }
        else if (event.getActionCommand().equals(modifyLabel))  // modify
        {
            LTOOLSgui.setActiveDirFilePane(parent) ;
            LTOOLSgui.myProg.modifyListItemFiles() ;
        }
        else if (event.getActionCommand().equals(viewLabel))  // view
        {
            LTOOLSgui.setActiveDirFilePane(parent) ;
            LTOOLSgui.myProg.viewListItemFiles() ;
        }
    }
}
