/*
 * DirectoryMutableTreeNode.java
 */
//import java.util.*;
import javax.swing.tree.*;

/** The DirectoryMutableTreeNode extends the DefaultMutableTreeNode and represents a
 * directory in the filesystem.
 * @author Joerg Holzaepfel
 */
public class DirectoryMutableTreeNode extends DefaultMutableTreeNode implements Comparable
{
    private DirFilePane parent ;                                // the DirFilePane 
    private String drive ;                                      // the drive of this Node
    private String directoryPath;                               // the directorypath of this Node
    private boolean subDirectoriesAdded;                        // true, if the subdirectories are added
    private boolean isRemovableDrive ;                          // flag if the Drive is Removeable (just for dos)
    
    /** Creates a new instance of DirectoryMutableTreeNode
     * @param parent The parent DirFilePane
     * @param userObject userObject
     * @param path path of the node
     * @param drive the drive of the node
     */
    public DirectoryMutableTreeNode(DirFilePane parent, Object userObject, String path, String drive)
    {
        super(userObject) ;
        this.parent = parent ;
        this.directoryPath = path ;
        this.drive = drive ;
        this.isRemovableDrive = false ;
    }
    /**
     * @return true if the subdirectories of this DirectoryMutableTreeNode are added
     */    
    /*  boolean getDirectoriesAdded() 
    {
        return this.directoriesAdded ;
    }
    */
    
    /** The getSubDirectoriesAdded()-method returns the value of the
     * subDirectoriesAdded-field
     * @return true if the subdirectories of this DirectoryMutableTreeNode are added
     */    
    boolean getSubDirectoriesAdded() 
    {
        return this.subDirectoriesAdded ;
    }
    /** the getDrive()-method returns the Drive of this node
     * @return the drive of this Node
     */
    String getDrive()
    {
        return this.drive ;
    }
    /** the getDirectoryPath()-method returns the directorypath of this node
     * @return the path of the directory represented by the DirectoryMutableTreeNode
     */    
    String getDirectoryPath() 
    {
        return this.directoryPath ;
    }
    /**
     * @param added true or false
     */
    /* void setDirectoriesAdded(boolean added) 
    {
        this.subDirectoriesAdded = added ;
    }
    */
    
    /** sets the value of the subDirectoriesAdded-field
     * @param added sets the value of the subDirectoriesAdded-field
     */
    public void setSubDirectoriesAdded(boolean added) 
    {
        this.subDirectoriesAdded = added ;
    }
    /** the setDrive()-method sets the drive-field of this node
     * @param drive the drive of this Node
     */
    void setDrive(String drive)
    {
        this.drive = drive ;
    }
    /** the setDirectoryPath()-method sets the directoryPath-field of this node
     * @param path Path of the directory
     */
    void setDirectoryPath(String path)
    {
        this.directoryPath = path ;
    }
    /** the isRemovableDrive()-method returns the value of the isRemovableDrive-field
     * @return the value of the isRemovableDrive-field
     */
    public boolean isRemovableDrive()
    {
        return isRemovableDrive ;
    }
    /** sets the value of the isRemovableDrive
     * @param b sets the value of the isRemovableDrive
     */
    public void setIsRemovableDrive(boolean b)
    {
        this.isRemovableDrive = b ;
    }
    /** this method is just for debugging
     * @return shows the attributes of this DirectoryMutableTreeNode
     */
    String showAttributes()
    {
        String attr = "drive: " + this.getDrive() + "\n" +
                      "directoryPath: " + this.getDirectoryPath() + "\n" +
                      "subDirectoriesAdded: " + this.getSubDirectoriesAdded() ;
        /*
        if (father != null)
        {
            attr = attr + "\nfather: " + father.showAttributes() ;
        }
        */
        return attr ;
    }
    
    /** Compares this object with the specified object for order.  Returns a
     * negative integer, zero, or a positive integer as this object is less
     * than, equal to, or greater than the specified object.<p>
     *
     * In the foregoing description, the notation
     * <tt>sgn(</tt><i>expression</i><tt>)</tt> designates the mathematical
     * <i>signum</i> function, which is defined to return one of <tt>-1</tt>,
     * <tt>0</tt>, or <tt>1</tt> according to whether the value of <i>expression</i>
     * is negative, zero or positive.
     *
     * The implementor must ensure <tt>sgn(x.compareTo(y)) ==
     * -sgn(y.compareTo(x))</tt> for all <tt>x</tt> and <tt>y</tt>.  (This
     * implies that <tt>x.compareTo(y)</tt> must throw an exception iff
     * <tt>y.compareTo(x)</tt> throws an exception.)<p>
     *
     * The implementor must also ensure that the relation is transitive:
     * <tt>(x.compareTo(y)&gt;0 &amp;&amp; y.compareTo(z)&gt;0)</tt> implies
     * <tt>x.compareTo(z)&gt;0</tt>.<p>
     *
     * Finally, the implementer must ensure that <tt>x.compareTo(y)==0</tt>
     * implies that <tt>sgn(x.compareTo(z)) == sgn(y.compareTo(z))</tt>, for
     * all <tt>z</tt>.<p>
     *
     * It is strongly recommended, but <i>not</i> strictly required that
     * <tt>(x.compareTo(y)==0) == (x.equals(y))</tt>.  Generally speaking, any
     * class that implements the <tt>Comparable</tt> interface and violates
     * this condition should clearly indicate this fact.  The recommended
     * language is "Note: this class has a natural ordering that is
     * inconsistent with equals."
     * @param o the Object to be compared.
     * @return a negative integer, zero, or a positive integer as this object
     * 		is less than, equal to, or greater than the specified object.
     * @throws ClassCastException if the specified object's type prevents it
     *         from being compared to this Object.
     */
    public int compareTo(Object o)
    {
        if (o == null)
        {
            return 1 ;
        }
        if (o.getClass() != this.getClass())
        {
            throw new ClassCastException() ;
        }
        DirectoryMutableTreeNode item = (DirectoryMutableTreeNode) o ;
        if (parent.isLinux())
        {
            return this.toString().compareTo(item.toString()) ;
        }
        else
        {
            return this.toString().toLowerCase().compareTo(item.toString().toLowerCase()) ;
        }
    }
}
