/*
 * HelpBox.java
 */
import java.io. *;
import java.awt. *;
//import java.awt.event. *;
import javax.swing. *;
import javax.swing.event. *;

/** the Help dialog box shows a dialog with helpfiles and navigation-buttons
 * @author Werner Zimmermann
 */
class HelpBox extends JDialog
{   
    int currentFilePointer;                                     // the current index of the current helpfile
    static final int maxFiles = 4;                              // the max. number of helpfiles
    String[] currentFileCache = new String[maxFiles];           // an array with all helpfile-paths
    
    /** creates a new Instance of the HelpBox-Dialog
     * @param parent the parent-frame
     * @param modal true if the dialog should be modal
     * @param baseDirectory the baseDirectory of the application, where the helpfiles should be
     */
    public HelpBox(Frame parent, boolean modal, String baseDirectory)
    {								//{{INIT_CONTROLS
        super(parent, modal) ;
		setTitle("LTOOLSgui Help");
		getContentPane().setLayout(new BorderLayout(0,0));
		setSize(800,600);
		setVisible(false);
		getContentPane().add(BorderLayout.CENTER, scrollPane);
		scrollPane.setBounds(0,0,800,465);
		jPanel1.setLayout(new FlowLayout(FlowLayout.CENTER,5,5));
		getContentPane().add(BorderLayout.SOUTH, jPanel1);
		jPanel1.setBounds(0,565,800,35);
		overviewButton.setText("Overview");
		overviewButton.setActionCommand("Overview");
		jPanel1.add(overviewButton);
		overviewButton.setFont(new Font("SansSerif", Font.BOLD, 12));
		overviewButton.setBounds(188,5,87,25);
		PrevButton.setText("Previous");
		jPanel1.add(PrevButton);
		PrevButton.setFont(new Font("SansSerif", Font.BOLD, 12));
		PrevButton.setBounds(280,5,85,25);
		NextButton.setText("   Next    ");
		jPanel1.add(NextButton);
		NextButton.setFont(new Font("SansSerif", Font.BOLD, 12));
		NextButton.setBounds(370,5,81,25);
		jLabel1.setText("                            ");
		jPanel1.add(jLabel1);
		jLabel1.setBounds(456,10,84,15);
		closeButton.setText("Close");
		closeButton.setActionCommand("Close");
		jPanel1.add(closeButton);
		closeButton.setFont(new Font("SansSerif", Font.BOLD, 12));
		closeButton.setBounds(545,5,67,25);
		//}}

	//{{REGISTER_LISTENERS
	SymAction lSymAction = new SymAction();
	closeButton.addActionListener(lSymAction);
	SymHyperlink lSymHyperlink = new SymHyperlink();
	view.addHyperlinkListener(lSymHyperlink);
	overviewButton.addActionListener(lSymAction);
	PrevButton.addActionListener(lSymAction);
	NextButton.addActionListener(lSymAction);
	//}}

	    view.setEditable(false);
	    view.setBounds(0, 0, 800, 565);
	    scrollPane.setViewportView(view);

	    currentFileCache[0] = baseDirectory+"LTOOLSgui1.htm";
	    currentFileCache[1] = baseDirectory+"LTOOLSgui2.htm";
	    currentFileCache[2] = baseDirectory+"LTOOLSgui3.htm";
	    currentFileCache[3] = baseDirectory+"LTOOLSgui4.htm";

	    currentFileCache[0].replace('/',File.separatorChar);
	    currentFileCache[1].replace('/',File.separatorChar);
	    currentFileCache[2].replace('/',File.separatorChar);
	    currentFileCache[3].replace('/',File.separatorChar);

	    currentFilePointer=0;

	    showCurrentFile();
    }


    //{{DECLARE_CONTROLS
	javax.swing.JScrollPane scrollPane = new javax.swing.JScrollPane();
	javax.swing.JPanel jPanel1 = new javax.swing.JPanel();
	javax.swing.JButton overviewButton = new javax.swing.JButton();
	javax.swing.JButton PrevButton = new javax.swing.JButton();
	javax.swing.JButton NextButton = new javax.swing.JButton();
	javax.swing.JLabel jLabel1 = new javax.swing.JLabel();
	javax.swing.JButton closeButton = new javax.swing.JButton();
	//}}
    JEditorPane view = new JEditorPane();
    /** ActionListener-class */
    class SymAction implements java.awt.event.ActionListener
    {   
        /** the actionPerformed()-method of the ActionListener
         * @param event the event data
         */        
        public void actionPerformed(java.awt.event.ActionEvent event)
        {   
            Object object = event.getSource();
            if (object == closeButton)
                closeButton_actionPerformed(event);
            else if (object == overviewButton)
                overviewButton_actionPerformed(event);
			else if (object == PrevButton)
				prevButton_actionPerformed(event);
			else if (object == NextButton)
				nextButton_actionPerformed(event);
        }
    }
    /** the closeButton_actionPerformed()-method is called when the close button was
     * pressed
     * @param event the event data
     */
    void closeButton_actionPerformed(java.awt.event.ActionEvent event)
    {   
        setVisible(false);
    }
    /** HyperlinkListener-class */
    class SymHyperlink implements javax.swing.event.HyperlinkListener
    {   
        /** the hyperlinkUpdate()-method of the HyperlinkListener
         * @param event the event-data
         */        
        public void hyperlinkUpdate(javax.swing.event.HyperlinkEvent event)
        {   
            Object object = event.getSource();
            if (object == view)
                view_hyperlinkUpdate(event);
        }
    }
    /** the searchFileInCache sets the new filePointer
     * @param newFile the new File to be shown in the help box
     */
    void searchFileInCache(String newFile)
    {   String searchFile = newFile.replace('/',File.separatorChar);
        
    	for (int i=0; i < maxFiles; i++)
        {   currentFileCache[i].replace('/',File.separatorChar);
            // System.out.println("search="+searchFile+"   current="+currentFileCache[i]);
            if (searchFile.indexOf(currentFileCache[i]) != -1)
            {	
                currentFilePointer=i;
                // System.out.println("--- found i="+i);
            	return;
            }
        }
        JOptionPane.showMessageDialog(this, "Invalid help " + searchFile, "LTOOLS", JOptionPane.ERROR_MESSAGE);
    }
    /** the showCurrentFile()-method */
    void showCurrentFile()
    {   
        try
        {
            view.setPage(currentFileCache[currentFilePointer]);
        }
        catch(IOException e)
        {   
            System.out.println("Could not find " + currentFileCache[currentFilePointer] + " " + e);
        }
        manageNavigationButtons();
    }
    /** the view_hyperlinkUpdate()-method
     * @param event the event data
     */
    void view_hyperlinkUpdate(javax.swing.event.HyperlinkEvent event)
    {   
        if (event.getEventType()!= HyperlinkEvent.EventType.ACTIVATED)
    	    return;

        searchFileInCache(event.getURL().toString());
    	showCurrentFile();
    }
    /** invoked when the overviewButton was pressed
     * @param event the event data
     */
    void overviewButton_actionPerformed(java.awt.event.ActionEvent event)
    {   currentFilePointer=0;
    	showCurrentFile();
    }

    /*
    //This is for testing only to run HelpBox as standalone program
    static public void main(String args[])
    {	
        JFrame myFrame = new JFrame("HelpBox Test");
        myFrame.setSize(600,200);
    	myFrame.setVisible(true);
    	HelpBox myBox = new HelpBox(myFrame, false, "") ;
    	myBox.setVisible(true);
    	myFrame.addWindowListener(new WindowAdapter()
        {   
            public void windowClosing(WindowEvent e)
            {   
                System.exit(0);
            }
        });
    }
    */
    /** the manageNavigationButtons()-method sets the active buttons to enabled and the
     * inactive buttons disabled
     */
	void manageNavigationButtons()
	{	if (currentFilePointer==0)
		    PrevButton.setEnabled(false);
		else
		    PrevButton.setEnabled(true);

		if (currentFilePointer==(maxFiles-1))
		    NextButton.setEnabled(false);
		else
		    NextButton.setEnabled(true);
	}
    /** invoked when the prevButton was pressed
     * @param event the event data
     */
	void prevButton_actionPerformed(java.awt.event.ActionEvent event)
	{
		currentFilePointer--;
		if (currentFilePointer < 0)
		{   
            currentFilePointer=0;
		}
		showCurrentFile();
	}
    /** invoked when the nextButton was pressed
     * @param event the event data
     */
	void nextButton_actionPerformed(java.awt.event.ActionEvent event)
	{
		currentFilePointer++;
		if (currentFilePointer > (maxFiles-1))
		    currentFilePointer=maxFiles-1;
		showCurrentFile();
	}
}

