/*
 * LToolGuiTableHeaderMouseListener.java
 */
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.table.*;

/** The LToolGuiTableHeaderMouseListener-class processes the TableHeaderMouseEvents
 * of a DirFilePane
 * @author Joerg Holzaepfel
 */
public class LToolGuiTableHeaderMouseListener implements MouseListener 
{
    DirFilePane parent ;                                        // the DirFilePane to process the TableHeaderMouseEvents
    JTable jTable ;                                             // the JTable of the DirFilePane
    JTableHeader jTableHeader ;                                 // the JTableHeader of the DirFilePane's JTable
    
    /** Creates a new instance of LToolGuiTableHeaderMouseListener
     * @param parent the DirFilePane to process the events
     */
    public LToolGuiTableHeaderMouseListener(DirFilePane parent) 
    {
        this.parent = parent ;
        jTable = parent.getJTable() ;
        jTableHeader = parent.getJTableHeader() ;
    }
    
    /** Invoked when the mouse button has been clicked (pressed
     * and released) on a component.
     * @param e the event data
     */
    public void mouseClicked(MouseEvent e) 
    {
        Rectangle rectColumn0 = jTableHeader.getHeaderRect(0) ;
        if (rectColumn0.contains(e.getX(), e.getY()))           // Column 0 was clicked
        {
            parent.changeSortOrderInJTable() ;
        }
        parent.changeSortOrder() ;
    }
    
    /** Invoked when the mouse enters a component.
     * @param e the event data
     */
    public void mouseEntered(MouseEvent e) 
    {
    }
    
    /** Invoked when the mouse exits a component.
     * @param e the event data
     */
    public void mouseExited(MouseEvent e) 
    {
    }
    
    /** Invoked when a mouse button has been pressed on a component.
     * @param e the event data
     */
    public void mousePressed(MouseEvent e) 
    {
    }
    
    /** Invoked when a mouse button has been released on a component.
     * @param e the event data
     */
    public void mouseReleased(MouseEvent e) 
    {
    }
}
