/*
 * LToolGuiTableModel.java
 */
import java.util.*;
import javax.swing.*;
import javax.swing.table.*;

/** The LToolGuiTableModel extends the DefaultTableModel.
 * @author Joerg Holzaepfel
 */
public class LToolGuiTableModel extends DefaultTableModel
{
    Vector dataVector ;                                         // the Vector contains ListItemFile-objects
    static final public LToolGuiTableColumnData columns[] = {   // the columns of the JTable
        new LToolGuiTableColumnData("Name",          200, JLabel.LEFT),
        new LToolGuiTableColumnData("Size [Bytes]",  60, JLabel.RIGHT),
        new LToolGuiTableColumnData("Typ",           60, JLabel.LEFT),
        new LToolGuiTableColumnData("Last Modified", 80, JLabel.LEFT),
        new LToolGuiTableColumnData("Access",        60, JLabel.LEFT),
        new LToolGuiTableColumnData("UserID",        60, JLabel.LEFT),
        new LToolGuiTableColumnData("GroupID",       60, JLabel.LEFT)
    } ;
    /** Creates a new instance of LToolGuiTableModel
     * @param isLinux true, if it's a Table showing linux-files
     */
    public LToolGuiTableModel(boolean isLinux) 
    {
        dataVector = new Vector() ;
    }
    /** The isCellEditable always returns false, because no cell should be editable.
     * @param row the row of the cell to edit
     * @param column the column of the row to edit
     * @return always false, because no cell should be editable
     */
    public boolean isCellEditable(int row, int column)
    {
        return (false) ;
    }
    /** The getRowCount()-method returns the number of rows in the tableModel
     * @return the number of rows (number of objects in the dataVector) in the tableModel
     */
    public int getRowCount()
    {
        return dataVector == null ? 0 : dataVector.size() ;
    }
    /** the getColumnCount()-method returns the number of columns in the tableModel
     * @return the number of columns in the tableModel
     */
    public int getColumnCount()
    {
        return columns.length ;
    }
    /** the getColumnName()-method returns the name of the column with the given index
     * @param column the index of column to get the name of
     * @return the name of the column with the index column
     */
    public String getColumnName(int column)
    {
        return columns[column].getTitle() ;
    }
    /** the getValueAt()-method returns the value in a cell at row nRow and column nCol
     * @param nRow nRow -
     * @param nCol nCol -
     * @return the value at row nRow and column nCol
     */
    public Object getValueAt(int nRow, int nCol)
    {
        try
        {
            if (nRow < 0 || nRow >= getRowCount())
            {
                return "" ;
            }
            ListItemFile item = (ListItemFile)dataVector.elementAt(nRow) ;
            switch (nCol)
            {
                case 0: 
                    return item.getTableIconData() ; // item.getFileName() ;
                case 1: 
                    if (item.isError())
                    {
                        return "" ;
                    }
                    return item.getFileSize() ;
                case 2: 
                    if (item.isError())
                    {
                        return "" ;
                    }
                    return item.getFileTyp() ;
                case 3: 
                    if (item.isError())
                    {
                        return "" ;
                    }
                    return item.getFileLastModified() ;
                case 4: 
                    if (item.isError())
                    {
                        return "" ;
                    }
                    return item.getAccess() ;
                case 5: 
                    if (item.isError())
                    {
                        return "" ;
                    }
                    return item.getUserID() ;
                case 6: 
                    if (item.isError())
                    {
                        return "" ;
                    }
                    return item.getGroupID() ;
            }
        }
        catch (Exception e)
        {
            e.printStackTrace() ;
        }
        return "" ;        
    }

    /** the removeAllRows()-method removes all data from the tableModel (removes all
     * objets in the dataVector)
     */
    public void removeAllRows()
    {
        dataVector.removeAllElements() ;
    }
    /** the addListItemFile()-method adds another ListItemFile to the tableModel
     * @param item the ListItemFile to add to the dataVector
     */
    public void addListItemFile(ListItemFile item)
    {
        try
        {
            dataVector.add(item) ;
        }
        catch (Exception e)
        {
            e.printStackTrace() ;
        }
    }
    /** the getListItemFile()-method returns a ListItemFile from a given row
     * @param row the row to get the ListItemFile from
     * @return returns the ListItemFile at the given row
     */
    public ListItemFile getListItemFile(int row)
    {
        return (ListItemFile)dataVector.elementAt(row) ;
    }
}
