/*
 * LToolGuiTreeIconCellRenderer.java
 */
import javax.swing.* ;
import javax.swing.tree.* ;
import java.awt.* ;

/** the LToolGuiTreeIconCellRenderer is the TreeCellRenderer of the JTree of a
 * DirFilePane. The LToolGuiTreeIconCellRenderer extends the class JLabel to show a
 * icon and text in the JTree.
 * @author Joerg Holzaepfel
 */
class LToolGuiTreeIconCellRenderer extends JLabel implements TreeCellRenderer
{
    protected Color textSelectionColor;                         // the color of selected text
    protected Color textNonSelectionColor;                      // the color of non-selected text
    protected Color bkSelectionColor;                           // the backgroundcolor of a selection
    protected Color bkNonSelectionColor;                        // the backgroundcolor of a non-selection
    protected Color borderSelectionColor;                       // the color of the border of a selection
    protected boolean selected;                                 // true if the cell is selected
    /** the LToolGuiTreeIconCellRenderer creates a new instance of the
     * LToolGuiTreeIconCellRenderer-class
     */
    public LToolGuiTreeIconCellRenderer()
    {
        super();
        this.textSelectionColor    = UIManager.getColor("Tree.selectionForeground");
        this.textNonSelectionColor = UIManager.getColor("Tree.textForeground");
        this.bkSelectionColor      = UIManager.getColor("Tree.selectionBackground");
        this.bkNonSelectionColor   = UIManager.getColor("Tree.textBackground");
        this.borderSelectionColor  = UIManager.getColor("Tree.selectionBorderColor");
        setOpaque(false);
    }

    /** Sets the value of the current tree cell to value. If selected is true, the cell
     * will be drawn as if selected. If expanded is true the node is currently expanded
     * and if leaf is true the node represets a leaf and if hasFocus is true the node
     * currently has focus. tree is the JTree the receiver is being configured for.
     * Returns the Component that the renderer uses to draw the value.
     * @param tree tree -
     * @param value value -
     * @param sel sel -
     * @param expanded expanded -
     * @param leaf leaf -
     * @param row row -
     * @param hasFocus hasFocus -
     * @return the Component that the renderer uses to draw the value
     */
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel,
                                boolean expanded, boolean leaf, int row, boolean hasFocus)
    {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
        Object obj = node.getUserObject();
        setText(obj.toString());

        /*
        if (obj instanceof Boolean)
        {
            setText("Retrieving data...");
        }
        */

        if (obj instanceof LToolGuiTreeIconData)
        {
            LToolGuiTreeIconData idata = (LToolGuiTreeIconData)obj;
            if (expanded)
            {
                setIcon(idata.getExpandedIcon());
            }
            else
            {
                setIcon(idata.getIcon());
            }
        }
        else
        {
            setIcon(null);
        }

        setFont(tree.getFont());
        setForeground(sel ? this.textSelectionColor : this.textNonSelectionColor);
        setBackground(sel ? this.bkSelectionColor :  this.bkNonSelectionColor);

        selected = sel;
        return this;
    }
    /** it's the overwritten method of JLabel.
     * Calls the UI delegate's paint method, if the UI delegate is non-null. We pass
     * the delegate a copy of the Graphics object to protect the rest of the paint code
     * from irrevocable changes (for example, Graphics.translate).
     * If you override this in a subclass you should not make permanent changes to the
     * passed in Graphics. For example, you should not alter the clip Rectangle or
     * modify the transform. If you need to do these operations you may find it easier
     * to create a new Graphics from the passed in Graphics and manipulate it. Further,
     * if you do not invoker super's implementation you must honor the opaque property,
     * that is if this component is opaque, you must completely fill in the background
     * in a non-opaque color. If you do not honor the opaque property you will likely
     * see visual artifacts.
     * @param g the Graphics object to protect
     */
    public void paintComponent(Graphics g)
    {
        Color bColor = getBackground();
        Icon icon = getIcon();

        g.setColor(bColor);
        int offset = 0;
        if(icon != null && getText() != null)
        {
            offset = (icon.getIconWidth() + getIconTextGap());
        }
        g.fillRect(offset, 0, getWidth() - 1 - offset, getHeight() - 1);

        if (selected)
        {
            g.setColor(this.borderSelectionColor);
            g.drawRect(offset, 0, getWidth()-1-offset, getHeight()-1);
        }
        super.paintComponent(g);
    }
    /*
    public void setMyColor()
    {
        System.out.println("setMyColor") ;
    }
    */
}
