/*
 * LToolGuiTreeWillExpandListener.java
 */
//import java.awt.* ;
//import javax.swing.*;
import javax.swing.event.*;
import javax.swing.tree.*;

/** The LToolGuiTreeWillExpandListener-class is processing the TreeWillExpandEvents
 * of the JTree in a DirFilePane
 * @author Joerg Holzaepfel
 */
public class LToolGuiTreeWillExpandListener implements TreeWillExpandListener 
{
    DirFilePane parent ;                                        // the DirFilePane of this Listener
    boolean isLinux ;                                           // true if it's a linux-DirFilePane
    /** Creates a new instance of the LToolGuiTreeWillExpandListener
     * @param parent the DirFilePane to process the events
     */
    public LToolGuiTreeWillExpandListener(DirFilePane parent) 
    {
        this.parent = parent ;
        this.isLinux = parent.isLinux() ;
    }

    /** Invoked whenever a node in the tree is about to be collapsed.
     * @param event the event data
     * @throws ExpandVetoException Exception used to stop and expand/collapse from happening.
     */
    public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException 
    {
        parent.debugOutput("treeWillCollapse()") ;
    }

    /** Invoked whenever a node in the tree is about to be expanded.
     * @param event the event data
     * @throws ExpandVetoException Exception used to stop and expand/collapse from happening.
     */
    public void treeWillExpand(TreeExpansionEvent event) throws ExpandVetoException 
    {
        if (isLinux)
        {
            // parent.debugOutput("treeWillExpand() - LINUX") ;
            // parent.debugOutput("event.getPath(): " + parent.getTreeNode(event.getPath())) ;
            if (parent.getTreeNode(event.getPath()).toString().equals(parent.getRootNodeText()))
            {
                // debugOutput(rootNodeText) ;
                return ;
            }
            else
            {
                // debugOutput("not " + rootNodeText) ;
            }
            parent.debugOutput("treeWillExpand() - LINUX - " + event.getPath()) ;
            DirectoryMutableTreeNode node = (DirectoryMutableTreeNode)parent.getTreeNode(event.getPath());
            // debugOutput("node.getDirectoryPath(): --- " + node.getDirectoryPath()) ;
            // debugOutput("node.getDepth(): --- " + node.getDepth()) ;
            // debugOutput("getLdirPath(event.getPath()): --- " + getLdirPath(event.getPath())) ;
            parent.setCurrentDirectory(event.getPath()) ;
            if (!node.getSubDirectoriesAdded())
            {
                // addLinuxSubDirectories(node) ;
                parent.addLinuxSubDirectories(node, parent.getCurrentDirectory()) ;
            }
        }
        else
        {
            if (parent.getTreeNode(event.getPath()).toString().equals(parent.getRootNodeText()))
            {
                return ;
            }
            parent.debugOutput("treeWillExpand() - DOS - " + event.getPath()) ;
            DirectoryMutableTreeNode node = (DirectoryMutableTreeNode)parent.getTreeNode(event.getPath());
            parent.setCurrentDirectory(event.getPath()) ;
            if (!node.getSubDirectoriesAdded())
            {
                parent.addDOSSubDirectories(node, parent.getCurrentDirectory()) ;
            }
        }
    }
}    
