/*
 * ModifyDosDialog.java
 */
import java.awt. *;
import java.awt.event.*;
import javax.swing. *;

/** the ModifyDosDialog-class creates a dialog where you can specify the attributes
 * of a dosfile
 * @author Werner Zimmermann
 */
public class ModifyDosDialog extends javax.swing.JDialog
{   
    static final int CANCEL = 0;                                // status of the dialog after clicking the cancel-button
    static final int OK = 1;                                    // status of the dialog after clicking the ok-button
    int status = CANCEL;                                        // the default-status of the dialog

    /** creates a new instance of a ModifyDosDialog()
     * @param parentFrame the parent Frame
     * @param isNew true if a new Directory should be created
     * @param fileName the filename of the file/directory
     * @param fileDate the lastmodified date of the file
     * @param fileLength the fileLength of the file
     * @param isDirectory true if the file is a directory
     * @param isReadOnly true if the file is readonly
     */
    public ModifyDosDialog(Frame parentFrame, boolean isNew, String fileName, String fileDate, 
            String fileLength, boolean isDirectory, boolean isReadOnly)
    {   super(parentFrame);
	// This code is automatically generated by Visual Cafe when you add
	// components to the visual environment. It instantiates and initializes
	// the components. To modify the code, only use code syntax that matches
	// what Visual Cafe can generate, or Visual Cafe may be unable to back
	// parse your Java file into its visual environment.
	//{{INIT_CONTROLS
		setModal(true);
		setTitle("LTOOL Modify Dos file or directory");
		getContentPane().setLayout(new GridLayout(5,2,0,0));
		setSize(500,160);
		setVisible(false);
		Text1Label.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
		Text1Label.setText("Name:");
		getContentPane().add(Text1Label);
		Text1Label.setFont(new Font("SansSerif", Font.BOLD, 12));
		Text1Label.setBounds(0,0,250,32);
		getContentPane().add(fileNameField);
		fileNameField.setFont(new Font("SansSerif", Font.BOLD, 12));
		fileNameField.setBounds(250,0,250,32);
		Text2Label.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
		Text2Label.setText("Modification date:");
		getContentPane().add(Text2Label);
		Text2Label.setFont(new Font("SansSerif", Font.BOLD, 12));
		Text2Label.setBounds(0,32,250,32);
		getContentPane().add(fileDateLabel);
		fileDateLabel.setFont(new Font("SansSerif", Font.BOLD, 12));
		fileDateLabel.setBounds(250,32,250,32);
		Text3Label.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
		Text3Label.setText("Length:");
		getContentPane().add(Text3Label);
		Text3Label.setFont(new Font("SansSerif", Font.BOLD, 12));
		Text3Label.setBounds(0,64,250,32);
		getContentPane().add(fileLengthLabel);
		fileLengthLabel.setFont(new Font("SansSerif", Font.BOLD, 12));
		fileLengthLabel.setBounds(250,64,250,32);
		Text4label.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
		Text4label.setText("Type:");
		getContentPane().add(Text4label);
		Text4label.setFont(new Font("SansSerif", Font.BOLD, 12));
		Text4label.setBounds(0,96,250,32);
		FileTypePanel.setLayout(new FlowLayout(FlowLayout.CENTER,5,5));
		getContentPane().add(FileTypePanel);
		FileTypePanel.setBounds(250,96,250,32);
		DirectoryBox.setText("Directory");
		DirectoryBox.setActionCommand("Directory");
		DirectoryBox.setEnabled(false);
		FileTypePanel.add(DirectoryBox);
		DirectoryBox.setBounds(44,5,77,23);
		ReadOnlyBox.setText("Read only");
		ReadOnlyBox.setActionCommand("Read only");
		ReadOnlyBox.setEnabled(false);
		FileTypePanel.add(ReadOnlyBox);
		ReadOnlyBox.setBounds(126,5,80,23);
		okButton.setText("OK");
		okButton.setOpaque(false);
		okButton.setActionCommand("OK");
		okButton.setMnemonic((int)'O');
		getContentPane().add(okButton);
		okButton.setFont(new Font("SansSerif", Font.BOLD, 12));
		okButton.setBounds(0,128,250,32);
		cancelButton.setText("Cancel");
		cancelButton.setActionCommand("Cancel");
		getContentPane().add(cancelButton);
		cancelButton.setFont(new Font("SansSerif", Font.BOLD, 12));
		cancelButton.setBounds(250,128,250,32);
		//}}
	if (isNew)
	    setTitle("LTOOL New Dos directory");
	fileNameField.setText(fileName);
	fileDateLabel.setText(fileDate);
	fileLengthLabel.setText(fileLength);
	if (isDirectory)
	    DirectoryBox.setSelected(true);
	if (isReadOnly)
	    ReadOnlyBox.setSelected(true);

	//{{REGISTER_LISTENERS
	SymWindow aSymWindow = new SymWindow();
	 this.addWindowListener(aSymWindow);
	SymAction lSymAction = new SymAction();
	 okButton.addActionListener(lSymAction);
	 cancelButton.addActionListener(lSymAction);
	//}}
        getRootPane().setDefaultButton(okButton) ;
    }
    /** the getStatus()-method returns the status of the dialog
     * @return the status of the dialog, OK if the ok-button was clicked, CANCEL if the cancel
     * button was clicked
     */
    public int getStatus()
    {   
        return status;
    }
    /** the getFileName()-method gets the new filename
     * @return the new FileName of the file in the fileNameField
     */
    public String getFileName()
    {   
        return fileNameField.getText();
    }
    /** sets the window visible or invisible
     * @param b sets the window visible or invisible
     */
    public void setVisible(boolean b)
    {   
        if (b)
        {   
            Rectangle bounds = (getParent()).getBounds();
            Dimension size = getSize();
            setLocation(bounds.x + (bounds.width - size.width) / 2,
                        bounds.y + (bounds.height - size.height) / 2);
        }
        super.setVisible(b);
    }
    /** calls the super.addNotify()-method */
    public void addNotify()
    {								// Record the size of the window prior to calling parents addNotify.
        Dimension d = getSize();
        super.addNotify();

        if (fComponentsAdjusted)
            return;
        // Adjust components according to the insets
        Insets insets = getInsets();
        setSize(insets.left + insets.right + d.width, insets.top + insets.bottom + d.height);
        Component components[] = getContentPane().getComponents();
        for (int i = 0; i < components.length; i++)
        {   
            Point p = components[i].getLocation();
            p.translate(insets.left, insets.top);
            components[i].setLocation(p);
        }
        fComponentsAdjusted = true;
    }

    // Used for addNotify check.
    boolean fComponentsAdjusted = false;

    //{{DECLARE_CONTROLS
	javax.swing.JLabel Text1Label = new javax.swing.JLabel();
	javax.swing.JTextField fileNameField = new javax.swing.JTextField();
	javax.swing.JLabel Text2Label = new javax.swing.JLabel();
	javax.swing.JLabel fileDateLabel = new javax.swing.JLabel();
	javax.swing.JLabel Text3Label = new javax.swing.JLabel();
	javax.swing.JLabel fileLengthLabel = new javax.swing.JLabel();
	javax.swing.JLabel Text4label = new javax.swing.JLabel();
	javax.swing.JPanel FileTypePanel = new javax.swing.JPanel();
	javax.swing.JCheckBox DirectoryBox = new javax.swing.JCheckBox();
	javax.swing.JCheckBox ReadOnlyBox = new javax.swing.JCheckBox();
	javax.swing.JButton okButton = new javax.swing.JButton();
	javax.swing.JButton cancelButton = new javax.swing.JButton();
	//}}
    /** a WindowAdapter class */
    class SymWindow extends java.awt.event.WindowAdapter
    {   
        /** the windowClosing()-event
         * @param event the event data
         */        
        public void windowClosing(java.awt.event.WindowEvent event)
        {   
            Object object = event.getSource();
            if (object == ModifyDosDialog.this)
                jAboutDialog_windowClosing(event);
        }
    }
    /** window closing
     * @param event the event data
     */
    void jAboutDialog_windowClosing(java.awt.event.WindowEvent event)
    {								// to do: code goes here.
        jAboutDialog_windowClosing_Interaction1(event);
    }
    /** window closing
     * @param event the event data
     */
    void jAboutDialog_windowClosing_Interaction1(java.awt.event.WindowEvent event)
    {   
        try
        {
            this.setVisible(false);                             // JAboutDialog Hide the JAboutDialog
        }
        catch(Exception e)
        {
        }
    }
    /** a ActionListener class */
    class SymAction implements java.awt.event.ActionListener
    {
        /** actionPerformed()
         * @param event the event data
         */
        public void actionPerformed(java.awt.event.ActionEvent event)
        {   
            Object object = event.getSource();
            if (object == okButton)
                okButton_actionPerformed(event);
            else if (object == cancelButton)
                cancelButton_actionPerformed(event);
        }
    }
    /** the okButton_actionPerformed()-method is called when the ok button was clicked
     * @param event the event data
     */
    void okButton_actionPerformed(java.awt.event.ActionEvent event)
    {   
        status = OK;
        try
        {
    	    this.setVisible(false);                             // JAboutDialog Hide the JAboutDialog
        }
        catch(Exception e)
        {
        }
    }
    /** the cancelButton_actionPerformed()-method is called when the cancel button was
     * clicked
     * @param event the event data
     */
    void cancelButton_actionPerformed(java.awt.event.ActionEvent event)
    {   
        status = CANCEL;
        try
        {
            this.setVisible(false);                             // JAboutDialog Hide the JAboutDialog
        }
        catch(Exception e)
        {
        }
    }
    /** This is only used for debugging purposes to run as stand alone program
     * @param args the commandline argument
     */
    static public void main(String args[])
    {	
        JFrame myFrame = new JFrame("ModifyDosDialog Test");
        myFrame.setSize(600,400);
        myFrame.setVisible(true);
    	ModifyDosDialog myDialog = new ModifyDosDialog(myFrame, false, "fileName", 
                "fileDate", "fileLength", false, true);
    	myDialog.setVisible(true);
    	myFrame.addWindowListener(new WindowAdapter()
        {   
            public void windowClosing(WindowEvent e)
            {   
                System.exit(0);
            }
        });
    }
}

