/* checkFile(): 
 * 
 * Read info from the executable file, and calculate how much
 * memory it needs.
 */

int checkFile(void)
{
    size_t nbytes;

    /* batch files are not supported */
    if (exeType == t_bat) return err_bat_file;
    
    if ((nbytes = DosRead(exeHandle, &exeHeader, sizeof exeHeader))
        != sizeof exeHeader) 
        if (fileSize >= sizeof exeHeader)
            return err_loading_file;
    

    if (exeType == t_exe)
        rc = checkExe();
    else rc = checkCom();

    if (exeHandle) {
        DosClose(exeHandle);
        exeHandle = 0;
    }

    return rc;
}

/* checkExe(): Read the EXE header info, and calculate the program's
 * memory requirements
 */

int checkExe(void)
{
   /* If EXE signature is missing, assume this is a COM file */

   if (exeHeader.signature != 'ZM' && exeHeader.signature != 'MZ')
       return checkCom();

   /* Get the size of the program image within the file. 
    *
    * The MS-DOS loader ignores the 'bytes on last page' field in the 
    * EXE header.
    */
   prgSize = ((DWORD)((exeHeader.pages << 5) - exeHeader.hdrSize)) << 4;

   /* Memory paragraphs needed = PSP + program size + extra paragraphs needed */
   memWanted = 0x10 + topara(prgSize);
   memNeeded = memWanted + exeHeader.minAlloc;
  
   if (!minMem) memNeeded += 0x100;  /* safety margin */

   if (!exeHeader.maxAlloc) {
       /* This is the 'load high' flag, meaning 'load the program image
          as high in memory as possible'. */

       loadhighFlag = 1;
       memWanted = 0xffff;
   }
   else if (0xffff - exeHeader.maxAlloc < memWanted)  /* avoid overflow */
        memWanted = 0xffff;
   else memWanted += exeHeader.maxAlloc;
   
   init.cs = exeHeader.initCS;
   init.ip = exeHeader.initIP;
   init.ss = exeHeader.initSS;
   init.sp = exeHeader.initSP;
   exeType = t_exe;
   return OK;
}

int checkCom(void)
{
   WORD sign;

   /* Some weird programs are named "COM", but are in fact EXEs */

   if (fileSize > sizeof exeHeader) {
       if (exeHeader.signature == 'ZM') 
           return checkExe();
   }
   
   prgSize = fileSize;
   if (prgSize > 0xff00) prgSize = 0xff00;

   memNeeded = topara(prgSize) + 0x10;
   memWanted = 0xffff;
   
   /* As a minimum, allocate 4K extra for the stack */
   if (memNeeded < 0xf00)
       memNeeded += 0x100;
   else memNeeded = 0x1000;
   
   init.cs = 0;
   init.ip = 0x100;
   init.ss = 0;
   init.sp = (memNeeded << 4) - 2;
   exeType = t_com;
   return OK;
}
