/*
 *  switch - DOS CLI option parser
 *  Copyright (C) 2016-2017 David McMackins II
 *
 *  Copying and distribution of this file, with or without modification,
 *  are permitted in any medium without royalty provided the copyright
 *  notice and this notice are preserved. This file is offered as-is,
 *  without any warranty.
 */

#include <ctype.h>
#include <string.h>

#include "switch.h"

static void
move(char *argv[], int from, int to)
{
	char *temp = argv[from];
	int i;

	for (i = from; i > to; --i)
		argv[i] = argv[i - 1];

	argv[to] = temp;
}

void
reorder_argv(int argc, char *argv[])
{
	int i, fpos;

	for (i = 1; i < argc; ++i)
		if ('/' != argv[i][0])
		{
			fpos = i++;
			break;
		}

	for (; i < argc; ++i)
		if ('/' == argv[i][0])
			move(argv, i, fpos++);
}

int
getswitch(int argc, char *argv[], const char *spec, int *index, char **optarg)
{
	char *opt;
	int i, olen, slen;

	if (*index >= argc || argv[*index][0] != '/')
		return SWITCH_END;

	opt = argv[*index];
	olen = strlen(opt);

	if (olen < 2)
		return SWITCH_UNKNOWN;

	slen = strlen(spec);
	for (i = 0; i < slen; ++i)
	{
		int c;

		if (':' == spec[i])
			continue;

		c = toupper(spec[i]);

		if (toupper(opt[1]) == c)
		{
			*optarg = strchr(opt + 2, ':');
			if (*optarg)
				++(*optarg);

			++(*index);
			return c;
		}
	}

	return SWITCH_UNKNOWN;
}
